/*
 * Decompiled with CFR 0.152.
 */
package kafka.durability.ondemand;

import io.confluent.rest.AuditJobRestApiResponseStatus;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import kafka.Kafka$;
import kafka.durability.audit.AuditJobSummary;
import kafka.durability.audit.AuditJobSummary$;
import kafka.durability.audit.DurabilityAuditConstants$;
import kafka.durability.audit.OffsetCount;
import kafka.durability.audit.job.BrokerAuditJob;
import kafka.durability.audit.job.BrokerAuditJob$;
import kafka.durability.audit.manager.AbstractAuditManager;
import kafka.durability.audit.manager.BrokerAuditManager;
import kafka.durability.audit.manager.DurabilityAuditCheck$;
import kafka.server.ReplicaManager;
import kafka.tier.store.TierObjectStore;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u00055f\u0001\u0002\u0010 \u0001\u0019B\u0001\"\f\u0001\u0003\u0006\u0004%\tA\f\u0005\tu\u0001\u0011\t\u0011)A\u0005_!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003>\u0011!!\u0005A!b\u0001\n\u0003)\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u000bA\u0003A\u0011A)\t\u000f]\u0003!\u0019!C\u00011\"1\u0011\r\u0001Q\u0001\neCqA\u0019\u0001C\u0002\u0013\u0005\u0001\f\u0003\u0004d\u0001\u0001\u0006I!\u0017\u0005\bI\u0002\u0011\r\u0011\"\u0001Y\u0011\u0019)\u0007\u0001)A\u00053\"9a\r\u0001b\u0001\n\u0003A\u0006BB4\u0001A\u0003%\u0011\fC\u0004i\u0001\t\u0007I\u0011A5\t\r]\u0004\u0001\u0015!\u0003k\u0011\u0015A\b\u0001\"\u0001z\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003Bq!a\u0011\u0001\t\u0003\t)\u0005C\u0004\u0002J\u0001!\t!!\u0011\t\u000f\u0005-\u0003\u0001\"\u0003\u0002N!9\u0011Q\u000e\u0001\u0005\n\u0005=\u0004bBA9\u0001\u0011%\u00111\u000f\u0005\b\u0003\u007f\u0002A\u0011BAA\u0011\u001d\t\u0019\t\u0001C\u0005\u0003\u000bCq!!$\u0001\t\u0013\ty\tC\u0004\u0002\u0016\u0002!I!a&\t\u000f\u0005\u0015\u0006\u0001\"\u0003\u0002(\nq\u0011)\u001e3ji*{'\rS3ma\u0016\u0014(B\u0001\u0011\"\u0003!yg\u000eZ3nC:$'B\u0001\u0012$\u0003)!WO]1cS2LG/\u001f\u0006\u0002I\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001(!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fM\u0006a\u0011-\u001e3ji6\u000bg.Y4feV\tq\u0006E\u0002)aIJ!!M\u0015\u0003\r=\u0003H/[8o!\t\u0019\u0004(D\u00015\u0015\t)d'A\u0004nC:\fw-\u001a:\u000b\u0005]\n\u0013!B1vI&$\u0018BA\u001d5\u0005I\u0011%o\\6fe\u0006+H-\u001b;NC:\fw-\u001a:\u0002\u001b\u0005,H-\u001b;NC:\fw-\u001a:!\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012!\u0010\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001\u000e\naa]3sm\u0016\u0014\u0018B\u0001\"@\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\u0013i&,'o\u00142kK\u000e$8\u000b^8sK>\u0003H/F\u0001G!\rA\u0003g\u0012\t\u0003\u00116k\u0011!\u0013\u0006\u0003\u0015.\u000bQa\u001d;pe\u0016T!\u0001T\u0012\u0002\tQLWM]\u0005\u0003\u001d&\u0013q\u0002V5fe>\u0013'.Z2u'R|'/Z\u0001\u0014i&,'o\u00142kK\u000e$8\u000b^8sK>\u0003H\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tI#VK\u0016\t\u0003'\u0002i\u0011a\b\u0005\u0006[\u001d\u0001\ra\f\u0005\u0006w\u001d\u0001\r!\u0010\u0005\u0006\t\u001e\u0001\rAR\u0001\u0006)>\u0003\u0016jQ\u000b\u00023B\u0011!lX\u0007\u00027*\u0011A,X\u0001\u0005Y\u0006twMC\u0001_\u0003\u0011Q\u0017M^1\n\u0005\u0001\\&AB*ue&tw-\u0001\u0004U\u001fBK5\tI\u0001\n!\u0006\u0013F+\u0013+J\u001f:\u000b!\u0002U!S)&#\u0016j\u0014(!\u0003I!v\nV!M?>3eiU#U?\u000e{UK\u0014+\u0002'Q{E+\u0011'`\u001f\u001a35+\u0012+`\u0007>+f\n\u0016\u0011\u0002\u001fQ{E+\u0011'`\u000f\u0006\u0003vlQ(V\u001dR\u000b\u0001\u0003V(U\u00032{v)\u0011)`\u0007>+f\n\u0016\u0011\u0002\tQLW.Z\u000b\u0002UB\u00111.^\u0007\u0002Y*\u0011QN\\\u0001\u0006kRLGn\u001d\u0006\u0003_B\faaY8n[>t'B\u0001\u0013r\u0015\t\u00118/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0006\u0019qN]4\n\u0005Yd'\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\n!#\\1z\u0005\u0016\u001cF/\u0019:u\u0003V$\u0017\u000e\u001e&pERI!0!\u0006\u0002(\u0005E\u00121\b\t\u0007wz\f\t!!\u0001\u000e\u0003qT!!`/\u0002\tU$\u0018\u000e\\\u0005\u0003\u007fr\u00141!T1q!\u0011\t\u0019!!\u0005\u000f\t\u0005\u0015\u0011Q\u0002\t\u0004\u0003\u000fISBAA\u0005\u0015\r\tY!J\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=\u0011&\u0001\u0004Qe\u0016$WMZ\u0005\u0004A\u0006M!bAA\bS!9\u0011q\u0003\nA\u0002\u0005e\u0011A\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\:NCB\u0004ba\u001f@\u0002\u0002\u0005m\u0001#B>\u0002\u001e\u0005\u0005\u0012bAA\u0010y\n\u00191+\u001a;\u0011\u0007i\u000b\u0019#C\u0002\u0002&m\u0013q!\u00138uK\u001e,'\u000fC\u0004\u0002*I\u0001\r!a\u000b\u0002\u0015\u0005,H-\u001b;K_\nLE\rE\u0002)\u0003[I1!a\f*\u0005\rIe\u000e\u001e\u0005\b\u0003g\u0011\u0002\u0019AA\u001b\u0003)1wN]2f'R\f'\u000f\u001e\t\u0004Q\u0005]\u0012bAA\u001dS\t9!i\\8mK\u0006t\u0007bBA\u001f%\u0001\u0007\u0011QG\u0001\u0016G>l\u0007/Y2uS>t7\t[3dW:+W\rZ3e\u0003Ei\u0017-\u001f\"f'R|\u0007/Q;eSRTuN\u0019\u000b\u0002u\u0006aR.Y=CK\u001e+G/Q;eSRTuNY*uCR,8\u000fR3uC&dGCAA$!\u0015Yh0!\u0001{\u0003ui\u0017-\u001f\"f\u000f\u0016$\u0018)\u001e3ji*{'m\u0015;biV\u001c8+^7nCJL\u0018aH2p]Z,'\u000f^*d_JLgnZ'baR{7\u000b^1ukN$U\r^1jYR1\u0011qJA+\u0003C\u0002ra_A)\u0003\u0003\t\t!C\u0002\u0002Tq\u0014q\u0001S1tQ6\u000b\u0007\u000fC\u0004\u0002XY\u0001\r!!\u0017\u0002\u0013A\f'\u000f^5uS>t\u0007\u0003BA.\u0003;j\u0011A\\\u0005\u0004\u0003?r'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003G2\u0002\u0019AA3\u0003-ygMZ:fi\u000e{WO\u001c;\u0011\t\u0005\u001d\u0014\u0011N\u0007\u0002m%\u0019\u00111\u000e\u001c\u0003\u0017=3gm]3u\u0007>,h\u000e^\u0001\u0015CV$\u0017\u000e\u001e&pEN#\u0018\r^;t\t\u0016$\u0018-\u001b7\u0016\u0005\u0005\u001d\u0013!F1vI&$(j\u001c2Ti\u0006$Xo]*v[6\f'/\u001f\u000b\u0004u\u0006U\u0004bBA<1\u0001\u0007\u0011\u0011P\u0001\u0010CV$\u0017\u000e\u001e&pEN+X.\\1ssB!\u0011qMA>\u0013\r\tiH\u000e\u0002\u0010\u0003V$\u0017\u000e\u001e&pEN+X.\\1ss\u0006!2\u000f^8q\u000bbL7\u000f^5oO\u0006+H-\u001b;K_\n,\u0012A_\u0001\u000egR\f'\u000f^!vI&$(j\u001c2\u0015\u000fi\f9)!#\u0002\f\"9\u0011q\u0003\u000eA\u0002\u0005e\u0001bBA\u00155\u0001\u0007\u00111\u0006\u0005\b\u0003{Q\u0002\u0019AA\u001b\u0003E!x\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0003#\u000b\u0019\nE\u0003|\u0003;\tI\u0006C\u0004\u0002\u0018m\u0001\r!!\u0007\u00021M$\u0018M\u001d;Bk\u0012LGOS8c%\u0016\u001c\bo\u001c8tK6\u000b\u0007\u000fF\u0004{\u00033\u000bi*!)\t\u000f\u0005mE\u00041\u0001\u0002,\u0005)!n\u001c2JI\"9\u0011q\u0014\u000fA\u0002\u0005U\u0012A\u00028fo*{'\rC\u0004\u0002$r\u0001\r!a\u000b\u0002\rM$\u0018\r^;t\u0003]\u0019Ho\u001c9Bk\u0012LGOS8c%\u0016\u001c\bo\u001c8tK6\u000b\u0007\u000fF\u0003{\u0003S\u000bY\u000bC\u0004\u0002\u001cv\u0001\r!a\u000b\t\u000f\u0005\rV\u00041\u0001\u0002,\u0001")
public class AuditJobHelper {
    private final Option<BrokerAuditManager> auditManager;
    private final ReplicaManager replicaManager;
    private final Option<TierObjectStore> tierObjectStoreOpt;
    private final String TOPIC;
    private final String PARTITION;
    private final String TOTAL_OFFSET_COUNT;
    private final String TOTAL_GAP_COUNT;
    private final Time time;

    public Option<BrokerAuditManager> auditManager() {
        return this.auditManager;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public Option<TierObjectStore> tierObjectStoreOpt() {
        return this.tierObjectStoreOpt;
    }

    public String TOPIC() {
        return this.TOPIC;
    }

    public String PARTITION() {
        return this.PARTITION;
    }

    public String TOTAL_OFFSET_COUNT() {
        return this.TOTAL_OFFSET_COUNT;
    }

    public String TOTAL_GAP_COUNT() {
        return this.TOTAL_GAP_COUNT;
    }

    public Time time() {
        return this.time;
    }

    public Map<String, String> mayBeStartAuditJob(Map<String, Set<Integer>> topicPartitionsMap, int auditJobId, boolean forceStart, boolean compactionCheckNeeded) {
        Option<KafkaThread> option = Option$.MODULE$.apply(((AbstractAuditManager)this.auditManager().get()).auditJobThread());
        if (option instanceof Some) {
            Some some = (Some)option;
            KafkaThread existingThread = (KafkaThread)some.value();
            if (existingThread.isAlive() && !forceStart) {
                Kafka$.MODULE$.debug((Function0<String> & Serializable)() -> "Found an already running audit job " + ((AbstractAuditManager)this.auditManager().get()).currentJobId() + ". Will not start new one");
                return this.startAuditJobResponseMap(((AbstractAuditManager)this.auditManager().get()).currentJobId(), false, AuditJobRestApiResponseStatus.success);
            }
            Kafka$.MODULE$.debug((Function0<String> & Serializable)() -> "Found an already running audit job " + ((AbstractAuditManager)this.auditManager().get()).currentJobId() + " but forceStart is true. Will stop existing job and start new one");
            return this.startAuditJob(topicPartitionsMap, auditJobId, compactionCheckNeeded);
        }
        Kafka$.MODULE$.debug((Function0<String> & Serializable)() -> "No existing audit job found. Will start new one");
        return this.startAuditJob(topicPartitionsMap, auditJobId, compactionCheckNeeded);
    }

    public Map<String, String> mayBeStopAuditJob() {
        Option<KafkaThread> option = Option$.MODULE$.apply(((AbstractAuditManager)this.auditManager().get()).auditJobThread());
        if (option instanceof Some) {
            Kafka$.MODULE$.debug((Function0<String> & Serializable)() -> "Found an already running audit job " + ((AbstractAuditManager)this.auditManager().get()).currentJobId() + ". Will stop the job");
            return this.stopExistingAuditJob();
        }
        Kafka$.MODULE$.debug((Function0<String> & Serializable)() -> "No existing audit job found. Nothing to stop");
        return this.stopAuditJobResponseMap(-1, AuditJobRestApiResponseStatus.success);
    }

    public Map<String, Map<String, String>> mayBeGetAuditJobStatusDetail() {
        Kafka$.MODULE$.debug((Function0<String> & Serializable)() -> "Retrieving status detail for most recent audit job");
        return this.auditJobStatusDetail();
    }

    public Map<String, String> mayBeGetAuditJobStatusSummary() {
        Kafka$.MODULE$.debug((Function0<String> & Serializable)() -> "Retrieving status summary for most recent audit job");
        return this.auditJobStatusSummary(this.auditManager().get().auditJobSummary());
    }

    private HashMap<String, String> convertScoringMapToStatusDetail(TopicPartition partition, OffsetCount offsetCount) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(this.TOPIC(), partition.topic());
        map.put(this.PARTITION(), Integer.toString(partition.partition()));
        map.put(this.TOTAL_OFFSET_COUNT(), Long.toString(offsetCount.total()));
        map.put(this.TOTAL_GAP_COUNT(), Long.toString(offsetCount.loss()));
        return map;
    }

    private Map<String, Map<String, String>> auditJobStatusDetail() {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        ((AbstractAuditManager)this.auditManager().get()).reporter().getScoringMap().foreach((Function1<Tuple2, Map> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition partition = (TopicPartition)tuple2._1();
                OffsetCount offsetCount = (OffsetCount)tuple2._2();
                HashMap<String, String> currMap = this.convertScoringMapToStatusDetail(partition, offsetCount);
                return map.put(partition.toString(), currMap);
            }
            throw new MatchError(tuple2);
        });
        HashMap<String, String> currMap = new HashMap<String, String>();
        currMap.put(DurabilityAuditConstants$.MODULE$.JOB_ID(), String.valueOf(((AbstractAuditManager)this.auditManager().get()).currentJobId()));
        map.put(DurabilityAuditConstants$.MODULE$.JOB_ID(), currMap);
        return map;
    }

    private Map<String, String> auditJobStatusSummary(AuditJobSummary auditJobSummary) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(DurabilityAuditConstants$.MODULE$.JOB_ID(), String.valueOf(auditJobSummary.jobId()));
        map.put(DurabilityAuditConstants$.MODULE$.TOPIC_PARTITIONS_REQUESTED(), String.valueOf(auditJobSummary.topicPartitionsRequested()));
        map.put(DurabilityAuditConstants$.MODULE$.STATUS(), auditJobSummary.status());
        map.put(DurabilityAuditConstants$.MODULE$.TOPIC_PARTITIONS_SCANNED_SUCCESS(), String.valueOf(auditJobSummary.topicPartitionScannedSuccess()));
        map.put(DurabilityAuditConstants$.MODULE$.TOPIC_PARTITIONS_SKIPPED(), String.valueOf(auditJobSummary.topicPartitionSkipped()));
        map.put(DurabilityAuditConstants$.MODULE$.TOPIC_PARTITIONS_SCANNED(), String.valueOf(auditJobSummary.topicPartitionScanned()));
        map.put(DurabilityAuditConstants$.MODULE$.TOTAL_TIER_COMPACTED_PARTITIONS_REQUESTED(), String.valueOf(auditJobSummary.totalTierCompactedPartitionsRequested()));
        map.put(DurabilityAuditConstants$.MODULE$.TOTAL_OFFSET_COUNT_ACROSS_PARTITIONS(), String.valueOf(auditJobSummary.totalOffsetCountAcrossPartitions()));
        map.put(DurabilityAuditConstants$.MODULE$.TOTAL_GAP_COUNT_ACROSS_PARTITIONS(), String.valueOf(auditJobSummary.totalGapCountAcrossPartitions()));
        map.put(DurabilityAuditConstants$.MODULE$.TOTAL_TIME_TAKEN_IN_MILLIS(), String.valueOf(auditJobSummary.totalTimeTakeInMillis()));
        map.put(DurabilityAuditConstants$.MODULE$.JOB_TYPE(), auditJobSummary.jobType());
        map.put(DurabilityAuditConstants$.MODULE$.START_TIME(), String.valueOf(auditJobSummary.startTime()));
        map.put(DurabilityAuditConstants$.MODULE$.COMPLETION_TIME(), String.valueOf(auditJobSummary.completionTime()));
        return map;
    }

    private Map<String, String> stopExistingAuditJob() {
        if (((AbstractAuditManager)this.auditManager().get()).auditJobThread() != null && ((AbstractAuditManager)this.auditManager().get()).auditJobThread().isAlive()) {
            int currentJobId = ((AbstractAuditManager)this.auditManager().get()).currentJobId();
            ((AbstractAuditManager)this.auditManager().get()).auditJobCountdownLatch().countDown();
            Kafka$.MODULE$.debug((Function0<String> & Serializable)() -> "Successfully cancelled AuditJob with jobId: " + ((AbstractAuditManager)this.auditManager().get()).currentJobId());
            return this.stopAuditJobResponseMap(currentJobId, AuditJobRestApiResponseStatus.success);
        }
        Kafka$.MODULE$.debug((Function0<String> & Serializable)() -> "No currently running audit job found. Nothing to stop");
        return this.stopAuditJobResponseMap(-1, AuditJobRestApiResponseStatus.success);
    }

    private Map<String, String> startAuditJob(Map<String, Set<Integer>> topicPartitionsMap, int auditJobId, boolean compactionCheckNeeded) {
        Map<String, String> map;
        try {
            if (((AbstractAuditManager)this.auditManager().get()).auditJobThread() != null && ((AbstractAuditManager)this.auditManager().get()).auditJobThread().isAlive()) {
                ((AbstractAuditManager)this.auditManager().get()).auditJobCountdownLatch().countDown();
                Kafka$.MODULE$.info((Function0<String> & Serializable)() -> "AuditManager cancelled AuditJob with jobId: " + ((AbstractAuditManager)this.auditManager().get()).currentJobId());
            }
            ((AbstractAuditManager)this.auditManager().get()).auditJobCountdownLatch_$eq(new CountDownLatch(1));
            ObjectRef<scala.collection.immutable.Set<Enumeration.Value>> checks = ObjectRef.create(((AbstractAuditManager)this.auditManager().get()).auditChecks());
            if (!compactionCheckNeeded) {
                Kafka$.MODULE$.debug((Function0<String> & Serializable)() -> auditJobId + ": Removing compaction checks");
                checks.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)checks.elem).$minus$minus(new $colon$colon<Nothing$>((Nothing$)((Object)DurabilityAuditCheck$.MODULE$.CompactTopicAudit()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)DurabilityAuditCheck$.MODULE$.DeepCompactTopicAudit()), Nil$.MODULE$)));
            }
            Kafka$.MODULE$.debug((Function0<String> & Serializable)() -> auditJobId + " Starting audit job with checks: " + (scala.collection.immutable.Set)checks$1.elem);
            BrokerAuditJob auditJob = null;
            this.auditManager().get().auditJobSummary_$eq(AuditJobSummary$.MODULE$.apply());
            auditJob = topicPartitionsMap.isEmpty() ? new BrokerAuditJob(((AbstractAuditManager)this.auditManager().get()).db().getTopicPartitionsForAudit(), this.replicaManager().logManager(), ((AbstractAuditManager)this.auditManager().get()).auditJobCountdownLatch(), ((AbstractAuditManager)this.auditManager().get()).reporter(), this.auditManager().get().auditJobSummary(), auditJobId, this.tierObjectStoreOpt(), this.time(), (scala.collection.immutable.Set)checks.elem, this.auditManager().get().config(), ((AbstractAuditManager)this.auditManager().get()).db(), new Some<ReplicaManager>(this.replicaManager()), true, BrokerAuditJob$.MODULE$.$lessinit$greater$default$14()) : new BrokerAuditJob(((AbstractAuditManager)this.auditManager().get()).db().getTopicPartitionsForAudit(), this.replicaManager().logManager(), ((AbstractAuditManager)this.auditManager().get()).auditJobCountdownLatch(), ((AbstractAuditManager)this.auditManager().get()).reporter(), this.auditManager().get().auditJobSummary(), auditJobId, this.tierObjectStoreOpt(), this.time(), (scala.collection.immutable.Set)checks.elem, this.auditManager().get().config(), ((AbstractAuditManager)this.auditManager().get()).db(), new Some<ReplicaManager>(this.replicaManager()), true, new Some<Set<TopicPartition>>(this.toTopicPartitions(topicPartitionsMap)));
            ((AbstractAuditManager)this.auditManager().get()).auditJobThread_$eq(KafkaThread.nonDaemon("OnDemandAuditJob-" + auditJobId, auditJob));
            ((AbstractAuditManager)this.auditManager().get()).auditJobThread().start();
            Kafka$.MODULE$.debug((Function0<String> & Serializable)() -> auditJobId + ": Successfully started audit job");
            map = this.startAuditJobResponseMap(auditJobId, true, AuditJobRestApiResponseStatus.success);
        }
        catch (Exception e) {
            Kafka$.MODULE$.error((Function0<String> & Serializable)() -> auditJobId + ": Received error while executing, will exit", (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
            map = this.startAuditJobResponseMap(-1, false, AuditJobRestApiResponseStatus.failure);
        }
        return map;
    }

    private Set<TopicPartition> toTopicPartitions(Map<String, Set<Integer>> topicPartitionsMap) {
        HashSet<TopicPartition> topicPartitions = new HashSet<TopicPartition>();
        topicPartitionsMap.forEach((x0$1, x1$1) -> {
            Tuple2<String, Set> tuple2 = new Tuple2<String, Set>((String)x0$1, (Set)x1$1);
            if (tuple2 != null) {
                String topicName = tuple2._1();
                Set partitions = tuple2._2();
                partitions.forEach(partition -> topicPartitions.add(new TopicPartition(topicName, Predef$.MODULE$.Integer2int((Integer)partition))));
                return;
            }
            throw new MatchError(tuple2);
        });
        return topicPartitions;
    }

    private Map<String, String> startAuditJobResponseMap(int jobId, boolean newJob, int status) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobId", String.valueOf(jobId));
        map.put("newJob", String.valueOf(newJob));
        map.put("status", String.valueOf(status));
        return map;
    }

    private Map<String, String> stopAuditJobResponseMap(int jobId, int status) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobId", String.valueOf(jobId));
        map.put("status", String.valueOf(status));
        return map;
    }

    public AuditJobHelper(Option<BrokerAuditManager> auditManager, ReplicaManager replicaManager, Option<TierObjectStore> tierObjectStoreOpt) {
        this.auditManager = auditManager;
        this.replicaManager = replicaManager;
        this.tierObjectStoreOpt = tierObjectStoreOpt;
        this.TOPIC = "topicName";
        this.PARTITION = "partition";
        this.TOTAL_OFFSET_COUNT = "totalOffsetCount";
        this.TOTAL_GAP_COUNT = "totalGapCount";
        this.time = Time.SYSTEM;
    }
}

