/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.util.Map;
import java.util.Optional;
import kafka.network.AbstractAutoTuningQuota;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.metrics.Sensor;

class ListenerIpAutoTuningQuota
extends AbstractAutoTuningQuota {
    ListenerIpAutoTuningQuota(Sensor connectionRateThrottleSensor, Sensor connectionRateLimitSensor) {
        super(connectionRateThrottleSensor, connectionRateLimitSensor);
    }

    @Override
    String quotaName(String listenerName) {
        return listenerName + "-per-ip-connection-rate";
    }

    @Override
    double nextMax(Map<String, ?> configs) {
        return Optional.ofNullable(configs.get(KafkaConfig.ListenerConnectionRatePerIpMaxProp())).map(v -> Double.valueOf(String.valueOf(v))).orElse((Double)Double.MAX_VALUE);
    }

    @Override
    double nextFloor(Map<String, ?> configs) {
        return Optional.ofNullable(configs.get(KafkaConfig.ListenerConnectionRatePerIpFloorProp())).map(v -> Double.valueOf(String.valueOf(v))).orElse((Double)Double.MAX_VALUE);
    }

    @Override
    double nextStep(Map<String, ?> configs) {
        return Optional.ofNullable(configs.get(KafkaConfig.ListenerConnectionRatePerIpStepProp())).map(v -> Double.valueOf(String.valueOf(v))).orElse(0.0);
    }

    @Override
    protected double connectionRateThrottleEnableThreshold(Map<String, ?> configs) {
        return Optional.ofNullable(configs.get(KafkaConfig.MaxConnectionRatePerIpThrottleEnableThresholdProp())).map(v -> Double.valueOf(String.valueOf(v))).orElse(0.0);
    }
}

