/*
 * Decompiled with CFR 0.152.
 */
package kafka.network.netty;

import io.opentelemetry.context.Context;
import java.util.Optional;
import java.util.function.Supplier;
import kafka.network.RequestChannel;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.internals.ConfluentMetricsContextProvider;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ProduceConsumeAuditLogTracker;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.protocol.ReadableBuf;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.ApiVersionManager;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.slf4j.Logger;
import scala.Option;
import scala.reflect.ClassTag;

public class BrokerKafkaRequestHandler {
    private final Logger log;
    private final Time time;
    private final Supplier<Long> requestIdGenerator;
    private final BrokerInterceptor interceptor;
    private final Metrics metrics;
    private final ApiVersionManager apiVersionManager;
    private final ProduceConsumeAuditLogTracker produceConsumeAuditLogTracker;
    private final MemoryPool memoryPool;
    private final RequestChannel requestChannel;
    private final RequestCallback requestCallback;
    private final AuditLogProvider auditLogProvider;
    private final RequestLogFilter requestLogFilter;

    public BrokerKafkaRequestHandler(int nodeId, Time time, Supplier<Long> requestIdGenerator, BrokerInterceptor interceptor, Metrics metrics, ApiVersionManager apiVersionManager, ProduceConsumeAuditLogTracker produceConsumeAuditLogTracker, MemoryPool memoryPool, RequestChannel requestChannel, RequestCallback requestCallback, AuditLogProvider auditLogProvider, RequestLogFilter requestLogFilter) {
        this.time = time;
        this.requestIdGenerator = requestIdGenerator;
        this.interceptor = interceptor;
        this.metrics = metrics;
        this.apiVersionManager = apiVersionManager;
        this.produceConsumeAuditLogTracker = produceConsumeAuditLogTracker;
        this.memoryPool = memoryPool;
        this.requestChannel = requestChannel;
        this.requestCallback = requestCallback;
        this.auditLogProvider = auditLogProvider;
        this.requestLogFilter = requestLogFilter;
        LogContext logContext = new LogContext(String.format("[%s nodeId=%d] ", BrokerKafkaRequestHandler.class.getSimpleName(), nodeId));
        this.log = logContext.logger(BrokerKafkaRequestHandler.class);
    }

    public boolean isApiEnabled(RequestHeader header) {
        return this.apiVersionManager.isApiEnabled(header.apiKey(), header.apiVersion());
    }

    public void parseAndSubmitKafkaRequest(ReadableBuf requestBuffer, RequestHeader requestHeader, String connectionId, long sequenceId, boolean isProxyModeLocal, KafkaPrincipalSerde principalSerde, KafkaPrincipal principal, AuthenticationContext authenticationContext, Integer clientPort, ClientInformation clientInformation, RequestChannel.ProxyChannel proxyChannel) {
        BrokerKafkaRequestHandler.validateParameters(requestBuffer, requestHeader, connectionId, sequenceId, principal, authenticationContext, proxyChannel);
        RequestContext requestContext = this.newRequestContext(requestHeader, connectionId, isProxyModeLocal, principalSerde, principal, authenticationContext, clientPort, clientInformation);
        RequestChannel.Request request = this.createRequest(requestBuffer, sequenceId, requestContext, proxyChannel);
        this.requestCallback.onRequest(requestContext.principal(), (AbstractRequest)request.body(ClassTag.apply(AbstractRequest.class)), Optional.ofNullable(requestHeader.data().clientId()), Optional.of(requestContext.listenerName()));
        this.log.debug("Sending request (api key = {}) for seqId = {} on stream {}, correlation id = {}", new Object[]{requestHeader.apiKey(), request.sequenceId(), connectionId, requestHeader.correlationId()});
        this.requestChannel.sendRequest(request);
    }

    private static void validateParameters(ReadableBuf requestBuffer, RequestHeader requestHeader, String connectionId, long sequenceId, KafkaPrincipal principal, AuthenticationContext authenticationContext, RequestChannel.ProxyChannel proxyChannel) {
        if (requestBuffer == null) {
            throw new IllegalArgumentException("Request buffer cannot be null");
        }
        if (requestHeader == null) {
            throw new IllegalArgumentException("Request header cannot be null");
        }
        if (connectionId == null) {
            throw new IllegalArgumentException("Connection id cannot be null");
        }
        if (sequenceId <= 0L) {
            throw new IllegalArgumentException("Invalid sequence id: " + sequenceId);
        }
        if (principal == null) {
            throw new IllegalArgumentException("Principal cannot be null");
        }
        if (authenticationContext == null) {
            throw new IllegalArgumentException("Authentication context cannot be null");
        }
        if (proxyChannel == null) {
            throw new IllegalArgumentException("Proxy channel cannot be null");
        }
    }

    private RequestChannel.Request createRequest(ReadableBuf requestBuffer, long sequenceId, RequestContext requestContext, RequestChannel.ProxyChannel proxyChannel) {
        return new RequestChannel.Request(-1, requestContext, this.time.nanoseconds(), this.memoryPool, requestBuffer, this.requestChannel.metrics(), Option.empty(), Context.root(), this.metrics.eventEmitter(), this.auditLogProvider, this.requestLogFilter, sequenceId, proxyChannel);
    }

    private RequestContext newRequestContext(RequestHeader header, String connectionId, boolean isProxyModeLocal, KafkaPrincipalSerde principalSerde, KafkaPrincipal principal, AuthenticationContext authenticationContext, Integer clientPort, ClientInformation clientInformation) {
        BrokerInterceptor.RequestContextOptions options = new BrokerInterceptor.RequestContextOptions(header, connectionId, this.requestIdGenerator.get(), authenticationContext.clientAddress(), Optional.ofNullable(clientPort), principal, ListenerName.normalised(authenticationContext.listenerName()), authenticationContext.securityProtocol(), clientInformation, this.metrics, null, false, Optional.ofNullable(principalSerde), authenticationContext, this.produceConsumeAuditLogTracker, isProxyModeLocal, null, false, ConfluentMetricsContextProvider.INSTANCE, null);
        return this.interceptor.newContext(options);
    }
}

