/*
 * Decompiled with CFR 0.152.
 */
package kafka.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kafka.network.RequestChannel;
import kafka.network.netty.BrokerKafkaRequestHandler;
import kafka.network.netty.KafkaAuthContext;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.network.netty.ByteBufReceive;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.network.netty.ReadableByteBuf;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;
import scala.runtime.BoxedUnit;

public class BrokerServerStreamHandler
implements NettyStream.StreamHandler,
RequestChannel.ProxyChannel {
    private static final int NO_SEQUENCE = -1;
    private final Logger log;
    private final int maxReceiveSize;
    private final NettyStream nettyStream;
    private final String connectionId;
    private final BrokerKafkaRequestHandler kafkaRequestHandler;
    private final Runnable onCloseCompleteCallback;
    private final KafkaPrincipalSerde principalSerde;
    private final KafkaAuthContext authContext;
    private final AtomicLong sequenceIdGenerator = new AtomicLong(0L);
    private final Queue<ByteBuf> receivedBufs = new ArrayDeque<ByteBuf>();
    private ByteBufReceive pendingRequestBuf = null;
    private long processingRequestId = -1L;
    private boolean throttled = false;
    private final int pipeliningMaxInflight;
    private final Queue<Long> pipelinedRequests;
    private final Map<Long, PendingResponse> pipelinedResponses;
    private PendingResponse pendingSendResponse = null;
    private State state = State.OPEN;
    private final int gracefulCloseTimeoutMs;

    public BrokerServerStreamHandler(NettyStream nettyStream, BrokerKafkaRequestHandler kafkaRequestHandler, KafkaPrincipalSerde principalSerde, KafkaAuthContext authContext, int maxReceiveSize, int pipeliningMaxInflight, int gracefulCloseTimeoutMs, Runnable onCloseCompleteCallback) {
        this.nettyStream = nettyStream;
        this.kafkaRequestHandler = kafkaRequestHandler;
        this.connectionId = nettyStream.toString();
        this.principalSerde = principalSerde;
        this.authContext = authContext;
        this.maxReceiveSize = maxReceiveSize;
        this.onCloseCompleteCallback = onCloseCompleteCallback;
        this.gracefulCloseTimeoutMs = gracefulCloseTimeoutMs;
        this.pipeliningMaxInflight = pipeliningMaxInflight;
        this.pipelinedRequests = new ArrayDeque<Long>(pipeliningMaxInflight);
        this.pipelinedResponses = new HashMap<Long, PendingResponse>();
        LogContext logContext = new LogContext(String.format("[%s stream=%s] ", BrokerServerStreamHandler.class.getSimpleName(), nettyStream));
        this.log = logContext.logger(BrokerServerStreamHandler.class);
    }

    @Override
    public void handleData(ByteBuf data) {
        if (!this.state.isOpen()) {
            this.log.debug("Stream is closed or closing, ignoring data of size {}", (Object)data.readableBytes());
            return;
        }
        this.log.debug("Processing request chunk of size {}", (Object)data.readableBytes());
        this.receivedBufs.add(data.retain());
        this.processReceivedBuffers();
    }

    @Override
    public void handleReadyForSend() {
        try {
            this.nettyStream.runOnEventLoop(this::sendResponse, true);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void handleException(Throwable t) {
        this.log.error("Exception occurred, closing connection {}", (Object)this.connectionId, (Object)t);
        this.closeImmediately();
    }

    @Override
    public void handleClose() {
        this.log.debug("Stream is closed, cleaning up resources");
        this.state = State.CLOSED;
        this.cleanupPendingRequests();
        this.cleanupPendingResponses();
        if (this.onCloseCompleteCallback != null) {
            try {
                this.onCloseCompleteCallback.run();
            }
            catch (Throwable t) {
                this.log.error("Exception occurred while running onCloseCompleteCallback", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReceivedBuffers() {
        if (this.state.isClosed() || !this.canProcessRequest()) {
            return;
        }
        while (!this.receivedBufs.isEmpty()) {
            ByteBuf byteBuf = this.receivedBufs.peek();
            if (this.pendingRequestBuf == null) {
                this.pendingRequestBuf = new ByteBufReceive(this.nettyStream.alloc(), this.maxReceiveSize);
            }
            this.pendingRequestBuf.readFrom(byteBuf);
            if (!byteBuf.isReadable()) {
                this.receivedBufs.poll();
                byteBuf.release();
            }
            if (!this.pendingRequestBuf.complete()) continue;
            long sequenceId = this.sequenceIdGenerator.incrementAndGet();
            try (ReadableByteBuf readableBuf = this.pendingRequestBuf.payload();){
                RequestHeader header = RequestHeader.parse(readableBuf);
                if (!this.kafkaRequestHandler.isApiEnabled(header)) {
                    throw new InvalidRequestException("Received request api key " + String.valueOf((Object)header.apiKey()) + " with version " + header.apiVersion() + " which is not enabled.");
                }
                this.kafkaRequestHandler.parseAndSubmitKafkaRequest(readableBuf, header, this.connectionId, sequenceId, this.isProxyModeLocal(header), this.principalSerde, this.authContext.principal(), this.authContext.authenticationContext(), this.authContext.clientPort(), this.authContext.clientInformation(), this);
                readableBuf = null;
                this.processingRequestId = sequenceId;
                this.pendingRequestBuf.close();
                this.pendingRequestBuf = null;
                break;
            }
        }
        if (this.state.isOpen() && this.receivedBufs.isEmpty()) {
            this.nettyStream.receiveMore();
        }
    }

    private boolean canProcessRequest() {
        return !this.throttled && this.processingRequestId == -1L && this.pipelinedRequests.size() < this.pipeliningMaxInflight;
    }

    @Override
    public void receiveResponseFromKafka(RequestChannel.Response response) {
        this.nettyStream.runOnEventLoop(() -> this.processKafkaResponse(response), true);
    }

    public CompletableFuture<Send> sendKafkaResponse(DirectSend send) {
        CompletableFuture<Send> future = new CompletableFuture<Send>();
        Runnable sendRunnable = this.sendRunnable(send, future);
        this.nettyStream.runOnEventLoop(sendRunnable, false);
        return future;
    }

    public CompletableFuture<Send> sendKafkaResponseWithDelay(DirectSend send, long delay, TimeUnit unit) {
        CompletableFuture<Send> future = new CompletableFuture<Send>();
        this.nettyStream.scheduleWithDelayOnEventLoop(this.sendRunnable(send, future), delay, unit);
        return future;
    }

    private Runnable sendRunnable(DirectSend send, CompletableFuture<Send> completableFuture) {
        return () -> {
            if (this.pendingSendResponse != null) {
                throw new IllegalStateException("Found existing pending response before authentication: " + String.valueOf(this.pendingSendResponse) + ". Trying to send: " + String.valueOf(send));
            }
            this.pendingSendResponse = new SendPendingResponse(send, completableFuture);
            this.sendResponse();
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processKafkaResponse(RequestChannel.Response response) {
        if (this.state.isClosed()) {
            if (response instanceof RequestChannel.SendResponse) {
                this.log.info("Attempting to send response via channel for which there is no open connection, connection id {}", (Object)this.connectionId);
                ((RequestChannel.SendResponse)response).responseSend().release();
                return;
            }
            this.log.error("After close received unexpected response type: {} for request correlation id {} ", (Object)response.getClass().getName(), (Object)response.request().header().correlationId());
            return;
        }
        long responseRequestSequenceId = response.request().sequenceId();
        if (response instanceof RequestChannel.SendResponse) {
            RequestChannel.SendResponse sendResponse = (RequestChannel.SendResponse)response;
            if (!(response instanceof RequestChannel.SendResponseAndReverse)) {
                SendResponsePendingResponse pendingResponse = new SendResponsePendingResponse(sendResponse);
                if (!this.pipelinedRequests.isEmpty() && !this.pipelinedRequests.peek().equals(responseRequestSequenceId)) {
                    this.pipelinedResponses.put(responseRequestSequenceId, pendingResponse);
                    if (this.processingRequestId != responseRequestSequenceId) return;
                    this.enqueuePipelinedRequestAndProcessReceivedBuffers(responseRequestSequenceId);
                    return;
                }
                this.pendingSendResponse = pendingResponse;
                this.sendResponse();
                return;
            }
        }
        if (response instanceof RequestChannel.StartThrottlingResponse) {
            this.throttled = true;
            return;
        }
        if (response instanceof RequestChannel.EndThrottlingResponse) {
            this.throttled = false;
            this.processReceivedBuffers();
            return;
        }
        if (response instanceof RequestChannel.RequestProcessedNotification) {
            if (this.processingRequestId != responseRequestSequenceId) {
                this.handleUnexpectedResponse(response);
                return;
            }
            this.enqueuePipelinedRequestAndProcessReceivedBuffers(responseRequestSequenceId);
            return;
        }
        if (response instanceof RequestChannel.CloseConnectionResponse) {
            this.log.debug("Received CloseConnectionResponse (api key = {}) for seqId = {}, correlation id = {}", new Object[]{response.request().header().apiKey(), responseRequestSequenceId, response.request().header().correlationId()});
            this.closeImmediately();
            return;
        }
        if (response instanceof RequestChannel.NoOpResponse) {
            this.log.debug("Received NoOpResponse for request (api key = {}), correlation id {}, continuing processing", (Object)response.request().header().apiKey(), (Object)response.request().header().correlationId());
        } else {
            this.log.debug("Received unsupported response type: {} for request (api key = {}), correlation id {}", new Object[]{response.getClass().getSimpleName(), response.request().header().apiKey(), response.request().header().correlationId()});
        }
        if (this.processingRequestId != responseRequestSequenceId) {
            this.handleUnexpectedResponse(response);
            return;
        }
        if (!this.pipelinedRequests.isEmpty() && this.pipelinedRequests.peek().equals(responseRequestSequenceId)) {
            this.pipelinedRequests.poll();
        }
        this.processingRequestId = -1L;
        this.processReceivedBuffers();
    }

    private void enqueuePipelinedRequestAndProcessReceivedBuffers(long sequenceId) {
        this.pipelinedRequests.offer(sequenceId);
        this.processingRequestId = -1L;
        this.processReceivedBuffers();
    }

    private void handleUnexpectedResponse(RequestChannel.Response response) {
        this.handleException(new IllegalStateException("Received unexpected " + response.getClass().getSimpleName() + " for request (api key = " + String.valueOf((Object)response.request().header().apiKey()) + ") correlation id " + response.request().header().correlationId() + ", expected seqId = " + this.processingRequestId + ", got seqId = " + response.request().sequenceId()));
    }

    private void sendResponse() {
        if (this.state.isClosed() || this.pendingSendResponse == null) {
            return;
        }
        try {
            long written = this.pendingSendResponse.writeTo(this.nettyStream.transferableChannel());
            this.log.debug("Written {} of {}, stream writable? {}", written, this.pendingSendResponse, this.nettyStream.isReadyForSending());
            if (this.pendingSendResponse.completed()) {
                this.handleCompletedResponse();
            }
            if (this.state.isClosing() && this.hasNoPendingRequestsResponses()) {
                this.closeImmediately();
            }
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    private void handleCompletedResponse() {
        this.pendingSendResponse.notifyCompletion();
        long completedRequestId = this.pendingSendResponse.sequenceId();
        this.log.debug("Completed response {} (api key = {}) for seqId = {}, correlation id = {}", this.pendingSendResponse, this.pendingSendResponse.apiKey(), this.pendingSendResponse.sequenceId(), this.pendingSendResponse.correlationId());
        this.pendingSendResponse.release();
        this.pendingSendResponse = null;
        if (!this.pipelinedRequests.isEmpty() && this.pipelinedRequests.peek().equals(completedRequestId)) {
            PendingResponse nextResponse;
            if (this.processingRequestId == completedRequestId) {
                throw new IllegalStateException("Pipelined request (seqId=" + completedRequestId + ") must have cleared pending processing request id");
            }
            this.pipelinedRequests.poll();
            if (!this.pipelinedRequests.isEmpty() && (nextResponse = this.pipelinedResponses.remove(this.pipelinedRequests.peek())) != null) {
                this.pendingSendResponse = nextResponse;
                this.sendResponse();
            }
        }
        if (this.processingRequestId == completedRequestId) {
            this.processingRequestId = -1L;
        }
        this.processReceivedBuffers();
    }

    private boolean hasNoPendingRequestsResponses() {
        return this.pendingSendResponse == null && this.pipelinedResponses.isEmpty() && this.pipelinedRequests.isEmpty() && this.processingRequestId == -1L;
    }

    void closeGracefully() {
        this.nettyStream.runOnEventLoop(() -> {
            if (!this.state.isOpen()) {
                this.log.debug("Stream is already closed or closing, ignoring graceful close request");
                return;
            }
            if (this.hasNoPendingRequestsResponses()) {
                this.log.debug("Stream is closing immediately due to send failure or no pending requests or responses");
                this.closeImmediately();
            } else {
                this.log.debug("Stream is gracefully closing with timeout {}ms", (Object)this.gracefulCloseTimeoutMs);
                try {
                    this.state = State.CLOSING;
                    this.nettyStream.scheduleWithDelayOnEventLoop(() -> {
                        this.log.debug("Graceful close timeout reached, closing stream immediately");
                        this.closeImmediately();
                    }, this.gracefulCloseTimeoutMs, TimeUnit.MILLISECONDS);
                }
                catch (Throwable e) {
                    this.log.warn("Failed to schedule close, closing immediately", e);
                    this.closeImmediately();
                }
            }
        }, false);
    }

    private void closeImmediately() {
        if (this.state.isClosed()) {
            this.log.debug("Stream is already closed, ignoring close request");
            return;
        }
        this.nettyStream.closeStream();
        this.state = State.CLOSED;
    }

    private void cleanupPendingResponses() {
        try {
            if (this.pendingSendResponse != null) {
                this.pendingSendResponse.release();
                this.pendingSendResponse = null;
            }
            for (PendingResponse response : this.pipelinedResponses.values()) {
                response.release();
            }
            this.pipelinedResponses.clear();
        }
        catch (Throwable t) {
            this.log.error("Error while releasing pending responses", t);
        }
    }

    private void cleanupPendingRequests() {
        if (this.pendingRequestBuf != null) {
            try {
                this.pendingRequestBuf.close();
                this.pendingRequestBuf = null;
            }
            catch (Throwable t) {
                this.log.error("Error while releasing request buffer", t);
            }
        }
        while (!this.receivedBufs.isEmpty()) {
            ReferenceCountUtil.safeRelease(this.receivedBufs.poll());
        }
    }

    private boolean isProxyModeLocal(RequestHeader header) {
        return false;
    }

    Collection<Long> pipelinedRequests() {
        return Collections.unmodifiableCollection(this.pipelinedRequests);
    }

    Map<Long, PendingResponse> pipelinedResponses() {
        return Collections.unmodifiableMap(this.pipelinedResponses);
    }

    long processingRequestId() {
        return this.processingRequestId;
    }

    PendingResponse pendingSendResponse() {
        return this.pendingSendResponse;
    }

    void pendingSendResponse(PendingResponse pendingSendResponse) {
        this.pendingSendResponse = pendingSendResponse;
    }

    State state() {
        return this.state;
    }

    boolean hasReceivedBufs() {
        return !this.receivedBufs.isEmpty();
    }

    public static interface PendingResponse
    extends Send {
        public void notifyCompletion();

        public long sequenceId();

        public Optional<ApiKeys> apiKey();

        public int correlationId();
    }

    static enum State {
        OPEN,
        CLOSING,
        CLOSED;


        boolean isOpen() {
            return this == OPEN;
        }

        boolean isClosing() {
            return this == CLOSING;
        }

        boolean isClosed() {
            return this == CLOSED;
        }
    }

    public record DirectSend(Send send, long sequenceId) {
    }

    private record SendResponsePendingResponse(RequestChannel.SendResponse sendResponse) implements PendingResponse
    {
        @Override
        public void notifyCompletion() {
            this.sendResponse.onComplete().foreach(c -> (BoxedUnit)c.apply(this.sendResponse.responseSend()));
        }

        @Override
        public long sequenceId() {
            return this.sendResponse.request().sequenceId();
        }

        @Override
        public Optional<ApiKeys> apiKey() {
            return Optional.of(this.sendResponse.request().header().apiKey());
        }

        @Override
        public int correlationId() {
            return this.sendResponse.request().header().correlationId();
        }

        @Override
        public boolean completed() {
            return this.sendResponse.responseSend().completed();
        }

        @Override
        public long size() {
            return this.sendResponse.responseSend().size();
        }

        @Override
        public void release() {
            this.sendResponse.responseSend().release();
        }

        @Override
        public long writeTo(TransferableChannel channel) throws IOException {
            return this.sendResponse.responseSend().writeTo(channel);
        }

        @Override
        public String toString() {
            return this.sendResponse.toString();
        }
    }

    private record SendPendingResponse(DirectSend directSend, CompletableFuture<Send> completableFuture) implements PendingResponse
    {
        @Override
        public void notifyCompletion() {
            this.completableFuture.complete(this.directSend.send());
        }

        @Override
        public long sequenceId() {
            return this.directSend().sequenceId();
        }

        @Override
        public Optional<ApiKeys> apiKey() {
            return Optional.empty();
        }

        @Override
        public int correlationId() {
            return -1;
        }

        @Override
        public boolean completed() {
            return this.directSend.send().completed();
        }

        @Override
        public long size() {
            return this.directSend.send().size();
        }

        @Override
        public void release() {
            this.directSend.send().release();
        }

        @Override
        public long writeTo(TransferableChannel channel) throws IOException {
            return this.directSend.send().writeTo(channel);
        }

        @Override
        public String toString() {
            return this.directSend.send().toString();
        }
    }
}

