/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;

public class RestoreMetricsUtil {
    private static final String METRICS_PREFIX = "kafka.restore";
    public static final String KAFKA_CLUSTER_ID = "kafka.cluster.id";
    public static final String KAFKA_NODE_ID = "kafka.node.id";

    public static Metrics initializeMetrics(KafkaConfig config, Time time, String clusterId) {
        KafkaMetricsContext metricsContext = RestoreMetricsUtil.createKafkaMetricsContext(config, clusterId);
        return RestoreMetricsUtil.buildMetrics(config, time, metricsContext);
    }

    private static Metrics buildMetrics(KafkaConfig config, Time time, KafkaMetricsContext metricsContext) {
        List<MetricsReporter> defaultReporters = RestoreMetricsUtil.initializeDefaultReporters(config);
        MetricConfig metricConfig = RestoreMetricsUtil.buildMetricsConfig(config);
        return new Metrics(metricConfig, defaultReporters, time, true, metricsContext);
    }

    private static MetricConfig buildMetricsConfig(KafkaConfig kafkaConfig) {
        return new MetricConfig().samples(kafkaConfig.metricNumSamples()).recordLevel(Sensor.RecordingLevel.forName(kafkaConfig.metricRecordingLevel())).timeWindow(kafkaConfig.metricSampleWindowMs(), TimeUnit.MILLISECONDS);
    }

    private static List<MetricsReporter> initializeDefaultReporters(KafkaConfig config) {
        JmxReporter jmxReporter = new JmxReporter();
        jmxReporter.configure(config.originals());
        ArrayList<MetricsReporter> reporters = new ArrayList<MetricsReporter>();
        reporters.add(jmxReporter);
        return reporters;
    }

    private static KafkaMetricsContext createKafkaMetricsContext(KafkaConfig config, String clusterId) {
        HashMap<String, Object> contextLabels = new HashMap<String, Object>();
        contextLabels.put(KAFKA_CLUSTER_ID, clusterId);
        contextLabels.put(KAFKA_NODE_ID, String.valueOf(config.nodeId()));
        contextLabels.putAll(config.originalsWithPrefix("metrics.context."));
        contextLabels.put("resource.type", "kafka");
        contextLabels.put("resource.version", AppInfoParser.getVersion());
        contextLabels.put("resource.commit.id", AppInfoParser.getCommitId());
        return new KafkaMetricsContext(METRICS_PREFIX, contextLabels);
    }
}

