/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kafka.tier.store.S3VersionInformation;
import kafka.tier.store.VersionInformation;

public class RestoreUtil {
    public static ThreadPoolExecutor createThreadPool(int poolSize, int queueSize) {
        return new ThreadPoolExecutor(poolSize, poolSize, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(queueSize), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static List<String> getMissingFiles(Map<String, List<VersionInformation>> versionListMap, Set<String> requiredObjectTypes) {
        ArrayList<String> missingFiles = new ArrayList<String>();
        Set suffixSet = versionListMap.keySet().stream().map(RestoreUtil::getSuffix).collect(Collectors.toSet());
        for (String objectType : requiredObjectTypes) {
            if (suffixSet.contains(objectType)) continue;
            missingFiles.add(objectType);
        }
        return missingFiles;
    }

    private static String getSuffix(String objectStorePath) {
        int lastIndexOfDot = objectStorePath.lastIndexOf(".");
        if (lastIndexOfDot != -1) {
            return objectStorePath.substring(lastIndexOfDot + 1);
        }
        return null;
    }

    public static String getLastLiveVersionId(String object, List<VersionInformation> vList) {
        if (vList == null) {
            return null;
        }
        for (VersionInformation v : vList) {
            if (v instanceof S3VersionInformation) {
                S3VersionInformation s3v = (S3VersionInformation)v;
                if (s3v.isDeleteMarker()) continue;
                return v.getVersionId();
            }
            return v.getVersionId();
        }
        return null;
    }

    public static String versionListMapToString(Map<String, List<VersionInformation>> versionListMap) {
        StringBuilder sb = new StringBuilder();
        versionListMap.forEach((k, vList) -> vList.stream().forEach(v -> {
            sb.append((String)k).append(": ").append(v.getVersionId());
            if (v instanceof S3VersionInformation) {
                S3VersionInformation s3v = (S3VersionInformation)v;
                sb.append("(isDeleteMarker: ").append(s3v.isDeleteMarker()).append(")");
            }
            sb.append("\n");
        }));
        return sb.toString();
    }

    public static String versionMapToString(Map<String, String> versionMap) {
        StringBuilder sb = new StringBuilder();
        versionMap.forEach((k, v) -> sb.append((String)k).append(": ").append((String)v).append("\n"));
        return sb.toString();
    }
}

