/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.operators;

import io.confluent.kafka.storage.checksum.CheckedFileIO;
import io.confluent.kafka.storage.tier.state.Header;
import io.confluent.kafka.storage.tier.state.SegmentState;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.state.FileTierPartitionState;

public class OperatorUtil {
    public static SegmentState findMaxSegmentState(Map<UUID, SegmentState> segmentStates) {
        SegmentState max = null;
        for (SegmentState current : segmentStates.values()) {
            if (max != null && current.tierEpoch() <= max.tierEpoch() && (current.tierEpoch() != max.tierEpoch() || current.endOffset() <= max.endOffset())) continue;
            max = current;
        }
        return max;
    }

    public static Header getFtpsHeader(File stateFile) throws IOException {
        CheckedFileIO stateFileChannel = CheckedFileIO.open(stateFile.toPath(), StandardOpenOption.READ);
        Optional<Header> headerOpt = FileTierPartitionState.readHeader(stateFileChannel);
        if (!headerOpt.isPresent()) {
            throw new IllegalStateException("Input state file is not valid, file path: " + stateFile.getAbsolutePath());
        }
        return headerOpt.get();
    }

    public static String computeMd5(CheckedFileIO fileChannel) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        if (fileChannel.size() == 0L) {
            throw new IllegalArgumentException("Empty FileChannel supplied to computeMd5.");
        }
        if (fileChannel.size() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File exceeds maximum size of 2147483647 vs " + fileChannel.size());
        }
        ByteBuffer buffer = ByteBuffer.allocate(Math.min(8192, (int)fileChannel.size()));
        for (long position = 0L; position < fileChannel.size(); position += (long)buffer.remaining()) {
            fileChannel.read(buffer, position);
            buffer.flip();
            digest.update(buffer);
            buffer.clear();
        }
        return String.format("%032x", new BigInteger(1, digest.digest()));
    }
}

