/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.rpo;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import kafka.log.MergedLog;
import kafka.restore.rpo.SegmentAndCreateTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionRpo {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionRpo.class);
    private static final long ONE_MINUTE_IN_MS = 60000L;
    TopicIdPartition topicIdPartition;
    List<SegmentAndCreateTime> segmentCreateTimeList;
    boolean isLoaded;
    private Time time = Time.SYSTEM;

    public PartitionRpo(TopicIdPartition topicIdPartition) {
        this.topicIdPartition = topicIdPartition;
        this.segmentCreateTimeList = new LinkedList<SegmentAndCreateTime>();
        this.isLoaded = false;
    }

    public PartitionRpo(TopicIdPartition topicIdPartition, Time time) {
        this(topicIdPartition);
        this.time = time;
    }

    public synchronized long rpo() {
        if (this.segmentCreateTimeList.size() == 0) {
            return 0L;
        }
        SegmentAndCreateTime head = this.segmentCreateTimeList.get(0);
        return Math.max(0L, this.time.milliseconds() - head.createTime);
    }

    public synchronized void mayAddSegmentAndCreateTime(long baseOffset, long timestamp) {
        if (this.isLoaded) {
            this.segmentCreateTimeList.add(new SegmentAndCreateTime(baseOffset, timestamp));
            LOGGER.info("{}: mark new segment roll with baseOffset at {} at timestamp {}, current rpo {} minutes", this.topicIdPartition, baseOffset, timestamp, this.rpo() / 60000L);
        }
    }

    public synchronized void removeSegmentByFirstUntieredOffset(long firstUntieredOffset) {
        SegmentAndCreateTime prev = null;
        HashSet<Long> toBeRemoved = new HashSet<Long>();
        for (SegmentAndCreateTime curr : this.segmentCreateTimeList) {
            if (curr.baseOffset > firstUntieredOffset) break;
            if (prev != null) {
                toBeRemoved.add(prev.baseOffset);
            }
            prev = curr;
        }
        this.segmentCreateTimeList.removeIf(s -> toBeRemoved.contains(s.baseOffset));
        LOGGER.debug("{}: removed {} segments with firstUntieredOffset as {}, segment list as {}", this.topicIdPartition, toBeRemoved.size(), firstUntieredOffset, this.segmentCreateTimeList);
    }

    protected synchronized void mayLoadPartitionRpo(MergedLog log) {
        if (this.isLoaded) {
            return;
        }
        this.segmentCreateTimeList = this.loadSegmentsFromLog(log);
        this.isLoaded = true;
        LOGGER.info("{}: load RPO metrics. current rpo as {} minutes, with SegmentAndCreateTimeList: {}", this.topicIdPartition, this.rpo() / 60000L, this.segmentCreateTimeList);
    }

    private List<SegmentAndCreateTime> loadSegmentsFromLog(MergedLog log) {
        ArrayList<SegmentAndCreateTime> unArchivedSegmentAndCreateTimeList = new ArrayList<SegmentAndCreateTime>();
        StreamSupport.stream(log.tierableLogSegments().spliterator(), false).map(PartitionRpo::toSegmentAndCreateTime).filter(Objects::nonNull).forEach(unArchivedSegmentAndCreateTimeList::add);
        SegmentAndCreateTime activeSegment = PartitionRpo.toSegmentAndCreateTime(log.activeSegment());
        if (activeSegment != null) {
            unArchivedSegmentAndCreateTimeList.add(activeSegment);
        }
        unArchivedSegmentAndCreateTimeList.sort(Comparator.comparingLong(s -> s.baseOffset));
        return unArchivedSegmentAndCreateTimeList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{TopicIdPartition: ").append(this.topicIdPartition).append(",").append(" SegmentCreateTimeList: [");
        for (SegmentAndCreateTime segment : this.segmentCreateTimeList) {
            sb.append(segment).append(", ");
        }
        sb.append("]").append("}");
        return sb.toString();
    }

    private static SegmentAndCreateTime toSegmentAndCreateTime(LogSegment s) {
        if (s == null || s.log() == null || s.log().file() == null) {
            return null;
        }
        File f = s.log().file();
        try {
            FileTime createTime = (FileTime)Files.getAttribute(f.getAbsoluteFile().toPath(), "creationTime", new LinkOption[0]);
            return new SegmentAndCreateTime(s.baseOffset(), createTime.toMillis());
        }
        catch (Exception e) {
            LOGGER.warn("error when add creation time for " + f.getName(), e);
            return null;
        }
    }
}

