/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine.transitions;

import io.confluent.kafka.storage.tier.state.TierPartitionStatus;
import java.util.List;
import kafka.restore.MessageEmitter;
import kafka.restore.configmap.NodeConfig;
import kafka.restore.messages.KafkaFenceResponse;
import kafka.restore.messages.KafkaTierPartitionStatusRequest;
import kafka.restore.snapshot.FtpsStateForRestore;
import kafka.restore.statemachine.api.Event;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.State;
import kafka.restore.statemachine.transitions.AbstractTransition;

public class PreConditionReadyToFenceEventSentTransition
extends AbstractTransition {
    public PreConditionReadyToFenceEventSentTransition(MessageEmitter messageEmitter) {
        super(messageEmitter);
    }

    @Override
    public State getSourceState() {
        return State.PRE_CONDITION_READY;
    }

    @Override
    public State getTargetState() {
        return State.FENCE_EVENT_SENT;
    }

    @Override
    public boolean handleEvent(FiniteStateMachine fsm, Event event) {
        Object responseObject = event.getData("message_response");
        if (!(responseObject instanceof KafkaFenceResponse)) {
            return false;
        }
        KafkaFenceResponse fenceResponse = (KafkaFenceResponse)event.getData("message_response");
        String topic = (String)fsm.getMetadata("topic");
        int partition = (Integer)fsm.getMetadata("partition");
        NodeConfig broker = (NodeConfig)fsm.getMetadata("partition_leader");
        List replicas = (List)fsm.getMetadata("partition_replicas");
        if (this.shouldRestoreFromFtpsSnapshot(fsm)) {
            FtpsStateForRestore ftpsForRestore = (FtpsStateForRestore)fsm.getMetadata("ftps_for_restore");
            ftpsForRestore.setFenceEventRecordMetadata(fenceResponse.getTierRecordMetadataResponse());
        }
        KafkaTierPartitionStatusRequest statusRequest = new KafkaTierPartitionStatusRequest(0, topic, partition, broker, replicas, TierPartitionStatus.FROZEN_LOG_START_OFFSET.ordinal());
        this.messageEmitter.submitRequest(statusRequest);
        return true;
    }
}

