/*
 * Decompiled with CFR 0.152.
 */
package kafka.rm;

import io.confluent.flink.apiserver.client.VersionApi;
import io.confluent.resourcemanager.api.client.Client;
import io.confluent.resourcemanager.api.client.ClientImpl;
import io.confluent.rm.RmClientFactory;
import io.grpc.ManagedChannel;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kafka.rm.RmMTls;
import kafka.server.KafkaConfig;
import okhttp3.OkHttpClient;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmMTlsClientFactory
implements RmClientFactory {
    private static final Logger log = LoggerFactory.getLogger(RmMTlsClientFactory.class);
    private final KafkaConfig brokerConfig;
    private final SslFactory sslFactory;

    public RmMTlsClientFactory(KafkaConfig brokerConfig) {
        this.brokerConfig = brokerConfig;
        this.sslFactory = RmMTlsClientFactory.initializeSslFactory(brokerConfig);
    }

    private static SslFactory initializeSslFactory(KafkaConfig config) {
        SslFactory sslFactory = new SslFactory(ConnectionMode.CLIENT);
        sslFactory.configure(RmMTls.getSslClientConfig(config));
        return sslFactory;
    }

    @Override
    public Client buildClient() {
        String httpEndpoint = this.brokerConfig.regionalResourceManagerEndpointUrl();
        if (httpEndpoint == null) {
            throw new IllegalStateException("Resource manager HTTPS endpoint URL is not configured.");
        }
        DefaultSslEngineFactory defaultSslEngineFactory = RmMTls.defaultSslEngineFactory(this.sslFactory);
        SSLSocketFactory sslSocketFactory = RmMTls.sslSocketFactory(defaultSslEngineFactory);
        X509TrustManager trustManager = RmMTls.trustManager(defaultSslEngineFactory);
        VersionApi versionApi = new VersionApi();
        versionApi.getApiClient().setBasePath(httpEndpoint);
        OkHttpClient httpClient = versionApi.getApiClient().getHttpClient().newBuilder().sslSocketFactory(sslSocketFactory, trustManager).build();
        ManagedChannel channel = RmMTls.managedChannel(this.brokerConfig, defaultSslEngineFactory);
        return ClientImpl.builder().httpHost(httpEndpoint).httpClient(httpClient).channel(channel).build();
    }

    @Override
    public void close() {
        this.sslFactory.close();
    }
}

