/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientSensors;
import kafka.server.ControllerMutationQuota;
import kafka.server.PermissiveControllerMutationQuota;
import kafka.server.StrictControllerMutationQuota;
import kafka.server.UnboundedControllerMutationQuota$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.Session;
import org.apache.kafka.server.config.ClientQuotaManagerConfig;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.quota.QuotaType;
import org.apache.kafka.server.quota.QuotaUtils;
import scala.Function0;
import scala.Option;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Eu!\u0002\r\u001a\u0011\u0003qb!\u0002\u0011\u001a\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003Ic\u0001\u0002\u0011\u001a\u0001)B\u0001BL\u0002\u0003\u0006\u0004%Ia\f\u0005\tw\r\u0011\t\u0011)A\u0005a!AAh\u0001BC\u0002\u0013%Q\b\u0003\u0005F\u0007\t\u0005\t\u0015!\u0003?\u0011!15A!b\u0001\n#:\u0005\"\u0003(\u0004\u0005\u0003\u0005\u000b\u0011\u0002%P\u0011!\u00016A!b\u0001\n\u0013\t\u0006\u0002C/\u0004\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011y\u001b!Q1A\u0005\n}C\u0001b\\\u0002\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\u0006Q\r!\t\u0001\u001d\u0005\u0006o\u000e!\t\u0005\u001f\u0005\b\u0003\u000b\u0019A\u0011IA\u0004\u0011\u001d\tya\u0001C!\u0003#Aq!!\u0011\u0004\t\u0003\t\u0019\u0005C\u0004\u0002P\r!\t!!\u0015\t\u000f\u0005=3\u0001\"\u0001\u0002^!9\u0011QO\u0002\u0005\u0002\u0005]\u0004bBA;\u0007\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u0003\u001bA\u0011AAB\u0003y\u0019uN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'O\u0003\u0002\u001b7\u000511/\u001a:wKJT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001!\ty\u0012!D\u0001\u001a\u0005y\u0019uN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'o\u0005\u0002\u0002EA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0010\u0014\u0005\rY\u0003CA\u0010-\u0013\ti\u0013D\u0001\nDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014\u0018AB2p]\u001aLw-F\u00011!\t\t\u0014(D\u00013\u0015\tq3G\u0003\u0002\u001bi)\u0011A$\u000e\u0006\u0003m]\na!\u00199bG\",'\"\u0001\u001d\u0002\u0007=\u0014x-\u0003\u0002;e\tA2\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u00059Q.\u001a;sS\u000e\u001cX#\u0001 \u0011\u0005}\u001aU\"\u0001!\u000b\u0005q\n%B\u0001\"5\u0003\u0019\u0019w.\\7p]&\u0011A\t\u0011\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001\u0002;j[\u0016,\u0012\u0001\u0013\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017\u0006\u000bQ!\u001e;jYNL!!\u0014&\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0005\u0003\r2\n\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0016\u0003I\u0003\"a\u0015.\u000f\u0005QC\u0006CA+%\u001b\u00051&BA,\u001e\u0003\u0019a$o\\8u}%\u0011\u0011\fJ\u0001\u0007!J,G-\u001a4\n\u0005mc&AB*ue&twM\u0003\u0002ZI\u0005\tB\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u0011\u0002'\rd\u0017.\u001a8u#V|G/Y\"bY2\u0014\u0017mY6\u0016\u0003\u0001\u00042aI1d\u0013\t\u0011GE\u0001\u0004PaRLwN\u001c\t\u0004I\u001eLW\"A3\u000b\u0005\u0019\f\u0015!C5oi\u0016\u0014h.\u00197t\u0013\tAWM\u0001\u0004QYV<\u0017N\u001c\t\u0003U6l\u0011a\u001b\u0006\u0003YN\nQ!];pi\u0006L!A\\6\u0003'\rc\u0017.\u001a8u#V|G/Y\"bY2\u0014\u0017mY6\u0002)\rd\u0017.\u001a8u#V|G/Y\"bY2\u0014\u0017mY6!)\u0019\t(o\u001d;vmB\u0011qd\u0001\u0005\u0006]9\u0001\r\u0001\r\u0005\u0006y9\u0001\rA\u0010\u0005\u0006\r:\u0001\r\u0001\u0013\u0005\u0006!:\u0001\rA\u0015\u0005\u0006=:\u0001\r\u0001Y\u0001\u0015G2LWM\u001c;SCR,W*\u001a;sS\u000et\u0015-\\3\u0015\u0005el\bC\u0001>|\u001b\u0005\t\u0015B\u0001?B\u0005)iU\r\u001e:jG:\u000bW.\u001a\u0005\u0006}>\u0001\ra`\u0001\u0010cV|G/Y'fiJL7\rV1hgB)1+!\u0001S%&\u0019\u00111\u0001/\u0003\u00075\u000b\u0007/A\ncC\u000e\\\u0007O]3tgV\u0014X-\u00128bE2,G-\u0006\u0002\u0002\nA\u00191%a\u0003\n\u0007\u00055AEA\u0004C_>dW-\u00198\u00025I,7m\u001c:e\u0003:$w)\u001a;UQJ|G\u000f\u001e7f)&lW-T:\u0015\u0015\u0005M\u0011\u0011DA\u0015\u0003[\t9\u0004E\u0002$\u0003+I1!a\u0006%\u0005\rIe\u000e\u001e\u0005\b\u00037\t\u0002\u0019AA\u000f\u0003\u001d\u0019Xm]:j_:\u0004B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003G!\u0014a\u00028fi^|'o[\u0005\u0005\u0003O\t\tCA\u0004TKN\u001c\u0018n\u001c8\t\r\u0005-\u0012\u00031\u0001S\u0003!\u0019G.[3oi&#\u0007bBA\u0018#\u0001\u0007\u0011\u0011G\u0001\u0006m\u0006dW/\u001a\t\u0004G\u0005M\u0012bAA\u001bI\t1Ai\\;cY\u0016Dq!!\u000f\u0012\u0001\u0004\tY$\u0001\u0004uS6,Wj\u001d\t\u0004G\u0005u\u0012bAA I\t!Aj\u001c8h\u00039!\bN]8ui2,G+[7f\u001bN$B!a\u000f\u0002F!9\u0011q\t\nA\u0002\u0005%\u0013!A3\u0011\u0007}\nY%C\u0002\u0002N\u0001\u0013q#U;pi\u00064\u0016n\u001c7bi&|g.\u0012=dKB$\u0018n\u001c8\u0002#9,wo\u0015;sS\u000e$\u0018+^8uC\u001a{'\u000f\u0006\u0004\u0002T\u0005e\u00131\f\t\u0004?\u0005U\u0013bAA,3\t92i\u001c8ue>dG.\u001a:NkR\fG/[8o#V|G/\u0019\u0005\b\u00037\u0019\u0002\u0019AA\u000f\u0011\u0019\tYc\u0005a\u0001%R!\u00111KA0\u0011\u001d\t\t\u0007\u0006a\u0001\u0003G\nqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002f\u0005=d\u0002BA4\u0003Wj!!!\u001b\u000b\u0007\u0005\r2$\u0003\u0003\u0002n\u0005%\u0014A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u0003c\n\u0019HA\u0004SKF,Xm\u001d;\u000b\t\u00055\u0014\u0011N\u0001\u0016]\u0016<\b+\u001a:nSN\u001c\u0018N^3Rk>$\u0018MR8s)\u0019\t\u0019&!\u001f\u0002|!9\u00111D\u000bA\u0002\u0005u\u0001BBA\u0016+\u0001\u0007!\u000b\u0006\u0003\u0002T\u0005}\u0004bBA1-\u0001\u0007\u00111M\u0001\f]\u0016<\u0018+^8uC\u001a{'\u000f\u0006\u0004\u0002T\u0005\u0015\u0015q\u0011\u0005\b\u0003C:\u0002\u0019AA2\u0011\u001d\tIi\u0006a\u0001\u0003\u0017\u000b!c\u001d;sS\u000e$8+\u001b8dKZ+'o]5p]B\u00191%!$\n\u0007\u0005=EEA\u0003TQ>\u0014H\u000f")
public class ControllerMutationQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final String threadNamePrefix;
    private final Option<Plugin<ClientQuotaCallback>> clientQuotaCallback;

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    @Override
    public Time time() {
        return super.time();
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<Plugin<ClientQuotaCallback>> clientQuotaCallback() {
        return this.clientQuotaCallback;
    }

    @Override
    public MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("mutation-rate", QuotaType.CONTROLLER_MUTATION.toString(), "Tracking mutation-rate per user/client-id", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    @Override
    public boolean backpressureEnabled() {
        return false;
    }

    @Override
    public int recordAndGetThrottleTimeMs(Session session, String clientId, double value, long timeMs) {
        int n;
        ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
        Sensor quotaSensor = clientSensors.quotaSensor();
        try {
            Sensor sensor = quotaSensor;
            synchronized (sensor) {
                quotaSensor.checkQuotas(timeMs);
                quotaSensor.record(value, timeMs, false);
            }
            n = 0;
        }
        catch (QuotaViolationException e) {
            int throttleTimeMs = (int)this.throttleTimeMs(e);
            this.debug((Function0<String> & Serializable)() -> "Quota violated for sensor (" + quotaSensor.name() + "). Delay time: (" + throttleTimeMs + ")");
            n = throttleTimeMs;
        }
        return n;
    }

    public long throttleTimeMs(QuotaViolationException e) {
        return QuotaUtils.boundedTokenBucketThrottleTime(e, this.quotaMaxThrottleTimeMs());
    }

    public ControllerMutationQuota newStrictQuotaFor(Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new StrictControllerMutationQuota(this.time(), clientSensors.quotaSensor(), this);
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newStrictQuotaFor(RequestChannel.Request request) {
        return this.newStrictQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newPermissiveQuotaFor(Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new PermissiveControllerMutationQuota(this.time(), clientSensors.quotaSensor(), this);
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newPermissiveQuotaFor(RequestChannel.Request request) {
        return this.newPermissiveQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newQuotaFor(RequestChannel.Request request, short strictSinceVersion) {
        if (request.header().apiVersion() >= strictSinceVersion) {
            return this.newStrictQuotaFor(request);
        }
        return this.newPermissiveQuotaFor(request);
    }

    public ControllerMutationQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<Plugin<ClientQuotaCallback>> clientQuotaCallback) {
        this.config = config;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.clientQuotaCallback = clientQuotaCallback;
        super(config, metrics, QuotaType.CONTROLLER_MUTATION, time, threadNamePrefix, clientQuotaCallback, ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
    }
}

