/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.server.AlterPartitionItem;
import kafka.server.AlterPartitionManager;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.common.ControllerRequestCompletionHandler;
import org.apache.kafka.server.common.NodeToControllerChannelManager;
import org.apache.kafka.server.common.TopicIdPartition;
import org.apache.kafka.server.util.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u0005me\u0001\u0002\r\u001a\u0001yA\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\t{\u0001\u0011\t\u0011)A\u0005c!Aa\b\u0001BC\u0002\u0013\u0005q\b\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003A\u0011!9\u0005A!b\u0001\n\u0003A\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u0011A\u0003!Q1A\u0005\u0002EC\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t-\u0002\u0011)\u0019!C\u0001/\"Aa\f\u0001B\u0001B\u0003%\u0001\fC\u0003`\u0001\u0011\u0005\u0001\r\u0003\u0005h\u0001\t\u0007I\u0011A\ri\u0011\u0019A\b\u0001)A\u0005S\"9\u0011\u0010\u0001b\u0001\n\u0013Q\bbBA\u0002\u0001\u0001\u0006Ia\u001f\u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011\u001d\ty\u0001\u0001C!\u0003\u000fAq!!\u0005\u0001\t\u0003\n\u0019\u0002\u0003\u0005\u0002:\u0001!\t!GA\u0004\u0011!\tY\u0004\u0001C\u00013\u0005\u001d\u0001bBA\u001f\u0001\u0011%\u0011q\b\u0005\b\u0003;\u0002A\u0011BA0\u0011\u001d\tY\b\u0001C\u0005\u0003{\u0012A\u0004R3gCVdG/\u00117uKJ\u0004\u0016M\u001d;ji&|g.T1oC\u001e,'O\u0003\u0002\u001b7\u000511/\u001a:wKJT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001q$J\u0015\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t1s%D\u0001\u001a\u0013\tA\u0013DA\u000bBYR,'\u000fU1si&$\u0018n\u001c8NC:\fw-\u001a:\u0011\u0005)jS\"A\u0016\u000b\u00051Z\u0012!B;uS2\u001c\u0018B\u0001\u0018,\u0005\u001daunZ4j]\u001e\f\u0001dY8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s+\u0005\t\u0004C\u0001\u001a<\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0019\u0019w.\\7p]*\u0011!D\u000e\u0006\u00039]R!\u0001O\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0014aA8sO&\u0011Ah\r\u0002\u001f\u001d>$W\rV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\f\u0011dY8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3sA\u0005I1o\u00195fIVdWM]\u000b\u0002\u0001B\u0011\u0011\tR\u0007\u0002\u0005*\u00111)N\u0001\u0005kRLG.\u0003\u0002F\u0005\nI1k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013\u0001\u0002;j[\u0016,\u0012!\u0013\t\u0003\u00156k\u0011a\u0013\u0006\u0003Y1S!\u0001\u000e\u001c\n\u00059[%\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\n\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0002%B\u0011\u0001eU\u0005\u0003)\u0006\u00121!\u00138u\u0003%\u0011'o\\6fe&#\u0007%A\nce>\\WM]#q_\u000eD7+\u001e9qY&,'/F\u0001Y!\r\u0001\u0013lW\u0005\u00035\u0006\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0005\u0001b\u0016BA/\"\u0005\u0011auN\\4\u0002)\t\u0014xn[3s\u000bB|7\r[*vaBd\u0017.\u001a:!\u0003\u0019a\u0014N\\5u}Q1\u0011MY2eK\u001a\u0004\"A\n\u0001\t\u000b=Z\u0001\u0019A\u0019\t\u000byZ\u0001\u0019\u0001!\t\u000b\u001d[\u0001\u0019A%\t\u000bA[\u0001\u0019\u0001*\t\u000bY[\u0001\u0019\u0001-\u0002!Ut7/\u001a8u\u0013N\u0014X\u000b\u001d3bi\u0016\u001cX#A5\u0011\t)\u0004(/^\u0007\u0002W*\u0011A.\\\u0001\u000bG>t7-\u001e:sK:$(BA\"o\u0015\u0005y\u0017\u0001\u00026bm\u0006L!!]6\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u00023g&\u0011Ao\r\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004\"A\n<\n\u0005]L\"AE!mi\u0016\u0014\b+\u0019:uSRLwN\\%uK6\f\u0011#\u001e8tK:$\u0018j\u001d:Va\u0012\fG/Z:!\u0003=IgN\u001a7jO\"$(+Z9vKN$X#A>\u0011\u0005q|X\"A?\u000b\u0005y\\\u0017AB1u_6L7-C\u0002\u0002\u0002u\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017\u0001E5oM2Lw\r\u001b;SKF,Xm\u001d;!\u0003\u0015\u0019H/\u0019:u)\t\tI\u0001E\u0002!\u0003\u0017I1!!\u0004\"\u0005\u0011)f.\u001b;\u0002\u0011MDW\u000f\u001e3po:\faa];c[&$H\u0003CA\u000b\u0003O\tY#a\f\u0011\u000b)\f9\"a\u0007\n\u0007\u0005e1NA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003C1\u0014\u0001C7fi\u0006$\u0017\r^1\n\t\u0005\u0015\u0012q\u0004\u0002\r\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d\u0005\u0007\u0003S\u0011\u0002\u0019\u0001:\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007bBA\u0017%\u0001\u0007\u00111D\u0001\rY\u0016\fG-\u001a:B]\u0012L5O\u001d\u0005\b\u0003c\u0011\u0002\u0019AA\u001a\u0003Q\u0001(o\u001c9bO\u0006$X-S7nK\u0012L\u0017\r^3msB\u0019\u0001%!\u000e\n\u0007\u0005]\u0012EA\u0004C_>dW-\u00198\u000215\f\u0017PY3Qe>\u0004\u0018mZ1uK&\u001b(o\u00115b]\u001e,7/\u0001\u000bdY\u0016\f'/\u00138GY&<\u0007\u000e\u001e*fcV,7\u000f^\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000f\u0006\u0003\u0002\n\u0005\u0005\u0003bBA\"+\u0001\u0007\u0011QI\u0001\u001cS:4G.[4ii\u0006cG/\u001a:QCJ$\u0018\u000e^5p]&#X-\\:\u0011\u000b\u0005\u001d\u0013qK;\u000f\t\u0005%\u00131\u000b\b\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)\u0019\u0011qJ\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0013bAA+C\u00059\u0001/Y2lC\u001e,\u0017\u0002BA-\u00037\u00121aU3r\u0015\r\t)&I\u0001\rEVLG\u000e\u001a*fcV,7\u000f\u001e\u000b\u0007\u0003C\n)(a\u001e\u0011\t\u0005\r\u0014q\u000e\b\u0005\u0003K\nY'\u0004\u0002\u0002h)\u0019\u0011\u0011\u000e'\u0002\u0011I,\u0017/^3tiNLA!!\u001c\u0002h\u0005)\u0012\t\u001c;feB\u000b'\u000f^5uS>t'+Z9vKN$\u0018\u0002BA9\u0003g\u0012qAQ;jY\u0012,'O\u0003\u0003\u0002n\u0005\u001d\u0004bBA\"-\u0001\u0007\u0011Q\t\u0005\u0007\u0003s2\u0002\u0019A.\u0002\u0017\t\u0014xn[3s\u000bB|7\r[\u0001\u001dQ\u0006tG\r\\3BYR,'\u000fU1si&$\u0018n\u001c8SKN\u0004xN\\:f)!\ty(a#\u0002\u0016\u0006e\u0005\u0003BAA\u0003\u000fk!!a!\u000b\u0007\u0005\u0015E*\u0001\u0005qe>$xnY8m\u0013\u0011\tI)a!\u0003\r\u0015\u0013(o\u001c:t\u0011\u001d\tii\u0006a\u0001\u0003\u001f\u000b!#\u00197uKJ\u0004\u0016M\u001d;ji&|gNU3taB!\u0011QMAI\u0013\u0011\t\u0019*a\u001a\u0003-\u0005cG/\u001a:QCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016Da!a&\u0018\u0001\u0004Y\u0016aD:f]R\u0014%o\\6fe\u0016\u0003xn\u00195\t\u000f\u0005\rs\u00031\u0001\u0002F\u0001")
public class DefaultAlterPartitionManager
implements AlterPartitionManager,
Logging {
    private final NodeToControllerChannelManager controllerChannelManager;
    private final Scheduler scheduler;
    private final Time time;
    private final int brokerId;
    private final Function0<Object> brokerEpochSupplier;
    private final ConcurrentHashMap<TopicIdPartition, AlterPartitionItem> unsentIsrUpdates;
    private final AtomicBoolean inflightRequest;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DefaultAlterPartitionManager defaultAlterPartitionManager = this;
        synchronized (defaultAlterPartitionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public NodeToControllerChannelManager controllerChannelManager() {
        return this.controllerChannelManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Time time() {
        return this.time;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Function0<Object> brokerEpochSupplier() {
        return this.brokerEpochSupplier;
    }

    public ConcurrentHashMap<TopicIdPartition, AlterPartitionItem> unsentIsrUpdates() {
        return this.unsentIsrUpdates;
    }

    private AtomicBoolean inflightRequest() {
        return this.inflightRequest;
    }

    @Override
    public void start() {
        this.controllerChannelManager().start();
    }

    @Override
    public void shutdown() {
        this.controllerChannelManager().shutdown();
    }

    @Override
    public CompletableFuture<LeaderAndIsr> submit(TopicIdPartition topicIdPartition, LeaderAndIsr leaderAndIsr, boolean propagateImmediately) {
        boolean enqueued;
        CompletableFuture<LeaderAndIsr> future = new CompletableFuture<LeaderAndIsr>();
        AlterPartitionItem alterPartitionItem = new AlterPartitionItem(topicIdPartition, leaderAndIsr, future);
        boolean bl = enqueued = this.unsentIsrUpdates().putIfAbsent(alterPartitionItem.topicIdPartition(), alterPartitionItem) == null;
        if (enqueued) {
            this.maybePropagateIsrChanges();
            v1 = BoxedUnit.UNIT;
        } else {
            v1 = BoxesRunTime.boxToBoolean(future.completeExceptionally(new OperationNotAttemptedException("Failed to enqueue ISR change state " + leaderAndIsr + " for partition " + topicIdPartition)));
        }
        return future;
    }

    public void maybePropagateIsrChanges() {
        if (!this.unsentIsrUpdates().isEmpty() && this.inflightRequest().compareAndSet(false, true)) {
            ListBuffer inflightAlterPartitionItems = new ListBuffer();
            this.unsentIsrUpdates().values().forEach(item -> inflightAlterPartitionItems.append(item));
            this.sendRequest(inflightAlterPartitionItems.toSeq());
            return;
        }
    }

    public void clearInFlightRequest() {
        if (!this.inflightRequest().compareAndSet(true, false)) {
            this.warn((Function0<String> & Serializable)() -> "Attempting to clear AlterPartition in-flight flag when no apparent request is in-flight");
            return;
        }
    }

    private void sendRequest(Seq<AlterPartitionItem> inflightAlterPartitionItems) {
        long brokerEpoch = this.brokerEpochSupplier().apply$mcJ$sp();
        AlterPartitionRequest.Builder request = this.buildRequest(inflightAlterPartitionItems, brokerEpoch);
        this.debug((Function0<String> & Serializable)() -> "Sending AlterPartition to controller " + request);
        this.controllerChannelManager().sendRequest(request, new ControllerRequestCompletionHandler(this, brokerEpoch, inflightAlterPartitionItems){
            private final /* synthetic */ DefaultAlterPartitionManager $outer;
            private final long brokerEpoch$1;
            private final Seq inflightAlterPartitionItems$2;

            public void onComplete(ClientResponse response) {
                Errors error;
                Errors errors;
                this.$outer.debug((Function0<String> & Serializable)() -> "Received AlterPartition response " + response);
                try {
                    errors = response.authenticationException() != null ? Errors.NETWORK_EXCEPTION : (response.versionMismatch() != null ? Errors.UNSUPPORTED_VERSION : this.$outer.kafka$server$DefaultAlterPartitionManager$$handleAlterPartitionResponse((AlterPartitionResponse)response.responseBody(), this.brokerEpoch$1, this.inflightAlterPartitionItems$2));
                }
                finally {
                    this.$outer.clearInFlightRequest();
                }
                Errors errors2 = error = errors;
                if (((Object)((Object)Errors.NONE)).equals((Object)((Object)errors2))) {
                    this.$outer.maybePropagateIsrChanges();
                    return;
                }
                this.$outer.scheduler().scheduleOnce("send-alter-partition", () -> $this.$outer.maybePropagateIsrChanges(), 50L);
            }

            public void onTimeout() {
                throw new IllegalStateException("Encountered unexpected timeout when sending AlterPartition to the controller");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.brokerEpoch$1 = brokerEpoch$1;
                this.inflightAlterPartitionItems$2 = inflightAlterPartitionItems$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onComplete$1(org.apache.kafka.clients.ClientResponse )}, serializedLambda);
            }
        });
    }

    private AlterPartitionRequest.Builder buildRequest(Seq<AlterPartitionItem> inflightAlterPartitionItems, long brokerEpoch) {
        AlterPartitionRequestData message = new AlterPartitionRequestData().setBrokerId(this.brokerId()).setBrokerEpoch(brokerEpoch);
        inflightAlterPartitionItems.groupBy((Function1<AlterPartitionItem, Uuid> & Serializable)x$1 -> x$1.topicIdPartition().topicId()).foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            DefaultAlterPartitionManager.$anonfun$buildRequest$2(message, x0$1);
            return BoxedUnit.UNIT;
        });
        return new AlterPartitionRequest.Builder(message);
    }

    public Errors kafka$server$DefaultAlterPartitionManager$$handleAlterPartitionResponse(AlterPartitionResponse alterPartitionResp, long sentBrokerEpoch, Seq<AlterPartitionItem> inflightAlterPartitionItems) {
        AlterPartitionResponseData data = alterPartitionResp.data();
        Errors errors = Errors.forCode(data.errorCode());
        if (((Object)((Object)Errors.STALE_BROKER_EPOCH)).equals((Object)errors)) {
            this.warn((Function0<String> & Serializable)() -> "Broker had a stale broker epoch (" + sentBrokerEpoch + "), retrying.");
        } else if (((Object)((Object)Errors.CLUSTER_AUTHORIZATION_FAILED)).equals((Object)errors)) {
            this.error((Function0<String> & Serializable)() -> "Broker is not authorized to send AlterPartition to controller", (Function0<Throwable>)(Function0<ApiException> & Serializable)() -> Errors.CLUSTER_AUTHORIZATION_FAILED.exception("Broker is not authorized to send AlterPartition to controller"));
        } else if (((Object)((Object)Errors.NONE)).equals((Object)errors)) {
            Object partitionResponses = HashMap$.MODULE$.empty();
            data.topics().forEach(arg_0 -> DefaultAlterPartitionManager.$anonfun$handleAlterPartitionResponse$4((HashMap)partitionResponses, arg_0));
            inflightAlterPartitionItems.foreach(arg_0 -> DefaultAlterPartitionManager.$anonfun$handleAlterPartitionResponse$6(this, (HashMap)partitionResponses, arg_0));
        } else {
            this.warn((Function0<String> & Serializable)() -> "Controller returned an unexpected top-level error when handling AlterPartition request: " + errors);
        }
        return Errors.forCode(data.errorCode());
    }

    public static final /* synthetic */ boolean $anonfun$buildRequest$3(AlterPartitionRequestData.TopicData topicData$1, AlterPartitionItem item) {
        LeaderRecoveryState leaderRecoveryState = item.leaderAndIsr().leaderRecoveryState();
        LeaderRecoveryState leaderRecoveryState2 = LeaderRecoveryState.RECOVERING;
        AlterPartitionRequestData.PartitionData partitionData = new AlterPartitionRequestData.PartitionData().setPartitionIndex(item.topicIdPartition().partitionId()).setLeaderEpoch(item.leaderAndIsr().leaderEpoch()).setNewIsrWithEpochs(item.leaderAndIsr().isrWithBrokerEpoch()).setPartitionEpoch(item.leaderAndIsr().partitionEpoch()).setIsUnclean(!(leaderRecoveryState != null ? !((Object)((Object)leaderRecoveryState)).equals((Object)leaderRecoveryState2) : leaderRecoveryState2 != null));
        partitionData.setLeaderRecoveryState(item.leaderAndIsr().leaderRecoveryState().value());
        item.leaderAndIsr().clusterLinkState().ifPresent(linkState -> {
            partitionData.setClusterLinkState(new AlterPartitionRequestData.ClusterLinkState().setLinkedLeaderEpoch(linkState.linkedLeaderEpoch()).setLinkFailed(linkState.linkFailed()));
            if (linkState.linkFailed()) {
                partitionData.setMirrorTopicError(linkState.error().code());
                return;
            }
        });
        return topicData$1.partitions().add(partitionData);
    }

    public static final /* synthetic */ void $anonfun$buildRequest$2(AlterPartitionRequestData message$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Uuid topicId = (Uuid)tuple2._1();
            Seq items = (Seq)tuple2._2();
            AlterPartitionRequestData.TopicData topicData = new AlterPartitionRequestData.TopicData().setTopicId(topicId);
            message$1.topics().add(topicData);
            items.foreach((Function1<AlterPartitionItem, Object> & Serializable)item -> BoxesRunTime.boxToBoolean(DefaultAlterPartitionManager.$anonfun$buildRequest$3(topicData, item)));
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$handleAlterPartitionResponse$4(HashMap partitionResponses$1, AlterPartitionResponseData.TopicData topic) {
        topic.partitions().forEach(partition -> {
            TopicIdPartition tp = new TopicIdPartition(topic.topicId(), partition.partitionIndex());
            partitionResponses$1.update(tp, partition);
        });
    }

    public static final /* synthetic */ Object $anonfun$handleAlterPartitionResponse$6(DefaultAlterPartitionManager $this, HashMap partitionResponses$1, AlterPartitionItem inflightAlterPartition) {
        Option option = partitionResponses$1.get(inflightAlterPartition.topicIdPartition());
        if (option instanceof Some) {
            Some some = (Some)option;
            AlterPartitionResponseData.PartitionData response = (AlterPartitionResponseData.PartitionData)some.value();
            $this.unsentIsrUpdates().remove(inflightAlterPartition.topicIdPartition());
            Errors error = Errors.forCode(response.errorCode());
            $this.debug((Function0<String> & Serializable)() -> "Controller response returned for AlterIsr request for " + inflightAlterPartition.topicIdPartition() + ": " + response);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null)) {
                return BoxesRunTime.boxToBoolean(inflightAlterPartition.future().complete(new LeaderAndIsr(response.leaderId(), response.leaderEpoch(), response.isr(), inflightAlterPartition.leaderAndIsr().leaderRecoveryState(), response.partitionEpoch(), inflightAlterPartition.leaderAndIsr().clusterLinkState())));
            }
            return BoxesRunTime.boxToBoolean(inflightAlterPartition.future().completeExceptionally(error.exception()));
        }
        if (None$.MODULE$.equals(option)) {
            $this.warn((Function0<String> & Serializable)() -> "Partition " + inflightAlterPartition.topicIdPartition() + " was sent but not included in the response");
            return BoxedUnit.UNIT;
        }
        throw new MatchError(option);
    }

    public DefaultAlterPartitionManager(NodeToControllerChannelManager controllerChannelManager, Scheduler scheduler, Time time, int brokerId, Function0<Object> brokerEpochSupplier) {
        this.controllerChannelManager = controllerChannelManager;
        this.scheduler = scheduler;
        this.time = time;
        this.brokerId = brokerId;
        this.brokerEpochSupplier = brokerEpochSupplier;
        AlterPartitionManager.$init$(this);
        Logging.$init$(this);
        this.unsentIsrUpdates = new ConcurrentHashMap();
        this.inflightRequest = new AtomicBoolean(false);
    }
}

