/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kafka.server.DelayedRemoteFetchMetrics$;
import kafka.server.FetchPartitionStatus;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.server.LogReadResult;
import org.apache.kafka.server.purgatory.DelayedOperation;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.server.storage.log.FetchPartitionStats;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.RemoteLogReadResult;
import org.apache.kafka.storage.internals.log.RemoteStorageFetchInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcZ$sp;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005=b\u0001\u0002\b\u0010\u0001QA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tq\u0001\u0011\t\u0011)A\u0005s!Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!\t\u0006A!A!\u0002\u0013\u0011\u0006\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011\u00024\t\u00111\u0004!\u0011!Q\u0001\n5D\u0001b\u001d\u0001\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\to\u0002\u0011\t\u0011)A\u0005q\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\u0010\u0001\u0011\u0005\u0013\u0011\u0005\u0005\b\u0003S\u0001A\u0011IA\u0016\u0011\u001d\ti\u0003\u0001C!\u0003W\u0011!\u0003R3mCf,GMU3n_R,g)\u001a;dQ*\u0011\u0001#E\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003I\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001+\u0005\u0002\"AF\u0010\u000e\u0003]Q!\u0001G\r\u0002\u0013A,(oZ1u_JL(B\u0001\t\u001b\u0015\t\u00112D\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<\u0017B\u0001\u0011\u0018\u0005A!U\r\\1zK\u0012|\u0005/\u001a:bi&|g\u000e\u0005\u0002#K5\t1E\u0003\u0002%#\u0005)Q\u000f^5mg&\u0011ae\t\u0002\b\u0019><w-\u001b8h\u0003=\u0011X-\\8uK\u001a+Go\u00195UCN\\\u0007cA\u00151e5\t!F\u0003\u0002,Y\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u00055r\u0013\u0001B;uS2T\u0011aL\u0001\u0005U\u00064\u0018-\u0003\u00022U\t1a)\u001e;ve\u0016\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\u0018\u0002\t1\fgnZ\u0005\u0003oQ\u0012AAV8jI\u0006\t\"/Z7pi\u00164U\r^2i%\u0016\u001cX\u000f\u001c;\u0011\u0007%RD(\u0003\u0002<U\t\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\u0005u\"U\"\u0001 \u000b\u0005}\u0002\u0015a\u00017pO*\u0011\u0011IQ\u0001\nS:$XM\u001d8bYNT!a\u0011\u000e\u0002\u000fM$xN]1hK&\u0011QI\u0010\u0002\u0014%\u0016lw\u000e^3M_\u001e\u0014V-\u00193SKN,H\u000e^\u0001\u0010e\u0016lw\u000e^3GKR\u001c\u0007.\u00138g_B\u0011Q\bS\u0005\u0003\u0013z\u0012aCU3n_R,7\u000b^8sC\u001e,g)\u001a;dQ&sgm\\\u0001\u0015e\u0016lw\u000e^3GKR\u001c\u0007.T1y/\u0006LG/T:\u0011\u00051{U\"A'\u000b\u00039\u000bQa]2bY\u0006L!\u0001U'\u0003\t1{gnZ\u0001\u0015M\u0016$8\r\u001b)beRLG/[8o'R\fG/^:\u0011\u0007M3\u0006,D\u0001U\u0015\t)V*\u0001\u0006d_2dWm\u0019;j_:L!a\u0016+\u0003\u0007M+\u0017\u000f\u0005\u0003M3n\u000b\u0017B\u0001.N\u0005\u0019!V\u000f\u001d7feA\u0011AlX\u0007\u0002;*\u0011aLG\u0001\u0007G>lWn\u001c8\n\u0005\u0001l&\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o!\t\u00117-D\u0001\u0010\u0013\t!wB\u0001\u000bGKR\u001c\u0007\u000eU1si&$\u0018n\u001c8Ti\u0006$Xo]\u0001\fM\u0016$8\r\u001b)be\u0006l7\u000f\u0005\u0002hU6\t\u0001N\u0003\u0002@S*\u00111)G\u0005\u0003W\"\u00141BR3uG\"\u0004\u0016M]1ng\u0006\u0001Bn\\2bYJ+\u0017\r\u001a*fgVdGo\u001d\t\u0004'Zs\u0007\u0003\u0002'Z7>\u0004\"\u0001]9\u000e\u0003eI!A]\r\u0003\u001b1{wMU3bIJ+7/\u001e7u\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"AY;\n\u0005Y|!A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0011e\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0004R\u0001T=|\u0003\u0003I!A_'\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA*WyB!A*W.~!\t9g0\u0003\u0002\u0000Q\n\u0011b)\u001a;dQB\u000b'\u000f^5uS>tG)\u0019;b!\ra\u00151A\u0005\u0004\u0003\u000bi%\u0001B+oSR\fa\u0001P5oSRtD\u0003FA\u0006\u0003\u001b\ty!!\u0005\u0002\u0014\u0005U\u0011qCA\r\u00037\ti\u0002\u0005\u0002c\u0001!)qE\u0003a\u0001Q!)\u0001H\u0003a\u0001s!)aI\u0003a\u0001\u000f\")!J\u0003a\u0001\u0017\")\u0011K\u0003a\u0001%\")QM\u0003a\u0001M\")AN\u0003a\u0001[\")1O\u0003a\u0001i\")qO\u0003a\u0001q\u0006YAO]=D_6\u0004H.\u001a;f)\t\t\u0019\u0003E\u0002M\u0003KI1!a\nN\u0005\u001d\u0011un\u001c7fC:\fAb\u001c8FqBL'/\u0019;j_:$\"!!\u0001\u0002\u0015=t7i\\7qY\u0016$X\r")
public class DelayedRemoteFetch
extends DelayedOperation
implements Logging {
    private final Future<Void> remoteFetchTask;
    private final CompletableFuture<RemoteLogReadResult> remoteFetchResult;
    private final RemoteStorageFetchInfo remoteFetchInfo;
    private final Seq<Tuple2<TopicIdPartition, FetchPartitionStatus>> fetchPartitionStatus;
    private final FetchParams fetchParams;
    private final Seq<Tuple2<TopicIdPartition, LogReadResult>> localReadResults;
    private final ReplicaManager replicaManager;
    private final Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DelayedRemoteFetch delayedRemoteFetch = this;
        synchronized (delayedRemoteFetch) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public boolean tryComplete() {
        boolean bl;
        Object object = new Object();
        try {
            this.fetchPartitionStatus.foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Object object;
                    TopicIdPartition topicPartition = (TopicIdPartition)tuple2._1();
                    FetchPartitionStatus fetchStatus = (FetchPartitionStatus)tuple2._2();
                    LogOffsetMetadata fetchOffset = fetchStatus.startOffsetMetadata();
                    try {
                        LogOffsetMetadata logOffsetMetadata = fetchOffset;
                        LogOffsetMetadata logOffsetMetadata2 = LogOffsetMetadata.UNKNOWN_OFFSET_METADATA;
                        object = (logOffsetMetadata == null ? logOffsetMetadata2 != null : !((Object)logOffsetMetadata).equals(logOffsetMetadata2)) ? $this.replicaManager.getPartitionOrException(topicPartition.topicPartition()) : BoxedUnit.UNIT;
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        this.debug((Function0<String> & Serializable)() -> "Partition " + topicPartition + " is in an offline log directory, satisfy " + $this.fetchParams + " immediately");
                        throw new NonLocalReturnControl$mcZ$sp(object, this.forceComplete());
                    }
                    catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                        this.debug((Function0<String> & Serializable)() -> "Broker no longer knows of partition " + topicPartition + ", satisfy " + $this.fetchParams + " immediately");
                        throw new NonLocalReturnControl$mcZ$sp(object, this.forceComplete());
                    }
                    catch (NotLeaderOrFollowerException notLeaderOrFollowerException) {
                        this.debug((Function0<String> & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Broker is no longer the leader or follower of %s, satisfy %s immediately"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{topicPartition, $this.fetchParams})));
                        throw new NonLocalReturnControl$mcZ$sp(object, this.forceComplete());
                    }
                    return object;
                }
                throw new MatchError(tuple2);
            });
            bl = this.remoteFetchResult.isDone() ? this.forceComplete() : false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    @Override
    public void onExpiration() {
        boolean cancelled = this.remoteFetchTask.cancel(false);
        if (!cancelled) {
            this.debug((Function0<String> & Serializable)() -> "Remote fetch task for RemoteStorageFetchInfo: " + $this.remoteFetchInfo + " could not be cancelled and its isDone value is " + $this.remoteFetchTask.isDone());
        }
        DelayedRemoteFetchMetrics$.MODULE$.expiredRequestMeter().mark();
    }

    @Override
    public void onComplete() {
        Seq fetchPartitionData = (Seq)this.localReadResults.map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicIdPartition tp = (TopicIdPartition)tuple2._1();
                LogReadResult result = (LogReadResult)tuple2._2();
                if (tp.topicPartition().equals($this.remoteFetchInfo.topicPartition) && $this.remoteFetchResult.isDone()) {
                    Errors errors = result.error();
                    Errors errors2 = Errors.NONE;
                    if (!(errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null) && result.info().delayedRemoteStorageFetch.isPresent()) {
                        if ($this.remoteFetchResult.get().error.isPresent()) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), new LogReadResult(new FetchDataInfo(LogOffsetMetadata.UNKNOWN_OFFSET_METADATA, MemoryRecords.EMPTY), Optional.empty(), -1L, -1L, -1L, -1L, -1L, OptionalLong.empty(), false, false, OptionalInt.empty(), Optional.of($this.remoteFetchResult.get().error.get()), 0L).toFetchPartitionData(false));
                        }
                        FetchDataInfo info = $this.remoteFetchResult.get().fetchDataInfo.get();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), new FetchPartitionData(result.error(), result.highWatermark(), result.leaderLogStartOffset(), info.records, Optional.empty(), result.lastStableOffset(), info.abortedTransactions, result.preferredReadReplica(), false, new FetchPartitionStats(0L, 0L)));
                    }
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), result.toFetchPartitionData(false));
            }
            throw new MatchError(tuple2);
        });
        this.responseCallback.apply(fetchPartitionData);
    }

    public DelayedRemoteFetch(Future<Void> remoteFetchTask, CompletableFuture<RemoteLogReadResult> remoteFetchResult, RemoteStorageFetchInfo remoteFetchInfo, long remoteFetchMaxWaitMs, Seq<Tuple2<TopicIdPartition, FetchPartitionStatus>> fetchPartitionStatus, FetchParams fetchParams, Seq<Tuple2<TopicIdPartition, LogReadResult>> localReadResults, ReplicaManager replicaManager, Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback) {
        this.remoteFetchTask = remoteFetchTask;
        this.remoteFetchResult = remoteFetchResult;
        this.remoteFetchInfo = remoteFetchInfo;
        this.fetchPartitionStatus = fetchPartitionStatus;
        this.fetchParams = fetchParams;
        this.localReadResults = localReadResults;
        this.replicaManager = replicaManager;
        this.responseCallback = responseCallback;
        super(remoteFetchMaxWaitMs);
        Logging.$init$(this);
        if (fetchParams.isFromFollower()) {
            throw new IllegalStateException("The follower should not invoke remote fetch. Fetch params are: " + fetchParams);
        }
    }
}

