/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.network.DataPlaneAcceptor$;
import kafka.network.SocketServer$;
import kafka.server.BrokerReconfigurable;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicListenerConfig$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.authenticator.LoginManager;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005Y<Q\u0001D\u0007\t\u0002I1Q\u0001F\u0007\t\u0002UAQ\u0001H\u0001\u0005\u0002uAqAH\u0001C\u0002\u0013\u0005q\u0004\u0003\u0004/\u0003\u0001\u0006I\u0001\t\u0004\u0005)5\u0001q\u0006\u0003\u0005\u000f\u000b\t\u0005\t\u0015!\u0003:\u0011\u0015aR\u0001\"\u0001=\u0011\u0015yT\u0001\"\u0011A\u0011\u0015aU\u0001\"\u0001N\u0011\u00151V\u0001\"\u0001X\u0011\u0015YV\u0001\"\u0003]\u0003U!\u0015P\\1nS\u000ed\u0015n\u001d;f]\u0016\u00148i\u001c8gS\u001eT!AD\b\u0002\rM,'O^3s\u0015\u0005\u0001\u0012!B6bM.\f7\u0001\u0001\t\u0003'\u0005i\u0011!\u0004\u0002\u0016\tft\u0017-\\5d\u0019&\u001cH/\u001a8fe\u000e{gNZ5h'\t\ta\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\tQCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7/F\u0001!!\r\tCEJ\u0007\u0002E)\u00111\u0005G\u0001\u000bG>dG.Z2uS>t\u0017BA\u0013#\u0005\r\u0019V\r\u001e\t\u0003O1j\u0011\u0001\u000b\u0006\u0003S)\nA\u0001\\1oO*\t1&\u0001\u0003kCZ\f\u0017BA\u0017)\u0005\u0019\u0019FO]5oO\u00061\"+Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001c\be\u0005\u0003\u0006-A\u001a\u0004CA\n2\u0013\t\u0011TB\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.\u001a\t\u0003i]j\u0011!\u000e\u0006\u0003m=\tQ!\u001e;jYNL!\u0001O\u001b\u0003\u000f1{wmZ5oOB\u00111CO\u0005\u0003w5\u00111bS1gW\u0006\u0014%o\\6feR\u0011QH\u0010\t\u0003'\u0015AQAD\u0004A\u0002e\nQC]3d_:4\u0017nZ;sC\ndWmQ8oM&<7/F\u0001B!\r\tCE\u0011\t\u0003\u0007*s!\u0001\u0012%\u0011\u0005\u0015CR\"\u0001$\u000b\u0005\u001d\u000b\u0012A\u0002\u001fs_>$h(\u0003\u0002J1\u00051\u0001K]3eK\u001aL!!L&\u000b\u0005%C\u0012a\u0006<bY&$\u0017\r^3SK\u000e|gNZ5hkJ\fG/[8o)\tq\u0015\u000b\u0005\u0002\u0018\u001f&\u0011\u0001\u000b\u0007\u0002\u0005+:LG\u000fC\u0003S\u0013\u0001\u00071+A\u0005oK^\u001cuN\u001c4jOB\u00111\u0003V\u0005\u0003+6\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006Y!/Z2p]\u001aLw-\u001e:f)\rq\u0005L\u0017\u0005\u00063*\u0001\raU\u0001\n_2$7i\u001c8gS\u001eDQA\u0015\u0006A\u0002M\u000ba\u0002\\5ti\u0016tWM]:U_6\u000b\u0007\u000f\u0006\u0002^cB!\u0011E\u00181n\u0013\ty&EA\u0002NCB\u0004\"!Y6\u000e\u0003\tT!a\u00193\u0002\u000f9,Go^8sW*\u0011QMZ\u0001\u0007G>lWn\u001c8\u000b\u0005A9'B\u00015j\u0003\u0019\t\u0007/Y2iK*\t!.A\u0002pe\u001eL!\u0001\u001c2\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0011\u00059|W\"\u00013\n\u0005A$'\u0001C#oIB|\u0017N\u001c;\t\u000bI\\\u0001\u0019A:\u0002\u00131L7\u000f^3oKJ\u001c\bcA\u0011u[&\u0011QO\t\u0002\u0004'\u0016\f\b")
public class DynamicListenerConfig
implements BrokerReconfigurable,
Logging {
    private final KafkaBroker server;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Set<String> ReconfigurableConfigs() {
        return DynamicListenerConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DynamicListenerConfig dynamicListenerConfig = this;
        synchronized (dynamicListenerConfig) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return DynamicListenerConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        KafkaConfig oldConfig = this.server.config();
        scala.collection.immutable.Set newListeners = ((IterableOnceOps)newConfig.listeners().map((Function1<Endpoint, ListenerName> & Serializable)l -> ListenerName.normalised(l.listener()))).toSet();
        scala.collection.immutable.Set oldAdvertisedListeners = ((IterableOnceOps)oldConfig.effectiveAdvertisedBrokerListeners().map((Function1<Endpoint, ListenerName> & Serializable)l -> ListenerName.normalised(l.listener()))).toSet();
        scala.collection.immutable.Set oldListeners = ((IterableOnceOps)oldConfig.listeners().map((Function1<Endpoint, ListenerName> & Serializable)l -> ListenerName.normalised(l.listener()))).toSet();
        if (!oldAdvertisedListeners.subsetOf(newListeners)) {
            throw new ConfigException("Advertised listeners '" + oldAdvertisedListeners + "' must be a subset of listeners '" + newListeners + "'");
        }
        if (!newListeners.subsetOf(CollectionConverters$.MODULE$.SetHasAsScala(newConfig.effectiveListenerSecurityProtocolMap().keySet()).asScala())) {
            throw new ConfigException("Listeners '" + newListeners + "' must be subset of listener map '" + newConfig.effectiveListenerSecurityProtocolMap() + "'");
        }
        newListeners.intersect(oldListeners).foreach((Function1<ListenerName, Object> & Serializable)listenerName -> {
            DynamicListenerConfig.$anonfun$validateReconfiguration$7(newConfig, oldConfig, listenerName);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Seq<Endpoint> newListeners = newConfig.listeners();
        Map<ListenerName, Endpoint> newListenerMap = this.listenersToMap(newListeners);
        Seq<Endpoint> oldListeners = oldConfig.listeners();
        Map<ListenerName, Endpoint> oldListenerMap = this.listenersToMap(oldListeners);
        Seq listenersRemoved = (Seq)oldListeners.filterNot((Function1<Endpoint, Object> & Serializable)e -> BoxesRunTime.boxToBoolean(newListenerMap.contains(ListenerName.normalised(e.listener()))));
        Seq listenersAdded = (Seq)newListeners.filterNot((Function1<Endpoint, Object> & Serializable)e -> BoxesRunTime.boxToBoolean(oldListenerMap.contains(ListenerName.normalised(e.listener()))));
        if (listenersRemoved.nonEmpty() || listenersAdded.nonEmpty()) {
            LoginManager.closeAll();
            if (listenersRemoved.nonEmpty()) {
                this.server.socketServer().removeListeners(listenersRemoved);
            }
            listenersRemoved.foreach((Function1<Endpoint, Object> & Serializable)listener -> {
                DynamicListenerConfig.$anonfun$reconfigure$6(this, listener);
                return BoxedUnit.UNIT;
            });
            if (listenersAdded.nonEmpty()) {
                this.server.socketServer().addListeners(listenersAdded);
            }
            listenersAdded.foreach((Function1<Endpoint, Object> & Serializable)listener -> {
                DynamicListenerConfig.$anonfun$reconfigure$7(this, listener);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private Map<ListenerName, Endpoint> listenersToMap(Seq<Endpoint> listeners) {
        return ((IterableOnceOps)listeners.map((Function1<Endpoint, Tuple2> & Serializable)e -> new Tuple2<ListenerName, Endpoint>(ListenerName.normalised(e.listener()), (Endpoint)e))).toMap($less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ boolean $anonfun$validateReconfiguration$8(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            return !DynamicBrokerConfig$.MODULE$.DynamicSecurityConfigs().contains(key) && !SocketServer$.MODULE$.ListenerQuotaReconfigurableConfigs().contains(key) && !DataPlaneAcceptor$.MODULE$.ListenerReconfigurableConfigs().contains(key);
        }
        throw new MatchError(tuple2);
    }

    private static final Map immutableListenerConfigs$1(KafkaConfig kafkaConfig, String prefix) {
        return (Map)CollectionConverters$.MODULE$.MapHasAsScala(kafkaConfig.originalsWithPrefix(prefix, true)).asScala().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(DynamicListenerConfig.$anonfun$validateReconfiguration$8(x0$1)));
    }

    public static final /* synthetic */ void $anonfun$validateReconfiguration$7(KafkaConfig newConfig$5, KafkaConfig oldConfig$3, ListenerName listenerName) {
        Map map = DynamicListenerConfig.immutableListenerConfigs$1(newConfig$5, listenerName.configPrefix());
        Map map2 = DynamicListenerConfig.immutableListenerConfigs$1(oldConfig$3, listenerName.configPrefix());
        if (map == null ? map2 != null : !((Object)map).equals(map2)) {
            throw new ConfigException("Configs cannot be updated dynamically for existing listener " + listenerName + ", restart broker or create a new listener for update");
        }
        if (!BoxesRunTime.equals((Object)oldConfig$3.effectiveListenerSecurityProtocolMap().get(listenerName), (Object)newConfig$5.effectiveListenerSecurityProtocolMap().get(listenerName))) {
            throw new ConfigException("Security protocol cannot be updated for existing listener " + listenerName);
        }
    }

    public static final /* synthetic */ void $anonfun$reconfigure$6(DynamicListenerConfig $this, Endpoint listener) {
        $this.server.quotaManagers().request().removeListenerMetrics(listener.listener());
    }

    public static final /* synthetic */ void $anonfun$reconfigure$7(DynamicListenerConfig $this, Endpoint listener) {
        $this.server.quotaManagers().request().addListenerMetrics(listener.listener());
    }

    public DynamicListenerConfig(KafkaBroker server) {
        this.server = server;
        Logging.$init$(this);
    }
}

