/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.coordinator.quota.QuotaCoordinator;
import kafka.server.AbstractQuotaChannelManager;
import kafka.server.DynamicQuotaChannelManager$;
import kafka.server.DynamicQuotaPublishingRequestThread;
import kafka.server.DynamicQuotaReportingRequestThread;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataCache;
import org.apache.kafka.server.util.KafkaScheduler;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005-r!B\n\u0015\u0011\u0003Ib!B\u000e\u0015\u0011\u0003a\u0002\"B\u0012\u0002\t\u0003!\u0003\"B\u0013\u0002\t\u00031c\u0001B\u000e\u0015\u0001mC\u0001b\u000b\u0003\u0003\u0002\u0003\u0006I\u0001\f\u0005\ta\u0011\u0011\t\u0011)A\u0005c!Aa\b\u0002B\u0001B\u0003%q\b\u0003\u0005G\t\t\u0005\t\u0015!\u0003H\u0011!qEA!A!\u0002\u0013y\u0005\u0002C,\u0005\u0005\u0003\u0005\u000b\u0011\u0002-\t\u000b\r\"A\u0011\u0001/\t\u000f\u0011$!\u0019!C!K\"1\u0011\u000e\u0002Q\u0001\n\u0019DqA\u001b\u0003C\u0002\u0013\u00053\u000e\u0003\u0004p\t\u0001\u0006I\u0001\u001c\u0005\u0006a\u0012!\t%\u001d\u0005\u0006}\u0012!\te \u0005\b\u0003\u0003!A\u0011BA\u0002\u0003i!\u0015P\\1nS\u000e\fVo\u001c;b\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0015\t)b#\u0001\u0004tKJ4XM\u001d\u0006\u0002/\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u000e\u0002\u001b\u0005!\"A\u0007#z]\u0006l\u0017nY)v_R\f7\t[1o]\u0016dW*\u00198bO\u0016\u00148CA\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!G\u0001\u0006CB\u0004H.\u001f\u000b\bO)zS(R'W!\tQ\u0002&\u0003\u0002*)\tY\u0012IY:ue\u0006\u001cG/U;pi\u0006\u001c\u0005.\u00198oK2l\u0015M\\1hKJDQaK\u0002A\u00021\naaY8oM&<\u0007C\u0001\u000e.\u0013\tqCCA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\"\u0002\u0019\u0004\u0001\u0004\t\u0014aB7fiJL7m\u001d\t\u0003emj\u0011a\r\u0006\u0003aQR!!\u000e\u001c\u0002\r\r|W.\\8o\u0015\t9rG\u0003\u00029s\u00051\u0011\r]1dQ\u0016T\u0011AO\u0001\u0004_J<\u0017B\u0001\u001f4\u0005\u001diU\r\u001e:jGNDQAP\u0002A\u0002}\nQ\"\\3uC\u0012\fG/Y\"bG\",\u0007C\u0001!D\u001b\u0005\t%B\u0001\"7\u0003!iW\r^1eCR\f\u0017B\u0001#B\u00055iU\r^1eCR\f7)Y2iK\")ai\u0001a\u0001\u000f\u0006!A/[7f!\tA5*D\u0001J\u0015\tQE'A\u0003vi&d7/\u0003\u0002M\u0013\n!A+[7f\u0011\u0015q5\u00011\u0001P\u00039Y\u0017MZ6b'\u000eDW\rZ;mKJ\u0004\"\u0001\u0015+\u000e\u0003ES!AU*\u0002\tU$\u0018\u000e\u001c\u0006\u0003+YJ!!V)\u0003\u001d-\u000bgm[1TG\",G-\u001e7fe\")qk\u0001a\u00011\u0006QAn\\4D_:$X\r\u001f;\u0011\u0005!K\u0016B\u0001.J\u0005)aunZ\"p]R,\u0007\u0010^\n\u0004\tu9CcB/_?\u0002\f'm\u0019\t\u00035\u0011AQaK\u0006A\u00021BQ\u0001M\u0006A\u0002EBQAP\u0006A\u0002}BQAR\u0006A\u0002\u001dCQAT\u0006A\u0002=CQaV\u0006A\u0002a\u000bacZ3u%\u0016\u0004xN\u001d;SKF,Xm\u001d;UQJ,\u0017\rZ\u000b\u0002MB\u0011!dZ\u0005\u0003QR\u0011!\u0005R=oC6L7-U;pi\u0006\u0014V\r]8si&twMU3rk\u0016\u001cH\u000f\u00165sK\u0006$\u0017aF4fiJ+\u0007o\u001c:u%\u0016\fX/Z:u)\"\u0014X-\u00193!\u0003]9W\r\u001e)vE2L7\u000f\u001b*fcV,7\u000f\u001e+ie\u0016\fG-F\u0001m!\tQR.\u0003\u0002o)\t\u0019C)\u001f8b[&\u001c\u0017+^8uCB+(\r\\5tQ&twMU3rk\u0016\u001cH\u000f\u00165sK\u0006$\u0017\u0001G4fiB+(\r\\5tQJ+\u0017/^3tiRC'/Z1eA\u0005)1\u000f^1siR\u0011!/\u001e\t\u0003=ML!\u0001^\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006mB\u0001\ra^\u0001\fG>|'\u000fZ5oCR|'\u000f\u0005\u0002yy6\t\u0011P\u0003\u0002{w\u0006)\u0011/^8uC*\u0011aOF\u0005\u0003{f\u0014\u0001#U;pi\u0006\u001cun\u001c:eS:\fGo\u001c:\u0002\u0011MDW\u000f\u001e3po:$\u0012A]\u0001\u0016O\u0016tWM]1uK:+Go^8sW\u000ec\u0017.\u001a8u)\u0011\t)!!\u0005\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u00037\u0003\u001d\u0019G.[3oiNLA!a\u0004\u0002\n\tia*\u001a;x_J\\7\t\\5f]RDq!a\u0005\u0013\u0001\u0004\t)\"\u0001\u0006oC6,\u0007K]3gSb\u0004B!a\u0006\u0002&9!\u0011\u0011DA\u0011!\r\tYbH\u0007\u0003\u0003;Q1!a\b\u0019\u0003\u0019a$o\\8u}%\u0019\u00111E\u0010\u0002\rA\u0013X\rZ3g\u0013\u0011\t9#!\u000b\u0003\rM#(/\u001b8h\u0015\r\t\u0019c\b")
public class DynamicQuotaChannelManager
implements AbstractQuotaChannelManager {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final Time time;
    private final LogContext logContext;
    private final DynamicQuotaReportingRequestThread getReportRequestThread;
    private final DynamicQuotaPublishingRequestThread getPublishRequestThread;

    public static AbstractQuotaChannelManager apply(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, Time time, KafkaScheduler kafkaScheduler, LogContext logContext) {
        return DynamicQuotaChannelManager$.MODULE$.apply(config, metrics, metadataCache, time, kafkaScheduler, logContext);
    }

    @Override
    public DynamicQuotaReportingRequestThread getReportRequestThread() {
        return this.getReportRequestThread;
    }

    @Override
    public DynamicQuotaPublishingRequestThread getPublishRequestThread() {
        return this.getPublishRequestThread;
    }

    @Override
    public void start(QuotaCoordinator coordinator) {
        this.getReportRequestThread().start(coordinator);
        this.getPublishRequestThread().start(coordinator);
    }

    @Override
    public void shutdown() {
        this.getPublishRequestThread().shutdown();
        this.getReportRequestThread().shutdown();
    }

    private NetworkClient generateNetworkClient(String namePrefix) {
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder(this.config.interBrokerSecurityProtocol(), JaasContext.Type.SERVER, this.config, this.config.interBrokerListenerName(), this.config.saslMechanismInterBrokerProtocol(), this.time, this.logContext);
        ChannelBuilder channelBuilder2 = channelBuilder;
        if (channelBuilder2 instanceof Reconfigurable) {
            ChannelBuilder channelBuilder3 = channelBuilder2;
            this.config.addReconfigurable((Reconfigurable)((Object)channelBuilder3));
        }
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, "dynamic-quota-" + namePrefix + "-channel", CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("BrokerId"), Integer.toString(this.config.brokerId()))}))).asJava(), false, channelBuilder, this.logContext);
        return new NetworkClient((Selectable)selector, new ManualMetadataUpdater(), "broker-" + this.config.brokerId() + "-dynamic-quota-" + namePrefix + "-sender", 1, 50L, 30000L, -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), this.config.requestTimeoutMs(), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, false, new ApiVersions(), this.logContext, MetadataRecoveryStrategy.NONE);
    }

    public DynamicQuotaChannelManager(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, Time time, KafkaScheduler kafkaScheduler, LogContext logContext) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.logContext = logContext;
        this.getReportRequestThread = new DynamicQuotaReportingRequestThread(config, metrics, metadataCache, this.generateNetworkClient("reporting"), kafkaScheduler, time);
        this.getPublishRequestThread = new DynamicQuotaPublishingRequestThread(config, metrics, metadataCache, this.generateNetworkClient("publishing"), kafkaScheduler, time);
    }
}

