/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.replication.push.ReplicationConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;

public class NetworkUtils {
    public static NetworkClient buildNetworkClient(String prefix, KafkaConfig config, Metrics metrics, Time time, LogContext logContext) {
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder(config.interBrokerSecurityProtocol(), JaasContext.Type.SERVER, config, config.interBrokerListenerName(), config.saslMechanismInterBrokerProtocol(), time, logContext);
        if (channelBuilder instanceof Reconfigurable) {
            config.addReconfigurable((Reconfigurable)((Object)channelBuilder));
        }
        String metricGroupPrefix = prefix + "-channel";
        Selector selector = new Selector(-1, config.connectionsMaxIdleMs(), metrics, time, metricGroupPrefix, Map.of(), false, channelBuilder, logContext);
        String clientId = prefix + "-client-" + config.nodeId();
        return new NetworkClient((Selectable)selector, new ManualMetadataUpdater(), clientId, 1, 50L, 50L, -1, (int)config.socketReceiveBufferBytes(), config.requestTimeoutMs(), (long)config.connectionSetupTimeoutMs(), (long)config.connectionSetupTimeoutMaxMs(), time, true, new ApiVersions(), logContext, MetadataRecoveryStrategy.NONE);
    }

    public static NetworkClient buildPushManagerNetworkClient(Integer threadId, KafkaConfig config, ReplicationConfig replicationConfig, Metrics metrics, Time time, LogContext logContext) {
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder(config.interBrokerSecurityProtocol(), JaasContext.Type.SERVER, config, config.interBrokerListenerName(), config.saslMechanismInterBrokerProtocol(), time, logContext);
        if (channelBuilder instanceof Reconfigurable) {
            config.addReconfigurable((Reconfigurable)((Object)channelBuilder));
        }
        String metricGroupPrefix = "pusher-thread";
        Selector selector = new Selector(-1, config.connectionsMaxIdleMs(), metrics, time, metricGroupPrefix, Map.of(metricGroupPrefix, threadId.toString()), false, channelBuilder, logContext);
        String clientId = String.format("%s-%d-%d", metricGroupPrefix, config.nodeId(), threadId);
        return new NetworkClient((Selectable)selector, new ManualMetadataUpdater(), clientId, replicationConfig.maxInFlightRequests(), 50L, TimeUnit.SECONDS.toMillis(1L), replicationConfig.socketSendBufferBytes(), -1, replicationConfig.requestTimeoutMs(), (long)config.connectionSetupTimeoutMs(), (long)config.connectionSetupTimeoutMaxMs(), time, false, new ApiVersions(), logContext, MetadataRecoveryStrategy.NONE);
    }
}

