/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ClusterlinkV1Api;
import io.confluent.flink.apiserver.client.CoreV1Api;
import io.confluent.flink.apiserver.client.model.ClusterlinkV1LogicalKafkaCluster;
import io.confluent.flink.apiserver.client.model.ClusterlinkV1LogicalKafkaClusterList;
import io.confluent.flink.apiserver.client.model.ClusterlinkV1LogicalKafkaClusterSpec;
import io.confluent.flink.apiserver.client.model.ClusterlinkV1Site;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kafka.rm.RmMTls;
import kafka.server.DataFlowPolicy;
import kafka.server.KafkaConfig;
import kafka.server.RegionalLkcMetadata;
import kafka.server.RegionalLkcMetadataLookupKey;
import kafka.server.RegionalMetadataClient;
import kafka.server.RegionalNetworkMetadata;
import kafka.server.RmRegionalMetadataClient$;
import kafka.server.RmRegionalMetadataWatcher;
import kafka.server.Subscription;
import kafka.server.Watch;
import kafka.server.ssl.MtlsWithServerCertConfigs;
import kafka.utils.Logging;
import okhttp3.OkHttpClient;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.ThreadUtils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\rUx!B*U\u0011\u0003If!B.U\u0011\u0003a\u0006\"B5\u0002\t\u0003Q\u0007bB6\u0002\u0005\u0004%I\u0001\u001c\u0005\u0007k\u0006\u0001\u000b\u0011B7\t\u000fY\f!\u0019!C\u0005Y\"1q/\u0001Q\u0001\n5Dq\u0001_\u0001C\u0002\u0013%A\u000e\u0003\u0004z\u0003\u0001\u0006I!\u001c\u0005\bu\u0006\u0011\r\u0011\"\u0003|\u0011\u0019y\u0018\u0001)A\u0005y\"Q\u0011\u0011A\u0001C\u0002\u0013\u0005A+a\u0001\t\u0011\u0005%\u0012\u0001)A\u0005\u0003\u000bA!\"a\u000b\u0002\u0005\u0004%\t\u0001VA\u0017\u0011!\ty$\u0001Q\u0001\n\u0005=\u0002bBA!\u0003\u0011%\u00111\t\u0005\b\u0003K\nA\u0011AA4\u0011\u001d\t9)\u0001C\u0001\u0003\u00133Qa\u0017+\u0003\u0003\u001bC!\"a'\u0013\u0005\u0003\u0005\u000b\u0011BAO\u0011)\t\u0019K\u0005B\u0001B\u0003%\u0011Q\u0015\u0005\u0007SJ!\t!!0\t\u0019\u0005\u0015'\u00031AA\u0002\u0013\u0005A+a2\t\u0019\u0005m'\u00031AA\u0002\u0013\u0005A+!8\t\u0017\u0005\r(\u00031A\u0001B\u0003&\u0011\u0011\u001a\u0005\n\u0003K\u0014\"\u0019!C\u0005\u0003OD\u0001\"a<\u0013A\u0003%\u0011\u0011\u001e\u0005\u000b\u0003c\u0014\"\u0019!C\u0001)\u0006M\b\u0002CA~%\u0001\u0006I!!>\t\u0015\u0005u(C1A\u0005\u0002Q\u000by\u0010\u0003\u0005\u0003\bI\u0001\u000b\u0011\u0002B\u0001\u0011-\u0011IA\u0005a\u0001\u0002\u0004%IAa\u0003\t\u0017\tu!\u00031AA\u0002\u0013%!q\u0004\u0005\f\u0005G\u0011\u0002\u0019!A!B\u0013\u0011i\u0001\u0003\u0006\u0003&I\u0001\r\u0011\"\u0001U\u0005OA!Ba\r\u0013\u0001\u0004%\t\u0001\u0016B\u001b\u0011!\u0011ID\u0005Q!\n\t%\u0002\u0002\u0004B\u001e%\u0001\u0007\t\u0019!C\u0001)\nu\u0002\u0002\u0004B#%\u0001\u0007\t\u0019!C\u0001)\n\u001d\u0003b\u0003B&%\u0001\u0007\t\u0011)Q\u0005\u0005\u007fA\u0011B!\u0014\u0013\u0005\u0004%IAa\u0014\t\u0011\t\u0005$\u0003)A\u0005\u0005#B!Ba\u0019\u0013\u0005\u0004%\t\u0001\u0016B3\u0011!\u00119H\u0005Q\u0001\n\t\u001d\u0004\"\u0003B=%\u0001\u0007I\u0011\u0001+|\u0011)\u0011YH\u0005a\u0001\n\u0003!&Q\u0010\u0005\b\u0005\u0003\u0013\u0002\u0015)\u0003}\u0011)\u0011\u0019I\u0005b\u0001\n\u0003!&Q\u0011\u0005\t\u0005\u001f\u0013\u0002\u0015!\u0003\u0003\b\"Q!\u0011\u0013\nC\u0002\u0013\u0005AK!\"\t\u0011\tM%\u0003)A\u0005\u0005\u000fC\u0011B!&\u0013\u0005\u0004%IA!\"\t\u0011\t]%\u0003)A\u0005\u0005\u000fC1B!'\u0013\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u001c\"Y!1\u0015\nA\u0002\u0003\u0007I\u0011\u0002BS\u0011-\u0011IK\u0005a\u0001\u0002\u0003\u0006KA!(\t\u0015\t-&C1A\u0005\u0002Q\u0013)\t\u0003\u0005\u0003.J\u0001\u000b\u0011\u0002BD\u0011%\u0011yK\u0005b\u0001\n\u0013\u0011)\t\u0003\u0005\u00032J\u0001\u000b\u0011\u0002BD\u0011-\u0011\u0019L\u0005a\u0001\u0002\u0004%IAa'\t\u0017\tU&\u00031AA\u0002\u0013%!q\u0017\u0005\f\u0005w\u0013\u0002\u0019!A!B\u0013\u0011i\n\u0003\u0005\u0003>J!\t\u0001\u0016B`\u0011\u001d\u0011IM\u0005C!\u0005\u0017D\u0001Ba8\u0013\t\u0003!&\u0011\u001d\u0005\b\u0005g\u0014B\u0011\tB{\u0011!\u0019YA\u0005C\u0001)\u000e5\u0001bBB\r%\u0011\u000531\u0004\u0005\b\u0007_\u0011B\u0011IB\u0019\u0011\u001d\u0019\u0019D\u0005C!\u0007kAqa!\u0017\u0013\t\u0013\u0019\t\u0004C\u0004\u0004\\I!Ia!\u0018\t\u000f\r}#\u0003\"\u0003\u00042!91\u0011\r\n\u0005B\r\r\u0004bBB3%\u0011%1q\r\u0005\b\u0007S\u0012B\u0011AB6\u0011\u001d\u0019\tH\u0005C\u0001\u0007gBqaa\u001e\u0013\t\u0013\u0019\t\u0004C\u0004\u0004zI!Iaa\u001f\t\u0011\re$\u0003\"\u0001U\u00077Cqa!\u001f\u0013\t\u0013\u00199\fC\u0004\u0004TJ!\te!6\u00021Ik'+Z4j_:\fG.T3uC\u0012\fG/Y\"mS\u0016tGO\u0003\u0002V-\u000611/\u001a:wKJT\u0011aV\u0001\u0006W\u000647.Y\u0002\u0001!\tQ\u0016!D\u0001U\u0005a\u0011VNU3hS>t\u0017\r\\'fi\u0006$\u0017\r^1DY&,g\u000e^\n\u0004\u0003u\u001b\u0007C\u00010b\u001b\u0005y&\"\u00011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t|&AB!osJ+g\r\u0005\u0002eO6\tQM\u0003\u0002g-\u0006)Q\u000f^5mg&\u0011\u0001.\u001a\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0011,A\u0007N\u000bR\u0013\u0016jQ*`\u000fJ{U\u000bU\u000b\u0002[B\u0011an]\u0007\u0002_*\u0011\u0001/]\u0001\u0005Y\u0006twMC\u0001s\u0003\u0011Q\u0017M^1\n\u0005Q|'AB*ue&tw-\u0001\bN\u000bR\u0013\u0016jQ*`\u000fJ{U\u000b\u0015\u0011\u0002)IkulQ!M\u0019~\u001bu*\u0016(U?N+ejU(S\u0003U\u0011VjX\"B\u00192{6iT+O)~\u001bVIT*P%\u0002\nQCU'`\u000bJ\u0013vJU0D\u001fVsEkX*F\u001dN{%+\u0001\fS\u001b~+%KU(S?\u000e{UK\u0014+`'\u0016s5k\u0014*!\u0003)i\u0017\r\u001f*fiJLWm]\u000b\u0002yB\u0011a,`\u0005\u0003}~\u00131!\u00138u\u0003-i\u0017\r\u001f*fiJLWm\u001d\u0011\u0002-I,GO]=P]\u000e{gN\\3di&|g.\u0012:s_J,\"!!\u0002\u0011\u000fy\u000b9!a\u0003\u0002$%\u0019\u0011\u0011B0\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA\u0007\u0003;qA!a\u0004\u0002\u001a9!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016a\u000ba\u0001\u0010:p_Rt\u0014\"\u00011\n\u0007\u0005mq,A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}\u0011\u0011\u0005\u0002\n)\"\u0014xn^1cY\u0016T1!a\u0007`!\rq\u0016QE\u0005\u0004\u0003Oy&a\u0002\"p_2,\u0017M\\\u0001\u0018e\u0016$(/_(o\u0007>tg.Z2uS>tWI\u001d:pe\u0002\n\u0001\"\u001c;TWV\u001cV\r^\u000b\u0003\u0003_\u0001R!!\r\u0002<5l!!a\r\u000b\t\u0005U\u0012qG\u0001\nS6lW\u000f^1cY\u0016T1!!\u000f`\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003{\t\u0019DA\u0002TKR\f\u0011\"\u001c;TWV\u001cV\r\u001e\u0011\u0002+%\u001c8i\u001c8oK\u000e$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]R!\u00111EA#\u0011\u001d\t9e\u0004a\u0001\u0003\u0013\n\u0011!\u001a\t\u0005\u0003\u0017\n\t'\u0004\u0002\u0002N)!\u0011qJA)\u0003\u0019\u0019G.[3oi*!\u00111KA+\u0003%\t\u0007/[:feZ,'O\u0003\u0003\u0002X\u0005e\u0013!\u00024mS:\\'\u0002BA.\u0003;\n\u0011bY8oM2,XM\u001c;\u000b\u0005\u0005}\u0013AA5p\u0013\u0011\t\u0019'!\u0014\u0003\u0019\u0005\u0003\u0018.\u0012=dKB$\u0018n\u001c8\u0002\t5\f\u0017N\u001c\u000b\u0005\u0003S\ny\u0007E\u0002_\u0003WJ1!!\u001c`\u0005\u0011)f.\u001b;\t\u000f\u0005E\u0004\u00031\u0001\u0002t\u0005!\u0011M]4t!\u0015q\u0016QOA=\u0013\r\t9h\u0018\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u0003w\n\u0019I\u0004\u0003\u0002~\u0005}\u0004cAA\t?&\u0019\u0011\u0011Q0\u0002\rA\u0013X\rZ3g\u0013\r!\u0018Q\u0011\u0006\u0004\u0003\u0003{\u0016a\u0001:v]R!\u0011\u0011NAF\u0011\u001d\t\t(\u0005a\u0001\u0003g\u001abAEAH\u0003+\u001b\u0007c\u00018\u0002\u0012&\u0019\u00111S8\u0003\r=\u0013'.Z2u!\rQ\u0016qS\u0005\u0004\u00033#&A\u0006*fO&|g.\u00197NKR\fG-\u0019;b\u00072LWM\u001c;\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0011\u0007i\u000by*C\u0002\u0002\"R\u00131bS1gW\u0006\u001cuN\u001c4jO\u00069Q.\u001a;sS\u000e\u001c\b\u0003BAT\u0003sk!!!+\u000b\t\u0005\r\u00161\u0016\u0006\u0005\u0003[\u000by+\u0001\u0004d_6lwN\u001c\u0006\u0004/\u0006E&\u0002BAZ\u0003k\u000ba!\u00199bG\",'BAA\\\u0003\ry'oZ\u0005\u0005\u0003w\u000bIKA\u0004NKR\u0014\u0018nY:\u0015\r\u0005}\u0016\u0011YAb!\tQ&\u0003C\u0004\u0002\u001cV\u0001\r!!(\t\u000f\u0005\rV\u00031\u0001\u0002&\u00061B.[:uK:,'OU3d_:4\u0017nZ;sC\ndW-\u0006\u0002\u0002JB)a,a3\u0002P&\u0019\u0011QZ0\u0003\r=\u0003H/[8o!\u0011\t\t.a6\u000e\u0005\u0005M'\u0002BAk\u0003W\u000bqA\\3uo>\u00148.\u0003\u0003\u0002Z\u0006M'A\u0006'jgR,g.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\u000251L7\u000f^3oKJ\u0014VmY8oM&<WO]1cY\u0016|F%Z9\u0015\t\u0005%\u0014q\u001c\u0005\n\u0003C<\u0012\u0011!a\u0001\u0003\u0013\f1\u0001\u001f\u00132\u0003]a\u0017n\u001d;f]\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,\u0007%A\u0005ba&\u001cE.[3oiV\u0011\u0011\u0011\u001e\t\u0005\u0003\u0017\nY/\u0003\u0003\u0002n\u00065#!C!qS\u000ec\u0017.\u001a8u\u0003)\t\u0007/[\"mS\u0016tG\u000fI\u0001\fG2lu\u000eZ3mg\u0006\u0003\u0018.\u0006\u0002\u0002vB!\u00111JA|\u0013\u0011\tI0!\u0014\u0003!\rcWo\u001d;fe2Lgn\u001b,2\u0003BL\u0017\u0001D2m\u001b>$W\r\\:Ba&\u0004\u0013aB2pe\u0016\f\u0005/[\u000b\u0003\u0005\u0003\u0001B!a\u0013\u0003\u0004%!!QAA'\u0005%\u0019uN]3Wc\u0005\u0003\u0018.\u0001\u0005d_J,\u0017\t]5!\u0003=)\u00070Z2vi>\u00148+\u001a:wS\u000e,WC\u0001B\u0007!\u0011\u0011yA!\u0007\u000e\u0005\tE!\u0002\u0002B\n\u0005+\t!bY8oGV\u0014(/\u001a8u\u0015\r\u00119\"]\u0001\u0005kRLG.\u0003\u0003\u0003\u001c\tE!\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\u0006\u0019R\r_3dkR|'oU3sm&\u001cWm\u0018\u0013fcR!\u0011\u0011\u000eB\u0011\u0011%\t\t\u000fIA\u0001\u0002\u0004\u0011i!\u0001\tfq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2fA\u0005\u0011R\r\u001f9p]\u0016tG/[1m\u0005\u0006\u001c7n\u001c4g+\t\u0011I\u0003\u0005\u0003\u0003,\t=RB\u0001B\u0017\u0015\r1\u00171V\u0005\u0005\u0005c\u0011iC\u0001\nFqB|g.\u001a8uS\u0006d')Y2l_\u001a4\u0017AF3ya>tWM\u001c;jC2\u0014\u0015mY6pM\u001a|F%Z9\u0015\t\u0005%$q\u0007\u0005\n\u0003C\u001c\u0013\u0011!a\u0001\u0005S\t1#\u001a=q_:,g\u000e^5bY\n\u000b7m[8gM\u0002\nqa^1uG\",'/\u0006\u0002\u0003@A\u0019!L!\u0011\n\u0007\t\rCKA\rS[J+w-[8oC2lU\r^1eCR\fw+\u0019;dQ\u0016\u0014\u0018aC<bi\u000eDWM]0%KF$B!!\u001b\u0003J!I\u0011\u0011\u001d\u0014\u0002\u0002\u0003\u0007!qH\u0001\to\u0006$8\r[3sA\u0005Q1o\u001d7GC\u000e$xN]=\u0016\u0005\tE\u0003\u0003\u0002B*\u0005;j!A!\u0016\u000b\t\t]#\u0011L\u0001\u0004gNd'\u0002\u0002B.\u0003W\u000b\u0001b]3dkJLG/_\u0005\u0005\u0005?\u0012)F\u0001\u0006Tg24\u0015m\u0019;pef\f1b]:m\r\u0006\u001cGo\u001c:zA\u0005qAn[2M_>\\W\u000f]\"bG\",WC\u0001B4!!\u0011IGa\u001b\u0002z\t=TB\u0001B\u000b\u0013\u0011\u0011iG!\u0006\u0003\u000f!\u000b7\u000f['baB)a,a3\u0003rA\u0019!La\u001d\n\u0007\tUDK\u0001\u000fSK\u001eLwN\\1m\u0019.\u001cW*\u001a;bI\u0006$\u0018\rT8pWV\u00048*Z=\u0002\u001f1\\7\rT8pWV\u00048)Y2iK\u0002\n\u0001\u0003\\5ti\u000e\u000bG\u000e\u001c)bO\u0016\u001c\u0016N_3\u0002)1L7\u000f^\"bY2\u0004\u0016mZ3TSj,w\fJ3r)\u0011\tIGa \t\u0011\u0005\u0005X&!AA\u0002q\f\u0011\u0003\\5ti\u000e\u000bG\u000e\u001c)bO\u0016\u001c\u0016N_3!\u0003e\u0019wN\u001c8fGRLwN\\\"pk:$X*\u001a;sS\u000et\u0015-\\3\u0016\u0005\t\u001d\u0005\u0003\u0002BE\u0005\u0017k!!a+\n\t\t5\u00151\u0016\u0002\u000b\u001b\u0016$(/[2OC6,\u0017AG2p]:,7\r^5p]\u000e{WO\u001c;NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013!\u0006:n\u0007\u0006dGnQ8v]RlU\r\u001e:jG:\u000bW.Z\u0001\u0017e6\u001c\u0015\r\u001c7D_VtG/T3ue&\u001cg*Y7fA\u0005I\"/\\\"bY2\u001cu.\u001e8u%\u0006$X-T3ue&\u001cg*Y7f\u0003i\u0011XnQ1mY\u000e{WO\u001c;SCR,W*\u001a;sS\u000et\u0015-\\3!\u0003E\u0011XnQ1mY\u000e{WO\u001c;TK:\u001cxN]\u000b\u0003\u0005;\u0003B!a*\u0003 &!!\u0011UAU\u0005\u0019\u0019VM\\:pe\u0006)\"/\\\"bY2\u001cu.\u001e8u'\u0016t7o\u001c:`I\u0015\fH\u0003BA5\u0005OC\u0011\"!97\u0003\u0003\u0005\rA!(\u0002%Il7)\u00197m\u0007>,h\u000e^*f]N|'\u000fI\u0001\u0017e6,%O]8s\u0007>,h\u000e^'fiJL7MT1nK\u00069\"/\\#se>\u00148i\\;oi6+GO]5d\u001d\u0006lW\rI\u0001\u001be6,%O]8s\u0007>,h\u000e\u001e*bi\u0016lU\r\u001e:jG:\u000bW.Z\u0001\u001ce6,%O]8s\u0007>,h\u000e\u001e*bi\u0016lU\r\u001e:jG:\u000bW.\u001a\u0011\u0002%IlWI\u001d:pe\u000e{WO\u001c;TK:\u001cxN]\u0001\u0017e6,%O]8s\u0007>,h\u000e^*f]N|'o\u0018\u0013fcR!\u0011\u0011\u000eB]\u0011%\t\t/PA\u0001\u0002\u0004\u0011i*A\ns[\u0016\u0013(o\u001c:D_VtGoU3og>\u0014\b%A\bhKRd5n\u0019'p_.,\boS3z)\u0019\u0011yG!1\u0003F\"9!1Y A\u0002\u0005e\u0014!B8sO&#\u0007b\u0002Bd\u007f\u0001\u0007\u0011\u0011P\u0001\nG2,8\u000f^3s\u0013\u0012\fabZ3u\u0019.\u001cW*\u001a;bI\u0006$\u0018\r\u0006\u0004\u0003N\nm'Q\u001c\t\u0007\u0005\u001f\u0011yMa5\n\t\tE'\u0011\u0003\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007#\u00020\u0002L\nU\u0007c\u0001.\u0003X&\u0019!\u0011\u001c+\u0003'I+w-[8oC2d5nY'fi\u0006$\u0017\r^1\t\u000f\t\r\u0007\t1\u0001\u0002z!9!q\u0019!A\u0002\u0005e\u0014\u0001E5t\u001bVdG/\u001b+f]\u0006tGoU6v)\u0011\t\u0019Ca9\t\u000f\t\u0015\u0018\t1\u0001\u0003h\u00069An[2Ta\u0016\u001c\u0007\u0003\u0002Bu\u0005_l!Aa;\u000b\t\t5\u0018QJ\u0001\u0006[>$W\r\\\u0005\u0005\u0005c\u0014YO\u0001\u0013DYV\u001cH/\u001a:mS:\\g+\r'pO&\u001c\u0017\r\\&bM.\f7\t\\;ti\u0016\u00148\u000b]3d\u0003I9W\r\u001e(fi^|'o['fi\u0006$\u0017\r^1\u0015\u0011\t]8\u0011AB\u0002\u0007\u000f\u0001bAa\u0004\u0003P\ne\b#\u00020\u0002L\nm\bc\u0001.\u0003~&\u0019!q +\u0003/I+w-[8oC2tU\r^<pe.lU\r^1eCR\f\u0007b\u0002Bb\u0005\u0002\u0007\u0011\u0011\u0010\u0005\b\u0007\u000b\u0011\u0005\u0019AA=\u0003\u0015)gN^%e\u0011\u001d\u0019IA\u0011a\u0001\u0003s\naB\\3uo>\u00148.\u00133QCJ\fW.A\fjg\u000e{gN\\3di&|g\u000eV=qKB\u0013\u0018N^1uKR!\u00111EB\b\u0011\u001d\u0019\tb\u0011a\u0001\u0007'\tqbY8o]\u0016\u001cG/[8o)f\u0004Xm\u001d\t\u0007\u0005S\u001a)\"!\u001f\n\t\r]!Q\u0003\u0002\u0005\u0019&\u001cH/A\thKR$\u0015\r^1GY><\bk\u001c7jGf$ba!\b\u0004(\r-\u0002C\u0002B\b\u0005\u001f\u001cy\u0002E\u0003_\u0003\u0017\u001c\t\u0003E\u0002[\u0007GI1a!\nU\u00059!\u0015\r^1GY><\bk\u001c7jGfDqa!\u000bE\u0001\u0004\tI(\u0001\bpe\u001e\fg.\u001b>bi&|g.\u00133\t\u000f\r5B\t1\u0001\u0002z\u0005iQM\u001c<je>tW.\u001a8u\u0013\u0012\fQa\u00197pg\u0016$\"!!\u001b\u0002\u0013\r|gNZ5hkJ,G\u0003BA5\u0007oAqa!\u000fG\u0001\u0004\u0019Y$A\u0004d_:4\u0017nZ:1\t\ru2q\t\t\t\u0005S\u001ay$!\u001f\u0004D%!1\u0011\tB\u000b\u0005\ri\u0015\r\u001d\t\u0005\u0007\u000b\u001a9\u0005\u0004\u0001\u0005\u0019\r%3qGA\u0001\u0002\u0003\u0015\taa\u0013\u0003\u0007}#\u0013'\u0005\u0003\u0004N\rM\u0003c\u00010\u0004P%\u00191\u0011K0\u0003\u000f9{G\u000f[5oOB\u0019al!\u0016\n\u0007\r]sLA\u0002B]f\f!cZ3u\u001fJ\u001c%/Z1uK6+GO]5dg\u0006y1m\u001c8oK\u000e$\u0018n\u001c8D_VtG\u000fF\u0001}\u0003e\tG\r\u001a'jgR,g.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\u0002\u001bM,\b\u000f]8siN<\u0016\r^2i)\t\t\u0019#A\u0007jg6#Hn]#oC\ndW\rZ\u000b\u0003\u0003G\tqC^1mS\u0012\fG/\u001a*fG>tg-[4ve\u0006$\u0018n\u001c8\u0015\t\u0005%4Q\u000e\u0005\b\u0007_b\u0005\u0019AAO\u0003%qWm^\"p]\u001aLw-A\u0006sK\u000e|gNZ5hkJ,G\u0003BA5\u0007kBqaa\u001cN\u0001\u0004\ti*A\bsK\u000e|gNZ5hkJ,W\n\u001e7t\u0003A)\u00070Z2vi\u0016<\u0016\u000e\u001e5SKR\u0014\u00180\u0006\u0003\u0004~\r\rECBB@\u0007\u000f\u001b9\n\u0005\u0004\u0003\u0010\t=7\u0011\u0011\t\u0005\u0007\u000b\u001a\u0019\tB\u0004\u0004\u0006>\u0013\raa\u0013\u0003\u0003QCqa!#P\u0001\u0004\u0019Y)\u0001\u0005tkB\u0004H.[3s!\u0019\u0019iia%\u0004\u00026\u00111q\u0012\u0006\u0005\u0007#\u0013)\"\u0001\u0005gk:\u001cG/[8o\u0013\u0011\u0019)ja$\u0003\u0011M+\b\u000f\u001d7jKJDqa!'P\u0001\u0004\t)!A\u0006tQ>,H\u000e\u001a*fiJLX\u0003BBO\u0007G#\"ba(\u0004&\u000e%61VBW!\u0019\u0011yAa4\u0004\"B!1QIBR\t\u001d\u0019)\t\u0015b\u0001\u0007\u0017Bqa!#Q\u0001\u0004\u00199\u000b\u0005\u0004\u0004\u000e\u000eM5\u0011\u0015\u0005\b\u00073\u0003\u0006\u0019AA\u0003\u0011\u0015Q\b\u000b1\u0001}\u0011\u001d\u0019y\u000b\u0015a\u0001\u0007c\u000bA!\u001e8jiB!!qBBZ\u0013\u0011\u0019)L!\u0005\u0003\u0011QKW.Z+oSR,Ba!/\u0004BRq\u0011\u0011NB^\u0007\u0007\u001cIma3\u0004N\u000e=\u0007bBBE#\u0002\u00071Q\u0018\t\u0007\u0007\u001b\u001b\u0019ja0\u0011\t\r\u00153\u0011\u0019\u0003\b\u0007\u000b\u000b&\u0019AB&\u0011\u001d\u0019)-\u0015a\u0001\u0007\u000f\faAZ;ukJ,\u0007C\u0002B\b\u0005\u001f\u001cy\fC\u0004\u0004\u001aF\u0003\r!!\u0002\t\u000bi\f\u0006\u0019\u0001?\t\u000f\r=\u0016\u000b1\u0001\u00042\"11\u0011[)A\u0002q\fq!\u0019;uK6\u0004H/A\u0003xCR\u001c\u0007.\u0006\u0003\u0004X\u000e-HCBBm\u0007?\u001ci\u000fE\u0002o\u00077L1a!8p\u00055\tU\u000f^8DY>\u001cX-\u00192mK\"91\u0011\u001d*A\u0002\r\r\u0018\u0001D:vEN\u001c'/\u001b9uS>t\u0007#\u0002.\u0004f\u000e%\u0018bABt)\na1+\u001e2tGJL\u0007\u000f^5p]B!1QIBv\t\u001d\u0019)I\u0015b\u0001\u0007\u0017Bqaa5S\u0001\u0004\u0019y\u000fE\u0003[\u0007c\u001cI/C\u0002\u0004tR\u0013QaV1uG\"\u0004")
public final class RmRegionalMetadataClient
implements RegionalMetadataClient,
Logging {
    public final KafkaConfig kafka$server$RmRegionalMetadataClient$$brokerConfig;
    private final Metrics metrics;
    private Option<ListenerReconfigurable> listenerReconfigurable;
    private final ApiClient apiClient;
    private final ClusterlinkV1Api clModelsApi;
    private final CoreV1Api coreApi;
    private ScheduledExecutorService executorService;
    private ExponentialBackoff exponentialBackoff;
    private RmRegionalMetadataWatcher watcher;
    private final SslFactory sslFactory;
    private final HashMap<String, Option<RegionalLkcMetadataLookupKey>> lkcLookupCache;
    private int listCallPageSize;
    private final MetricName connectionCountMetricName;
    private final MetricName rmCallCountMetricName;
    private final MetricName rmCallCountRateMetricName;
    private Sensor rmCallCountSensor;
    private final MetricName rmErrorCountMetricName;
    private final MetricName rmErrorCountRateMetricName;
    private Sensor rmErrorCountSensor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void run(String[] args) {
        RmRegionalMetadataClient$.MODULE$.run(args);
    }

    public static void main(String[] args) {
        RmRegionalMetadataClient$.MODULE$.main(args);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        RmRegionalMetadataClient rmRegionalMetadataClient = this;
        synchronized (rmRegionalMetadataClient) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Option<ListenerReconfigurable> listenerReconfigurable() {
        return this.listenerReconfigurable;
    }

    public void listenerReconfigurable_$eq(Option<ListenerReconfigurable> x$1) {
        this.listenerReconfigurable = x$1;
    }

    private ApiClient apiClient() {
        return this.apiClient;
    }

    public ClusterlinkV1Api clModelsApi() {
        return this.clModelsApi;
    }

    public CoreV1Api coreApi() {
        return this.coreApi;
    }

    private ScheduledExecutorService executorService() {
        return this.executorService;
    }

    private void executorService_$eq(ScheduledExecutorService x$1) {
        this.executorService = x$1;
    }

    public ExponentialBackoff exponentialBackoff() {
        return this.exponentialBackoff;
    }

    public void exponentialBackoff_$eq(ExponentialBackoff x$1) {
        this.exponentialBackoff = x$1;
    }

    public RmRegionalMetadataWatcher watcher() {
        return this.watcher;
    }

    public void watcher_$eq(RmRegionalMetadataWatcher x$1) {
        this.watcher = x$1;
    }

    private SslFactory sslFactory() {
        return this.sslFactory;
    }

    public HashMap<String, Option<RegionalLkcMetadataLookupKey>> lkcLookupCache() {
        return this.lkcLookupCache;
    }

    public int listCallPageSize() {
        return this.listCallPageSize;
    }

    public void listCallPageSize_$eq(int x$1) {
        this.listCallPageSize = x$1;
    }

    public MetricName connectionCountMetricName() {
        return this.connectionCountMetricName;
    }

    public MetricName rmCallCountMetricName() {
        return this.rmCallCountMetricName;
    }

    private MetricName rmCallCountRateMetricName() {
        return this.rmCallCountRateMetricName;
    }

    private Sensor rmCallCountSensor() {
        return this.rmCallCountSensor;
    }

    private void rmCallCountSensor_$eq(Sensor x$1) {
        this.rmCallCountSensor = x$1;
    }

    public MetricName rmErrorCountMetricName() {
        return this.rmErrorCountMetricName;
    }

    private MetricName rmErrorCountRateMetricName() {
        return this.rmErrorCountRateMetricName;
    }

    private Sensor rmErrorCountSensor() {
        return this.rmErrorCountSensor;
    }

    private void rmErrorCountSensor_$eq(Sensor x$1) {
        this.rmErrorCountSensor = x$1;
    }

    public Option<RegionalLkcMetadataLookupKey> getLkcLookupKey(String orgId, String clusterId) {
        if (this.lkcLookupCache().containsKey(clusterId)) {
            return this.lkcLookupCache().get(clusterId);
        }
        String string = null;
        int i = 0;
        boolean fetchMore = true;
        while (fetchMore) {
            ClusterlinkV1LogicalKafkaClusterList response = this.clModelsApi().listClusterlinkV1LogicalKafkaClustersForAllEnvironments(orgId, string, null, null, null, Predef$.MODULE$.int2Integer(this.listCallPageSize()));
            this.rmCallCountSensor().record();
            this.debug((Function0<String> & Serializable)() -> "Got list response: " + response);
            response.getItems().forEach(item -> {
                String envId = item.getMetadata().getEnvironment();
                String lkcId = item.getMetadata().getName();
                RegionalLkcMetadataLookupKey lkcKey = new RegionalLkcMetadataLookupKey(orgId, envId);
                this.lkcLookupCache().put(lkcId, new Some<RegionalLkcMetadataLookupKey>(lkcKey));
            });
            string = response.getMetadata().getContinue();
            if (string == null) {
                fetchMore = false;
            } else if (i > 200) {
                throw new IllegalStateException("More than 100k LKCs found in the org:" + orgId + " or this is a bug, breaking out of loop");
            }
            ++i;
        }
        return this.lkcLookupCache().getOrDefault(clusterId, None$.MODULE$);
    }

    @Override
    public CompletableFuture<Option<RegionalLkcMetadata>> getLkcMetadata(String orgId, String clusterId) {
        Supplier<Option> metadataSupplier = () -> {
            Option option;
            try {
                if (orgId == null || clusterId == null) {
                    option = None$.MODULE$;
                    return option;
                }
                Option<RegionalLkcMetadataLookupKey> lkcKey = this.getLkcLookupKey(orgId, clusterId);
                if (lkcKey.isEmpty()) {
                    option = None$.MODULE$;
                    return option;
                }
                String envId = lkcKey.get().environmentId();
                ClusterlinkV1LogicalKafkaCluster lkcResponse = this.clModelsApi().readClusterlinkV1LogicalKafkaCluster(envId, clusterId, orgId, null);
                this.rmCallCountSensor().record();
                this.info((Function0<String> & Serializable)() -> "For " + clusterId + " got LKC response: " + lkcResponse);
                ClusterlinkV1LogicalKafkaClusterSpec lkcSpec = lkcResponse.getSpec();
                option = new Some<$anon$1>(new RegionalLkcMetadata(this, orgId, envId, lkcSpec){
                    private final /* synthetic */ RmRegionalMetadataClient $outer;
                    private final String orgId$2;
                    private final String envId$1;
                    private final ClusterlinkV1LogicalKafkaClusterSpec lkcSpec$1;

                    public String organizationId() {
                        return this.orgId$2;
                    }

                    public String environmentId() {
                        return this.envId$1;
                    }

                    public String networkId() {
                        return this.lkcSpec$1.getNetworkId();
                    }

                    public String intranetFqdn() {
                        return this.lkcSpec$1.getInternalUrl();
                    }

                    public boolean isMultiTenant() {
                        return this.$outer.isMultiTenantSku(this.lkcSpec$1);
                    }

                    public String toString() {
                        return "RegionalLkcMetadata{organizationId=" + this.organizationId() + ", environmentId=" + this.environmentId() + ", networkId=" + this.networkId() + ", intranetFqdn=" + this.intranetFqdn() + ", isMultiTenant=" + this.isMultiTenant() + "}";
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.orgId$2 = orgId$2;
                        this.envId$1 = envId$1;
                        this.lkcSpec$1 = lkcSpec$1;
                    }
                });
                return option;
            }
            catch (ApiException e) {
                int n = e.getCode();
                switch (n) {
                    case 404: {
                        this.warn((Function0<String> & Serializable)() -> "Cluster " + clusterId + " not found in org " + orgId + " , apiException: " + e);
                        option = None$.MODULE$;
                        return option;
                    }
                    default: {
                        throw e;
                    }
                }
            }
        };
        return this.executeWithRetry(metadataSupplier, RmRegionalMetadataClient$.MODULE$.retryOnConnectionError());
    }

    public boolean isMultiTenantSku(ClusterlinkV1LogicalKafkaClusterSpec lkcSpec) {
        return lkcSpec.getSku() != null && RmRegionalMetadataClient$.MODULE$.mtSkuSet().contains(lkcSpec.getSku().toUpperCase(Locale.ROOT));
    }

    @Override
    public CompletableFuture<Option<RegionalNetworkMetadata>> getNetworkMetadata(String orgId, String envId, String networkIdParam) {
        Supplier<Option> metadataSupplier = () -> {
            Option option;
            try {
                if (orgId == null || envId == null || networkIdParam == null) {
                    option = None$.MODULE$;
                    return option;
                }
                ClusterlinkV1Site networkResponse = this.clModelsApi().readClusterlinkV1Site(envId, networkIdParam, orgId, null);
                this.rmCallCountSensor().record();
                this.info((Function0<String> & Serializable)() -> "For " + networkIdParam + " got network response: " + networkResponse);
                option = new Some<$anon$2>(new RegionalNetworkMetadata(this, networkIdParam, networkResponse){
                    private final /* synthetic */ RmRegionalMetadataClient $outer;
                    private final String networkIdParam$1;
                    private final ClusterlinkV1Site networkResponse$1;

                    public String networkId() {
                        return this.networkIdParam$1;
                    }

                    public boolean isPrivate() {
                        List<String> connectionTypes = this.networkResponse$1.getSpec().getConnectionTypes();
                        return this.$outer.isConnectionTypePrivate(connectionTypes);
                    }

                    public String toString() {
                        return "RegionalNetworkMetadata{networkId=" + this.networkIdParam$1 + ", isPrivate=" + this.isPrivate() + "}, connectionTypes=" + this.networkResponse$1.getSpec().getConnectionTypes();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.networkIdParam$1 = networkIdParam$1;
                        this.networkResponse$1 = networkResponse$1;
                    }
                });
                return option;
            }
            catch (ApiException e) {
                int n = e.getCode();
                switch (n) {
                    case 404: {
                        this.warn((Function0<String> & Serializable)() -> "Network " + networkIdParam + " not found in org " + orgId + ", env " + envId + " , apiException: " + e);
                        option = None$.MODULE$;
                        return option;
                    }
                    default: {
                        throw e;
                    }
                }
            }
        };
        return this.executeWithRetry(metadataSupplier, RmRegionalMetadataClient$.MODULE$.retryOnConnectionError());
    }

    public boolean isConnectionTypePrivate(List<String> connectionTypes) {
        return connectionTypes != null && !connectionTypes.isEmpty() && !connectionTypes.contains("PUBLIC");
    }

    @Override
    public CompletableFuture<Option<DataFlowPolicy>> getDataFlowPolicy(String organizationId, String environmentId) {
        return CompletableFuture.completedFuture(None$.MODULE$);
    }

    @Override
    public void close() {
        OkHttpClient okClient;
        this.listenerReconfigurable().foreach((Function1<Reconfigurable, Object> & Serializable)reconfigurable -> {
            this.kafka$server$RmRegionalMetadataClient$$brokerConfig.removeReconfigurable(reconfigurable);
            return BoxedUnit.UNIT;
        });
        if (this.executorService() != null) {
            this.executorService().shutdownNow();
            this.executorService_$eq(null);
        }
        if ((okClient = this.apiClient().getHttpClient()) != null) {
            okClient.dispatcher().executorService().shutdownNow();
            okClient.connectionPool().evictAll();
        }
        if (this.watcher() != null) {
            this.watcher().close();
            this.watcher_$eq(null);
        }
        this.sslFactory().close();
        this.metrics.removeMetric(this.connectionCountMetricName());
        this.metrics.removeSensor(RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$RM_CALL_COUNT_SENSOR());
    }

    @Override
    public void configure(Map<String, ?> configs) {
        if (this.kafka$server$RmRegionalMetadataClient$$brokerConfig.regionalResourceManagerEndpointUrl() == null) {
            throw new ConfigException("confluent.regional.resource.manager.endpoint", null, "Endpoint URL is not configured");
        }
        this.addListenerReconfigurable();
        String endpointUrl = this.kafka$server$RmRegionalMetadataClient$$brokerConfig.regionalResourceManagerEndpointUrl();
        this.apiClient().setBasePath(endpointUrl);
        Integer numSchedulerThreads = this.kafka$server$RmRegionalMetadataClient$$brokerConfig.regionalResourceManagerClientSchedulerThreads();
        this.executorService_$eq(Executors.newScheduledThreadPool(Predef$.MODULE$.Integer2int(numSchedulerThreads), ThreadUtils.createThreadFactory("rm-regional-metadata-client-thread-%d", false)));
        if (this.kafka$server$RmRegionalMetadataClient$$brokerConfig.regionalResourceManagerGrpcEndpointUrl() != null) {
            this.watcher_$eq(new RmRegionalMetadataWatcher());
        }
        if (this.isMtlsEnabled()) {
            this.sslFactory().configure(RmMTls.getSslClientConfig(this.kafka$server$RmRegionalMetadataClient$$brokerConfig));
            this.reconfigureMtls();
        } else if (this.watcher() != null) {
            ManagedChannel channel = ((ManagedChannelBuilder)((ManagedChannelBuilder)ManagedChannelBuilder.forTarget(this.kafka$server$RmRegionalMetadataClient$$brokerConfig.regionalResourceManagerGrpcEndpointUrl()).defaultLoadBalancingPolicy("round_robin")).usePlaintext()).build();
            this.watcher().configure(channel);
        }
        this.getOrCreateMetrics();
    }

    private void getOrCreateMetrics() {
        this.rmCallCountSensor_$eq(this.metrics.getSensor(RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$RM_CALL_COUNT_SENSOR()));
        if (this.rmCallCountSensor() == null) {
            this.rmCallCountSensor_$eq(this.metrics.sensor(RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$RM_CALL_COUNT_SENSOR()));
            this.metrics.addMetric(this.connectionCountMetricName(), (config, now) -> this.connectionCount());
            this.rmCallCountSensor().add(this.rmCallCountMetricName(), new CumulativeSum());
            this.rmCallCountSensor().add(this.rmCallCountRateMetricName(), new Rate());
            this.rmErrorCountSensor_$eq(this.metrics.sensor(RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$RM_ERROR_COUNT_SENSOR()));
            this.rmErrorCountSensor().add(this.rmErrorCountMetricName(), new CumulativeSum());
            this.rmErrorCountSensor().add(this.rmErrorCountRateMetricName(), new Rate());
            return;
        }
    }

    private int connectionCount() {
        return this.apiClient().getHttpClient().connectionPool().connectionCount();
    }

    private void addListenerReconfigurable() {
        ListenerName listenerToWatchForReconfiguration = ListenerName.normalised(new MtlsWithServerCertConfigs(this.kafka$server$RmRegionalMetadataClient$$brokerConfig).mtListenerToWatchForReconfiguration());
        this.info((Function0<String> & Serializable)() -> "Listener to watch for reconfiguration: " + listenerToWatchForReconfiguration);
        this.listenerReconfigurable_$eq(new Some<ListenerReconfigurable>(new ListenerReconfigurable(this, listenerToWatchForReconfiguration){
            private final /* synthetic */ RmRegionalMetadataClient $outer;
            private final ListenerName listenerToWatchForReconfiguration$1;

            public ListenerName listenerName() {
                return this.listenerToWatchForReconfiguration$1;
            }

            public Set<String> reconfigurableConfigs() {
                return SslConfigs.RECONFIGURABLE_CONFIGS;
            }

            public void validateReconfiguration(Map<String, ?> configs) {
                this.$outer.validateReconfiguration(this.$outer.kafka$server$RmRegionalMetadataClient$$brokerConfig);
            }

            public void reconfigure(Map<String, ?> configs) {
                this.$outer.reconfigure(this.$outer.kafka$server$RmRegionalMetadataClient$$brokerConfig);
            }

            public void configure(Map<String, ?> configs) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.listenerToWatchForReconfiguration$1 = listenerToWatchForReconfiguration$1;
            }
        }));
        this.kafka$server$RmRegionalMetadataClient$$brokerConfig.addReconfigurable(this.listenerReconfigurable().get());
    }

    @Override
    public boolean supportsWatch() {
        return this.watcher() != null;
    }

    private boolean isMtlsEnabled() {
        return this.apiClient().getBasePath().toLowerCase(Locale.ROOT).contains("https");
    }

    public void validateReconfiguration(KafkaConfig newConfig) {
        if (this.isMtlsEnabled()) {
            this.sslFactory().validateReconfiguration(RmMTls.getSslClientConfig(newConfig));
            return;
        }
    }

    public void reconfigure(KafkaConfig newConfig) {
        if (this.isMtlsEnabled()) {
            this.info((Function0<String> & Serializable)() -> "Reconfiguring SSL for Regional Metadata Client");
            this.sslFactory().reconfigure(RmMTls.getSslClientConfig(newConfig));
            this.reconfigureMtls();
            return;
        }
    }

    private void reconfigureMtls() {
        DefaultSslEngineFactory defaultSslEngineFactory = RmMTls.defaultSslEngineFactory(this.sslFactory());
        SSLSocketFactory sslSocketFactory = RmMTls.sslSocketFactory(defaultSslEngineFactory);
        X509TrustManager trustManager = RmMTls.trustManager(defaultSslEngineFactory);
        OkHttpClient httpClient = this.apiClient().getHttpClient().newBuilder().sslSocketFactory(sslSocketFactory, trustManager).build();
        this.apiClient().setHttpClient(httpClient);
        if (this.watcher() != null) {
            ManagedChannel managedChannel = RmMTls.managedChannel(this.kafka$server$RmRegionalMetadataClient$$brokerConfig, defaultSslEngineFactory);
            this.watcher().configure(managedChannel);
            return;
        }
    }

    private <T> CompletableFuture<T> executeWithRetry(Supplier<T> supplier, Function1<Throwable, Object> shouldRetry) {
        return this.executeWithRetry(supplier, shouldRetry, RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$maxRetries(), TimeUnit.MILLISECONDS);
    }

    public <T> CompletableFuture<T> executeWithRetry(Supplier<T> supplier, Function1<Throwable, Object> shouldRetry, int maxRetries, TimeUnit unit) {
        CompletableFuture future = new CompletableFuture();
        Runnable runnable = () -> this.executeWithRetry(supplier, future, shouldRetry, maxRetries, unit, 1);
        this.executorService().schedule(runnable, 0L, unit);
        return future;
    }

    private <T> void executeWithRetry(Supplier<T> supplier, CompletableFuture<T> future, Function1<Throwable, Object> shouldRetry, int maxRetries, TimeUnit unit, int attempt) {
        block3: {
            try {
                T result = supplier.get();
                future.complete(result);
            }
            catch (Throwable e) {
                if (BoxesRunTime.unboxToBoolean(shouldRetry.apply(e)) && attempt < maxRetries) {
                    long backoffDelay = this.exponentialBackoff().backoff(attempt);
                    this.info((Function0<String> & Serializable)() -> "Failed to execute task, retrying attempt:" + attempt + " in " + backoffDelay + " ms", (Function0<Throwable> & Serializable)() -> e);
                    Runnable runnable = () -> this.executeWithRetry(supplier, future, shouldRetry, maxRetries, unit, attempt + 1);
                    this.executorService().schedule(runnable, backoffDelay, unit);
                    break block3;
                }
                this.error((Function0<String> & Serializable)() -> "Failed to execute task", (Function0<Throwable> & Serializable)() -> e);
                this.rmErrorCountSensor().record();
                future.completeExceptionally(e);
            }
        }
    }

    @Override
    public <T> AutoCloseable watch(Subscription<T> subscription, Watch<T> watch) {
        if (this.watcher() == null) {
            throw new IllegalStateException("Watcher is not configured, please configure 'confluent.regional.resource.manager.grpc.endpoint' before using it.");
        }
        return this.watcher().watch(subscription, watch);
    }

    public RmRegionalMetadataClient(KafkaConfig brokerConfig, Metrics metrics) {
        this.kafka$server$RmRegionalMetadataClient$$brokerConfig = brokerConfig;
        this.metrics = metrics;
        Logging.$init$(this);
        this.apiClient = new ApiClient();
        this.clModelsApi = new ClusterlinkV1Api(this.apiClient());
        this.coreApi = new CoreV1Api(this.apiClient());
        this.exponentialBackoff = new ExponentialBackoff(250L, 2, 5000L, 0.2);
        this.sslFactory = new SslFactory(ConnectionMode.CLIENT);
        this.lkcLookupCache = new HashMap();
        this.listCallPageSize = 500;
        this.connectionCountMetricName = metrics.metricName("connection-count", RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$METRICS_GROUP(), "The number of active connections.", "connection-type", "http");
        this.rmCallCountMetricName = metrics.metricName("rm-call-count-total", RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$METRICS_GROUP(), "The total out of process calls made to ResourceManager.");
        this.rmCallCountRateMetricName = metrics.metricName("rm-call-count-rate", RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$METRICS_GROUP(), "The rate of out of process calls made to ResourceManager.");
        this.rmErrorCountMetricName = metrics.metricName("rm-error-count-total", RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$METRICS_GROUP(), "The total errors on calls made to ResourceManager.");
        this.rmErrorCountRateMetricName = metrics.metricName("rm-error-count-rate", RmRegionalMetadataClient$.MODULE$.kafka$server$RmRegionalMetadataClient$$METRICS_GROUP(), "The rate of errors on calls made to ResourceManager.");
    }
}

