/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kafka.server.FetchContext;
import kafka.server.PartitionFetchMetadata;
import kafka.server.SessionlessFetchContext$;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchResponse;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005-q!\u0002\b\u0010\u0011\u0003!b!\u0002\f\u0010\u0011\u00039\u0002\"\u0002\u0010\u0002\t\u0003y\u0002b\u0002\u0011\u0002\u0005\u0004%i!\t\u0005\u0007Y\u0005\u0001\u000bQ\u0002\u0012\u0007\tYy\u0001!\f\u0005\tc\u0015\u0011)\u0019!C\u0001e!A\u0011*\u0002B\u0001B\u0003%1\u0007C\u0003\u001f\u000b\u0011\u0005!\n\u0003\u0005!\u000b!\u0015\r\u0011\"\u0011\"\u0011\u0015iU\u0001\"\u0011O\u0011\u00159V\u0001\"\u0011Y\u0011\u0015\tW\u0001\"\u0011c\u0011\u0015!X\u0001\"\u0011v\u0003]\u0019Vm]:j_:dWm]:GKR\u001c\u0007nQ8oi\u0016DHO\u0003\u0002\u0011#\u000511/\u001a:wKJT\u0011AE\u0001\u0006W\u000647.Y\u0002\u0001!\t)\u0012!D\u0001\u0010\u0005]\u0019Vm]:j_:dWm]:GKR\u001c\u0007nQ8oi\u0016DHo\u0005\u0002\u00021A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u000b\u0002\r1|wmZ3s+\u0005\u0011\u0003CA\u0012+\u001b\u0005!#BA\u0013'\u00031\u00198-\u00197bY><w-\u001b8h\u0015\t9\u0003&\u0001\u0005usB,7/\u00194f\u0015\u0005I\u0013aA2p[&\u00111\u0006\n\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sAM\u0019Q\u0001\u0007\u0018\u0011\u0005Uy\u0013B\u0001\u0019\u0010\u000511U\r^2i\u0007>tG/\u001a=u\u0003%1W\r^2i\t\u0006$\u0018-F\u00014!\u0011!\u0014h\u000f$\u000e\u0003UR!AN\u001c\u0002\tU$\u0018\u000e\u001c\u0006\u0002q\u0005!!.\u0019<b\u0013\tQTGA\u0002NCB\u0004\"\u0001\u0010#\u000e\u0003uR!AP \u0002\r\r|W.\\8o\u0015\t\u0011\u0002I\u0003\u0002B\u0005\u00061\u0011\r]1dQ\u0016T\u0011aQ\u0001\u0004_J<\u0017BA#>\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002\u0016\u000f&\u0011\u0001j\u0004\u0002\u0017!\u0006\u0014H/\u001b;j_:4U\r^2i\u001b\u0016$\u0018\rZ1uC\u0006Qa-\u001a;dQ\u0012\u000bG/\u0019\u0011\u0015\u0005-c\u0005CA\u000b\u0006\u0011\u0015\t\u0004\u00021\u00014\u000399W\r\u001e$fi\u000eDwJ\u001a4tKR$\"aT+\u0011\u0007e\u0001&+\u0003\u0002R5\t1q\n\u001d;j_:\u0004\"!G*\n\u0005QS\"\u0001\u0002'p]\u001eDQA\u0016\u0006A\u0002m\nA\u0001]1si\u0006\u0001bm\u001c:fC\u000eD\u0007+\u0019:uSRLwN\u001c\u000b\u00033r\u0003\"!\u0007.\n\u0005mS\"\u0001B+oSRDQ!X\u0006A\u0002y\u000b1AZ;o!\u0015Irl\u000f$Z\u0013\t\u0001'DA\u0005Gk:\u001cG/[8oe\u0005yq-\u001a;SKN\u0004xN\\:f'&TX\rF\u0002dM>\u0004\"!\u00073\n\u0005\u0015T\"aA%oi\")q\r\u0004a\u0001Q\u00069Q\u000f\u001d3bi\u0016\u001c\bCA5m\u001d\t)\".\u0003\u0002l\u001f\u0005aa)\u001a;dQN+7o]5p]&\u0011QN\u001c\u0002\t%\u0016\u001b\u0006kX'B!*\u00111n\u0004\u0005\u0006a2\u0001\r!]\u0001\nm\u0016\u00148/[8o\u0013\u0012\u0004\"!\u0007:\n\u0005MT\"!B*i_J$\u0018!H;qI\u0006$X-\u00118e\u000f\u0016tWM]1uKJ+7\u000f]8og\u0016$\u0015\r^1\u0015\u0007YdX\u0010\u0005\u0002xu6\t\u0001P\u0003\u0002z{\u0005A!/Z9vKN$8/\u0003\u0002|q\nia)\u001a;dQJ+7\u000f]8og\u0016DQaZ\u0007A\u0002!DQA`\u0007A\u0002}\fQB\\8eK\u0016sG\r]8j]R\u001c\b#\u0002\u001b\u0002\u0002\u0005\u0015\u0011bAA\u0002k\t!A*[:u!\ra\u0014qA\u0005\u0004\u0003\u0013i$\u0001\u0002(pI\u0016\u0004")
public class SessionlessFetchContext
implements FetchContext {
    private Logger logger;
    private final Map<TopicIdPartition, PartitionFetchMetadata> fetchData;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String partitionsToLogString(Collection<TopicIdPartition> partitions) {
        return FetchContext.partitionsToLogString$(this, partitions);
    }

    @Override
    public FetchResponse getThrottledResponse(int throttleTimeMs, List<Node> nodeEndpoints) {
        return FetchContext.getThrottledResponse$(this, throttleTimeMs, nodeEndpoints);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Map<TopicIdPartition, PartitionFetchMetadata> fetchData() {
        return this.fetchData;
    }

    private Logger logger$lzycompute() {
        SessionlessFetchContext sessionlessFetchContext = this;
        synchronized (sessionlessFetchContext) {
            if (!this.bitmap$0) {
                this.logger = SessionlessFetchContext$.MODULE$.kafka$server$SessionlessFetchContext$$logger();
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public Option<Object> getFetchOffset(TopicIdPartition part) {
        return Option$.MODULE$.apply(this.fetchData().get(part)).map((Function1<PartitionFetchMetadata, Object> & Serializable)x$2 -> BoxesRunTime.boxToLong(x$2.fetchOffset()));
    }

    @Override
    public void foreachPartition(Function2<TopicIdPartition, PartitionFetchMetadata, BoxedUnit> fun) {
        this.fetchData().forEach((topicPartition, partition) -> fun.apply((TopicIdPartition)topicPartition, (PartitionFetchMetadata)partition));
    }

    @Override
    public int getResponseSize(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates, short versionId) {
        return FetchResponse.sizeOf(versionId, updates.entrySet().iterator());
    }

    @Override
    public FetchResponse updateAndGenerateResponseData(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates, List<Node> nodeEndpoints) {
        this.debug((Function0<String> & Serializable)() -> "Sessionless fetch context returning " + this.partitionsToLogString(updates.keySet()));
        return FetchResponse.of(Errors.NONE, 0, 0, updates, nodeEndpoints);
    }

    public SessionlessFetchContext(Map<TopicIdPartition, PartitionFetchMetadata> fetchData) {
        this.fetchData = fetchData;
        Logging.$init$(this);
        FetchContext.$init$(this);
    }
}

