/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.IoThread$;
import kafka.server.NetworkThread$;
import kafka.server.RequestType;
import kafka.server.ThreadType;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ThreadUsageMetrics$ {
    public static final ThreadUsageMetrics$ MODULE$ = new ThreadUsageMetrics$();
    private static final String MetricGroup = "threads-usage-metrics";
    private static final String ListenerMetricTag = "listener";

    public String MetricGroup() {
        return MetricGroup;
    }

    public String ListenerMetricTag() {
        return ListenerMetricTag;
    }

    private double threadUsage(Metrics metrics, ThreadType threadType, Map<String, String> metricTags, RequestType requestType) {
        Option<KafkaMetric> metricOpt = Option$.MODULE$.apply(metrics.metric(this.threadUsageMetricName(metrics, threadType, metricTags, requestType)));
        Option<KafkaMetric> option = metricOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            KafkaMetric metric = (KafkaMetric)some.value();
            return BoxesRunTime.unboxToDouble(metric.metricValue());
        }
        return 0.0;
    }

    public double ioThreadsUsage(Metrics metrics, RequestType requestType) {
        return this.threadUsage(metrics, IoThread$.MODULE$, this.ioThreadUsageMetricTags(), requestType);
    }

    public double networkThreadsUsage(Metrics metrics, Seq<String> listeners, RequestType requestType) {
        return BoxesRunTime.unboxToDouble(listeners.foldLeft(BoxesRunTime.boxToDouble(0.0), (Function2<Object, String, Object> & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToDouble(ThreadUsageMetrics$.$anonfun$networkThreadsUsage$1(metrics, requestType, BoxesRunTime.unboxToDouble(x0$1), x1$1))));
    }

    public MetricName threadUsageMetricName(Metrics metrics, ThreadType threadType, Map<String, String> metricTags, RequestType requestType) {
        return metrics.metricName("request" + requestType.metricName() + "-" + threadType.name() + "-time", this.MetricGroup(), "Tracking " + requestType.name() + " request utilization percentage of " + threadType.name() + " threads", CollectionConverters$.MODULE$.MapHasAsJava(metricTags).asJava());
    }

    public Map<String, String> listenerNetworkThreadUsageMetricTags(String listener) {
        return (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.ListenerMetricTag()), listener)}));
    }

    public Map<String, String> ioThreadUsageMetricTags() {
        return Predef$.MODULE$.Map().empty();
    }

    public double networkThreadsCapacity(Metrics metrics, Seq<String> listeners) {
        return BoxesRunTime.unboxToDouble(listeners.foldLeft(BoxesRunTime.boxToDouble(0.0), (Function2<Object, String, Object> & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToDouble(ThreadUsageMetrics$.$anonfun$networkThreadsCapacity$1(metrics, BoxesRunTime.unboxToDouble(x0$1), x1$1))));
    }

    public double ioThreadsCapacity(Metrics metrics) {
        return this.threadPoolCapacity(metrics, IoThread$.MODULE$, this.ioThreadUsageMetricTags());
    }

    public MetricName ioThreadPoolCapacityMetricName(Metrics metrics) {
        return this.threadPoolCapacityMetricName(metrics, IoThread$.MODULE$, this.ioThreadUsageMetricTags(), "(current number of io threads)*100%");
    }

    public MetricName networkThreadPoolCapacityMetricName(Metrics metrics, String listener) {
        return this.threadPoolCapacityMetricName(metrics, NetworkThread$.MODULE$, this.listenerNetworkThreadUsageMetricTags(listener), "(current number of network threads for " + listener + ")*100%");
    }

    public MetricName threadPoolCapacityMetricName(Metrics metrics, ThreadType threadType, Map<String, String> metricTags, String metricDescription) {
        return metrics.metricName("total-" + threadType.name() + "-time", this.MetricGroup(), metricDescription, CollectionConverters$.MODULE$.MapHasAsJava(metricTags).asJava());
    }

    private double threadPoolCapacity(Metrics metrics, ThreadType threadType, Map<String, String> metricTags) {
        MetricName metricName = this.threadPoolCapacityMetricName(metrics, threadType, metricTags, "");
        Option<KafkaMetric> option = Option$.MODULE$.apply(metrics.metric(metricName));
        if (option instanceof Some) {
            Some some = (Some)option;
            KafkaMetric metric = (KafkaMetric)some.value();
            return BoxesRunTime.unboxToDouble(metric.metricValue());
        }
        return 0.0;
    }

    public static final /* synthetic */ double $anonfun$networkThreadsUsage$1(Metrics metrics$1, RequestType requestType$1, double x0$1, String x1$1) {
        Tuple2<Double, String> tuple2 = new Tuple2<Double, String>(BoxesRunTime.boxToDouble(x0$1), x1$1);
        if (tuple2 != null) {
            double usage = tuple2._1$mcD$sp();
            String listener = tuple2._2();
            return usage + MODULE$.threadUsage(metrics$1, NetworkThread$.MODULE$, MODULE$.listenerNetworkThreadUsageMetricTags(listener), requestType$1);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ double $anonfun$networkThreadsCapacity$1(Metrics metrics$2, double x0$1, String x1$1) {
        Tuple2<Double, String> tuple2 = new Tuple2<Double, String>(BoxesRunTime.boxToDouble(x0$1), x1$1);
        if (tuple2 != null) {
            double capacity = tuple2._1$mcD$sp();
            String listener = tuple2._2();
            return capacity + MODULE$.threadPoolCapacity(metrics$2, NetworkThread$.MODULE$, MODULE$.listenerNetworkThreadUsageMetricTags(listener));
        }
        throw new MatchError(tuple2);
    }

    private ThreadUsageMetrics$() {
    }
}

