/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import kafka.server.ThrottleCallback;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00154A!\u0004\b\u0001'!A!\u0006\u0001BC\u0002\u0013\u00051\u0006\u0003\u00059\u0001\t\u0005\t\u0015!\u0003-\u0011!I\u0004A!b\u0001\n\u0003Q\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u0011\t\u0003!Q1A\u0005\u0002\rC\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\u0006\u0013\u0002!\tA\u0013\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003Q\u0011\u0019!\u0006\u0001)A\u0005#\")Q\u000b\u0001C\u0001-\")!\f\u0001C!7\")\u0011\r\u0001C!E\n\u0001B\u000b\u001b:piRdW\rZ\"iC:tW\r\u001c\u0006\u0003\u001fA\taa]3sm\u0016\u0014(\"A\t\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0006\u000f%!\t)\"$D\u0001\u0017\u0015\t9\u0002$\u0001\u0003mC:<'\"A\r\u0002\t)\fg/Y\u0005\u00037Y\u0011aa\u00142kK\u000e$\bCA\u000f#\u001b\u0005q\"BA\u0010!\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003Ca\tA!\u001e;jY&\u00111E\b\u0002\b\t\u0016d\u0017-_3e!\t)\u0003&D\u0001'\u0015\t9\u0003#A\u0003vi&d7/\u0003\u0002*M\t9Aj\\4hS:<\u0017\u0001\u0002;j[\u0016,\u0012\u0001\f\t\u0003[Yj\u0011A\f\u0006\u0003O=R!\u0001M\u0019\u0002\r\r|W.\\8o\u0015\t\t\"G\u0003\u00024i\u00051\u0011\r]1dQ\u0016T\u0011!N\u0001\u0004_J<\u0017BA\u001c/\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u001dQD'o\u001c;uY\u0016$\u0016.\\3NgV\t1\b\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UHA\u0002J]R\fq\u0002\u001e5s_R$H.\u001a+j[\u0016l5\u000fI\u0001\tG\u0006dGNY1dWV\tA\t\u0005\u0002F\r6\ta\"\u0003\u0002H\u001d\t\u0001B\u000b\u001b:piRdWmQ1mY\n\f7m[\u0001\nG\u0006dGNY1dW\u0002\na\u0001P5oSRtD\u0003B&M\u001b:\u0003\"!\u0012\u0001\t\u000b):\u0001\u0019\u0001\u0017\t\u000be:\u0001\u0019A\u001e\t\u000b\t;\u0001\u0019\u0001#\u0002\u0019\u0015tG\rV5nK:\u000bgn\\:\u0016\u0003E\u0003\"\u0001\u0010*\n\u0005Mk$\u0001\u0002'p]\u001e\fQ\"\u001a8e)&lWMT1o_N\u0004\u0013\u0001\u00068pi&4\u0017\u0010\u00165s_R$H.\u001b8h\t>tW\rF\u0001X!\ta\u0004,\u0003\u0002Z{\t!QK\\5u\u0003!9W\r\u001e#fY\u0006LHCA)]\u0011\u0015i6\u00021\u0001_\u0003\u0011)h.\u001b;\u0011\u0005uy\u0016B\u00011\u001f\u0005!!\u0016.\\3V]&$\u0018!C2p[B\f'/\u001a+p)\tY4\rC\u0003e\u0019\u0001\u0007A$A\u0001e\u0001")
public class ThrottledChannel
implements Delayed,
Logging {
    private final Time time;
    private final int throttleTimeMs;
    private final ThrottleCallback callback;
    private final long endTimeNanos;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ThrottledChannel throttledChannel = this;
        synchronized (throttledChannel) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Time time() {
        return this.time;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public ThrottleCallback callback() {
        return this.callback;
    }

    private long endTimeNanos() {
        return this.endTimeNanos;
    }

    public void notifyThrottlingDone() {
        this.trace((Function0<String> & Serializable)() -> "Channel throttled for: " + this.throttleTimeMs() + " ms");
        this.callback().endThrottling();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.endTimeNanos() - this.time().nanoseconds(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed d) {
        ThrottledChannel other = (ThrottledChannel)d;
        return Long.compare(this.endTimeNanos(), other.endTimeNanos());
    }

    public ThrottledChannel(Time time, int throttleTimeMs, ThrottleCallback callback) {
        this.time = time;
        this.throttleTimeMs = throttleTimeMs;
        this.callback = callback;
        Logging.$init$(this);
        this.endTimeNanos = time.nanoseconds() + TimeUnit.MILLISECONDS.toNanos(throttleTimeMs);
        callback.startThrottling();
    }
}

