/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.datapolicy;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.server.DataFlowPolicy;
import kafka.server.KafkaConfig;
import kafka.server.RegionalMetadataClient;
import kafka.server.RegionalMetadataClient$;
import kafka.server.Subscription;
import kafka.server.Subscription$SubscriptionFactory$;
import kafka.server.datapolicy.DataFlowPolicyOptInListener;
import kafka.server.datapolicy.EnvironmentKey;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.WindowedCount;
import org.apache.kafka.server.datapolicy.DefaultDataPolicyStore;
import org.apache.kafka.server.multitenant.LogicalClusterMetadata;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.apache.kafka.server.util.KafkaScheduler;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t}d\u0001B\u001e=\u0001\rC\u0001\u0002\u0015\u0001\u0003\u0006\u0004%\t!\u0015\u0005\t-\u0002\u0011\t\u0011)A\u0005%\"Aq\u000b\u0001B\u0001B\u0003%\u0001\f\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003f\u0011!y\u0007A!A!\u0002\u0013\u0001\b\"\u0002;\u0001\t\u0003)\bb\u0002?\u0001\u0005\u0004%I! \u0005\b\u0003'\u0001\u0001\u0015!\u0003\u007f\u0011)\t)\u0002\u0001a\u0001\n\u0003a\u0014q\u0003\u0005\u000b\u0003\u0003\u0002\u0001\u0019!C\u0001y\u0005\r\u0003\u0002CA\u0019\u0001\u0001\u0006K!!\u0007\t\u0013\u0005e\u0003\u00011A\u0005\n\u0005m\u0003\"CA5\u0001\u0001\u0007I\u0011BA6\u0011!\ty\u0007\u0001Q!\n\u0005u\u0003\u0002DA9\u0001\u0001\u0007\t\u0019!C\u0001y\u0005M\u0004\u0002DA@\u0001\u0001\u0007\t\u0019!C\u0001y\u0005\u0005\u0005bCAC\u0001\u0001\u0007\t\u0011)Q\u0005\u0003kB1\"a\"\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\n\"Y\u0011q\u0013\u0001A\u0002\u0003\u0007I\u0011BAM\u0011-\ti\n\u0001a\u0001\u0002\u0003\u0006K!a#\t\u0017\u0005}\u0005\u00011AA\u0002\u0013%\u0011\u0011\u0015\u0005\f\u0003_\u0003\u0001\u0019!a\u0001\n\u0013\t\t\fC\u0006\u00026\u0002\u0001\r\u0011!Q!\n\u0005\r\u0006BCA\\\u0001\u0001\u0007I\u0011\u0001\u001f\u0002:\"Q\u0011\u0011\u0019\u0001A\u0002\u0013\u0005A(a1\t\u0011\u0005\u001d\u0007\u0001)Q\u0005\u0003wC!\"!3\u0001\u0001\u0004%\t\u0001PA]\u0011)\tY\r\u0001a\u0001\n\u0003a\u0014Q\u001a\u0005\t\u0003#\u0004\u0001\u0015)\u0003\u0002<\"Q\u00111\u001b\u0001A\u0002\u0013\u0005A(!6\t\u0015\u0005\r\b\u00011A\u0005\u0002q\n)\u000f\u0003\u0005\u0002j\u0002\u0001\u000b\u0015BAl\u0011)\tY\u000f\u0001a\u0001\n\u0003a\u0014Q\u001b\u0005\u000b\u0003[\u0004\u0001\u0019!C\u0001y\u0005=\b\u0002CAz\u0001\u0001\u0006K!a6\t\u0013\u0005U\b\u00011A\u0005\n\u0005]\b\"\u0003B\u0001\u0001\u0001\u0007I\u0011\u0002B\u0002\u0011!\u00119\u0001\u0001Q!\n\u0005e\b\"\u0003B\u0005\u0001\u0001\u0007I\u0011BA|\u0011%\u0011Y\u0001\u0001a\u0001\n\u0013\u0011i\u0001\u0003\u0005\u0003\u0012\u0001\u0001\u000b\u0015BA}\u0011)\u0011\u0019\u0002\u0001a\u0001\n\u0003a$Q\u0003\u0005\u000b\u0005c\u0001\u0001\u0019!C\u0001y\tM\u0002\u0002\u0003B\u001c\u0001\u0001\u0006KAa\u0006\t\u000f\te\u0002\u0001\"\u0001\u0003<!9!\u0011\t\u0001\u0005\u0002\t\r\u0003b\u0002B$\u0001\u0011\u0005!\u0011\n\u0005\t\u0005\u0017\u0002A\u0011\u0001\u001f\u0003N!A!q\u000b\u0001\u0005\u0002q\u0012i\u0005C\u0004\u0003Z\u0001!\tA!\u0013\t\u0011\tm\u0003\u0001\"\u0001?\u0005\u0013B\u0001B!\u0018\u0001\t\u0003a$Q\u0003\u0005\t\u0005?\u0002A\u0011\u0001\u001f\u0003J!A!\u0011\r\u0001\u0005\u0002q\u0012I\u0005\u0003\u0005\u0003d\u0001!\t\u0001\u0010B%\u0011\u001d\u0011)\u0007\u0001C\u0005\u0005\u0013B\u0001Ba\u001a\u0001\t\u0003a$\u0011\u000e\u0005\t\u0005_\u0002A\u0011\u0001\u001f\u0003r\t)B)\u0019;b\r2|w\u000fU8mS\u000eLx+\u0019;dQ\u0016\u0014(BA\u001f?\u0003)!\u0017\r^1q_2L7-\u001f\u0006\u0003\u007f\u0001\u000baa]3sm\u0016\u0014(\"A!\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0012&\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\r\u0005s\u0017PU3g!\tYe*D\u0001M\u0015\ti\u0005)A\u0003vi&d7/\u0003\u0002P\u0019\n9Aj\\4hS:<\u0017\u0001\u00042s_.,'oQ8oM&<W#\u0001*\u0011\u0005M#V\"\u0001 \n\u0005Us$aC&bM.\f7i\u001c8gS\u001e\fQB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\u0013aB7fiJL7m\u001d\t\u00033\nl\u0011A\u0017\u0006\u0003/nS!\u0001X/\u0002\r\r|W.\\8o\u0015\t\teL\u0003\u0002`A\u00061\u0011\r]1dQ\u0016T\u0011!Y\u0001\u0004_J<\u0017BA2[\u0005\u001diU\r\u001e:jGN\f1#\\;mi&$VM\\1oi6+G/\u00193bi\u0006\u00042!\u00124i\u0013\t9gI\u0001\u0004PaRLwN\u001c\t\u0003S6l\u0011A\u001b\u0006\u0003W2\f1\"\\;mi&$XM\\1oi*\u0011q(X\u0005\u0003]*\u00141#T;mi&$VM\\1oi6+G/\u00193bi\u0006\faC]3hS>t\u0017\r\\'fi\u0006$\u0017\r^1DY&,g\u000e\u001e\t\u0004\u000b\u001a\f\bCA*s\u0013\t\u0019hH\u0001\fSK\u001eLwN\\1m\u001b\u0016$\u0018\rZ1uC\u000ec\u0017.\u001a8u\u0003\u0019a\u0014N\\5u}Q)a\u000f_={wB\u0011q\u000fA\u0007\u0002y!)\u0001K\u0002a\u0001%\")qK\u0002a\u00011\")AM\u0002a\u0001K\")qN\u0002a\u0001a\u0006IA.[:uK:,'o]\u000b\u0002}B)q0!\u0003\u0002\u000e5\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0003vi&d'BAA\u0004\u0003\u0011Q\u0017M^1\n\t\u0005-\u0011\u0011\u0001\u0002\u0004'\u0016$\bcA<\u0002\u0010%\u0019\u0011\u0011\u0003\u001f\u00037\u0011\u000bG/\u0019$m_^\u0004v\u000e\\5ds>\u0003H/\u00138MSN$XM\\3s\u0003)a\u0017n\u001d;f]\u0016\u00148\u000fI\u0001\u0013G\u0006\u001c\u0007.Z+qI\u0006$XM\u001d$viV\u0014X-\u0006\u0002\u0002\u001aA!QIZA\u000ea\u0011\ti\"!\f\u0011\r\u0005}\u0011QEA\u0015\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0005\u0011AC2p]\u000e,(O]3oi&!\u0011qEA\u0011\u0005=\u00196\r[3ek2,GMR;ukJ,\u0007\u0003BA\u0016\u0003[a\u0001\u0001B\u0006\u00020-\t\t\u0011!A\u0003\u0002\u0005M\"aA0%c\u0005\u00192-Y2iKV\u0003H-\u0019;fe\u001a+H/\u001e:fAE!\u0011QGA\u001e!\r)\u0015qG\u0005\u0004\u0003s1%a\u0002(pi\"Lgn\u001a\t\u0004\u000b\u0006u\u0012bAA \r\n\u0019\u0011I\\=\u0002-\r\f7\r[3Va\u0012\fG/\u001a:GkR,(/Z0%KF$B!!\u0012\u0002LA\u0019Q)a\u0012\n\u0007\u0005%cI\u0001\u0003V]&$\b\"CA'\u0015\u0005\u0005\t\u0019AA(\u0003\rAH%\r\t\u0005\u000b\u001a\f\t\u0006\r\u0003\u0002T\u0005]\u0003CBA\u0010\u0003K\t)\u0006\u0005\u0003\u0002,\u0005]C\u0001DA\u0018\u0003\u0017\n\t\u0011!A\u0003\u0002\u0005M\u0012AD6bM.\f7k\u00195fIVdWM]\u000b\u0003\u0003;\u0002B!\u00124\u0002`A!\u0011\u0011MA3\u001b\t\t\u0019GC\u0002\u0002\u00041LA!a\u001a\u0002d\tq1*\u00194lCN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AE6bM.\f7k\u00195fIVdWM]0%KF$B!!\u0012\u0002n!I\u0011QJ\u0007\u0002\u0002\u0003\u0007\u0011QL\u0001\u0010W\u000647.Y*dQ\u0016$W\u000f\\3sA\u0005yA-\u0019;b!>d\u0017nY=Ti>\u0014X-\u0006\u0002\u0002vA!\u0011qOA>\u001b\t\tIH\u0003\u0002>Y&!\u0011QPA=\u0005Y!UMZ1vYR$\u0015\r^1Q_2L7-_*u_J,\u0017a\u00053bi\u0006\u0004v\u000e\\5dsN#xN]3`I\u0015\fH\u0003BA#\u0003\u0007C\u0011\"!\u0014\u0011\u0003\u0003\u0005\r!!\u001e\u0002!\u0011\fG/\u0019)pY&\u001c\u0017p\u0015;pe\u0016\u0004\u0013!B<bi\u000eDWCAAF!\u0011\ti)a%\u000e\u0005\u0005=%\u0002BAI\u0003\u000b\tA\u0001\\1oO&!\u0011QSAH\u00055\tU\u000f^8DY>\u001cX-\u00192mK\u0006Iq/\u0019;dQ~#S-\u001d\u000b\u0005\u0003\u000b\nY\nC\u0005\u0002NM\t\t\u00111\u0001\u0002\f\u00061q/\u0019;dQ\u0002\nAb];cg\u000e\u0014\u0018\u000e\u001d;j_:,\"!a)\u0011\u000bM\u000b)+!+\n\u0007\u0005\u001dfH\u0001\u0007Tk\n\u001c8M]5qi&|g\u000eE\u0002T\u0003WK1!!,?\u00059!\u0015\r^1GY><\bk\u001c7jGf\f\u0001c];cg\u000e\u0014\u0018\u000e\u001d;j_:|F%Z9\u0015\t\u0005\u0015\u00131\u0017\u0005\n\u0003\u001b2\u0012\u0011!a\u0001\u0003G\u000bQb];cg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\u0013\u0001\u0004:fgR\f'\u000f^,bi\u000eDWCAA^!\r)\u0015QX\u0005\u0004\u0003\u007f3%a\u0002\"p_2,\u0017M\\\u0001\u0011e\u0016\u001cH/\u0019:u/\u0006$8\r[0%KF$B!!\u0012\u0002F\"I\u0011QJ\r\u0002\u0002\u0003\u0007\u00111X\u0001\u000ee\u0016\u001cH/\u0019:u/\u0006$8\r\u001b\u0011\u0002\u001fI,\u0007o\u001c9vY\u0006$XmQ1dQ\u0016\f1C]3q_B,H.\u0019;f\u0007\u0006\u001c\u0007.Z0%KF$B!!\u0012\u0002P\"I\u0011Q\n\u000f\u0002\u0002\u0003\u0007\u00111X\u0001\u0011e\u0016\u0004x\u000e];mCR,7)Y2iK\u0002\n\u0011C]3ti\u0006\u0014HoV1uG\"\u001cu.\u001e8u+\t\t9\u000e\u0005\u0003\u0002Z\u0006}WBAAn\u0015\u0011\ti.!\t\u0002\r\u0005$x.\\5d\u0013\u0011\t\t/a7\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0003U\u0011Xm\u001d;beR<\u0016\r^2i\u0007>,h\u000e^0%KF$B!!\u0012\u0002h\"I\u0011QJ\u0010\u0002\u0002\u0003\u0007\u0011q[\u0001\u0013e\u0016\u001cH/\u0019:u/\u0006$8\r[\"pk:$\b%\u0001\u000bsKB|\u0007/\u001e7bi\u0016\u001c\u0015m\u00195f\u0007>,h\u000e^\u0001\u0019e\u0016\u0004x\u000e];mCR,7)Y2iK\u000e{WO\u001c;`I\u0015\fH\u0003BA#\u0003cD\u0011\"!\u0014#\u0003\u0003\u0005\r!a6\u0002+I,\u0007o\u001c9vY\u0006$XmQ1dQ\u0016\u001cu.\u001e8uA\u0005\u0011r/\u0019;dQ\u001a\u000b\u0017\u000e\\;sKN+gn]8s+\t\tI\u0010\u0005\u0003FM\u0006m\bcA-\u0002~&\u0019\u0011q .\u0003\rM+gn]8s\u0003Y9\u0018\r^2i\r\u0006LG.\u001e:f'\u0016t7o\u001c:`I\u0015\fH\u0003BA#\u0005\u000bA\u0011\"!\u0014&\u0003\u0003\u0005\r!!?\u0002']\fGo\u00195GC&dWO]3TK:\u001cxN\u001d\u0011\u00025\r\f7\r[3Q_B,H.\u0019;f\r\u0006LG.\u001e:f'\u0016t7o\u001c:\u0002=\r\f7\r[3Q_B,H.\u0019;f\r\u0006LG.\u001e:f'\u0016t7o\u001c:`I\u0015\fH\u0003BA#\u0005\u001fA\u0011\"!\u0014)\u0003\u0003\u0005\r!!?\u00027\r\f7\r[3Q_B,H.\u0019;f\r\u0006LG.\u001e:f'\u0016t7o\u001c:!\u0003i\u0001(/\u001a<F]ZL'o\u001c8nK:$8oQ8og&$WM]3e+\t\u00119\u0002\u0005\u0004\u0003\u001a\t\u001d\"1\u0006\b\u0005\u00057\u0011\u0019\u0003E\u0002\u0003\u001e\u0019k!Aa\b\u000b\u0007\t\u0005\")\u0001\u0004=e>|GOP\u0005\u0004\u0005K1\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\f\t%\"b\u0001B\u0013\rB\u0019qO!\f\n\u0007\t=BH\u0001\bF]ZL'o\u001c8nK:$8*Z=\u0002=A\u0014XM^#om&\u0014xN\\7f]R\u001c8i\u001c8tS\u0012,'/\u001a3`I\u0015\fH\u0003BA#\u0005kA\u0011\"!\u0014,\u0003\u0003\u0005\rAa\u0006\u00027A\u0014XM^#om&\u0014xN\\7f]R\u001c8i\u001c8tS\u0012,'/\u001a3!\u0003A\u0011XmZ5ti\u0016\u0014H*[:uK:,'\u000f\u0006\u0003\u0002F\tu\u0002b\u0002B [\u0001\u0007\u0011QB\u0001\tY&\u001cH/\u001a8fe\u0006\u0011B-\u001a*fO&\u001cH/\u001a:MSN$XM\\3s)\u0011\t)E!\u0012\t\u000f\t}b\u00061\u0001\u0002\u000e\u000591\u000f^1siV\u0004HCAA#\u0003y\u0019\u0017m\u00195f!>\u0004X\u000f\\1uK\u001a\u000b\u0017\u000e\\;sK6+GO]5d\u001d\u0006lW-\u0006\u0002\u0003PA!!\u0011\u000bB*\u001b\u0005Y\u0016b\u0001B+7\nQQ*\u001a;sS\u000et\u0015-\\3\u0002-]\fGo\u00195GC&dWO]3NKR\u0014\u0018n\u0019(b[\u0016\f\u0001b\u001d5vi\u0012|wO\\\u0001$[\u0006L(-\u001a)paVd\u0017\r^3DC\u000eDW-\u00118e%\u0016\u001cH/\u0019:u/\u0006$8\r[3s\u0003=9W\r^#om&\u0014xN\\7f]R\u001c\u0018\u0001F7bs\n,'+\u001a9paVd\u0017\r^3DC\u000eDW-\u0001\u0014dQ\u0016\u001c7NU3q_B,H.\u0019;f\tV,Gk\\#om&\u0014xN\\7f]R\u001c8\t[1oO\u0016\f1#\\1zE\u0016\u0014Vm\u001d;beR<\u0016\r^2iKJ\fQb\u001d5vi\u0012|wO\\,bi\u000eD\u0017AD8o!>d\u0017nY=DQ\u0006tw-\u001a\u000b\u0005\u0003\u000b\u0012Y\u0007C\u0004\u0003ne\u0002\r!!+\u0002\u001d\u0011\fG/\u0019$m_^\u0004v\u000e\\5ds\u0006\u0011\"-^5mI\u001aKW\r\u001c3TK2,7\r^8s)\t\u0011\u0019\bE\u0004\u0000\u0005k\u0012IH!\u001f\n\t\t]\u0014\u0011\u0001\u0002\u0004\u001b\u0006\u0004\b\u0003\u0002B\r\u0005wJAA! \u0003*\t11\u000b\u001e:j]\u001e\u0004")
public class DataFlowPolicyWatcher
implements Logging {
    private final KafkaConfig brokerConfig;
    private final Metrics metrics;
    private final Option<MultiTenantMetadata> multiTenantMetadata;
    private final Option<RegionalMetadataClient> regionalMetadataClient;
    private final Set<DataFlowPolicyOptInListener> listeners;
    private Option<ScheduledFuture<?>> cacheUpdaterFuture;
    private Option<KafkaScheduler> kafkaScheduler;
    private DefaultDataPolicyStore dataPolicyStore;
    private AutoCloseable watch;
    private Subscription<DataFlowPolicy> subscription;
    private boolean restartWatch;
    private boolean repopulateCache;
    private AtomicInteger restartWatchCount;
    private AtomicInteger repopulateCacheCount;
    private Option<Sensor> watchFailureSensor;
    private Option<Sensor> cachePopulateFailureSensor;
    private scala.collection.immutable.Set<EnvironmentKey> prevEnvironmentsConsidered;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DataFlowPolicyWatcher dataFlowPolicyWatcher = this;
        synchronized (dataFlowPolicyWatcher) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    private Set<DataFlowPolicyOptInListener> listeners() {
        return this.listeners;
    }

    public Option<ScheduledFuture<?>> cacheUpdaterFuture() {
        return this.cacheUpdaterFuture;
    }

    public void cacheUpdaterFuture_$eq(Option<ScheduledFuture<?>> x$1) {
        this.cacheUpdaterFuture = x$1;
    }

    private Option<KafkaScheduler> kafkaScheduler() {
        return this.kafkaScheduler;
    }

    private void kafkaScheduler_$eq(Option<KafkaScheduler> x$1) {
        this.kafkaScheduler = x$1;
    }

    public DefaultDataPolicyStore dataPolicyStore() {
        return this.dataPolicyStore;
    }

    public void dataPolicyStore_$eq(DefaultDataPolicyStore x$1) {
        this.dataPolicyStore = x$1;
    }

    private AutoCloseable watch() {
        return this.watch;
    }

    private void watch_$eq(AutoCloseable x$1) {
        this.watch = x$1;
    }

    private Subscription<DataFlowPolicy> subscription() {
        return this.subscription;
    }

    private void subscription_$eq(Subscription<DataFlowPolicy> x$1) {
        this.subscription = x$1;
    }

    public boolean restartWatch() {
        return this.restartWatch;
    }

    public void restartWatch_$eq(boolean x$1) {
        this.restartWatch = x$1;
    }

    public boolean repopulateCache() {
        return this.repopulateCache;
    }

    public void repopulateCache_$eq(boolean x$1) {
        this.repopulateCache = x$1;
    }

    public AtomicInteger restartWatchCount() {
        return this.restartWatchCount;
    }

    public void restartWatchCount_$eq(AtomicInteger x$1) {
        this.restartWatchCount = x$1;
    }

    public AtomicInteger repopulateCacheCount() {
        return this.repopulateCacheCount;
    }

    public void repopulateCacheCount_$eq(AtomicInteger x$1) {
        this.repopulateCacheCount = x$1;
    }

    private Option<Sensor> watchFailureSensor() {
        return this.watchFailureSensor;
    }

    private void watchFailureSensor_$eq(Option<Sensor> x$1) {
        this.watchFailureSensor = x$1;
    }

    private Option<Sensor> cachePopulateFailureSensor() {
        return this.cachePopulateFailureSensor;
    }

    private void cachePopulateFailureSensor_$eq(Option<Sensor> x$1) {
        this.cachePopulateFailureSensor = x$1;
    }

    public scala.collection.immutable.Set<EnvironmentKey> prevEnvironmentsConsidered() {
        return this.prevEnvironmentsConsidered;
    }

    public void prevEnvironmentsConsidered_$eq(scala.collection.immutable.Set<EnvironmentKey> x$1) {
        this.prevEnvironmentsConsidered = x$1;
    }

    public void registerListener(DataFlowPolicyOptInListener listener) {
        this.listeners().add(listener);
    }

    public void deRegisterListener(DataFlowPolicyOptInListener listener) {
        this.listeners().remove(listener);
    }

    public void startup() {
        if (this.multiTenantMetadata.isDefined() && this.regionalMetadataClient.isDefined() && this.regionalMetadataClient.get().supportsWatch()) {
            this.watchFailureSensor_$eq(new Some<Sensor>(this.metrics.sensor("data-flow-policy-watch-failure")));
            this.watchFailureSensor().get().add(this.watchFailureMetricName(), new WindowedCount());
            this.cachePopulateFailureSensor_$eq(new Some<Sensor>(this.metrics.sensor("data-flow-policy-cache-populate-failure")));
            this.cachePopulateFailureSensor().get().add(this.cachePopulateFailureMetricName(), new WindowedCount());
            this.dataPolicyStore_$eq(DefaultDataPolicyStore.getInstance(this.brokerConfig().brokerSessionUuid()));
            this.kafkaScheduler_$eq(new Some<KafkaScheduler>(new KafkaScheduler(1, true, "data-flow-policy-watch-scheduler-", false)));
            this.kafkaScheduler().get().startup();
            this.cacheUpdaterFuture_$eq(new Some(this.kafkaScheduler().get().schedule("dataFlowPolicyWatchMonitor", () -> this.maybePopulateCacheAndRestartWatcher(), 0L, Predef$.MODULE$.Long2long(this.brokerConfig().dataFlowPolicyWatchMonitorMs()))));
            return;
        }
    }

    public MetricName cachePopulateFailureMetricName() {
        return this.metrics.metricName("data-flow-policy-cache-populate-failure", RegionalMetadataClient$.MODULE$.metricGrouName(), "The windowed failure count for data flow policy cache population.");
    }

    public MetricName watchFailureMetricName() {
        return this.metrics.metricName("data-flow-policy-watch-failure", RegionalMetadataClient$.MODULE$.metricGrouName(), "The windowed failure count for watch event handler.");
    }

    public void shutdown() {
        this.cacheUpdaterFuture().foreach((Function1<ScheduledFuture, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(x$4.cancel(true)));
        this.kafkaScheduler().foreach((Function1<KafkaScheduler, Object> & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        this.shutdownWatch();
        this.watchFailureSensor().foreach((Function1<Sensor, Object> & Serializable)s -> {
            this.metrics.removeSensor(s.name());
            return BoxedUnit.UNIT;
        });
        this.cachePopulateFailureSensor().foreach((Function1<Sensor, Object> & Serializable)s -> {
            this.metrics.removeSensor(s.name());
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void maybePopulateCacheAndRestartWatcher() {
        this.maybeRestartWatcher();
        this.maybeRepopulateCache();
    }

    public scala.collection.immutable.Set<EnvironmentKey> getEnvironments() {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(this.multiTenantMetadata.get().kafkaLogicalClusterIds()).asScala().map((Function1<String, EnvironmentKey> & Serializable)clusterId -> {
            LogicalClusterMetadata lkc = $this.multiTenantMetadata.get().metadata((String)clusterId);
            if (lkc != null) {
                return new EnvironmentKey(lkc.organizationId(), lkc.environmentId());
            }
            return null;
        })).filter((Function1<EnvironmentKey, Object> & Serializable)e -> BoxesRunTime.boxToBoolean(DataFlowPolicyWatcher.$anonfun$getEnvironments$2(e)))).toSet();
    }

    public void maybeRepopulateCache() {
        this.checkRepopulateDueToEnvironmentsChange();
        if (this.repopulateCache()) {
            try {
                this.info((Function0<String> & Serializable)() -> "Repopulating cache with data flow policies, repopulateCacheCount=" + this.repopulateCacheCount());
                this.repopulateCacheCount().incrementAndGet();
                ListBuffer futures = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                scala.collection.immutable.Set<EnvironmentKey> currentEnvironments = this.getEnvironments();
                currentEnvironments.foreach((Function1<EnvironmentKey, Object> & Serializable)envKey -> {
                    Object object;
                    block3: {
                        try {
                            CompletableFuture<Option<DataFlowPolicy>> dataFlowPolicy = $this.regionalMetadataClient.get().getDataFlowPolicy(envKey.organizationId(), envKey.environmentId());
                            if (dataFlowPolicy != null) {
                                futures.$plus$eq(dataFlowPolicy);
                                object = dataFlowPolicy.whenComplete((policy, ex) -> {
                                    if (ex != null) {
                                        this.cachePopulateFailureSensor().foreach((Function1<Sensor, Object> & Serializable)x$6 -> {
                                            x$6.record();
                                            return BoxedUnit.UNIT;
                                        });
                                        this.handleException$1((Throwable)ex, envKey.environmentId());
                                        return;
                                    }
                                    if (policy.isDefined()) {
                                        this.debug((Function0<String> & Serializable)() -> "Adding policy for environmentId=" + envKey.environmentId() + " with value=" + policy + ".get.envWideBoundary");
                                        this.dataPolicyStore().addPolicy(envKey.environmentId(), ((DataFlowPolicy)policy.get()).envWideBoundary());
                                        return;
                                    }
                                });
                                break block3;
                            }
                            object = BoxedUnit.UNIT;
                        }
                        catch (Throwable e) {
                            this.handleException$1(e, envKey.environmentId());
                            object = BoxedUnit.UNIT;
                        }
                    }
                    return object;
                });
                if (futures.isEmpty()) {
                    this.repopulateCache_$eq(false);
                    this.info((Function0<String> & Serializable)() -> "Cache populated with data flow policies for 0 environments, repopulateCacheCount=" + this.repopulateCacheCount());
                    v0 = BoxedUnit.UNIT;
                } else {
                    v0 = ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])futures.toSeq().toArray(ClassTag$.MODULE$.apply(CompletableFuture.class))).whenComplete((x$7, ex) -> {
                        if (ex != null) {
                            this.handleException$1((Throwable)ex, DataFlowPolicyWatcher.handleException$default$2$1());
                            return;
                        }
                        this.repopulateCache_$eq(false);
                        this.info((Function0<String> & Serializable)() -> "Cache populated with data flow policies for " + futures.size() + " environments, repopulateCacheCount=" + this.repopulateCacheCount());
                    })).join();
                }
                if (!this.repopulateCache()) {
                    this.prevEnvironmentsConsidered_$eq(currentEnvironments);
                }
            }
            catch (Throwable e) {
                this.handleException$1(e, DataFlowPolicyWatcher.handleException$default$2$1());
            }
            return;
        }
    }

    public void checkRepopulateDueToEnvironmentsChange() {
        if (!this.repopulateCache()) {
            scala.collection.immutable.Set<EnvironmentKey> currentEnvironments;
            scala.collection.immutable.Set<EnvironmentKey> set = currentEnvironments = this.getEnvironments();
            scala.collection.immutable.Set<EnvironmentKey> set2 = this.prevEnvironmentsConsidered();
            if (set == null ? set2 != null : !set.equals(set2)) {
                this.info((Function0<String> & Serializable)() -> "Environments loaded=" + currentEnvironments.size() + ", previousEnvironmentsLoaded=" + this.prevEnvironmentsConsidered().size());
                this.repopulateCache_$eq(true);
                return;
            }
            return;
        }
    }

    public void maybeRestartWatcher() {
        if (this.restartWatch()) {
            try {
                this.restartWatchCount().incrementAndGet();
                this.shutdownWatch();
                this.subscription_$eq(Subscription$SubscriptionFactory$.MODULE$.newDataFlowPolicySubscriptionBuilder(false).withFieldSelector(this.buildFieldSelector()).build());
                this.info((Function0<String> & Serializable)() -> "Starting watch with subscription=" + this.subscription().subscriptionId() + ", restartWatchCount=" + this.restartWatchCount());
                this.watch_$eq(this.regionalMetadataClient.get().watch(this.subscription(), RegionalMetadataClient$.MODULE$.newSimpleWatch((Function1<DataFlowPolicy, Object> & Serializable)dataFlowPolicy -> {
                    this.onPolicyChange(dataFlowPolicy);
                    return BoxedUnit.UNIT;
                }, (Function1<Throwable, BoxedUnit>)(Function1<Throwable, Object> & Serializable)throwable -> {
                    this.handleException$2(throwable);
                    return BoxedUnit.UNIT;
                })));
                this.restartWatch_$eq(false);
                this.info((Function0<String> & Serializable)() -> "Started watch with subscription=" + this.subscription().subscriptionId() + ", restartWatchCount=" + this.restartWatchCount());
            }
            catch (Throwable e) {
                this.handleException$2(e);
            }
            return;
        }
    }

    private void shutdownWatch() {
        if (this.watch() != null) {
            CoreUtils$.MODULE$.swallow(() -> this.watch().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.info((Function0<String> & Serializable)() -> "Closed watch with subscription=" + this.subscription().subscriptionId() + ", restartWatchCount=" + this.restartWatchCount());
            return;
        }
    }

    public void onPolicyChange(DataFlowPolicy dataFlowPolicy) {
        boolean existingValue = this.dataPolicyStore().getPolicy(dataFlowPolicy.environmentId());
        boolean newValue = dataFlowPolicy.envWideBoundary();
        this.dataPolicyStore().addPolicy(dataFlowPolicy.environmentId(), newValue);
        if (existingValue != newValue) {
            if (newValue) {
                this.info((Function0<String> & Serializable)() -> "Notifying listeners on opt-in for environmentId=" + dataFlowPolicy.environmentId());
                this.listeners().forEach(listener -> listener.onOptIn(dataFlowPolicy.environmentId()));
                return;
            }
            this.info((Function0<String> & Serializable)() -> "Notifying listeners on opt-out for environmentId=" + dataFlowPolicy.environmentId());
            this.listeners().forEach(listener -> listener.onOptOut(dataFlowPolicy.environmentId()));
            return;
        }
    }

    public java.util.Map<String, String> buildFieldSelector() {
        block1: {
            String string = this.multiTenantMetadata.get().dedicatedLogicalClusterId();
            String string2 = "";
            if (!(string == null ? string2 != null : !string.equals(string2))) break block1;
            LogicalClusterMetadata lkc = this.multiTenantMetadata.get().metadata(this.multiTenantMetadata.get().dedicatedLogicalClusterId());
            if (lkc != null) {
                return CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("metadata.environment"), lkc.environmentId())}))).asJava();
            }
            this.warn((Function0<String> & Serializable)() -> "Could not find LKC metadata for dedicated cluster=" + $this.multiTenantMetadata.get().dedicatedLogicalClusterId());
        }
        return Collections.emptyMap();
    }

    public static final /* synthetic */ boolean $anonfun$getEnvironments$2(EnvironmentKey e) {
        return e != null;
    }

    private final void handleException$1(Throwable e, String envId) {
        this.warn((Function0<String> & Serializable)() -> "Error while fetching data flow policy for environmentId=" + envId + ", will retry on next scheduler run, repopulateCacheCount=" + this.repopulateCacheCount(), (Function0<Throwable> & Serializable)() -> e);
        this.repopulateCache_$eq(true);
    }

    private static final String handleException$default$2$1() {
        return "";
    }

    private final void handleException$2(Throwable throwable) {
        this.watchFailureSensor().foreach((Function1<Sensor, Object> & Serializable)x$8 -> {
            x$8.record();
            return BoxedUnit.UNIT;
        });
        this.error((Function0<String> & Serializable)() -> "Error while watching with subscription=" + this.subscription().subscriptionId() + ", will restart watch on next schedule, restartWatchCount=" + this.restartWatchCount(), (Function0<Throwable> & Serializable)() -> throwable);
        this.restartWatch_$eq(true);
        this.repopulateCache_$eq(true);
    }

    public DataFlowPolicyWatcher(KafkaConfig brokerConfig, Metrics metrics, Option<MultiTenantMetadata> multiTenantMetadata, Option<RegionalMetadataClient> regionalMetadataClient) {
        this.brokerConfig = brokerConfig;
        this.metrics = metrics;
        this.multiTenantMetadata = multiTenantMetadata;
        this.regionalMetadataClient = regionalMetadataClient;
        Logging.$init$(this);
        this.listeners = ConcurrentHashMap.newKeySet();
        this.cacheUpdaterFuture = None$.MODULE$;
        this.kafkaScheduler = None$.MODULE$;
        this.restartWatch = true;
        this.repopulateCache = true;
        this.restartWatchCount = new AtomicInteger();
        this.repopulateCacheCount = new AtomicInteger();
        this.watchFailureSensor = None$.MODULE$;
        this.cachePopulateFailureSensor = None$.MODULE$;
        this.prevEnvironmentsConsidered = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
    }
}

