/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.IOException;
import java.io.Serializable;
import kafka.server.link.AclFilter;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.AclMigrationJsonValidator;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.SecurityUtils;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;

public final class AclJson$ {
    public static final AclJson$ MODULE$ = new AclJson$();
    private static final AclMigrationJsonValidator VALIDATOR = new AclMigrationJsonValidator();
    private static final ObjectMapper JSON_SERDE = new ObjectMapper();

    static {
        MODULE$.JSON_SERDE().configure(JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION, true);
        MODULE$.JSON_SERDE().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        MODULE$.JSON_SERDE().registerModule(DefaultScalaModule$.MODULE$);
    }

    public AclMigrationJsonValidator VALIDATOR() {
        return VALIDATOR;
    }

    public ObjectMapper JSON_SERDE() {
        return JSON_SERDE;
    }

    public ListBuffer<AclBindingFilter> toAclBindingFilters(AclFiltersJson json) {
        ListBuffer aclBindingFilterList = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        json.aclFilters().foreach((Function1<AclFilter, ListBuffer> & Serializable)aclFilter -> {
            ResourceType resourceType = SecurityUtils.resourceType(aclFilter.resourceFilter().resourceType());
            PatternType pattern = SecurityUtils.patternType(aclFilter.resourceFilter().patternType());
            AclOperation operation = SecurityUtils.operation(aclFilter.accessFilter().operation());
            AclPermissionType permission = SecurityUtils.permissionType(aclFilter.accessFilter().permissionType());
            String name = aclFilter.resourceFilter().name();
            String principal = aclFilter.accessFilter().principal();
            String host = aclFilter.accessFilter().host();
            ResourcePatternFilter resourcePatternFilter = new ResourcePatternFilter(resourceType, name, pattern);
            AccessControlEntryFilter accessControlEntryFilter = new AccessControlEntryFilter(principal, host, operation, permission, aclFilter.accessFilter().clusterLinkIds());
            AclBindingFilter aclBindingFilter = new AclBindingFilter(resourcePatternFilter, accessControlEntryFilter);
            return (ListBuffer)aclBindingFilterList.$plus$eq(aclBindingFilter);
        });
        return aclBindingFilterList;
    }

    public Option<AclFiltersJson> parse(String value) {
        Some<AclFiltersJson> some;
        if (value == null || value.trim().isEmpty()) {
            return Option$.MODULE$.empty();
        }
        try {
            ObjectMapper JSON_SERDE = new ObjectMapper();
            JSON_SERDE.configure(JsonParser.Feature.INCLUDE_SOURCE_IN_LOCATION, true);
            JSON_SERDE.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
            JSON_SERDE.registerModule(DefaultScalaModule$.MODULE$);
            AclFiltersJson aclJson = JSON_SERDE.readValue(value, AclFiltersJson.class);
            if (aclJson.aclFilters() == null) {
                throw new IllegalArgumentException("acl.filters cannot be the JSON null");
            }
            if (aclJson.aclFilters().isEmpty()) {
                throw new IllegalArgumentException("aclFilters field cannot be empty");
            }
            aclJson.aclFilters().foreach((Function1<AclFilter, Object> & Serializable)aclFilter -> {
                AclJson$.$anonfun$parse$1(aclFilter);
                return BoxedUnit.UNIT;
            });
            some = new Some<AclFiltersJson>(aclJson);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException ? true : (throwable2 instanceof JsonMappingException ? true : throwable2 instanceof JsonParseException)) {
                throw new IllegalArgumentException("Exception while parsing ACL JSON: " + throwable2);
            }
            throw throwable;
        }
        return some;
    }

    public static final /* synthetic */ void $anonfun$parse$1(AclFilter aclFilter) {
        String resourceType = aclFilter.resourceFilter().resourceType();
        if (resourceType == null) {
            throw new IllegalArgumentException("resourceType field may not be null.");
        }
        if (resourceType.isEmpty()) {
            throw new IllegalArgumentException("resourceType field may not be empty.");
        }
        ResourceType resourceType2 = SecurityUtils.resourceType(resourceType);
        ResourceType resourceType3 = ResourceType.UNKNOWN;
        if (!(resourceType2 != null ? !((Object)((Object)resourceType2)).equals((Object)resourceType3) : resourceType3 != null)) {
            throw new IllegalArgumentException("Unknown resourceType: " + resourceType);
        }
        String patternType = aclFilter.resourceFilter().patternType();
        if (patternType == null) {
            throw new IllegalArgumentException("patternType field may not be null.");
        }
        if (patternType.isEmpty()) {
            throw new IllegalArgumentException("patternType field may not be empty.");
        }
        PatternType patternType2 = SecurityUtils.patternType(patternType);
        PatternType patternType3 = PatternType.UNKNOWN;
        if (!(patternType2 != null ? !((Object)((Object)patternType2)).equals((Object)patternType3) : patternType3 != null)) {
            throw new IllegalArgumentException("Unknown patternType: " + patternType);
        }
        String permissionType = aclFilter.accessFilter().permissionType();
        if (permissionType == null) {
            throw new IllegalArgumentException("permissionType field may not be null.");
        }
        if (permissionType.isEmpty()) {
            throw new IllegalArgumentException("permissionType field may not be empty.");
        }
        AclPermissionType aclPermissionType = SecurityUtils.permissionType(permissionType);
        AclPermissionType aclPermissionType2 = AclPermissionType.UNKNOWN;
        if (!(aclPermissionType != null ? !((Object)((Object)aclPermissionType)).equals((Object)aclPermissionType2) : aclPermissionType2 != null)) {
            throw new IllegalArgumentException("Unknown permissionType: " + permissionType);
        }
        String operation = aclFilter.accessFilter().operation();
        if (operation == null) {
            throw new IllegalArgumentException("operation field may not be null.");
        }
        if (operation.isEmpty()) {
            throw new IllegalArgumentException("operation field may not be empty.");
        }
        AclOperation aclOperation = SecurityUtils.operation(operation);
        AclOperation aclOperation2 = AclOperation.UNKNOWN;
        if (!(aclOperation != null ? !((Object)((Object)aclOperation)).equals((Object)aclOperation2) : aclOperation2 != null)) {
            throw new IllegalArgumentException("Unknown operation: " + operation);
        }
        String principal = aclFilter.accessFilter().principal();
        Object object = principal != null ? SecurityUtils.parseKafkaPrincipal(principal) : BoxedUnit.UNIT;
        if (aclFilter.accessFilter().clusterLinkIds().isEmpty()) {
            throw new IllegalArgumentException("'clusterLinkIds' should not be empty, leave unspecified to migrate only local ACLs or specify link ids after verifying they do not form a cycle");
        }
    }

    private AclJson$() {
    }
}

