/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.time.Duration;
import java.util.ServiceLoader;
import kafka.server.link.AclBindingFilterTransformer;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkLocalAdmin;
import kafka.server.link.IdentityAclBindingFilterTransformer;
import org.apache.kafka.clients.ClientInterceptor;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class ClusterLinkManager$ {
    public static final ClusterLinkManager$ MODULE$ = new ClusterLinkManager$();
    private static final String LocalTenantPrefixProp = "cluster.link.local.tenant.prefix";
    private static final String LinkNameProp = "cluster.link.name";
    private static final String LinkMetricsModeProp = "cluster.link.metrics.mode";
    private static final String IsMultiTenantProp = "multi.tenant.enabled";
    private static final String migrateBootstrapOverrideTaskName = "MigrateBootstrapOverride";

    public Option<String> $lessinit$greater$default$8() {
        return None$.MODULE$;
    }

    public String LocalTenantPrefixProp() {
        return LocalTenantPrefixProp;
    }

    public String LinkNameProp() {
        return LinkNameProp;
    }

    public String LinkMetricsModeProp() {
        return LinkMetricsModeProp;
    }

    public String IsMultiTenantProp() {
        return IsMultiTenantProp;
    }

    public String migrateBootstrapOverrideTaskName() {
        return migrateBootstrapOverrideTaskName;
    }

    public ClientInterceptor prefixInterceptor(String localTenantPrefix, String clusterLinkPrefix, String linkName, ClusterLinkConfig.LinkMode linkModeForMetrics, Metrics metrics, boolean isMultiTenant, boolean clusterLinkPrefixConsumerGroup, boolean clusterLinkEnableMetricsReductionAdvanced, String ccloudIntranetHostSuffixes) {
        if (!linkName.startsWith(localTenantPrefix)) {
            throw new IllegalStateException("Tenant interceptor request for link '" + linkName + "' without prefix '" + localTenantPrefix + "''");
        }
        String unprefixedLinkName = linkName.substring(localTenantPrefix.length());
        java.util.Map configs = CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.LocalTenantPrefixProp()), localTenantPrefix), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.LinkNameProp()), unprefixedLinkName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.LinkMetricsModeProp()), linkModeForMetrics), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp()), clusterLinkPrefix), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ClusterLinkConfig$.MODULE$.ConsumerGroupPrefixEnableProp()), BoxesRunTime.boxToBoolean(clusterLinkPrefixConsumerGroup)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.IsMultiTenantProp()), BoxesRunTime.boxToBoolean(isMultiTenant)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("confluent.cluster.link.enable.metrics.reduction.advanced"), BoxesRunTime.boxToBoolean(clusterLinkEnableMetricsReductionAdvanced)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("confluent.ccloud.intranet.host.suffixes"), ccloudIntranetHostSuffixes)}))).asJava();
        if (isMultiTenant) {
            return (ClientInterceptor)CollectionConverters$.MODULE$.IterableHasAsScala(ServiceLoader.load(ClientInterceptor.class)).asScala().find((Function1<ClientInterceptor, Object> & Serializable)interceptor -> BoxesRunTime.boxToBoolean(ClusterLinkManager$.$anonfun$prefixInterceptor$1(configs, metrics, interceptor))).getOrElse((Function0<Nothing$> & Serializable)() -> {
                throw new InvalidClusterLinkException("Cluster link interceptor not found");
            });
        }
        Some<ClientInterceptor> interceptor2 = new Some<ClientInterceptor>((ClientInterceptor)Class.forName("io.confluent.kafka.link.ClusterLinkInterceptor").newInstance());
        interceptor2.foreach((Function1<ClientInterceptor, Object> & Serializable)x$1 -> {
            x$1.configure(configs);
            return BoxedUnit.UNIT;
        });
        interceptor2.foreach((Function1<ClientInterceptor, Object> & Serializable)x$2 -> {
            x$2.configureMetrics(metrics);
            return BoxedUnit.UNIT;
        });
        ClientInterceptor clientInterceptor = (ClientInterceptor)interceptor2.getOrElse((Function0<Nothing$> & Serializable)() -> {
            throw new InvalidClusterLinkException("Cluster link interceptor not found");
        });
        return clientInterceptor;
    }

    public int hashValue(String name, int max) {
        return Utils.toPositive(Utils.murmur2(name.getBytes())) % max;
    }

    public AclBindingFilterTransformer aclBindingFilterTransform(Option<String> tenantPrefix, boolean isMultiTenant) {
        if (isMultiTenant && tenantPrefix.isDefined()) {
            return (AclBindingFilterTransformer)CollectionConverters$.MODULE$.IterableHasAsScala(ServiceLoader.load(AclBindingFilterTransformer.class)).asScala().find((Function1<AclBindingFilterTransformer, Object> & Serializable)transformer -> BoxesRunTime.boxToBoolean(ClusterLinkManager$.$anonfun$aclBindingFilterTransform$1(tenantPrefix, transformer))).getOrElse((Function0<Nothing$> & Serializable)() -> {
                throw new InvalidClusterLinkException("AclBindingFilterTransformer implementation not found.");
            });
        }
        return new IdentityAclBindingFilterTransformer();
    }

    public <T> void runAndCloseAdmin(KafkaFuture<T> result, Function1<KafkaFuture<T>, BoxedUnit> cb, Option<ClusterLinkLocalAdmin> temporaryClient) {
        try {
            cb.apply(result);
        }
        finally {
            temporaryClient.foreach((Function1<ClusterLinkLocalAdmin, Object> & Serializable)x$5 -> {
                x$5.close(Duration.ZERO);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$prefixInterceptor$1(java.util.Map configs$1, Metrics metrics$1, ClientInterceptor interceptor) {
        boolean bl;
        try {
            interceptor.configure(configs$1);
            interceptor.configureMetrics(metrics$1);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$aclBindingFilterTransform$1(Option tenantPrefix$1, AclBindingFilterTransformer transformer) {
        boolean bl;
        try {
            transformer.configure((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.LocalTenantPrefixProp()), tenantPrefix$1.get())})));
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private ClusterLinkManager$() {
    }
}

