/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import kafka.server.link.FindCoordinatorResponseResult;
import kafka.utils.Logging;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.FindCoordinatorResponseData;
import org.apache.kafka.common.protocol.Errors;
import scala.Function0;
import scala.None$;
import scala.Some;

public final class ClusterLinkMetadataThread$ {
    public static final ClusterLinkMetadataThread$ MODULE$ = new ClusterLinkMetadataThread$();

    public FindCoordinatorResponseResult handleFindCoordinatorResponse(String linkName, Logging log, FindCoordinatorResponseData findCoordinatorResponse) {
        Errors topLevelError;
        Errors errors = topLevelError = Errors.forCode(findCoordinatorResponse.errorCode());
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null)) {
            Errors linkCoordinatorError;
            if (findCoordinatorResponse.coordinators().isEmpty()) {
                log.error((Function0<String> & Serializable)() -> "Failed to find a link coordinator for " + linkName);
                return new FindCoordinatorResponseResult(None$.MODULE$, false);
            }
            FindCoordinatorResponseData.Coordinator linkCoordinator = findCoordinatorResponse.coordinators().get(0);
            if (findCoordinatorResponse.coordinators().size() != 1) {
                log.error((Function0<String> & Serializable)() -> "Received two link coordinators " + findCoordinatorResponse.coordinators() + " for " + linkName + ". Using the first one " + linkCoordinator + ".");
            }
            Errors errors3 = linkCoordinatorError = Errors.forCode(linkCoordinator.errorCode());
            Errors errors4 = Errors.NONE;
            if (!(errors3 != null ? !((Object)((Object)errors3)).equals((Object)errors4) : errors4 != null)) {
                if (linkCoordinator.nodeId() != -1) {
                    Node coordinatorNode = new Node(linkCoordinator.nodeId(), linkCoordinator.host(), linkCoordinator.port());
                    return new FindCoordinatorResponseResult(new Some<Node>(coordinatorNode), false);
                }
                log.debug((Function0<String> & Serializable)() -> "Link coordinator node is not available yet for " + linkName + ".");
                return new FindCoordinatorResponseResult(None$.MODULE$, false);
            }
            Errors errors5 = linkCoordinatorError;
            Errors errors6 = Errors.INVALID_REQUEST;
            if (!(errors5 != null ? !((Object)((Object)errors5)).equals((Object)errors6) : errors6 != null)) {
                log.warn((Function0<String> & Serializable)() -> "Failed to find link coordinator for " + linkName + " due to coordinator level error " + linkCoordinatorError + ". Error message: " + linkCoordinator.errorMessage() + ".");
                return new FindCoordinatorResponseResult(None$.MODULE$, true);
            }
            log.error((Function0<String> & Serializable)() -> "Failed to find link coordinator for " + linkName + " due to coordinator level error " + linkCoordinatorError + ". Error message: " + linkCoordinator.errorMessage());
            return new FindCoordinatorResponseResult(None$.MODULE$, false);
        }
        log.error((Function0<String> & Serializable)() -> "Failed to find link coordinator for " + linkName + " due to top level error " + topLevelError + ". Error message: " + topLevelError.message());
        return new FindCoordinatorResponseResult(None$.MODULE$, false);
    }

    private ClusterLinkMetadataThread$() {
    }
}

