/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkCoordinatorEndpointResolver;
import kafka.server.link.ClusterLinkData;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.LinkCoordinatorManager;
import kafka.server.metadata.KRaftImageMetadataCache;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005)4AAC\u0006\u0001%!Aq\u0003\u0001B\u0001B\u0003%\u0001\u0004\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001e\u0011!\u0019\u0003A!A!\u0002\u0013!\u0003\"B\u0014\u0001\t\u0003A\u0003\"B\u0017\u0001\t\u0003r\u0003\"B\u001b\u0001\t\u00032\u0004\"\u0002\u001e\u0001\t\u0003Z\u0004\"\u0002!\u0001\t\u0003\n\u0005\"B$\u0001\t\u0003B%\u0001G&3\u0019&t7nQ8pe\u0012Lg.\u0019;pe6\u000bg.Y4fe*\u0011A\"D\u0001\u0005Y&t7N\u0003\u0002\u000f\u001f\u000511/\u001a:wKJT\u0011\u0001E\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0003\u0005\u0002\u0015+5\t1\"\u0003\u0002\u0017\u0017\t1B*\u001b8l\u0007>|'\u000fZ5oCR|'/T1oC\u001e,'/\u0001\u0007ce>\\WM]\"p]\u001aLw\r\u0005\u0002\u001a55\tQ\"\u0003\u0002\u001c\u001b\tY1*\u00194lC\u000e{gNZ5h\u00035iW\r^1eCR\f7)Y2iKB\u0011a$I\u0007\u0002?)\u0011\u0001%D\u0001\t[\u0016$\u0018\rZ1uC&\u0011!e\b\u0002\u0018\u0017J\u000bg\r^%nC\u001e,W*\u001a;bI\u0006$\u0018mQ1dQ\u0016\fq\u0004\\5oW\u000e{wN\u001d3j]\u0006$xN]#oIB|\u0017N\u001c;SKN|GN^3s!\t!R%\u0003\u0002'\u0017\t13\t\\;ti\u0016\u0014H*\u001b8l\u0007>|'\u000fZ5oCR|'/\u00128ea>Lg\u000e\u001e*fg>dg/\u001a:\u0002\rqJg.\u001b;?)\u0011I#f\u000b\u0017\u0011\u0005Q\u0001\u0001\"B\f\u0005\u0001\u0004A\u0002\"\u0002\u000f\u0005\u0001\u0004i\u0002\"B\u0012\u0005\u0001\u0004!\u0013\u0001G4fi:+X.T3uC\u0012\fG/\u0019)beRLG/[8ogV\tq\u0006\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014GA\u0002J]R\fqa\u001d;beR,\b\u000fF\u00018!\t\u0001\u0004(\u0003\u0002:c\t!QK\\5u\u0003)yg.\u00127fGRLwN\u001c\u000b\u0004oqr\u0004\"B\u001f\b\u0001\u0004y\u0013a\u00039beRLG/[8o\u0013\u0012DQaP\u0004A\u0002=\n1\u0002\\3bI\u0016\u0014X\t]8dQ\u0006iqN\u001c*fg&<g.\u0019;j_:$2a\u000e\"D\u0011\u0015i\u0004\u00021\u00010\u0011\u0015y\u0004\u00021\u0001E!\r\u0001TiL\u0005\u0003\rF\u0012aa\u00149uS>t\u0017a\u00047j].\u001cun\u001c:eS:\fGo\u001c:\u0015\u0007%+&\rE\u00021\u000b*\u0003\"aS*\u000e\u00031S!!\u0014(\u0002\r\r|W.\\8o\u0015\t\u0001rJ\u0003\u0002Q#\u00061\u0011\r]1dQ\u0016T\u0011AU\u0001\u0004_J<\u0017B\u0001+M\u0005\u0011qu\u000eZ3\t\u000bYK\u0001\u0019A,\u0002\u00111Lgn\u001b(b[\u0016\u0004\"\u0001W0\u000f\u0005ek\u0006C\u0001.2\u001b\u0005Y&B\u0001/\u0012\u0003\u0019a$o\\8u}%\u0011a,M\u0001\u0007!J,G-\u001a4\n\u0005\u0001\f'AB*ue&twM\u0003\u0002_c!)1-\u0003a\u0001I\u0006aA.[:uK:,'OT1nKB\u0011Q\r[\u0007\u0002M*\u0011q\rT\u0001\b]\u0016$xo\u001c:l\u0013\tIgM\u0001\u0007MSN$XM\\3s\u001d\u0006lW\r")
public class K2LinkCoordinatorManager
extends LinkCoordinatorManager {
    private final KafkaConfig brokerConfig;
    private final ClusterLinkCoordinatorEndpointResolver linkCoordinatorEndpointResolver;

    @Override
    public int getNumMetadataPartitions() {
        return Predef$.MODULE$.Integer2int(this.brokerConfig.clusterLinkMetadataTopicPartitions());
    }

    @Override
    public void startup() {
        this.initialized_$eq(true);
    }

    @Override
    public void onElection(int partitionId, int leaderEpoch) {
        boolean bl;
        Object object = this.lock();
        synchronized (object) {
            boolean bl2;
            if (!this.ownedPartitions().contains(BoxesRunTime.boxToInteger(partitionId))) {
                this.debug((Function0<String> & Serializable)() -> "Elected as link coordinator for links with metadata topic partition " + partitionId + " at epoch " + leaderEpoch);
                bl2 = this.ownedPartitions().add(BoxesRunTime.boxToInteger(partitionId));
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        boolean elected = bl;
        Object links = elected ? this.getClusterLinksForPartitionId(partitionId) : Predef$.MODULE$.Set().empty();
        this.metadataImageListeners().foreach(arg_0 -> K2LinkCoordinatorManager.$anonfun$onElection$2$adapted((Set)links, arg_0));
    }

    @Override
    public void onResignation(int partitionId, Option<Object> leaderEpoch) {
        boolean bl;
        Object object = this.lock();
        synchronized (object) {
            boolean bl2;
            if (this.ownedPartitions().contains(BoxesRunTime.boxToInteger(partitionId))) {
                this.debug((Function0<String> & Serializable)() -> "Resigned as link coordinator for links with metadata topic partition " + partitionId + " at epoch " + leaderEpoch);
                bl2 = this.ownedPartitions().remove(BoxesRunTime.boxToInteger(partitionId));
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        boolean resigned = bl;
        Object linkIds = resigned ? (Set)this.getClusterLinksForPartitionId(partitionId).map((Function1<ClusterLinkData, Uuid> & Serializable)x$2 -> x$2.linkId()) : Predef$.MODULE$.Set().empty();
        this.metadataImageListeners().foreach(arg_0 -> K2LinkCoordinatorManager.$anonfun$onResignation$3$adapted((Set)linkIds, arg_0));
    }

    @Override
    public Option<Node> linkCoordinator(String linkName, ListenerName listenerName) {
        return this.linkCoordinatorEndpointResolver.getPartitionEndpoint(this.linkNameToPartitionId(linkName), listenerName).get(this.brokerConfig.requestTimeoutMs(), TimeUnit.MILLISECONDS);
    }

    public K2LinkCoordinatorManager(KafkaConfig brokerConfig, KRaftImageMetadataCache metadataCache, ClusterLinkCoordinatorEndpointResolver linkCoordinatorEndpointResolver) {
        this.brokerConfig = brokerConfig;
        this.linkCoordinatorEndpointResolver = linkCoordinatorEndpointResolver;
        super(metadataCache);
    }

    public static final /* synthetic */ Object $anonfun$onElection$2$adapted(Set links$1, ClusterLinkFactory.LinkCoordinatorListener x$1) {
        x$1.onClusterLinkCoordinatorElection(links$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$onResignation$3$adapted(Set linkIds$1, ClusterLinkFactory.LinkCoordinatorListener x$3) {
        x$3.onClusterLinkCoordinatorResignation(linkIds$1);
        return BoxedUnit.UNIT;
    }
}

