/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.util.List;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.MirrorTopicConfigSyncRules$;
import org.apache.kafka.common.config.ConfigDef;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;

public final class TopicConfigSyncIncludeValidator$ {
    public static final TopicConfigSyncIncludeValidator$ MODULE$ = new TopicConfigSyncIncludeValidator$();
    private static final ConfigDef.Validator ConfigDefValidator = new ConfigDef.NonEmptyStringWithoutControlChars(){

        private /* synthetic */ void super$ensureValid(String name, Object value) {
            super.ensureValid(name, value);
        }

        public void ensureValid(String name, Object value) {
            List list = (List)value;
            list.forEach(str -> this.super$ensureValid(name, str));
        }
    };

    public ConfigDef.Validator ConfigDefValidator() {
        return ConfigDefValidator;
    }

    public Set<String> validate(List<String> value) {
        Set<String> topicConfigs = CollectionConverters$.MODULE$.ListHasAsScala(value).asScala().toSet();
        this.checkUnknownTopicConfigs(topicConfigs);
        this.checkAlwaysConfigs(topicConfigs);
        this.checkIndependentConfigs(topicConfigs);
        return topicConfigs;
    }

    private void checkUnknownTopicConfigs(Set<String> configs) {
        Set diff = (Set)configs.$minus$minus(MirrorTopicConfigSyncRules$.MODULE$.AllConfigs());
        if (diff.nonEmpty()) {
            throw new IllegalArgumentException("Invalid topic configs specified in " + ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp() + ": " + diff.mkString(",") + ". Please use the common topic config name.");
        }
    }

    private void checkAlwaysConfigs(Set<String> configs) {
        Set diff = (Set)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$minus$minus(configs);
        if (diff.nonEmpty()) {
            throw new IllegalArgumentException("To make cluster linking function properly, " + ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp() + " must include these topic configs: " + MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().mkString(",") + " \nThese topic configs are missing: " + diff.mkString(","));
        }
    }

    private void checkIndependentConfigs(Set<String> configs) {
        Set inter = (Set)configs.intersect(MirrorTopicConfigSyncRules$.MODULE$.IndependentConfigs());
        if (inter.nonEmpty()) {
            throw new IllegalArgumentException("To make cluster linking function properly, " + ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp() + " cannot include these topic configs: " + MirrorTopicConfigSyncRules$.MODULE$.IndependentConfigs().mkString(",") + " \nRemove these topic configs: " + inter.mkString(","));
        }
    }

    private TopicConfigSyncIncludeValidator$() {
    }
}

