/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ConfluentKeyValueStreamsIngesterManager;
import org.apache.kafka.raft.BatchReader;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.snapshot.SnapshotReader;
import org.slf4j.Logger;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001B\t\u0013\u0001eA\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005u!A\u0011\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003D\u0011!9\u0005A!b\u0001\n\u0003A\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u000bE\u0003A\u0011\u0001*\t\u000fa\u0003!\u0019!C\u00013\"1\u0001\r\u0001Q\u0001\niCQ!\u0019\u0001\u0005B\tDQa\u001b\u0001\u0005B1Dq\u0001\u001e\u0001C\u0002\u0013\u0005Q\u000f\u0003\u0004z\u0001\u0001\u0006IA\u001e\u0005\bu\u0002\u0011\r\u0011\"\u0003|\u0011\u001d\t)\u0001\u0001Q\u0001\nqDq!a\u0002\u0001\t\u0003\nIAA\u0010D_:4G.^3oi&sw-Z:uKJ,\u0006\u000fZ1uK2K7\u000f^3oKJT!a\u0005\u000b\u0002\u00115,G/\u00193bi\u0006T!!\u0006\f\u0002\rM,'O^3s\u0015\u00059\u0012!B6bM.\f7\u0001A\n\u0004\u0001i\u0011\u0003CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0011a\u0017M\\4\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007\rr\u0013G\u0004\u0002%Y5\tQE\u0003\u0002'O\u0005!!/\u00194u\u0015\t9\u0002F\u0003\u0002*U\u00051\u0011\r]1dQ\u0016T\u0011aK\u0001\u0004_J<\u0017BA\u0017&\u0003)\u0011\u0016M\u001a;DY&,g\u000e^\u0005\u0003_A\u0012\u0001\u0002T5ti\u0016tWM\u001d\u0006\u0003[\u0015\u0002\"A\r\u001c\u000e\u0003MR!\u0001N\u001b\u0002\r\r|W.\\8o\u0015\t)r%\u0003\u00028g\t!\u0012\t]5NKN\u001c\u0018mZ3B]\u00124VM]:j_:\fq\"\u001b8hKN$XM]'b]\u0006<WM]\u000b\u0002uA\u00111HP\u0007\u0002y)\u0011QhJ\u0001\u000bG>tGO]8mY\u0016\u0014\u0018BA =\u0005\u001d\u001auN\u001c4mk\u0016tGoS3z-\u0006dW/Z*ue\u0016\fWn]%oO\u0016\u001cH/\u001a:NC:\fw-\u001a:\u0002!%tw-Z:uKJl\u0015M\\1hKJ\u0004\u0013A\u00028pI\u0016LE-F\u0001D!\tYB)\u0003\u0002F9\t9\u0011J\u001c;fO\u0016\u0014\u0018a\u00028pI\u0016LE\rI\u0001\u0005i&lW-F\u0001J!\tQe*D\u0001L\u0015\taU*A\u0003vi&d7O\u0003\u00025O%\u0011qj\u0013\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005'V3v\u000b\u0005\u0002U\u00015\t!\u0003C\u00039\u000f\u0001\u0007!\bC\u0003B\u000f\u0001\u00071\tC\u0003H\u000f\u0001\u0007\u0011*A\u0010J\u001d\u001e+5\u000bV#S?N#\u0016I\u0015+`)&kUiX(V)~k\u0015JT+U\u000bN+\u0012A\u0017\t\u00037zk\u0011\u0001\u0018\u0006\u0002;\u0006)1oY1mC&\u0011q\f\u0018\u0002\u0004\u0013:$\u0018\u0001I%O\u000f\u0016\u001bF+\u0012*`'R\u000b%\u000bV0U\u00136+ulT+U?6Ke*\u0016+F'\u0002\nA\u0002[1oI2,7i\\7nSR$\"a\u00194\u0011\u0005m#\u0017BA3]\u0005\u0011)f.\u001b;\t\u000b\u001dT\u0001\u0019\u00015\u0002\rI,\u0017\rZ3s!\r!\u0013.M\u0005\u0003U\u0016\u00121BQ1uG\"\u0014V-\u00193fe\u0006\u0011\u0002.\u00198eY\u0016du.\u00193T]\u0006\u00048\u000f[8u)\t\u0019W\u000eC\u0003h\u0017\u0001\u0007a\u000eE\u0002peFj\u0011\u0001\u001d\u0006\u0003c\u001e\n\u0001b\u001d8baNDw\u000e^\u0005\u0003gB\u0014ab\u00158baNDw\u000e\u001e*fC\u0012,'/\u0001\u0006m_\u001e\u001cuN\u001c;fqR,\u0012A\u001e\t\u0003\u0015^L!\u0001_&\u0003\u00151{wmQ8oi\u0016DH/A\u0006m_\u001e\u001cuN\u001c;fqR\u0004\u0013a\u00017pOV\tA\u0010E\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007f*\nQa\u001d7gi)L1!a\u0001\u007f\u0005\u0019aunZ4fe\u0006!An\\4!\u0003IA\u0017M\u001c3mK2+\u0017\rZ3s\u0007\"\fgnZ3\u0015\u0007\r\fY\u0001C\u0004\u0002\u000eA\u0001\r!a\u0004\u0002\r1,\u0017\rZ3s!\r!\u0013\u0011C\u0005\u0004\u0003')#A\u0004'fC\u0012,'/\u00118e\u000bB|7\r\u001b")
public class ConfluentIngesterUpdateListener
implements RaftClient.Listener<ApiMessageAndVersion> {
    private final ConfluentKeyValueStreamsIngesterManager ingesterManager;
    private final Integer nodeId;
    private final Time time;
    private final int INGESTER_START_TIME_OUT_MINUTES;
    private final LogContext logContext;
    private final Logger log;

    @Override
    public void beginShutdown() {
        RaftClient.Listener.super.beginShutdown();
    }

    public ConfluentKeyValueStreamsIngesterManager ingesterManager() {
        return this.ingesterManager;
    }

    public Integer nodeId() {
        return this.nodeId;
    }

    public Time time() {
        return this.time;
    }

    public int INGESTER_START_TIME_OUT_MINUTES() {
        return this.INGESTER_START_TIME_OUT_MINUTES;
    }

    @Override
    public void handleCommit(BatchReader<ApiMessageAndVersion> reader) {
        reader.close();
    }

    @Override
    public void handleLoadSnapshot(SnapshotReader<ApiMessageAndVersion> reader) {
        reader.close();
    }

    public LogContext logContext() {
        return this.logContext;
    }

    private Logger log() {
        return this.log;
    }

    @Override
    public void handleLeaderChange(LeaderAndEpoch leader) {
        if (leader.isLeader(Predef$.MODULE$.Integer2int(this.nodeId()))) {
            this.log().info("leader start to daemon thread, leader: " + this.nodeId());
            CompletionStage<Void> workerFuture = this.ingesterManager().startWorker();
            ((CompletableFuture)workerFuture).orTimeout(this.INGESTER_START_TIME_OUT_MINUTES(), TimeUnit.MINUTES);
            workerFuture = ((CompletableFuture)workerFuture).exceptionally(ex -> {
                throw new RuntimeException("ingester worker did not complete within " + this.INGESTER_START_TIME_OUT_MINUTES() + " minutes", (Throwable)ex);
            });
            ((CompletableFuture)workerFuture).whenComplete((unused, throwable) -> {
                if (throwable == null) {
                    this.log().info("ingester worker started successfully ");
                    return;
                }
                this.log().error("ingester worker failed: " + throwable.getMessage());
            });
            return;
        }
        this.log().info("not the current leader, follower pause daemon thread, leader: " + leader.leaderId());
        this.ingesterManager().shutDownWorker();
    }

    public ConfluentIngesterUpdateListener(ConfluentKeyValueStreamsIngesterManager ingesterManager, Integer nodeId, Time time) {
        this.ingesterManager = ingesterManager;
        this.nodeId = nodeId;
        this.time = time;
        this.INGESTER_START_TIME_OUT_MINUTES = 10;
        this.logContext = new LogContext("[ConfluentKeyValueStreams id=" + nodeId + "]");
        this.log = this.logContext().logger(ConfluentIngesterUpdateListener.class);
    }
}

