/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import io.confluent.k2.kafka.image.publisher.K2MetadataPublisher;
import io.confluent.k2.kafka.image.publisher.K2TopicsImageAndVersion;
import io.confluent.kafka.image.publisher.K2KRaftMetadataPublisherHelper;
import java.io.Serializable;
import kafka.server.KafkaConfig;
import kafka.server.metadata.ClientQuotaMetadataManager;
import kafka.server.metadata.K2KRaftClientQuotaClusterDescriber;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.image.ClientQuotasDelta;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.jdk.javaapi.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005=c\u0001B\u0007\u000f\u0001UA\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"A1\f\u0001B\u0001B\u0003%A\f\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003i\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u001d\u0019\bA1A\u0005\nQDa\u0001\u001f\u0001!\u0002\u0013)\b\"B=\u0001\t\u0003R\b\"B>\u0001\t\u0003b\bBB>\u0001\t\u0003\tI\u0002C\u0004\u0002 \u0001!\t%!\t\t\u000f\u00055\u0002\u0001\"\u0011\u00020\tYB)\u001f8b[&\u001c7\t\\5f]R\fVo\u001c;b!V\u0014G.[:iKJT!a\u0004\t\u0002\u00115,G/\u00193bi\u0006T!!\u0005\n\u0002\rM,'O^3s\u0015\u0005\u0019\u0012!B6bM.\f7\u0001A\n\u0007\u0001Ya\"e\f\u001f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\r\u0005s\u0017PU3g!\ti\u0002%D\u0001\u001f\u0015\ty\"#A\u0003vi&d7/\u0003\u0002\"=\t9Aj\\4hS:<\u0007CA\u0012.\u001b\u0005!#BA\u0013'\u0003%\u0001XO\u00197jg\",'O\u0003\u0002(Q\u0005)\u0011.\\1hK*\u00111#\u000b\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014x-\u0003\u0002/I\t\tR*\u001a;bI\u0006$\u0018\rU;cY&\u001c\b.\u001a:\u0011\u0005ART\"A\u0019\u000b\u0005\u0015\u0012$BA\u00144\u0015\t\u0019BG\u0003\u00026m\u0005\u00111N\r\u0006\u0003oa\n\u0011bY8oM2,XM\u001c;\u000b\u0003e\n!![8\n\u0005m\n$aE&3\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u0014\b\u0003B\u001fE\u000f.s!A\u0010\"\u000e\u0003}R!!\n!\u000b\u0005\u001d\n%BA\n7\u0013\t\u0019u(\u0001\u0010Le-\u0013\u0016M\u001a;NKR\fG-\u0019;b!V\u0014G.[:iKJDU\r\u001c9fe&\u0011QI\u0012\u0002\t\u0007\u0006dGNY1dW*\u00111i\u0010\t\u0003\u0011&k\u0011AJ\u0005\u0003\u0015\u001a\u0012Q\"T3uC\u0012\fG/Y%nC\u001e,\u0007C\u0001%M\u0013\tieEA\u0007NKR\fG-\u0019;b\t\u0016dG/Y\u0001\u0005G>tg\r\u0005\u0002Q#6\t\u0001#\u0003\u0002S!\tY1*\u00194lC\u000e{gNZ5h\u000311\u0017-\u001e7u\u0011\u0006tG\r\\3s!\t)\u0016,D\u0001W\u0015\t9\u0006,A\u0003gCVdGO\u0003\u0002\u0012Q%\u0011!L\u0016\u0002\r\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\t]>$W\rV=qKB\u0011Q\f\u001a\b\u0003=\n\u0004\"a\u0018\r\u000e\u0003\u0001T!!\u0019\u000b\u0002\rq\u0012xn\u001c;?\u0013\t\u0019\u0007$\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u001a\u0014aa\u0015;sS:<'BA2\u0019\u0003i\u0019G.[3oiF+x\u000e^1NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s!\tI'.D\u0001\u000f\u0013\tYgB\u0001\u000eDY&,g\u000e^)v_R\fW*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u0006]>\u0004\u0018O\u001d\t\u0003S\u0002AQAT\u0003A\u0002=CQaU\u0003A\u0002QCQaW\u0003A\u0002qCQaZ\u0003A\u0002!\fad\u001b\u001aL%\u00064G/T3uC\u0012\fG/\u0019)vE2L7\u000f[3s\u0011\u0016d\u0007/\u001a:\u0016\u0003U\u0004BA\u0010<H\u0017&\u0011qo\u0010\u0002\u001f\u0017JZ%+\u00194u\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u0014\b*\u001a7qKJ\fqd\u001b\u001aL%\u00064G/T3uC\u0012\fG/\u0019)vE2L7\u000f[3s\u0011\u0016d\u0007/\u001a:!\u0003\u0011q\u0017-\\3\u0015\u0003q\u000b\u0001c\u001c8NKR\fG-\u0019;b+B$\u0017\r^3\u0015\u000fu\f\t!!\u0002\u0002\nA\u0011qC`\u0005\u0003\u007fb\u0011A!\u00168ji\"1\u00111A\u0005A\u0002-\u000bQ\u0001Z3mi\u0006Da!a\u0002\n\u0001\u00049\u0015\u0001\u00038fo&k\u0017mZ3\t\u000f\u0005-\u0011\u00021\u0001\u0002\u000e\u0005AQ.\u00198jM\u0016\u001cH\u000f\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019BJ\u0001\u0007Y>\fG-\u001a:\n\t\u0005]\u0011\u0011\u0003\u0002\u000f\u0019>\fG-\u001a:NC:Lg-Z:u)\u0015i\u00181DA\u000f\u0011\u0019\t\u0019A\u0003a\u0001\u0017\"1\u0011q\u0001\u0006A\u0002\u001d\u000b!c\u001c8Le5+G/\u00193bi\u0006,\u0006\u000fZ1uKR\u0019Q0a\t\t\u000f\u0005\u00152\u00021\u0001\u0002(\u0005q2-\u001e:sK:$8J\r+pa&\u001c7/S7bO\u0016\fe\u000e\u001a,feNLwN\u001c\t\u0004a\u0005%\u0012bAA\u0016c\t92J\r+pa&\u001c7/S7bO\u0016\fe\u000e\u001a,feNLwN\\\u0001\nI>\u0004VO\u00197jg\"$r\"`A\u0019\u0003k\tI$a\u000f\u0002@\u0005\u0005\u00131\n\u0005\u0007\u0003ga\u0001\u0019A$\u0002#\r,(O]3oi.\u0013\u0016M\u001a;J[\u0006<W\r\u0003\u0004\u000281\u0001\raS\u0001\u0012GV\u0014(/\u001a8u\u0017J\u000bg\r\u001e#fYR\f\u0007bBA\u0006\u0019\u0001\u0007\u0011Q\u0002\u0005\b\u0003{a\u0001\u0019AA\u0014\u0003m\u0001(/\u001a<LeQ{\u0007/[2t\u00136\fw-Z!oIZ+'o]5p]\"9\u0011Q\u0005\u0007A\u0002\u0005\u001d\u0002bBA\"\u0019\u0001\u0007\u0011QI\u0001\u0011IV,Gk\\&SC\u001a$8\t[1oO\u0016\u00042aFA$\u0013\r\tI\u0005\u0007\u0002\b\u0005>|G.Z1o\u0011\u0019\ti\u0005\u0004a\u00019\u0006YA-Z:de&\u0004H/[8o\u0001")
public class DynamicClientQuotaPublisher
implements Logging,
MetadataPublisher,
K2MetadataPublisher,
K2KRaftMetadataPublisherHelper.Callback<MetadataImage, MetadataDelta> {
    private final KafkaConfig conf;
    private final FaultHandler faultHandler;
    private final String nodeType;
    private final ClientQuotaMetadataManager clientQuotaMetadataManager;
    private final K2KRaftMetadataPublisherHelper<MetadataImage, MetadataDelta> k2KRaftMetadataPublisherHelper;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public void onControllerChange(LeaderAndEpoch newLeaderAndEpoch) {
        MetadataPublisher.super.onControllerChange(newLeaderAndEpoch);
    }

    @Override
    public void close() throws Exception {
        MetadataPublisher.super.close();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        DynamicClientQuotaPublisher dynamicClientQuotaPublisher = this;
        synchronized (dynamicClientQuotaPublisher) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private K2KRaftMetadataPublisherHelper<MetadataImage, MetadataDelta> k2KRaftMetadataPublisherHelper() {
        return this.k2KRaftMetadataPublisherHelper;
    }

    @Override
    public String name() {
        return "DynamicClientQuotaPublisher " + this.nodeType + " id=" + this.conf.nodeId();
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        this.onMetadataUpdate(delta, newImage);
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage) {
        this.k2KRaftMetadataPublisherHelper().maybePublishKRaftImageAndDelta(newImage, delta, null);
        try {
            Option$.MODULE$.apply(delta.clientQuotasDelta()).foreach((Function1<ClientQuotasDelta, Object> & Serializable)clientQuotasDelta -> {
                this.clientQuotaMetadataManager.update(clientQuotasDelta);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            this.faultHandler.handleFault("Uncaught exception while publishing dynamic client quota delta from KRaft MetadataDelta up " + newImage.highestOffsetAndEpoch().offset(), t);
        }
    }

    @Override
    public void onK2MetadataUpdate(K2TopicsImageAndVersion currentK2TopicsImageAndVersion) {
        this.k2KRaftMetadataPublisherHelper().maybePublishK2ImageAndVersion(currentK2TopicsImageAndVersion);
    }

    @Override
    public void doPublish(MetadataImage currentKRaftImage, MetadataDelta currentKRaftDelta, LoaderManifest manifest, K2TopicsImageAndVersion prevK2TopicsImageAndVersion, K2TopicsImageAndVersion currentK2TopicsImageAndVersion, boolean dueToKRaftChange, String description) {
        try {
            OptionConverters$.MODULE$.toScala(this.clientQuotaMetadataManager.quotaManagers().clientQuotaCallbackPlugin()).foreach((Function1<Plugin, Object> & Serializable)quotaCallback -> {
                if ($this.conf.isKRaftIsolatedControllerMode()) {
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Skipping invocation of client quotas callback for metadata change on isolated controller node");
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Invoking client quotas callback for metadata change");
                    v0 = BoxedUnit.UNIT;
                } else {
                    v0 = BoxedUnit.UNIT;
                }
                return BoxesRunTime.boxToBoolean(((ClientQuotaCallback)quotaCallback.get()).updateClusterMetadata(new K2KRaftClientQuotaClusterDescriber(currentKRaftImage.topics(), currentK2TopicsImageAndVersion.image())));
            });
        }
        catch (Throwable t) {
            this.faultHandler.handleFault("Uncaught exception while publishing dynamic client quota changes to client quota callback from " + description, t);
        }
    }

    public DynamicClientQuotaPublisher(KafkaConfig conf, FaultHandler faultHandler, String nodeType, ClientQuotaMetadataManager clientQuotaMetadataManager) {
        this.conf = conf;
        this.faultHandler = faultHandler;
        this.nodeType = nodeType;
        this.clientQuotaMetadataManager = clientQuotaMetadataManager;
        Logging.$init$(this);
        this.k2KRaftMetadataPublisherHelper = new K2KRaftMetadataPublisherHelper<MetadataImage, MetadataDelta>(MetadataImage.EMPTY, () -> new MetadataDelta(MetadataImage.EMPTY, x$1 -> null, new MetadataEncryptorFactory()), (x$2, delta) -> Predef$.MODULE$.boolean2Boolean(delta.topicsDelta() != null && !delta.topicsDelta().changedTopics().isEmpty()), (image, x$3) -> "KRaft MetadataDelta up to " + image.highestOffsetAndEpoch().offset(), (prevK2, currentK2) -> Predef$.MODULE$.boolean2Boolean(currentK2.assignmentsVersion() != prevK2.assignmentsVersion()), this);
        this.logIdent_$eq("[" + this.name() + "] ");
    }
}

