/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import io.confluent.k2.kafka.K2MetadataUtil;
import io.confluent.k2.kafka.K2Node;
import io.confluent.k2.kafka.affinity.AffinitySelector;
import io.confluent.k2.kafka.affinity.ClientContext;
import io.confluent.k2.kafka.affinity.ClientMetadataUtil;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kafka.server.metadata.K2MetadataCache;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class K2MetadataCache$ {
    public static final K2MetadataCache$ MODULE$ = new K2MetadataCache$();
    private static final ClientContext EMPTY_CLIENT_CONTEXT = new ClientContext(){

        public Optional<TenantMetadata> tenantMetadata() {
            return Optional.empty();
        }

        public Optional<String> zone() {
            return Optional.empty();
        }
    };

    public List<K2Node> availableBrokers(List<K2Node> nodes, Map<K2Node, K2Node.NodeStatus> nodeStatus) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(nodes).asScala().filter((Function1<K2Node, Object> & Serializable)node -> BoxesRunTime.boxToBoolean(K2MetadataCache$.$anonfun$availableBrokers$1(nodeStatus, node)))).toList()).asJava();
    }

    public List<Integer> assignedBrokerIds(List<K2Node> assignment) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(assignment).asScala().map((Function1<K2Node, Integer> & Serializable)k2Node -> MODULE$.toBrokerId((K2Node)k2Node))).toList()).asJava();
    }

    public Integer toBrokerId(K2Node k2Node) {
        return Predef$.MODULE$.int2Integer(Integer.parseInt(k2Node.id()));
    }

    public List<Integer> toBrokerIds(List<K2Node> k2Nodes) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(k2Nodes).asScala().map((Function1<K2Node, Integer> & Serializable)k2Node -> MODULE$.toBrokerId((K2Node)k2Node))).toList()).asJava();
    }

    public ClientContext EMPTY_CLIENT_CONTEXT() {
        return EMPTY_CLIENT_CONTEXT;
    }

    public K2MetadataCache.ReplicaSetMetadata computeReplicaSetMetadataWithAffinity(TopicIdPartition partition, List<K2Node> assignment, List<K2Node> availableFallbackNodes, Map<K2Node, K2Node.NodeStatus> nodeStatus, ClientContext clientContext, AffinitySelector affinitySelector) {
        List<Integer> brokerAssignment = this.assignedBrokerIds(assignment);
        List<K2Node> available = this.availableBrokers(assignment, nodeStatus);
        if (!available.isEmpty()) {
            Option<K2Node> leader = OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(affinitySelector.selectNode(clientContext, available)));
            return new K2MetadataCache.ReplicaSetMetadata(Predef$.MODULE$.Integer2int(this.toBrokerId((K2Node)leader.getOrElse((Function0<K2Node> & Serializable)() -> (K2Node)available.get(0)))), brokerAssignment, this.toBrokerIds(available));
        }
        return this.handleFallback(partition, brokerAssignment, available, availableFallbackNodes);
    }

    public K2MetadataCache.ReplicaSetMetadata handleFallback(TopicIdPartition partition, List<Integer> brokerAssignment, List<K2Node> available, List<K2Node> availableFallbackNodes) {
        if (availableFallbackNodes.isEmpty()) {
            return new K2MetadataCache.ReplicaSetMetadata(-1, brokerAssignment, this.toBrokerIds(available));
        }
        int fallbackLeaderId = K2MetadataUtil.hrwHashPartitionLeader(partition, this.toBrokerIds(availableFallbackNodes));
        $colon$colon<Nothing$> availableFallback = new $colon$colon<Nothing$>((Nothing$)((Object)BoxesRunTime.boxToInteger(fallbackLeaderId)), Nil$.MODULE$);
        Buffer brokerAssignmentWithFallback = (Buffer)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(brokerAssignment).asScala().$plus$plus(availableFallback)).sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        return new K2MetadataCache.ReplicaSetMetadata(fallbackLeaderId, CollectionConverters$.MODULE$.BufferHasAsJava(brokerAssignmentWithFallback).asJava(), CollectionConverters$.MODULE$.SeqHasAsJava(availableFallback).asJava());
    }

    public ClientContext extractClientContext(RequestContext requestContext, Option<ClientMetadata> clientMetadata) {
        Some some;
        ClientMetadata metadata;
        Optional<Object> optional;
        KafkaPrincipal kafkaPrincipal = requestContext.principal;
        if (kafkaPrincipal instanceof MultiTenantPrincipal) {
            MultiTenantPrincipal multiTenantPrincipal = (MultiTenantPrincipal)kafkaPrincipal;
            optional = Optional.of(multiTenantPrincipal.tenantMetadata());
        } else {
            optional = Optional.empty();
        }
        Optional tenantMetadata = optional;
        Option<ClientMetadata> option = clientMetadata;
        Optional<String> zone = option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((metadata = (ClientMetadata)(some = (Some)option).value()).rackId())) ? Optional.of(metadata.rackId()) : ClientMetadataUtil.parseZone(requestContext.clientId());
        return new ClientContext(tenantMetadata, (Optional)zone){};
    }

    public static final /* synthetic */ boolean $anonfun$availableBrokers$1(Map nodeStatus$1, K2Node node) {
        return ((Object)((Object)K2Node.NodeStatus.ONLINE)).equals(nodeStatus$1.get(node));
    }

    private K2MetadataCache$() {
    }
}

