/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kafka.server.metadata.KRaftImageMetadataCache;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.metadata.placement.UsableBroker;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.immutable.ImmutableMap;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0005\u0011]b\u0001B\u001f?\u0001\u0015C\u0001B\u0015\u0001\u0003\u0006\u0004%\ta\u0015\u0005\t5\u0002\u0011\t\u0011)A\u0005)\"A1\f\u0001BC\u0002\u0013\u0005A\f\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003^\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u001d9\b\u00011A\u0005\naD\u0001b \u0001A\u0002\u0013%\u0011\u0011\u0001\u0005\b\u0003\u001b\u0001\u0001\u0015)\u0003z\u0011\u001d\t9\u0002\u0001C\u0005\u00033Aq!!\u0015\u0001\t\u0003\t\u0019\u0006C\u0004\u0002V\u0001!I!a\u0016\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\"9\u0011\u0011\u001e\u0001\u0005\n\u0005-\bbBA\u0000\u0001\u0011%!\u0011\u0001\u0005\b\u0005#\u0001A\u0011\u0002B\n\u0011\u001d\u0011I\u0002\u0001C\u0005\u00057AqAa\f\u0001\t\u0003\u0012\t\u0004C\u0005\u0003L\u0001\t\n\u0011\"\u0001\u0003N!I!1\r\u0001\u0012\u0002\u0013\u0005!Q\n\u0005\b\u0005K\u0002A\u0011\tB4\u0011\u001d\u0011\u0019\b\u0001C!\u0005kBqA!'\u0001\t\u0003\u0012Y\nC\u0004\u0003f\u0001!\tEa*\t\u000f\t%\u0006\u0001\"\u0011\u0003,\"9!Q\u0017\u0001\u0005B\t]\u0006b\u0002B_\u0001\u0011\u0005#q\u0018\u0005\b\u0005\u0017\u0004A\u0011\tBg\u0011\u001d\u0011\t\u000e\u0001C!\u0005'DqAa6\u0001\t\u0003\u0012I\u000eC\u0004\u0003^\u0002!IAa8\t\u000f\tu\u0007\u0001\"\u0001\u0003r\"9!1\u001f\u0001\u0005B\tU\bb\u0002B\u007f\u0001\u0011\u0005#q \u0005\b\u0007\u0007\u0001A\u0011IB\u0003\u0011\u001d\u0019Y\u0001\u0001C!\u0007\u001bAqa!\u0005\u0001\t\u0003\u0019\u0019\u0002C\u0004\u0004&\u0001!\taa\n\t\u000f\rM\u0002\u0001\"\u0001\u00046!911\b\u0001\u0005B\ru\u0002bBB'\u0001\u0011\u00053q\n\u0005\b\u0007+\u0002A\u0011IB,\u0011\u001d\u0019i\u0006\u0001C!\u0007?Bqaa\u0019\u0001\t\u0003\u001a)\u0007C\u0004\u0004n\u0001!\tea\u001c\t\u000f\re\u0004\u0001\"\u0001\u0004|!91\u0011\u0012\u0001\u0005B\r-\u0005bBBG\u0001\u0011%1q\u0012\u0005\b\u0007'\u0003A\u0011IBK\u0011\u001d\u0019\t\u000b\u0001C!\u0007GCqa!)\u0001\t\u0003\u001a9\u000bC\u0004\u0004,\u0002!\te!,\t\u000f\rM\u0006\u0001\"\u0001\u0002T!91Q\u0017\u0001\u0005B\r]\u0006bBBg\u0001\u0011\u00053q\u001a\u0005\b\u0007C\u0004A\u0011IBr\u0011\u001d\u0019\u0019\u0010\u0001C!\u0007kDqa!@\u0001\t\u0003\u001ay\u0010C\u0004\u0005\b\u0001!\t\u0005\"\u0003\t\u000f\u00115\u0001\u0001\"\u0011\u0005\u0010!9Aq\u0005\u0001\u0005\u0002\u0011%\"AE&SC\u001a$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016T!a\u0010!\u0002\u00115,G/\u00193bi\u0006T!!\u0011\"\u0002\rM,'O^3s\u0015\u0005\u0019\u0015!B6bM.\f7\u0001A\n\u0004\u0001\u0019s\u0005CA$M\u001b\u0005A%BA%K\u0003\u0011a\u0017M\\4\u000b\u0003-\u000bAA[1wC&\u0011Q\n\u0013\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005=\u0003V\"\u0001 \n\u0005Es$aF&SC\u001a$\u0018*\\1hK6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0003!\u0011'o\\6fe&#W#\u0001+\u0011\u0005UCV\"\u0001,\u000b\u0003]\u000bQa]2bY\u0006L!!\u0017,\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005!2N]1giZ+'o]5p]N+\b\u000f\u001d7jKJ,\u0012!\u0018\t\u0004=\u000e,W\"A0\u000b\u0005\u0001\f\u0017\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0005\tT\u0015\u0001B;uS2L!\u0001Z0\u0003\u0011M+\b\u000f\u001d7jKJ\u0004\"AZ8\u000e\u0003\u001dT!\u0001[5\u0002\r\r|W.\\8o\u0015\t\t%N\u0003\u0002DW*\u0011A.\\\u0001\u0007CB\f7\r[3\u000b\u00039\f1a\u001c:h\u0013\t\u0001xM\u0001\u0007L%\u00064GOV3sg&|g.A\u000ble\u00064GOV3sg&|gnU;qa2LWM\u001d\u0011\u0002\rqJg.\u001b;?)\r!XO\u001e\t\u0003\u001f\u0002AQAU\u0003A\u0002QCQaW\u0003A\u0002u\u000bQbX2veJ,g\u000e^%nC\u001e,W#A=\u0011\u0005ilX\"A>\u000b\u0005qT\u0017!B5nC\u001e,\u0017B\u0001@|\u00055iU\r^1eCR\f\u0017*\\1hK\u0006\trlY;se\u0016tG/S7bO\u0016|F%Z9\u0015\t\u0005\r\u0011\u0011\u0002\t\u0004+\u0006\u0015\u0011bAA\u0004-\n!QK\\5u\u0011!\tYaBA\u0001\u0002\u0004I\u0018a\u0001=%c\u0005qqlY;se\u0016tG/S7bO\u0016\u0004\u0003f\u0001\u0005\u0002\u0012A\u0019Q+a\u0005\n\u0007\u0005UaK\u0001\u0005w_2\fG/\u001b7f\u0003ai\u0017-\u001f2f\r&dG/\u001a:BY&4XMU3qY&\u001c\u0017m\u001d\u000b\u000b\u00037\tI#a\u000b\u00026\u0005\u001d\u0003CBA\u000f\u0003?\t\u0019#D\u0001b\u0013\r\t\t#\u0019\u0002\u0005\u0019&\u001cH\u000fE\u0002H\u0003KI1!a\nI\u0005\u001dIe\u000e^3hKJDQ\u0001`\u0005A\u0002eDq!!\f\n\u0001\u0004\ty#A\u0004ce>\\WM]:\u0011\tU\u000b\t\u0004V\u0005\u0004\u0003g1&!B!se\u0006L\bbBA\u001c\u0013\u0001\u0007\u0011\u0011H\u0001\rY&\u001cH/\u001a8fe:\u000bW.\u001a\t\u0005\u0003w\t\u0019%\u0004\u0002\u0002>)!\u0011qHA!\u0003\u001dqW\r^<pe.T!\u0001\u001b6\n\t\u0005\u0015\u0013Q\b\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0005\b\u0003\u0013J\u0001\u0019AA&\u0003i1\u0017\u000e\u001c;feVs\u0017M^1jY\u0006\u0014G.Z#oIB|\u0017N\u001c;t!\r)\u0016QJ\u0005\u0004\u0003\u001f2&a\u0002\"p_2,\u0017M\\\u0001\rGV\u0014(/\u001a8u\u00136\fw-\u001a\u000b\u0002s\u0006!r-\u001a;QCJ$\u0018\u000e^5p]6+G/\u00193bi\u0006$B\"!\u0017\u0002\u001e\u0006}\u00151WA[\u0003s\u0003R!VA.\u0003?J1!!\u0018W\u0005\u0019y\u0005\u000f^5p]B1\u0011\u0011MA9\u0003orA!a\u0019\u0002n9!\u0011QMA6\u001b\t\t9GC\u0002\u0002j\u0011\u000ba\u0001\u0010:p_Rt\u0014\"A,\n\u0007\u0005=d+A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0014Q\u000f\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011q\u000e,\u0011\t\u0005e\u0014q\u0013\b\u0005\u0003w\n\tJ\u0004\u0003\u0002~\u00055e\u0002BA@\u0003\u0017sA!!!\u0002\n:!\u00111QAD\u001d\u0011\t)'!\"\n\u00039L!\u0001\\7\n\u0005\r[\u0017B\u00015k\u0013\u0011\ty)!\u0011\u0002\u000f5,7o]1hK&!\u00111SAK\u0003QiU\r^1eCR\f'+Z:q_:\u001cX\rR1uC*!\u0011qRA!\u0013\u0011\tI*a'\u000335+G/\u00193bi\u0006\u0014Vm\u001d9p]N,\u0007+\u0019:uSRLwN\u001c\u0006\u0005\u0003'\u000b)\nC\u0003}\u0017\u0001\u0007\u0011\u0010C\u0004\u0002\".\u0001\r!a)\u0002\u0013Q|\u0007/[2OC6,\u0007\u0003BAS\u0003[sA!a*\u0002*B\u0019\u0011Q\r,\n\u0007\u0005-f+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003_\u000b\tL\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003W3\u0006bBA\u001c\u0017\u0001\u0007\u0011\u0011\b\u0005\b\u0003o[\u0001\u0019AA&\u0003e)'O]8s+:\fg/Y5mC\ndW-\u00128ea>Lg\u000e^:\t\u000f\u0005m6\u00021\u0001\u0002L\u0005IRM\u001d:peVs\u0017M^1jY\u0006\u0014G.\u001a'jgR,g.\u001a:t\u00031:W\r\u001e)beRLG/[8o\u001b\u0016$\u0018\rZ1uC\u001a{'\u000fR3tGJL'-\u001a+pa&\u001c'+Z:q_:\u001cX\r\u0006\u0007\u0002B\u0006m\u0017Q\\Ap\u0003C\f)\u000f\u0005\u0004V\u0003\u0007\f9\rV\u0005\u0004\u0003\u000b4&A\u0002+va2,'\u0007E\u0003V\u00037\nI\r\u0005\u0004\u0002b\u0005-\u0017QZ\u0005\u0005\u0003C\t)\b\u0005\u0003\u0002P\u0006Ug\u0002BA>\u0003#LA!a5\u0002\u0016\u0006\u0019C)Z:de&\u0014W\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d*fgB|gn]3ECR\f\u0017\u0002BAl\u00033\u0014\u0001\u0006R3tGJL'-\u001a+pa&\u001c\u0007+\u0019:uSRLwN\\:SKN\u0004xN\\:f!\u0006\u0014H/\u001b;j_:TA!a5\u0002\u0016\")A\u0010\u0004a\u0001s\"9\u0011\u0011\u0015\u0007A\u0002\u0005\r\u0006bBA\u001c\u0019\u0001\u0007\u0011\u0011\b\u0005\u0007\u0003Gd\u0001\u0019\u0001+\u0002\u0015M$\u0018M\u001d;J]\u0012,\u0007\u0010\u0003\u0004\u0002h2\u0001\r\u0001V\u0001\t[\u0006D8i\\;oi\u0006\u0011r-\u001a;PM\u001ad\u0017N\\3SKBd\u0017nY1t)!\tY\"!<\u0002p\u0006u\b\"\u0002?\u000e\u0001\u0004I\bbBAy\u001b\u0001\u0007\u00111_\u0001\na\u0006\u0014H/\u001b;j_:\u0004B!!>\u0002z6\u0011\u0011q\u001f\u0006\u0003\u007f)LA!a?\u0002x\n)\u0002+\u0019:uSRLwN\u001c*fO&\u001cHO]1uS>t\u0007bBA\u001c\u001b\u0001\u0007\u0011\u0011H\u0001\u0011SN\u0014V\r\u001d7jG\u0006|eM\u001a7j]\u0016$\u0002\"a\u0013\u0003\u0004\t\u0015!q\u0001\u0005\b\u0003ct\u0001\u0019AAz\u0011\u001d\t9D\u0004a\u0001\u0003sAqA!\u0003\u000f\u0001\u0004\u0011Y!\u0001\u0004ce>\\WM\u001d\t\u0005\u0003k\u0014i!\u0003\u0003\u0003\u0010\u0005](A\u0005\"s_.,'OU3hSN$(/\u0019;j_:\fQ#[:SKBd\u0017nY1J]>3g\r\\5oK\u0012K'\u000f\u0006\u0004\u0002L\tU!q\u0003\u0005\b\u0005\u0013y\u0001\u0019\u0001B\u0006\u0011\u001d\t\tp\u0004a\u0001\u0003g\f\u0001cZ3u\u00032Lg/Z#oIB|\u0017N\u001c;\u0015\u0011\tu!q\u0005B\u0015\u0005[\u0001R!VA.\u0005?\u0001BA!\t\u0003$5\u0011\u0011\u0011I\u0005\u0005\u0005K\t\tE\u0001\u0003O_\u0012,\u0007\"\u0002?\u0011\u0001\u0004I\bB\u0002B\u0016!\u0001\u0007A+\u0001\u0002jI\"9\u0011q\u0007\tA\u0002\u0005e\u0012\u0001E4fiR{\u0007/[2NKR\fG-\u0019;b))\u0011\u0019Da\u000f\u0003F\t\u001d#\u0011\n\t\u0007\u0003;\tyB!\u000e\u0011\t\u0005e$qG\u0005\u0005\u0005s\tYJA\u000bNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tKR{\u0007/[2\t\u000f\tu\u0012\u00031\u0001\u0003@\u00051Ao\u001c9jGN\u0004b!!\b\u0003B\u0005\r\u0016b\u0001B\"C\n\u00191+\u001a;\t\u000f\u0005]\u0012\u00031\u0001\u0002:!I\u0011qW\t\u0011\u0002\u0003\u0007\u00111\n\u0005\n\u0003w\u000b\u0002\u0013!a\u0001\u0003\u0017\n!dZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIM*\"Aa\u0014+\t\u0005-#\u0011K\u0016\u0003\u0005'\u0002BA!\u0016\u0003`5\u0011!q\u000b\u0006\u0005\u00053\u0012Y&A\u0005v]\u000eDWmY6fI*\u0019!Q\f,\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003b\t]#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Qr-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u0013eK\u001a\fW\u000f\u001c;%i\u0005aq-\u001a;BY2$v\u000e]5dgR!!q\bB5\u0011\u001d\u0011Y\u0007\u0006a\u0001\u0005[\nq\u0002^3oC:$\bK]3gSb|\u0005\u000f\u001e\t\u0007\u0003;\u0011y'a)\n\u0007\tE\u0014M\u0001\u0005PaRLwN\\1m\u0003U!Wm]2sS\n,Gk\u001c9jGJ+7\u000f]8og\u0016$BBa\u001e\u0003\u0000\t\u0015%q\u0011BI\u0005+\u0003BA!\u001f\u0003|5\u0011\u0011QS\u0005\u0005\u0005{\n)JA\u0012EKN\u001c'/\u001b2f)>\u0004\u0018n\u0019)beRLG/[8ogJ+7\u000f]8og\u0016$\u0015\r^1\t\u000f\tuR\u00031\u0001\u0003\u0002B1\u0011Q\u0004BB\u0003GK1!a\u001db\u0011\u001d\t9$\u0006a\u0001\u0003sAqA!#\u0016\u0001\u0004\u0011Y)\u0001\ru_BL7\rU1si&$\u0018n\u001c8Ti\u0006\u0014H/\u00138eKb\u0004rA\u0018BG\u0003G\u000b\u0019#C\u0002\u0003\u0010~\u0013\u0001BR;oGRLwN\u001c\u0005\u0007\u0005'+\u0002\u0019\u0001+\u000235\f\u00070[7v[:+XNY3s\u001f\u001a\u0004\u0016M\u001d;ji&|gn\u001d\u0005\b\u0005/+\u0002\u0019AA&\u0003iIwM\\8sKR{\u0007/[2t/&$\b.\u0012=dKB$\u0018n\u001c8t\u0003I9W\r\u001e+pa&\u001c\u0007+\u0019:uSRLwN\\:\u0015\t\tu%Q\u0015\t\u0007\u0003;\u0011\tEa(\u0011\t\t\u0005\"\u0011U\u0005\u0005\u0005G\u000b\tE\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005\u0005f\u00031\u0001\u0002$R\u0011!qH\u0001\u000bO\u0016$Hk\u001c9jG&#G\u0003\u0002BW\u0005g\u0003BA!\t\u00030&!!\u0011WA!\u0005\u0011)V/\u001b3\t\u000f\u0005\u0005\u0006\u00041\u0001\u0002$\u0006aq-\u001a;U_BL7MT1nKR!!Q\u000eB]\u0011\u001d\u0011Y,\u0007a\u0001\u0005[\u000bq\u0001^8qS\u000eLE-\u0001\u0007hKR$v\u000e]5d)f\u0004X\r\u0006\u0003\u0003B\n%\u0007CBA\u000f\u0005_\u0012\u0019\r\u0005\u0003\u0003\"\t\u0015\u0017\u0002\u0002Bd\u0003\u0003\u0012\u0011\u0002V8qS\u000e$\u0016\u0010]3\t\u000f\u0005\u0005&\u00041\u0001\u0002$\u0006q\u0001.Y:BY&4XM\u0011:pW\u0016\u0014H\u0003BA&\u0005\u001fDQAU\u000eA\u0002Q\u000ba\"[:Ce>\\WM\u001d$f]\u000e,G\r\u0006\u0003\u0002L\tU\u0007\"\u0002*\u001d\u0001\u0004!\u0016\u0001F5t\u0005J|7.\u001a:TQV$H/\u001b8h\t><h\u000e\u0006\u0003\u0002L\tm\u0007\"\u0002*\u001e\u0001\u0004!\u0016aD4fi\u0006c\u0017N^3Ce>\\WM]:\u0015\t\t\u0005(q\u001e\t\u0007\u0003;\tyBa9\u0011\t\t\u0015(1^\u0007\u0003\u0005OTAA!;\u0002x\u0006I\u0001\u000f\\1dK6,g\u000e^\u0005\u0005\u0005[\u00149O\u0001\u0007Vg\u0006\u0014G.\u001a\"s_.,'\u000fC\u0003}=\u0001\u0007\u00110\u0006\u0002\u0003b\u0006\u0011r-\u001a;BY&4XM\u0011:pW\u0016\u0014hj\u001c3f)\u0019\u00119P!?\u0003|B1\u0011Q\u0004B8\u0005?AQA\u0015\u0011A\u0002QCq!a\u000e!\u0001\u0004\tI$A\bhKR\u0014%o\\6fe\u000e+G\u000e\\%e)\r!6\u0011\u0001\u0005\u0006%\u0006\u0002\r\u0001V\u0001\u0014O\u0016$\u0018\t\\5wK\n\u0013xn[3s\u001d>$Wm\u001d\u000b\u0005\u0007\u000f\u0019I\u0001\u0005\u0004\u0002\u001e\u0005}!q\u0004\u0005\b\u0003o\u0011\u0003\u0019AA\u001d\u000399W\r\u001e\"s_.,'OT8eKN$Baa\u0002\u0004\u0010!9\u0011qG\u0012A\u0002\u0005e\u0012aD4fiR{\u0007/[2t\u0005fd\u0015N\\6\u0015\t\rU1\u0011\u0005\t\t\u0003K\u001b9\"a)\u0004\u001c%!1\u0011DAY\u0005\ri\u0015\r\u001d\t\u0004u\u000eu\u0011bAB\u0010w\nQAk\u001c9jG&k\u0017mZ3\t\u000f\r\rB\u00051\u0001\u0003.\u0006!Q/^5e\u0003m9W\r^'jeJ|'\u000fU1si&$\u0018n\u001c8t\u0005fdU-\u00193feR!1\u0011FB\u0018!\u0019\t\tga\u000b\u0003 &!1QFA;\u0005\r\u0019V-\u001d\u0005\u0007\u0007c)\u0003\u0019\u0001+\u0002\u00111,\u0017\rZ3s\u0013\u0012\facZ3u\u0019&t7NT1nK\nK\b+\u0019:uSRLwN\u001c\u000b\u0005\u0007o\u0019I\u0004E\u0003V\u00037\n\u0019\u000bC\u0004\u0002r\u001a\u0002\rAa(\u0002\u001f\u001d,G\u000fT3bI\u0016\u0014\u0018I\u001c3JgJ$baa\u0010\u0004H\r%\u0003CBA\u000f\u0005_\u001a\t\u0005\u0005\u0003\u0002v\u000e\r\u0013\u0002BB#\u0003o\u0014A\u0002T3bI\u0016\u0014\u0018I\u001c3JgJDq!!)(\u0001\u0004\t\u0019\u000b\u0003\u0004\u0004L\u001d\u0002\r\u0001V\u0001\fa\u0006\u0014H/\u001b;j_:LE-A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0007#\u001a\u0019\u0006\u0005\u0004\u0002\u001e\t=\u00141\u0005\u0005\b\u0003CC\u0003\u0019AAR\u0003=!x\u000e]5d\u001d\u0006lWm\u001d+p\u0013\u0012\u001cHCAB-!!\tiba\u0017\u0002$\n5\u0016bAB\rC\u0006yAo\u001c9jG&#7\u000fV8OC6,7\u000f\u0006\u0002\u0004bAA\u0011QDB.\u0005[\u000b\u0019+\u0001\u000ehKR\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014XI\u001c3q_&tG\u000f\u0006\u0005\u0003x\u000e\u001d4\u0011NB6\u0011\u001d\t\tk\u000ba\u0001\u0003GCaaa\u0013,\u0001\u0004!\u0006bBA\u001cW\u0001\u0007\u0011\u0011H\u0001\u001dO\u0016$\b+\u0019:uSRLwN\u001c*fa2L7-Y#oIB|\u0017N\u001c;t)\u0019\u0019\tha\u001d\u0004xAA\u0011QDB.\u0003G\u0011y\u0002C\u0004\u0004v1\u0002\rAa(\u0002\u0005Q\u0004\bbBA\u001cY\u0001\u0007\u0011\u0011H\u0001\u0013O\u0016$8\t\\;ti\u0016\u0014X*\u001a;bI\u0006$\u0018\r\u0006\u0004\u0004~\r\r5q\u0011\t\u0005\u0005C\u0019y(\u0003\u0003\u0004\u0002\u0006\u0005#aB\"mkN$XM\u001d\u0005\b\u0007\u000bk\u0003\u0019AAR\u0003%\u0019G.^:uKJLE\rC\u0004\u000285\u0002\r!!\u000f\u0002-\u001d,GOU1oI>l\u0017\t\\5wK\n\u0013xn[3s\u0013\u0012$\"a!\u0015\u0002)\u001d,GOU1oI>l\u0017\t\\5wK\n\u0013xn[3s)\u0011\u0019\tf!%\t\u000bq|\u0003\u0019A=\u0002'\u001d,G/\u00117jm\u0016\u0014%o\\6fe\u0016\u0003xn\u00195\u0015\t\r]5q\u0014\t\u0007\u0003;\u0011yg!'\u0011\u0007\u001d\u001bY*C\u0002\u0004\u001e\"\u0013A\u0001T8oO\")!\u000b\ra\u0001)\u0006A1m\u001c8uC&t7\u000f\u0006\u0003\u0002L\r\u0015\u0006bBAQc\u0001\u0007\u00111\u0015\u000b\u0005\u0003\u0017\u001aI\u000bC\u0004\u0004vI\u0002\rAa(\u0002\u0011M,G/S7bO\u0016$B!a\u0001\u00040\"11\u0011W\u001aA\u0002e\f\u0001B\\3x\u00136\fw-Z\u0001\tO\u0016$\u0018*\\1hK\u000611m\u001c8gS\u001e$Ba!/\u0004@B!\u0011QDB^\u0013\r\u0019i,\u0019\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBBak\u0001\u000711Y\u0001\u000fG>tg-[4SKN|WO]2f!\u0011\u0019)m!3\u000e\u0005\r\u001d'\u0002BB[\u0003\u0003JAaa3\u0004H\nq1i\u001c8gS\u001e\u0014Vm]8ve\u000e,\u0017\u0001\u00063fg\u000e\u0014\u0018NY3DY&,g\u000e^)v_R\f7\u000f\u0006\u0003\u0004R\u000e]\u0007\u0003\u0002B=\u0007'LAa!6\u0002\u0016\n\u0001C)Z:de&\u0014Wm\u00117jK:$\u0018+^8uCN\u0014Vm\u001d9p]N,G)\u0019;b\u0011\u001d\u0019IN\u000ea\u0001\u00077\fqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0003z\ru\u0017\u0002BBp\u0003+\u0013q\u0004R3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001c(+Z9vKN$H)\u0019;b\u0003a!Wm]2sS\n,7k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0005\u0007K\u001cY\u000f\u0005\u0003\u0003z\r\u001d\u0018\u0002BBu\u0003+\u0013\u0001\u0006R3tGJL'-Z+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3ta>t7/\u001a#bi\u0006Dqa!78\u0001\u0004\u0019i\u000f\u0005\u0003\u0003z\r=\u0018\u0002BBy\u0003+\u0013q\u0005R3tGJL'-Z+tKJ\u001c6M]1n\u0007J,G-\u001a8uS\u0006d7OU3rk\u0016\u001cH\u000fR1uC\u0006yQ.\u001a;bI\u0006$\u0018MV3sg&|g\u000e\u0006\u0002\u0004xB\u0019am!?\n\u0007\rmxMA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003!1W-\u0019;ve\u0016\u001cHC\u0001C\u0001!\r1G1A\u0005\u0004\t\u000b9'!\u0005$j]\u0006d\u0017N_3e\r\u0016\fG/\u001e:fg\u0006\u0001\u0012n\u001d\"s_.,'\u000fR3he\u0006$W\r\u001a\u000b\u0005\u0003\u0017\"Y\u0001C\u0003Su\u0001\u0007A+A\rjg\n\u0013xn[3s\u0007>l\u0007o\u001c8f]R$Um\u001a:bI\u0016$GCBA&\t#!\u0019\u0002C\u0003Sw\u0001\u0007A\u000bC\u0004\u0005\u0016m\u0002\r\u0001b\u0006\u0002\u0013\r|W\u000e]8oK:$\b\u0003\u0002C\r\tGi!\u0001b\u0007\u000b\t\u0011uAqD\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0004\tCQ\u0017aB2mS\u0016tGo]\u0005\u0005\tK!YBA\bCe>\\WM]\"p[B|g.\u001a8u\u0003Ai\u0017N\u001d:peR{\u0007/[2Ti\u0006$X\r\u0006\u0003\u0005,\u0011M\u0002CBA\u000f\u0005_\"i\u0003\u0005\u0003\u0002v\u0012=\u0012\u0002\u0002C\u0019\u0003o\u00141\"T5se>\u0014Hk\u001c9jG\"9AQ\u0007\u001fA\u0002\u0005\r\u0016!\u0002;pa&\u001c\u0007")
public class KRaftMetadataCache
implements KRaftImageMetadataCache {
    private final int brokerId;
    private final Supplier<KRaftVersion> kraftVersionSupplier;
    private volatile MetadataImage _currentImage;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        KRaftMetadataCache kRaftMetadataCache = this;
        synchronized (kRaftMetadataCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public int brokerId() {
        return this.brokerId;
    }

    public Supplier<KRaftVersion> kraftVersionSupplier() {
        return this.kraftVersionSupplier;
    }

    private MetadataImage _currentImage() {
        return this._currentImage;
    }

    private void _currentImage_$eq(MetadataImage x$1) {
        this._currentImage = x$1;
    }

    private java.util.List<Integer> maybeFilterAliveReplicas(MetadataImage image, int[] brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return Replicas.toList(brokers);
        }
        ArrayList<Integer> res = new ArrayList<Integer>(brokers.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(brokers), brokerId -> Option$.MODULE$.apply(image.cluster().broker(brokerId)).foreach((Function1<BrokerRegistration, Object> & Serializable)b -> {
            if (!b.fenced() && b.listeners().containsKey(listenerName.value())) {
                return BoxesRunTime.boxToBoolean(res.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }));
        return res;
    }

    @Override
    public MetadataImage currentImage() {
        return this._currentImage();
    }

    private Option<Iterator<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataImage image, String topicName, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        Option<TopicImage> option = Option$.MODULE$.apply(image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            TopicImage topic = (TopicImage)some.value();
            if (((Object)BoxesRunTime.boxToByte(topic.topicType())).equals(BoxesRunTime.boxToByte(TopicType.VIRTUAL.id()))) {
                int n;
                Option option2 = CollectionConverters$.MODULE$.ListHasAsScala(this.getAliveBrokers()).asScala().toSeq().headOption();
                if (None$.MODULE$.equals(option2)) {
                    n = -1;
                } else if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    UsableBroker broker = (UsableBroker)some2.value();
                    n = broker.id();
                } else {
                    throw new MatchError(option2);
                }
                int virtualTopicLeaderId = n;
                return Option$.MODULE$.apply(package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MetadataResponseData.MetadataResponsePartition[]{new MetadataResponseData.MetadataResponsePartition().setErrorCode(Errors.NONE.code()).setPartitionIndex(0).setLeaderId(virtualTopicLeaderId).setLeaderEpoch(-1).setReplicaNodes(Collections.emptyList()).setObservers(Collections.emptyList()).setIsrNodes(Collections.emptyList()).setOfflineReplicas(Collections.emptyList())})));
            }
            return new Some<Iterator<MetadataResponseData.MetadataResponsePartition>>(((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().entrySet()).asScala().map((Function1<Map.Entry, MetadataResponseData.MetadataResponsePartition> & Serializable)entry -> {
                Integer partitionId = (Integer)entry.getKey();
                PartitionRegistration partition = (PartitionRegistration)entry.getValue();
                java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(image, partition.replicas, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredObservers = this.maybeFilterAliveReplicas(image, partition.observers, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(image, partition.isr, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> offlineReplicas = this.getOfflineReplicas(image, partition, listenerName);
                Option<Node> maybeLeader = this.getAliveEndpoint(image, partition.leader, listenerName);
                Option<Node> option = maybeLeader;
                if (None$.MODULE$.equals(option)) {
                    Errors errors;
                    if (!image.cluster().brokers().containsKey(BoxesRunTime.boxToInteger(partition.leader))) {
                        this.debug((Function0<String> & Serializable)() -> "Error while fetching metadata for " + topicName + "-" + partitionId + ": leader not available");
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String> & Serializable)() -> "Error while fetching metadata for " + topicName + "-" + partitionId + ": listener " + listenerName + " not found on leader " + partition$1.leader);
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(-1).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setObservers(filteredObservers).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                if (option instanceof Some) {
                    Errors errors;
                    Some some = (Some)option;
                    Node leader = (Node)some.value();
                    if (filteredReplicas.size() < partition.replicas.length) {
                        this.debug((Function0<String> & Serializable)() -> "Error while fetching metadata for " + topicName + "-" + partitionId + ": replica information not available for following brokers " + Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.replicas), (Function1<Object, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(filteredReplicas.contains(x$1)))).mkString(","));
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < partition.isr.length) {
                        this.debug((Function0<String> & Serializable)() -> "Error while fetching metadata for " + topicName + "-" + partitionId + ": in sync replica information not available for following brokers " + Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.isr), (Function1<Object, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(filteredIsr.contains(x$1)))).mkString(","));
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(leader.id()).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setObservers(filteredObservers).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                throw new MatchError(option);
            })).iterator());
        }
        throw new MatchError(option);
    }

    private Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object> getPartitionMetadataForDescribeTopicResponse(MetadataImage image, String topicName, ListenerName listenerName, int startIndex, int maxCount) {
        Option<TopicImage> option = Option$.MODULE$.apply(image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return new Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object>(None$.MODULE$, BoxesRunTime.boxToInteger(-1));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            TopicImage topic = (TopicImage)some.value();
            ListBuffer result = new ListBuffer();
            Set<Integer> partitions = topic.partitions().keySet();
            int upperIndex = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(topic.partitions().size()), startIndex + maxCount);
            int nextIndex = upperIndex < partitions.size() ? upperIndex : -1;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(startIndex), upperIndex).foreach((Function1<Object, Object> & Serializable)partitionId -> KRaftMetadataCache.$anonfun$getPartitionMetadataForDescribeTopicResponse$1(this, topic, image, listenerName, result, topicName, BoxesRunTime.unboxToInt(partitionId)));
            return new Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object>(new Some(result.toList()), BoxesRunTime.boxToInteger(nextIndex));
        }
        throw new MatchError(option);
    }

    private java.util.List<Integer> getOfflineReplicas(MetadataImage image, PartitionRegistration partition, ListenerName listenerName) {
        ArrayList<Integer> offlineReplicas = new ArrayList<Integer>(0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1<Object, Object> & Serializable)brokerId -> KRaftMetadataCache.$anonfun$getOfflineReplicas$1(this, image, offlineReplicas, partition, listenerName, BoxesRunTime.unboxToInt(brokerId)));
        return offlineReplicas;
    }

    private boolean isReplicaOffline(PartitionRegistration partition, ListenerName listenerName, BrokerRegistration broker) {
        return broker.fenced() || !broker.listeners().containsKey(listenerName.value()) || this.isReplicaInOfflineDir(broker, partition);
    }

    private boolean isReplicaInOfflineDir(BrokerRegistration broker, PartitionRegistration partition) {
        return !broker.hasOnlineDir(partition.directory(broker.id()));
    }

    private Option<Node> getAliveEndpoint(MetadataImage image, int id, ListenerName listenerName) {
        return Option$.MODULE$.apply(image.cluster().broker(id)).flatMap((Function1<BrokerRegistration, Option> & Serializable)x$1 -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(x$1.node(listenerName.value()))));
    }

    @Override
    public java.util.List<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataImage image = this._currentImage();
        return topics.stream().flatMap(topic -> {
            Option<Iterator<MetadataResponseData.MetadataResponsePartition>> option = this.getPartitionMetadata(image, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners);
            if (option instanceof Some) {
                Some some = (Some)option;
                Iterator partitionMetadata = (Iterator)some.value();
                TopicImage topicImage = image.topics().getTopic((String)topic);
                return Stream.of(new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName((String)topic).setTopicId((Uuid)Option$.MODULE$.apply(topicImage.id()).getOrElse((Function0<Uuid> & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal(topic)).setPartitions(CollectionConverters$.MODULE$.BufferHasAsJava(partitionMetadata.toBuffer()).asJava()).setTopicType(topicImage.topicType()));
            }
            if (None$.MODULE$.equals(option)) {
                return Stream.empty();
            }
            throw new MatchError(option);
        }).collect(Collectors.toList());
    }

    public boolean getTopicMetadata$default$3() {
        return false;
    }

    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics(Optional<String> tenantPrefixOpt) {
        if (tenantPrefixOpt.isEmpty()) {
            return this._currentImage().topics().topicsByName().keySet();
        }
        return this._currentImage().topics().topicsByTenant(tenantPrefixOpt.get());
    }

    @Override
    public DescribeTopicPartitionsResponseData describeTopicResponse(java.util.Iterator<String> topics, ListenerName listenerName, Function<String, Integer> topicPartitionStartIndex, int maximumNumberOfPartitions, boolean ignoreTopicsWithExceptions) {
        MetadataImage image = this._currentImage();
        IntRef remaining = IntRef.create(maximumNumberOfPartitions);
        DescribeTopicPartitionsResponseData result = new DescribeTopicPartitionsResponseData();
        Breaks$.MODULE$.breakable(() -> topics.forEachRemaining(topicName -> {
            if (remaining$1.elem > 0) {
                Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object> tuple2 = this.getPartitionMetadataForDescribeTopicResponse(image, (String)topicName, listenerName, Predef$.MODULE$.Integer2int((Integer)topicPartitionStartIndex.apply((String)topicName)), remaining$1.elem);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>> partitionResponse = tuple2._1();
                int nextPartition = tuple2._2$mcI$sp();
                Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Integer> tuple22 = new Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Integer>(partitionResponse, BoxesRunTime.boxToInteger(nextPartition));
                Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>> partitionResponse2 = tuple22._1();
                int nextPartition2 = tuple22._2$mcI$sp();
                partitionResponse2.map((Function1<List, Object> & Serializable)partitions -> {
                    KRaftMetadataCache.$anonfun$describeTopicResponse$3(topicName, image, result, nextPartition2, remaining, partitions);
                    return BoxedUnit.UNIT;
                });
                if (!ignoreTopicsWithExceptions && partitionResponse2.isEmpty()) {
                    Errors errors;
                    try {
                        Topic.validate(topicName);
                        errors = Errors.UNKNOWN_TOPIC_OR_PARTITION;
                    }
                    catch (InvalidTopicException invalidTopicException) {
                        errors = Errors.INVALID_TOPIC_EXCEPTION;
                    }
                    Errors error = errors;
                    result.topics().add(new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(error.code()).setName((String)topicName).setTopicId(this.getTopicId((String)topicName)).setIsInternal(Topic.isInternal(topicName)));
                    return;
                }
                return;
            }
            if (remaining$1.elem == 0) {
                result.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName((String)topicName).setPartitionIndex(0));
                throw Breaks$.MODULE$.break();
            }
        }));
        return result;
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        Option<TopicImage> option = Option$.MODULE$.apply(this._currentImage().topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return Set.of();
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            TopicImage topic = (TopicImage)some.value();
            return CollectionConverters$.MODULE$.MutableSetHasAsJava((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().keySet()).asScala().map((Function1<Integer, TopicPartition> & Serializable)x$3 -> new TopicPartition(topicName, Predef$.MODULE$.Integer2int((Integer)x$3)))).asJava();
        }
        throw new MatchError(option);
    }

    @Override
    public Set<String> getAllTopics() {
        return this._currentImage().topics().topicsByName().keySet();
    }

    @Override
    public Uuid getTopicId(String topicName) {
        return Optional.ofNullable(this._currentImage().topics().topicsByName().get(topicName)).map(x$4 -> x$4.id()).orElse(Uuid.ZERO_UUID);
    }

    @Override
    public Optional<String> getTopicName(Uuid topicId) {
        return Optional.ofNullable(this._currentImage().topics().topicsById().get(topicId)).map(t -> t.name());
    }

    @Override
    public Optional<TopicType> getTopicType(String topicName) {
        TopicImage image = this._currentImage().topics().getTopic(topicName);
        if (image == null) {
            return Optional.empty();
        }
        return Optional.of(TopicType.forId(image.topicType()));
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(this._currentImage().cluster().broker(brokerId))).count((Function1<BrokerRegistration, Object> & Serializable)x$5 -> BoxesRunTime.boxToBoolean(KRaftMetadataCache.$anonfun$hasAliveBroker$1(x$5))) == 1;
    }

    @Override
    public boolean isBrokerFenced(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(this._currentImage().cluster().broker(brokerId))).count((Function1<BrokerRegistration, Object> & Serializable)x$6 -> BoxesRunTime.boxToBoolean(x$6.fenced())) == 1;
    }

    @Override
    public boolean isBrokerShuttingDown(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply(this._currentImage().cluster().broker(brokerId))).count((Function1<BrokerRegistration, Object> & Serializable)x$7 -> BoxesRunTime.boxToBoolean(x$7.inControlledShutdown())) == 1;
    }

    private java.util.List<UsableBroker> getAliveBrokers(MetadataImage image) {
        return image.cluster().brokers().values().stream().filter(Predicate.not(x$8 -> x$8.fenced())).map(broker -> new UsableBroker(broker.id(), broker.rack(), broker.fenced())).collect(Collectors.toList());
    }

    public java.util.List<UsableBroker> getAliveBrokers() {
        return this.getAliveBrokers(this._currentImage());
    }

    @Override
    public Optional<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return Optional.ofNullable(this._currentImage().cluster().broker(brokerId)).filter(Predicate.not(x$9 -> x$9.fenced())).flatMap(broker -> broker.node(listenerName.value()));
    }

    @Override
    public int getBrokerCellId(int brokerId) {
        return this._currentImage().cells().getBrokerCellId(brokerId);
    }

    @Override
    public java.util.List<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return this._currentImage().cluster().brokers().values().stream().filter(Predicate.not(x$10 -> x$10.fenced())).flatMap(broker -> broker.node(listenerName.value()).stream()).collect(Collectors.toList());
    }

    @Override
    public java.util.List<Node> getBrokerNodes(ListenerName listenerName) {
        return this._currentImage().cluster().brokers().values().stream().flatMap(broker -> broker.node(listenerName.value()).stream()).collect(Collectors.toList());
    }

    public scala.collection.immutable.Map<String, TopicImage> getTopicsByLink(Uuid uuid) {
        return CollectionConverters$.MODULE$.MapHasAsScala(this._currentImage().topics().topicsByLinkId(uuid)).asScala().map((Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicImage image = (TopicImage)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(image.name()), image);
            }
            throw new MatchError(tuple2);
        }).toMap($less$colon$less$.MODULE$.refl());
    }

    public Seq<TopicPartition> getMirrorPartitionsByLeader(int leaderId) {
        return (Seq)CollectionConverters$.MODULE$.MapHasAsScala(this._currentImage().topics().topicsByLinkId()).asScala().toSeq().flatMap((Function1<Tuple2, IterableOnce> & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                ImmutableMap topicImageMap = (ImmutableMap)tuple2._2();
                return (IterableOnce)CollectionConverters$.MODULE$.MapHasAsScala(topicImageMap).asScala().toSeq().flatMap((Function1<Tuple2, IterableOnce> & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        Uuid topicId = (Uuid)tuple2._1();
                        TopicImage topicImage = (TopicImage)tuple2._2();
                        return (IterableOnce)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(topicImage.partitions()).asScala().filter((Function1<Tuple2, Object> & Serializable)x0$3 -> BoxesRunTime.boxToBoolean(KRaftMetadataCache.$anonfun$getMirrorPartitionsByLeader$3(leaderId, x0$3)))).filter((Function1<Tuple2, Object> & Serializable)x$11 -> BoxesRunTime.boxToBoolean(KRaftMetadataCache.$anonfun$getMirrorPartitionsByLeader$4(this, topicId, x$11)))).map((Function1<Tuple2, TopicPartition> & Serializable)x0$4 -> {
                            Tuple2 tuple2 = x0$4;
                            if (tuple2 != null) {
                                Integer partitionId = (Integer)tuple2._1();
                                return new TopicPartition(this.getTopicName(topicId).get(), Predef$.MODULE$.Integer2int(partitionId));
                            }
                            throw new MatchError(tuple2);
                        });
                    }
                    throw new MatchError(tuple2);
                });
            }
            throw new MatchError(tuple2);
        });
    }

    public Option<String> getLinkNameByPartition(TopicPartition partition) {
        Option option = CollectionConverters$.MODULE$.MapHasAsScala(this._currentImage().topics().topicsByName()).asScala().get(partition.topic());
        if (option instanceof Some) {
            Some some = (Some)option;
            TopicImage topicImage = (TopicImage)some.value();
            Option<MirrorTopic> option2 = OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(topicImage.mirrorTopic()));
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                MirrorTopic mirrorTopic = (MirrorTopic)some2.value();
                return new Some<String>(mirrorTopic.linkName());
            }
            if (None$.MODULE$.equals(option2)) {
                return Option$.MODULE$.empty();
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            return Option$.MODULE$.empty();
        }
        throw new MatchError(option);
    }

    @Override
    public Optional<LeaderAndIsr> getLeaderAndIsr(String topicName, int partitionId) {
        return Optional.ofNullable(this._currentImage().topics().getTopic(topicName)).flatMap(topic -> Optional.ofNullable(topic.partitions().get(BoxesRunTime.boxToInteger(partitionId)))).flatMap(partition -> Optional.ofNullable(new LeaderAndIsr(partition.leader, partition.leaderEpoch, Arrays.asList((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.isr), (Function1<Object, Integer> & Serializable)i -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(i)), ClassTag$.MODULE$.apply(Integer.class))), partition.leaderRecoveryState, partition.partitionEpoch, Optional.empty())));
    }

    @Override
    public Optional<Integer> numPartitions(String topicName) {
        return Optional.ofNullable(this._currentImage().topics().getTopic(topicName)).map(topic -> Predef$.MODULE$.int2Integer(topic.partitions().size()));
    }

    @Override
    public Map<String, Uuid> topicNamesToIds() {
        return this._currentImage().topics().topicNameToIdView();
    }

    @Override
    public Map<Uuid, String> topicIdsToNames() {
        return this._currentImage().topics().topicIdToNameView();
    }

    @Override
    public Optional<Node> getPartitionLeaderEndpoint(String topicName, int partitionId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        Option<TopicImage> option = Option$.MODULE$.apply(image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return Optional.empty();
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            TopicImage topic = (TopicImage)some.value();
            Option<PartitionRegistration> option2 = Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger(partitionId)));
            if (None$.MODULE$.equals(option2)) {
                return Optional.empty();
            }
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                PartitionRegistration partition = (PartitionRegistration)some2.value();
                Option<BrokerRegistration> option3 = Option$.MODULE$.apply(image.cluster().broker(partition.leader));
                if (None$.MODULE$.equals(option3)) {
                    return Optional.of(Node.noNode());
                }
                if (option3 instanceof Some) {
                    Some some3 = (Some)option3;
                    BrokerRegistration broker = (BrokerRegistration)some3.value();
                    return Optional.of(broker.node(listenerName.value()).orElse(Node.noNode()));
                }
                throw new MatchError(option3);
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    @Override
    public Map<Integer, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        HashMap<Integer, Node> result = new HashMap<Integer, Node>();
        Option$.MODULE$.apply(image.topics().getTopic(tp.topic())).foreach((Function1<TopicImage, Object> & Serializable)topic -> {
            KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$1(tp, image, listenerName, result, topic);
            return BoxedUnit.UNIT;
        });
        return result;
    }

    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        HashMap nodes = new HashMap();
        image.cluster().brokers().values().forEach(broker -> {
            if (!broker.fenced()) {
                OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(broker.node(listenerName.value()))).foreach((Function1<Node, Node> & Serializable)node -> nodes.put(Predef$.MODULE$.int2Integer(broker.id()), node));
                return;
            }
        });
        ArrayList<PartitionInfo> partitionInfos = new ArrayList<PartitionInfo>();
        HashSet<String> internalTopics = new HashSet<String>();
        image.topics().topicsByName().values().forEach(topic -> topic.partitions().forEach((key, value) -> {
            Integer partitionId = key;
            PartitionRegistration partition = value;
            partitionInfos.add(new PartitionInfo(topic.name(), Predef$.MODULE$.Integer2int(partitionId), KRaftMetadataCache.node$1(partition.leader, nodes), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1<Object, Node> & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt(replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.isr), (Function1<Object, Node> & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt(replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.getOfflineReplicas(image, partition, listenerName)).asScala().map((Function1<Integer, Node> & Serializable)replica -> KRaftMetadataCache.node$1(Predef$.MODULE$.Integer2int((Integer)replica), nodes))).toArray(ClassTag$.MODULE$.apply(Node.class))));
            if (Topic.isInternal(topic.name())) {
                internalTopics.add(topic.name());
                return;
            }
        }));
        Node controllerNode = KRaftMetadataCache.node$1(Predef$.MODULE$.Integer2int(this.getRandomAliveBroker(image).orElse(Predef$.MODULE$.int2Integer(-1))), nodes);
        return new Cluster(clusterId, nodes.values(), partitionInfos, Collections.emptySet(), internalTopics, controllerNode);
    }

    @Override
    public Optional<Integer> getRandomAliveBrokerId() {
        return this.getRandomAliveBroker(this._currentImage());
    }

    private Optional<Integer> getRandomAliveBroker(MetadataImage image) {
        java.util.List<Object> aliveBrokers = image.cluster().brokers().values().stream().filter(Predicate.not(x$12 -> x$12.fenced())).map(x$13 -> BoxesRunTime.boxToInteger(x$13.id())).toList();
        if (aliveBrokers.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt(aliveBrokers.get(ThreadLocalRandom.current().nextInt(aliveBrokers.size())))));
    }

    @Override
    public Optional<Long> getAliveBrokerEpoch(int brokerId) {
        return Optional.ofNullable(this._currentImage().cluster().broker(brokerId)).filter(Predicate.not(x$14 -> x$14.fenced())).map(brokerRegistration -> Predef$.MODULE$.long2Long(brokerRegistration.epoch()));
    }

    @Override
    public boolean contains(String topicName) {
        return this._currentImage().topics().topicsByName().containsKey(topicName);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        Option<TopicImage> option = Option$.MODULE$.apply(this._currentImage().topics().getTopic(tp.topic()));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            TopicImage topic = (TopicImage)some.value();
            return topic.partitions().containsKey(BoxesRunTime.boxToInteger(tp.partition()));
        }
        throw new MatchError(option);
    }

    @Override
    public void setImage(MetadataImage newImage) {
        this._currentImage_$eq(newImage);
    }

    public MetadataImage getImage() {
        return this._currentImage();
    }

    @Override
    public Properties config(ConfigResource configResource) {
        return this._currentImage().configs().configProperties(configResource);
    }

    @Override
    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData request) {
        return this._currentImage().clientQuotas().describe(request);
    }

    @Override
    public DescribeUserScramCredentialsResponseData describeScramCredentials(DescribeUserScramCredentialsRequestData request) {
        return this._currentImage().scram().describe(request);
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this._currentImage().features().metadataVersionOrThrow();
    }

    @Override
    public FinalizedFeatures features() {
        MetadataImage image = this._currentImage();
        HashMap<String, Short> finalizedFeatures = new HashMap<String, Short>(image.features().finalizedVersions());
        short kraftVersionLevel = this.kraftVersionSupplier().get().featureLevel();
        Serializable serializable = kraftVersionLevel > 0 ? finalizedFeatures.put("kraft.version", Predef$.MODULE$.short2Short(kraftVersionLevel)) : BoxedUnit.UNIT;
        return new FinalizedFeatures(image.features().metadataVersionOrThrow(), finalizedFeatures, image.highestOffsetAndEpoch().offset());
    }

    @Override
    public boolean isBrokerDegraded(int brokerId) {
        return Option$.MODULE$.apply(this._currentImage().cluster().broker(brokerId)).exists((Function1<BrokerRegistration, Object> & Serializable)registration -> BoxesRunTime.boxToBoolean(KRaftMetadataCache.$anonfun$isBrokerDegraded$1(registration)));
    }

    @Override
    public boolean isBrokerComponentDegraded(int brokerId, BrokerComponent component) {
        return Option$.MODULE$.apply(this._currentImage().cluster().broker(brokerId)).exists((Function1<BrokerRegistration, Object> & Serializable)registration -> BoxesRunTime.boxToBoolean(KRaftMetadataCache.$anonfun$isBrokerComponentDegraded$1(component, registration)));
    }

    @Override
    public Optional<MirrorTopic> mirrorTopicState(String topic) {
        MetadataImage image = this._currentImage();
        TopicImage topicImage = image.topics().getTopic(topic);
        if (topicImage == null) {
            return Optional.empty();
        }
        return topicImage.mirrorTopic();
    }

    public static final /* synthetic */ Object $anonfun$getPartitionMetadataForDescribeTopicResponse$1(KRaftMetadataCache $this, TopicImage topic$1, MetadataImage image$3, ListenerName listenerName$3, ListBuffer result$1, String topicName$2, int partitionId) {
        PartitionRegistration partitionRegistration = topic$1.partitions().get(BoxesRunTime.boxToInteger(partitionId));
        if (partitionRegistration != null) {
            PartitionRegistration partitionRegistration2 = partitionRegistration;
            java.util.List<Integer> filteredReplicas = $this.maybeFilterAliveReplicas(image$3, partitionRegistration2.replicas, listenerName$3, false);
            java.util.List<Integer> filteredIsr = $this.maybeFilterAliveReplicas(image$3, partitionRegistration2.isr, listenerName$3, false);
            java.util.List<Integer> filteredObservers = $this.maybeFilterAliveReplicas(image$3, partitionRegistration2.observers, listenerName$3, false);
            java.util.List<Integer> offlineReplicas = $this.getOfflineReplicas(image$3, partitionRegistration2, listenerName$3);
            Option<Node> maybeLeader = $this.getAliveEndpoint(image$3, partitionRegistration2.leader, listenerName$3);
            Option<Node> option = maybeLeader;
            if (None$.MODULE$.equals(option)) {
                return (ListBuffer)result$1.append(new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setPartitionIndex(partitionId).setLeaderId(-1).setLeaderEpoch(partitionRegistration2.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setObservers(filteredObservers).setOfflineReplicas(offlineReplicas).setEligibleLeaderReplicas(Replicas.toList(partitionRegistration2.elr)).setLastKnownElr(Replicas.toList(partitionRegistration2.lastKnownElr)));
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                Node leader = (Node)some.value();
                return (ListBuffer)result$1.append(new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setPartitionIndex(partitionId).setLeaderId(leader.id()).setLeaderEpoch(partitionRegistration2.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setObservers(filteredObservers).setOfflineReplicas(offlineReplicas).setEligibleLeaderReplicas(Replicas.toList(partitionRegistration2.elr)).setLastKnownElr(Replicas.toList(partitionRegistration2.lastKnownElr)));
            }
            throw new MatchError(option);
        }
        $this.warn((Function0<String> & Serializable)() -> "The partition " + partitionId + " does not exist for " + topicName$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$getOfflineReplicas$1(KRaftMetadataCache $this, MetadataImage image$4, ArrayList offlineReplicas$1, PartitionRegistration partition$2, ListenerName listenerName$4, int brokerId) {
        Option<BrokerRegistration> option = Option$.MODULE$.apply(image$4.cluster().broker(brokerId));
        if (None$.MODULE$.equals(option)) {
            return BoxesRunTime.boxToBoolean(offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            BrokerRegistration broker = (BrokerRegistration)some.value();
            if ($this.isReplicaOffline(partition$2, listenerName$4, broker)) {
                return BoxesRunTime.boxToBoolean(offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$describeTopicResponse$3(String topicName$3, MetadataImage image$6, DescribeTopicPartitionsResponseData result$2, int nextPartition$1, IntRef remaining$1, List partitions) {
        DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic response = new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(Errors.NONE.code()).setName(topicName$3).setTopicId((Uuid)Option$.MODULE$.apply(image$6.topics().getTopic(topicName$3).id()).getOrElse((Function0<Uuid> & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal(topicName$3)).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava(partitions).asJava());
        result$2.topics().add(response);
        if (nextPartition$1 != -1) {
            result$2.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName$3).setPartitionIndex(nextPartition$1));
            throw Breaks$.MODULE$.break();
        }
        remaining$1.elem -= partitions.size();
    }

    public static final /* synthetic */ boolean $anonfun$hasAliveBroker$1(BrokerRegistration x$5) {
        return !x$5.fenced();
    }

    public static final /* synthetic */ boolean $anonfun$getMirrorPartitionsByLeader$3(int leaderId$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            PartitionRegistration description = (PartitionRegistration)tuple2._2();
            return description.leader == leaderId$1;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$getMirrorPartitionsByLeader$4(KRaftMetadataCache $this, Uuid topicId$1, Tuple2 x$11) {
        return $this.getTopicName(topicId$1).isPresent();
    }

    public static final /* synthetic */ void $anonfun$getPartitionReplicaEndpoints$1(TopicPartition tp$1, MetadataImage image$7, ListenerName listenerName$11, HashMap result$3, TopicImage topic) {
        Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger(tp$1.partition()))).foreach((Function1<PartitionRegistration, Object> & Serializable)partition -> {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), replicaId -> {
                BrokerRegistration broker = image$7.cluster().broker(replicaId);
                if (broker != null && !broker.fenced()) {
                    broker.node(listenerName$11.value()).ifPresent(node -> {
                        if (!node.isEmpty()) {
                            result$3.put(Predef$.MODULE$.int2Integer(replicaId), node);
                            return;
                        }
                    });
                    return;
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    private static final Node node$1(int id, HashMap nodes$1) {
        return (Node)Option$.MODULE$.apply(nodes$1.get(BoxesRunTime.boxToInteger(id))).getOrElse((Function0<Node> & Serializable)() -> Node.noNode());
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerDegraded$1(BrokerRegistration registration) {
        return !registration.degradedComponents().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerComponentDegraded$1(BrokerComponent component$1, BrokerRegistration registration) {
        return registration.degradedComponents().stream().anyMatch(degradedComponent -> {
            BrokerComponent brokerComponent = degradedComponent.component();
            BrokerComponent brokerComponent2 = component$1;
            return !(brokerComponent != null ? !((Object)((Object)brokerComponent)).equals((Object)brokerComponent2) : brokerComponent2 != null);
        });
    }

    public KRaftMetadataCache(int brokerId, Supplier<KRaftVersion> kraftVersionSupplier) {
        this.brokerId = brokerId;
        this.kraftVersionSupplier = kraftVersionSupplier;
        Logging.$init$(this);
        this.logIdent_$eq("[MetadataCache brokerId=" + brokerId + "] ");
        this._currentImage = MetadataImage.EMPTY;
    }
}

