/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.ScramDelta;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.ScramCredentialData;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.security.CredentialProvider;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005A4A!\u0003\u0006\u0001#!A1\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011!A\u0004A!A!\u0002\u0013I\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000b-\u0003A\u0011\u0001'\t\u000bM\u0003A\u0011\t+\t\u000bU\u0003A\u0011\t,\t\u000bU\u0003A\u0011A7\u0003\u001dM\u001b'/Y7Qk\nd\u0017n\u001d5fe*\u00111\u0002D\u0001\t[\u0016$\u0018\rZ1uC*\u0011QBD\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003=\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001%aq\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\u001d\u0005)Q\u000f^5mg&\u0011QD\u0007\u0002\b\u0019><w-\u001b8h!\ty\u0012&D\u0001!\u0015\t\t#%A\u0005qk\nd\u0017n\u001d5fe*\u00111\u0005J\u0001\u0006S6\fw-\u001a\u0006\u0003\u001f\u0015R!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sO&\u0011!\u0006\t\u0002\u0012\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u0014\u0018\u0001B2p]\u001a\u0004\"!\f\u0018\u000e\u00031I!a\f\u0007\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\rM\u0006,H\u000e\u001e%b]\u0012dWM\u001d\t\u0003eYj\u0011a\r\u0006\u0003iU\nQAZ1vYRT!!\u0004\u0013\n\u0005]\u001a$\u0001\u0004$bk2$\b*\u00198eY\u0016\u0014\u0018\u0001\u00038pI\u0016$\u0016\u0010]3\u0011\u0005i\neBA\u001e@!\taD#D\u0001>\u0015\tq\u0004#\u0001\u0004=e>|GOP\u0005\u0003\u0001R\ta\u0001\u0015:fI\u00164\u0017B\u0001\"D\u0005\u0019\u0019FO]5oO*\u0011\u0001\tF\u0001\u0013GJ,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'\u000f\u0005\u0002G\u00136\tqI\u0003\u0002II\u0005A1/Z2ve&$\u00180\u0003\u0002K\u000f\n\u00112I]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s\u0003\u0019a\u0014N\\5u}Q)Qj\u0014)R%B\u0011a\nA\u0007\u0002\u0015!)1&\u0002a\u0001Y!)\u0001'\u0002a\u0001c!)\u0001(\u0002a\u0001s!)A)\u0002a\u0001\u000b\u0006!a.Y7f)\u0005I\u0014\u0001E8o\u001b\u0016$\u0018\rZ1uCV\u0003H-\u0019;f)\u00119&\fY3\u0011\u0005MA\u0016BA-\u0015\u0005\u0011)f.\u001b;\t\u000bm;\u0001\u0019\u0001/\u0002\u000b\u0011,G\u000e^1\u0011\u0005usV\"\u0001\u0012\n\u0005}\u0013#!D'fi\u0006$\u0017\r^1EK2$\u0018\rC\u0003b\u000f\u0001\u0007!-\u0001\u0005oK^LU.Y4f!\ti6-\u0003\u0002eE\tiQ*\u001a;bI\u0006$\u0018-S7bO\u0016DQAZ\u0004A\u0002\u001d\f\u0001\"\\1oS\u001a,7\u000f\u001e\t\u0003Q.l\u0011!\u001b\u0006\u0003U\n\na\u0001\\8bI\u0016\u0014\u0018B\u00017j\u00059au.\u00193fe6\u000bg.\u001b4fgR$2a\u00168p\u0011\u0015Y\u0006\u00021\u0001]\u0011\u0015\t\u0007\u00021\u0001c\u0001")
public class ScramPublisher
implements Logging,
MetadataPublisher {
    private final KafkaConfig conf;
    private final FaultHandler faultHandler;
    private final String nodeType;
    private final CredentialProvider credentialProvider;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public void onControllerChange(LeaderAndEpoch newLeaderAndEpoch) {
        MetadataPublisher.super.onControllerChange(newLeaderAndEpoch);
    }

    @Override
    public void close() throws Exception {
        MetadataPublisher.super.close();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ScramPublisher scramPublisher = this;
        synchronized (scramPublisher) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String name() {
        return "ScramPublisher " + this.nodeType + " id=" + this.conf.nodeId();
    }

    @Override
    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        this.onMetadataUpdate(delta, newImage);
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage) {
        String deltaName = "MetadataDelta up to " + newImage.highestOffsetAndEpoch().offset();
        try {
            Option$.MODULE$.apply(delta.scramDelta()).foreach((Function1<ScramDelta, Object> & Serializable)scramDelta -> {
                ScramPublisher.$anonfun$onMetadataUpdate$1(this, scramDelta);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            this.faultHandler.handleFault("Uncaught exception while publishing SCRAM changes from " + deltaName, t);
        }
    }

    public static final /* synthetic */ void $anonfun$onMetadataUpdate$1(ScramPublisher $this, ScramDelta scramDelta) {
        scramDelta.changes().forEach((x0$1, x1$1) -> {
            Tuple2<ScramMechanism, Map> tuple2 = new Tuple2<ScramMechanism, Map>((ScramMechanism)((Object)x0$1), (Map)x1$1);
            if (tuple2 != null) {
                ScramMechanism mechanism = tuple2._1();
                Map userChanges = tuple2._2();
                userChanges.forEach((x0$2, x1$2) -> {
                    Tuple2<String, Optional> tuple2 = new Tuple2<String, Optional>((String)x0$2, (Optional)x1$2);
                    if (tuple2 != null) {
                        String userName = tuple2._1();
                        Optional change = tuple2._2();
                        if (change.isPresent()) {
                            $this.credentialProvider.updateCredential(mechanism, userName, ((ScramCredentialData)change.get()).toCredential());
                            return;
                        }
                        $this.credentialProvider.removeCredentials(mechanism, userName);
                        return;
                    }
                    throw new MatchError(tuple2);
                });
                return;
            }
            throw new MatchError(tuple2);
        });
    }

    public ScramPublisher(KafkaConfig conf, FaultHandler faultHandler, String nodeType, CredentialProvider credentialProvider) {
        this.conf = conf;
        this.faultHandler = faultHandler;
        this.nodeType = nodeType;
        this.credentialProvider = credentialProvider;
        Logging.$init$(this);
        this.logIdent_$eq("[" + this.name() + "] ");
    }
}

