/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.share;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.ReplicaManager;
import kafka.server.share.ShareFetchUtils;
import kafka.server.share.SharePartitionManager;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.CoordinatorNotAvailableException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.InvalidRecordStateException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.GroupConfig;
import org.apache.kafka.coordinator.group.GroupConfigManager;
import org.apache.kafka.coordinator.group.ShareGroupAutoOffsetResetStrategy;
import org.apache.kafka.server.share.acknowledge.ShareAcknowledgementBatch;
import org.apache.kafka.server.share.fetch.AcquisitionLockTimeoutHandler;
import org.apache.kafka.server.share.fetch.AcquisitionLockTimerTask;
import org.apache.kafka.server.share.fetch.DelayedShareFetchGroupKey;
import org.apache.kafka.server.share.fetch.DelayedShareFetchKey;
import org.apache.kafka.server.share.fetch.DeliveryCountOps;
import org.apache.kafka.server.share.fetch.InFlightBatch;
import org.apache.kafka.server.share.fetch.InFlightState;
import org.apache.kafka.server.share.fetch.RecordState;
import org.apache.kafka.server.share.fetch.ShareAcquiredRecords;
import org.apache.kafka.server.share.metrics.SharePartitionMetrics;
import org.apache.kafka.server.share.persister.GroupTopicPartitionData;
import org.apache.kafka.server.share.persister.PartitionErrorData;
import org.apache.kafka.server.share.persister.PartitionFactory;
import org.apache.kafka.server.share.persister.PartitionIdLeaderEpochData;
import org.apache.kafka.server.share.persister.PartitionStateBatchData;
import org.apache.kafka.server.share.persister.Persister;
import org.apache.kafka.server.share.persister.PersisterStateBatch;
import org.apache.kafka.server.share.persister.ReadShareGroupStateParameters;
import org.apache.kafka.server.share.persister.TopicData;
import org.apache.kafka.server.share.persister.WriteShareGroupStateParameters;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import org.apache.kafka.server.util.timer.Timer;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharePartition {
    private static final Logger log = LoggerFactory.getLogger(SharePartition.class);
    static final String EMPTY_MEMBER_ID = Uuid.ZERO_UUID.toString();
    private final String groupId;
    private final TopicIdPartition topicIdPartition;
    private final int leaderEpoch;
    private final NavigableMap<Long, InFlightBatch> cachedState;
    private final ReadWriteLock lock;
    private final AtomicReference<Uuid> fetchLock;
    private final int maxInFlightMessages;
    private final int maxDeliveryCount;
    private final GroupConfigManager groupConfigManager;
    private final int defaultRecordLockDurationMs;
    private boolean findNextFetchOffset;
    private final Timer timer;
    private final Time time;
    private final Persister persister;
    private final SharePartitionManager.SharePartitionListener listener;
    private final long loadStartTimeMs;
    private final SharePartitionMetrics sharePartitionMetrics;
    private final AcquisitionLockTimeoutHandler timeoutHandler;
    private final ReplicaManager replicaManager;
    private long startOffset;
    private long endOffset;
    private GapWindow persisterReadResultGapWindow;
    private final OffsetMetadata fetchOffsetMetadata;
    private final DelayedShareFetchKey delayedShareFetchKey;
    private int stateEpoch;
    private SharePartitionState partitionState;
    private long fetchLockAcquiredTimeMs;
    private long fetchLockReleasedTimeMs;
    private long fetchLockIdleDurationMs;

    SharePartition(String groupId, TopicIdPartition topicIdPartition, int leaderEpoch, int maxInFlightMessages, int maxDeliveryCount, int defaultRecordLockDurationMs, Timer timer, Time time, Persister persister, ReplicaManager replicaManager, GroupConfigManager groupConfigManager, SharePartitionManager.SharePartitionListener listener) {
        this(groupId, topicIdPartition, leaderEpoch, maxInFlightMessages, maxDeliveryCount, defaultRecordLockDurationMs, timer, time, persister, replicaManager, groupConfigManager, SharePartitionState.EMPTY, listener, new SharePartitionMetrics(groupId, topicIdPartition.topic(), topicIdPartition.partition()));
    }

    SharePartition(String groupId, TopicIdPartition topicIdPartition, int leaderEpoch, int maxInFlightMessages, int maxDeliveryCount, int defaultRecordLockDurationMs, Timer timer, Time time, Persister persister, ReplicaManager replicaManager, GroupConfigManager groupConfigManager, SharePartitionState sharePartitionState, SharePartitionManager.SharePartitionListener listener, SharePartitionMetrics sharePartitionMetrics) {
        this.groupId = groupId;
        this.topicIdPartition = topicIdPartition;
        this.leaderEpoch = leaderEpoch;
        this.maxInFlightMessages = maxInFlightMessages;
        this.maxDeliveryCount = maxDeliveryCount;
        this.cachedState = new ConcurrentSkipListMap<Long, InFlightBatch>();
        this.lock = new ReentrantReadWriteLock();
        this.findNextFetchOffset = false;
        this.fetchLock = new AtomicReference<Object>(null);
        this.defaultRecordLockDurationMs = defaultRecordLockDurationMs;
        this.timer = timer;
        this.time = time;
        this.loadStartTimeMs = time.hiResClockMs();
        this.persister = persister;
        this.partitionState = sharePartitionState;
        this.replicaManager = replicaManager;
        this.groupConfigManager = groupConfigManager;
        this.fetchOffsetMetadata = new OffsetMetadata();
        this.delayedShareFetchKey = new DelayedShareFetchGroupKey(groupId, topicIdPartition);
        this.listener = listener;
        this.sharePartitionMetrics = sharePartitionMetrics;
        this.timeoutHandler = this.releaseAcquisitionLockOnTimeout();
        this.registerGaugeMetrics();
    }

    public CompletableFuture<Void> maybeInitialize() {
        log.debug("Maybe initialize share partition: {}-{}", (Object)this.groupId, (Object)this.topicIdPartition);
        try {
            if (this.initializedOrThrowException()) {
                return CompletableFuture.completedFuture(null);
            }
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        try {
            if (!this.emptyToInitialState()) {
                return CompletableFuture.completedFuture(null);
            }
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.persister.readState(new ReadShareGroupStateParameters.Builder().setGroupTopicPartitionData(new GroupTopicPartitionData.Builder().setGroupId(this.groupId).setTopicsData(List.of(new TopicData<PartitionIdLeaderEpochData>(this.topicIdPartition.topicId(), List.of(PartitionFactory.newPartitionIdLeaderEpochData(this.topicIdPartition.partition(), this.leaderEpoch))))).build()).build()).whenComplete((result, exception) -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 10[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextFetchOffset() {
        this.lock.writeLock().lock();
        try {
            if (!this.findNextFetchOffset) {
                if (this.cachedState.isEmpty() || this.startOffset > this.cachedState.lastEntry().getValue().lastOffset()) {
                    log.trace("The next fetch offset for the share partition {}-{} is {}", this.groupId, this.topicIdPartition, this.endOffset);
                    long l = this.endOffset;
                    return l;
                }
                log.trace("The next fetch offset for the share partition {}-{} is {}", this.groupId, this.topicIdPartition, this.endOffset + 1L);
                long l = this.endOffset + 1L;
                return l;
            }
            if (this.cachedState.isEmpty() || this.startOffset > this.cachedState.lastEntry().getValue().lastOffset()) {
                this.updateFindNextFetchOffset(false);
                log.trace("The next fetch offset for the share partition {}-{} is {}", this.groupId, this.topicIdPartition, this.endOffset);
                long l = this.endOffset;
                return l;
            }
            long nextFetchOffset = -1L;
            long gapStartOffset = this.isPersisterReadGapWindowActive() ? this.persisterReadResultGapWindow.gapStartOffset() : -1L;
            for (Map.Entry entry : this.cachedState.entrySet()) {
                if (this.isPersisterReadGapWindowActive()) {
                    if ((Long)entry.getKey() > gapStartOffset) {
                        nextFetchOffset = gapStartOffset;
                        break;
                    }
                    gapStartOffset = Math.max(((InFlightBatch)entry.getValue()).lastOffset() + 1L, gapStartOffset);
                }
                if (((InFlightBatch)entry.getValue()).offsetState() == null) {
                    if (((InFlightBatch)entry.getValue()).batchState() != RecordState.AVAILABLE || ((InFlightBatch)entry.getValue()).batchHasOngoingStateTransition()) continue;
                    nextFetchOffset = ((InFlightBatch)entry.getValue()).firstOffset();
                    break;
                }
                for (Map.Entry offsetState : ((InFlightBatch)entry.getValue()).offsetState().entrySet()) {
                    if (((InFlightState)offsetState.getValue()).state() != RecordState.AVAILABLE || ((InFlightState)offsetState.getValue()).hasOngoingStateTransition()) continue;
                    nextFetchOffset = (Long)offsetState.getKey();
                    break;
                }
                if (nextFetchOffset == -1L) continue;
                break;
            }
            if (nextFetchOffset == -1L) {
                this.updateFindNextFetchOffset(false);
                nextFetchOffset = this.endOffset + 1L;
            }
            log.trace("The next fetch offset for the share partition {}-{} is {}", this.groupId, this.topicIdPartition, nextFetchOffset);
            long l = nextFetchOffset;
            return l;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareAcquiredRecords acquire(String memberId, int batchSize, int maxFetchRecords, long fetchOffset, FetchPartitionData fetchPartitionData, FetchIsolation isolationLevel) {
        log.trace("Received acquire request for share partition: {}-{} memberId: {}", this.groupId, this.topicIdPartition, memberId);
        if (this.stateNotActive() || maxFetchRecords <= 0) {
            return ShareAcquiredRecords.empty();
        }
        RecordBatch lastBatch = fetchPartitionData.records.lastBatch().orElse(null);
        if (lastBatch == null) {
            return ShareAcquiredRecords.empty();
        }
        LastOffsetAndMaxRecords lastOffsetAndMaxRecords = this.lastOffsetAndMaxRecordsToAcquire(fetchOffset, maxFetchRecords, lastBatch.lastOffset());
        if (lastOffsetAndMaxRecords.maxRecords() <= 0) {
            return ShareAcquiredRecords.empty();
        }
        int maxRecordsToAcquire = lastOffsetAndMaxRecords.maxRecords();
        long lastOffsetToAcquire = lastOffsetAndMaxRecords.lastOffset();
        RecordBatch firstBatch = fetchPartitionData.records.batches().iterator().next();
        this.lock.writeLock().lock();
        try {
            Object object;
            NavigableMap<Long, InFlightBatch> subMap;
            long baseOffset = firstBatch.baseOffset();
            this.maybeArchiveStaleBatches(fetchOffset, baseOffset);
            Map.Entry<Long, InFlightBatch> floorEntry = this.cachedState.floorEntry(baseOffset);
            if (floorEntry == null) {
                if (baseOffset < this.startOffset) {
                    log.info("Adjusting base offset for the fetch as it's prior to start offset: {}-{}from {} to {}", this.groupId, this.topicIdPartition, baseOffset, this.startOffset);
                    baseOffset = this.startOffset;
                }
            } else if (floorEntry.getValue().lastOffset() >= baseOffset) {
                baseOffset = floorEntry.getKey();
            }
            if ((subMap = this.cachedState.subMap(baseOffset, true, lastBatch.lastOffset(), true)).isEmpty()) {
                log.trace("No cached data exists for the share partition for requested fetch batch: {}-{}", (Object)this.groupId, (Object)this.topicIdPartition);
                ShareAcquiredRecords shareAcquiredRecords = this.acquireNewBatchRecords(memberId, fetchPartitionData.records.batches(), firstBatch.baseOffset(), lastBatch.lastOffset(), batchSize, maxRecordsToAcquire);
                ShareAcquiredRecords shareAcquiredRecords2 = this.maybeFilterAbortedTransactionalAcquiredRecords(fetchPartitionData, isolationLevel, shareAcquiredRecords);
                return shareAcquiredRecords2;
            }
            log.trace("Overlap exists with in-flight records. Acquire the records if available for the share partition: {}-{}", (Object)this.groupId, (Object)this.topicIdPartition);
            ArrayList<ShareFetchResponseData.AcquiredRecords> result = new ArrayList<ShareFetchResponseData.AcquiredRecords>();
            int acquiredCount = 0;
            long maybeGapStartOffset = baseOffset;
            for (Map.Entry entry : subMap.entrySet()) {
                boolean fullMatch;
                if (acquiredCount >= maxRecordsToAcquire) break;
                InFlightBatch inFlightBatch = (InFlightBatch)entry.getValue();
                if (this.isPersisterReadGapWindowActive()) {
                    if (maybeGapStartOffset < (Long)entry.getKey()) {
                        ShareAcquiredRecords shareAcquiredRecords = this.acquireNewBatchRecords(memberId, fetchPartitionData.records.batches(), maybeGapStartOffset, (Long)entry.getKey() - 1L, batchSize, maxRecordsToAcquire);
                        result.addAll(shareAcquiredRecords.acquiredRecords());
                        acquiredCount += shareAcquiredRecords.count();
                    }
                    maybeGapStartOffset = inFlightBatch.lastOffset() + 1L;
                    if (acquiredCount >= maxRecordsToAcquire) break;
                }
                if (!(fullMatch = this.checkForFullMatch(inFlightBatch, firstBatch.baseOffset(), lastBatch.lastOffset())) || inFlightBatch.offsetState() != null) {
                    log.trace("Subset or offset tracked batch record found for share partition, batch: {} request offsets - first: {}, last: {} for the share partition: {}-{}", inFlightBatch, firstBatch.baseOffset(), lastBatch.lastOffset(), this.groupId, this.topicIdPartition);
                    if (inFlightBatch.offsetState() == null) {
                        if (inFlightBatch.batchState() != RecordState.AVAILABLE || inFlightBatch.batchHasOngoingStateTransition()) {
                            log.trace("The batch is not available to acquire in share partition: {}-{}, skipping: {} skipping offset tracking for batch as well.", this.groupId, this.topicIdPartition, inFlightBatch);
                            continue;
                        }
                        inFlightBatch.maybeInitializeOffsetStateUpdate();
                    }
                    int acquiredSubsetCount = this.acquireSubsetBatchRecords(memberId, firstBatch.baseOffset(), lastOffsetToAcquire, inFlightBatch, result);
                    acquiredCount += acquiredSubsetCount;
                    continue;
                }
                if (inFlightBatch.batchState() != RecordState.AVAILABLE || inFlightBatch.batchHasOngoingStateTransition()) {
                    log.trace("The batch is not available to acquire in share partition: {}-{}, skipping: {}", this.groupId, this.topicIdPartition, inFlightBatch);
                    continue;
                }
                InFlightState updateResult = inFlightBatch.tryUpdateBatchState(RecordState.ACQUIRED, DeliveryCountOps.INCREASE, this.maxDeliveryCount, memberId);
                if (updateResult == null || updateResult.state() != RecordState.ACQUIRED) {
                    log.info("Unable to acquire records for the batch: {} in share partition: {}-{}", inFlightBatch, this.groupId, this.topicIdPartition);
                    continue;
                }
                AcquisitionLockTimerTask acquisitionLockTimeoutTask = this.scheduleAcquisitionLockTimeout(memberId, inFlightBatch.firstOffset(), inFlightBatch.lastOffset());
                inFlightBatch.updateAcquisitionLockTimeout(acquisitionLockTimeoutTask);
                result.add(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(inFlightBatch.firstOffset()).setLastOffset(inFlightBatch.lastOffset()).setDeliveryCount((short)inFlightBatch.batchDeliveryCount()));
                acquiredCount += (int)(inFlightBatch.lastOffset() - inFlightBatch.firstOffset() + 1L);
            }
            if (acquiredCount < maxRecordsToAcquire && subMap.lastEntry().getValue().lastOffset() < lastOffsetToAcquire) {
                log.trace("There exists another batch which needs to be acquired as well");
                ShareAcquiredRecords shareAcquiredRecords = this.acquireNewBatchRecords(memberId, fetchPartitionData.records.batches(), subMap.lastEntry().getValue().lastOffset() + 1L, lastOffsetToAcquire, batchSize, maxRecordsToAcquire - acquiredCount);
                result.addAll(shareAcquiredRecords.acquiredRecords());
                acquiredCount += shareAcquiredRecords.count();
            }
            if (!result.isEmpty()) {
                this.maybeUpdatePersisterGapWindowStartOffset(((ShareFetchResponseData.AcquiredRecords)result.get(result.size() - 1)).lastOffset() + 1L);
                object = this.maybeFilterAbortedTransactionalAcquiredRecords(fetchPartitionData, isolationLevel, new ShareAcquiredRecords(result, acquiredCount));
                return object;
            }
            object = new ShareAcquiredRecords(result, acquiredCount);
            return object;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> acknowledge(String memberId, List<ShareAcknowledgementBatch> acknowledgementBatches) {
        log.trace("Acknowledgement batch request for share partition: {}-{}", (Object)this.groupId, (Object)this.topicIdPartition);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Throwable throwable = null;
        ArrayList<InFlightState> updatedStates = new ArrayList<InFlightState>();
        ArrayList<PersisterStateBatch> stateBatches = new ArrayList<PersisterStateBatch>();
        this.lock.writeLock().lock();
        try {
            for (ShareAcknowledgementBatch batch : acknowledgementBatches) {
                NavigableMap<Long, InFlightBatch> subMap;
                Map<Long, RecordState> recordStateMap;
                try {
                    recordStateMap = this.fetchRecordStateMapForAcknowledgementBatch(batch);
                }
                catch (IllegalArgumentException e) {
                    log.debug("Invalid acknowledge type: {} for share partition: {}-{}", batch.acknowledgeTypes(), this.groupId, this.topicIdPartition);
                    throwable = new InvalidRequestException("Invalid acknowledge type: " + String.valueOf(batch.acknowledgeTypes()));
                    break;
                }
                if (batch.lastOffset() < this.startOffset) {
                    log.trace("All offsets in the acknowledgement batch {} are already archived: {}-{}", batch, this.groupId, this.topicIdPartition);
                    continue;
                }
                try {
                    subMap = this.fetchSubMapForAcknowledgementBatch(batch);
                }
                catch (InvalidRecordStateException | InvalidRequestException e) {
                    throwable = e;
                    break;
                }
                Optional<Throwable> ackThrowable = this.acknowledgeBatchRecords(memberId, batch, recordStateMap, subMap, updatedStates, stateBatches);
                if (!ackThrowable.isPresent()) continue;
                throwable = ackThrowable.get();
                break;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.rollbackOrProcessStateUpdates(future, throwable, updatedStates, stateBatches);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> releaseAcquiredRecords(String memberId) {
        log.trace("Release acquired records request for share partition: {}-{} memberId: {}", this.groupId, this.topicIdPartition, memberId);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Throwable throwable = null;
        ArrayList<InFlightState> updatedStates = new ArrayList<InFlightState>();
        ArrayList<PersisterStateBatch> stateBatches = new ArrayList<PersisterStateBatch>();
        this.lock.writeLock().lock();
        try {
            RecordState recordState = RecordState.AVAILABLE;
            for (Map.Entry entry : this.cachedState.entrySet()) {
                InFlightBatch inFlightBatch = (InFlightBatch)entry.getValue();
                if (inFlightBatch.offsetState() == null && inFlightBatch.batchState() == RecordState.ACQUIRED && inFlightBatch.batchMemberId().equals(memberId) && this.checkForStartOffsetWithinBatch(inFlightBatch.firstOffset(), inFlightBatch.lastOffset())) {
                    inFlightBatch.maybeInitializeOffsetStateUpdate();
                }
                if (inFlightBatch.offsetState() != null) {
                    releaseAcquiredRecordsThrowable = this.releaseAcquiredRecordsForPerOffsetBatch(memberId, inFlightBatch, recordState, updatedStates, stateBatches);
                    if (!releaseAcquiredRecordsThrowable.isPresent()) continue;
                    throwable = releaseAcquiredRecordsThrowable.get();
                } else {
                    releaseAcquiredRecordsThrowable = this.releaseAcquiredRecordsForCompleteBatch(memberId, inFlightBatch, recordState, updatedStates, stateBatches);
                    if (!releaseAcquiredRecordsThrowable.isPresent()) continue;
                    throwable = releaseAcquiredRecordsThrowable.get();
                }
                break;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.rollbackOrProcessStateUpdates(future, throwable, updatedStates, stateBatches);
        return future;
    }

    long loadStartTimeMs() {
        return this.loadStartTimeMs;
    }

    private Optional<Throwable> releaseAcquiredRecordsForPerOffsetBatch(String memberId, InFlightBatch inFlightBatch, RecordState recordState, List<InFlightState> updatedStates, List<PersisterStateBatch> stateBatches) {
        log.trace("Offset tracked batch record found, batch: {} for the share partition: {}-{}", inFlightBatch, this.groupId, this.topicIdPartition);
        for (Map.Entry offsetState : inFlightBatch.offsetState().entrySet()) {
            if (!((InFlightState)offsetState.getValue()).memberId().equals(memberId) && !((InFlightState)offsetState.getValue()).memberId().equals(EMPTY_MEMBER_ID)) {
                log.debug("Member {} is not the owner of offset: {} in batch: {} for the share partition: {}-{}. Skipping offset.", memberId, offsetState.getKey(), inFlightBatch, this.groupId, this.topicIdPartition);
                return Optional.empty();
            }
            if (((InFlightState)offsetState.getValue()).state() != RecordState.ACQUIRED) continue;
            InFlightState updateResult = ((InFlightState)offsetState.getValue()).startStateTransition((Long)offsetState.getKey() < this.startOffset ? RecordState.ARCHIVED : recordState, DeliveryCountOps.DECREASE, this.maxDeliveryCount, EMPTY_MEMBER_ID);
            if (updateResult == null) {
                log.debug("Unable to release records from acquired state for the offset: {} in batch: {} for the share partition: {}-{}", offsetState.getKey(), inFlightBatch, this.groupId, this.topicIdPartition);
                return Optional.of(new InvalidRecordStateException("Unable to release acquired records for the offset"));
            }
            updatedStates.add(updateResult);
            stateBatches.add(new PersisterStateBatch((Long)offsetState.getKey(), (Long)offsetState.getKey(), updateResult.state().id(), (short)updateResult.deliveryCount()));
        }
        return Optional.empty();
    }

    private Optional<Throwable> releaseAcquiredRecordsForCompleteBatch(String memberId, InFlightBatch inFlightBatch, RecordState recordState, List<InFlightState> updatedStates, List<PersisterStateBatch> stateBatches) {
        if (!inFlightBatch.batchMemberId().equals(memberId) && !inFlightBatch.batchMemberId().equals(EMPTY_MEMBER_ID)) {
            log.debug("Member {} is not the owner of batch record {} for share partition: {}-{}. Skipping batch.", memberId, inFlightBatch, this.groupId, this.topicIdPartition);
            return Optional.empty();
        }
        log.trace("Releasing acquired records for complete batch {} for the share partition: {}-{}", inFlightBatch, this.groupId, this.topicIdPartition);
        if (inFlightBatch.batchState() == RecordState.ACQUIRED) {
            InFlightState updateResult = inFlightBatch.startBatchStateTransition(inFlightBatch.lastOffset() < this.startOffset ? RecordState.ARCHIVED : recordState, DeliveryCountOps.DECREASE, this.maxDeliveryCount, EMPTY_MEMBER_ID);
            if (updateResult == null) {
                log.debug("Unable to release records from acquired state for the batch: {} for the share partition: {}-{}", inFlightBatch, this.groupId, this.topicIdPartition);
                return Optional.of(new InvalidRecordStateException("Unable to release acquired records for the batch"));
            }
            updatedStates.add(updateResult);
            stateBatches.add(new PersisterStateBatch(inFlightBatch.firstOffset(), inFlightBatch.lastOffset(), updateResult.state().id(), (short)updateResult.deliveryCount()));
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCacheAndOffsets(long logStartOffset) {
        log.debug("Updating cached states for share partition: {}-{} with new log start offset: {}", this.groupId, this.topicIdPartition, logStartOffset);
        this.lock.writeLock().lock();
        try {
            if (logStartOffset <= this.startOffset) {
                log.error("The log start offset: {} is not greater than the start offset: {} for the share partition: {}-{}", logStartOffset, this.startOffset, this.groupId, this.topicIdPartition);
                return;
            }
            log.debug("Updating start offset for share partition: {}-{} from: {} to: {} since LSO has moved to: {}", this.groupId, this.topicIdPartition, this.startOffset, logStartOffset, logStartOffset);
            if (this.cachedState.isEmpty()) {
                this.startOffset = logStartOffset;
                this.endOffset = logStartOffset;
                return;
            }
            boolean anyRecordArchived = this.archiveAvailableRecordsOnLsoMovement(logStartOffset);
            if (anyRecordArchived) {
                this.updateFindNextFetchOffset(true);
            }
            this.startOffset = logStartOffset;
            if (this.endOffset < this.startOffset) {
                this.endOffset = this.startOffset;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeArchiveStaleBatches(long fetchOffset, long baseOffset) {
        this.lock.writeLock().lock();
        try {
            NavigableMap<Long, InFlightBatch> subMap;
            if (this.cachedState.isEmpty() || fetchOffset >= baseOffset) {
                return;
            }
            long floorOffset = fetchOffset;
            Map.Entry<Long, InFlightBatch> floorEntry = this.cachedState.floorEntry(fetchOffset);
            if (floorEntry != null && floorEntry.getValue().lastOffset() >= fetchOffset) {
                floorOffset = floorEntry.getKey();
            }
            if ((subMap = this.cachedState.subMap(floorOffset, true, baseOffset, false)).isEmpty()) {
                return;
            }
            boolean anyRecordArchived = this.archiveRecords(fetchOffset, baseOffset, subMap, RecordState.AVAILABLE);
            if (anyRecordArchived) {
                this.updateFindNextFetchOffset(true);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean archiveAvailableRecordsOnLsoMovement(long logStartOffset) {
        this.lock.writeLock().lock();
        try {
            boolean bl = this.archiveRecords(this.startOffset, logStartOffset, this.cachedState, RecordState.AVAILABLE);
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean archiveRecords(long startOffset, long endOffset, NavigableMap<Long, InFlightBatch> map, RecordState initialState) {
        this.lock.writeLock().lock();
        try {
            Map.Entry entry;
            long batchStartOffset;
            boolean isAnyOffsetArchived = false;
            boolean isAnyBatchArchived = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext() && (batchStartOffset = ((Long)(entry = iterator.next()).getKey()).longValue()) < endOffset) {
                InFlightBatch inFlightBatch = (InFlightBatch)entry.getValue();
                boolean fullMatch = this.checkForFullMatch(inFlightBatch, startOffset, endOffset - 1L);
                if (!fullMatch || inFlightBatch.offsetState() != null) {
                    log.debug("Subset or offset tracked batch record found while trying to update offsets and cached state map, batch: {}, offsets to update - first: {}, last: {} for the share partition: {}-{}", inFlightBatch, startOffset, endOffset - 1L, this.groupId, this.topicIdPartition);
                    if (inFlightBatch.offsetState() == null) {
                        if (inFlightBatch.batchState() != initialState) continue;
                        inFlightBatch.maybeInitializeOffsetStateUpdate();
                    }
                    isAnyOffsetArchived = this.archivePerOffsetBatchRecords(inFlightBatch, startOffset, endOffset - 1L, initialState) || isAnyOffsetArchived;
                    continue;
                }
                isAnyBatchArchived = this.archiveCompleteBatch(inFlightBatch, initialState) || isAnyBatchArchived;
            }
            boolean bl = isAnyOffsetArchived || isAnyBatchArchived;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean archivePerOffsetBatchRecords(InFlightBatch inFlightBatch, long startOffsetToArchive, long endOffsetToArchive, RecordState initialState) {
        this.lock.writeLock().lock();
        try {
            boolean isAnyOffsetArchived = false;
            log.trace("Archiving offset tracked batch: {} for the share partition: {}-{}", inFlightBatch, this.groupId, this.topicIdPartition);
            for (Map.Entry offsetState : inFlightBatch.offsetState().entrySet()) {
                if ((Long)offsetState.getKey() < startOffsetToArchive) continue;
                if ((Long)offsetState.getKey() > endOffsetToArchive) break;
                if (((InFlightState)offsetState.getValue()).state() != initialState) continue;
                ((InFlightState)offsetState.getValue()).archive();
                isAnyOffsetArchived = true;
            }
            boolean bl = isAnyOffsetArchived;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean archiveCompleteBatch(InFlightBatch inFlightBatch, RecordState initialState) {
        this.lock.writeLock().lock();
        try {
            log.trace("Archiving complete batch: {} for the share partition: {}-{}", inFlightBatch, this.groupId, this.topicIdPartition);
            if (inFlightBatch.batchState() == initialState) {
                inFlightBatch.archiveBatch();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return false;
    }

    boolean canAcquireRecords() {
        if (this.nextFetchOffset() != this.endOffset() + 1L) {
            return true;
        }
        return this.numInFlightRecords() < this.maxInFlightMessages;
    }

    public boolean maybeAcquireFetchLock(Uuid fetchId) {
        if (this.stateNotActive()) {
            return false;
        }
        boolean acquired = this.fetchLock.compareAndSet(null, Objects.requireNonNull(fetchId));
        if (acquired) {
            long currentTime;
            this.fetchLockAcquiredTimeMs = currentTime = this.time.hiResClockMs();
            this.fetchLockIdleDurationMs = this.fetchLockReleasedTimeMs != 0L ? currentTime - this.fetchLockReleasedTimeMs : 0L;
        }
        return acquired;
    }

    void releaseFetchLock(Uuid fetchId) {
        long currentTime = this.time.hiResClockMs();
        if (!this.fetchLock.compareAndSet(Objects.requireNonNull(fetchId), null)) {
            Uuid fetchLockAcquiredBy = this.fetchLock.getAndSet(null);
            log.info("Instance {} does not hold the fetch lock, yet trying to release it for share partition {}-{}. The lock was held by {}", fetchId, this.groupId, this.topicIdPartition, fetchLockAcquiredBy);
        }
        long acquiredDurationMs = currentTime - this.fetchLockAcquiredTimeMs;
        this.sharePartitionMetrics.recordFetchLockTimeMs(acquiredDurationMs);
        this.recordFetchLockRatioMetric(acquiredDurationMs);
        this.fetchLockReleasedTimeMs = currentTime;
    }

    void markFenced() {
        this.lock.writeLock().lock();
        try {
            this.partitionState = SharePartitionState.FENCED;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    SharePartitionManager.SharePartitionListener listener() {
        return this.listener;
    }

    int leaderEpoch() {
        return this.leaderEpoch;
    }

    void recordFetchLockRatioMetric(long acquiredDurationMs) {
        if (this.fetchLockIdleDurationMs < 0L) {
            return;
        }
        double fetchLockToTotalTime = acquiredDurationMs + this.fetchLockIdleDurationMs == 0L ? 1.0 : (acquiredDurationMs == 0L ? 1.0 / (double)this.fetchLockIdleDurationMs : (double)acquiredDurationMs * (1.0 / (double)(acquiredDurationMs + this.fetchLockIdleDurationMs)));
        this.sharePartitionMetrics.recordFetchLockRatio((int)(fetchLockToTotalTime * 100.0));
    }

    private void registerGaugeMetrics() {
        this.sharePartitionMetrics.registerInFlightMessageCount(this::numInFlightRecords);
        this.sharePartitionMetrics.registerInFlightBatchCount(this.cachedState::size);
    }

    private int numInFlightRecords() {
        int numRecords;
        this.lock.readLock().lock();
        try {
            numRecords = this.cachedState.isEmpty() ? 0 : (int)(this.endOffset - this.startOffset + 1L);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return numRecords;
    }

    private boolean stateNotActive() {
        return this.partitionState() != SharePartitionState.ACTIVE;
    }

    private boolean emptyToInitialState() {
        this.lock.writeLock().lock();
        try {
            if (this.initializedOrThrowException()) {
                boolean bl = false;
                return bl;
            }
            this.partitionState = SharePartitionState.INITIALIZING;
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean initializedOrThrowException() {
        SharePartitionState currentState = this.partitionState();
        return switch (currentState.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 2 -> true;
            case 3 -> throw new IllegalStateException(String.format("Share partition failed to load %s-%s", this.groupId, this.topicIdPartition));
            case 1 -> throw new LeaderNotAvailableException(String.format("Share partition is already initializing %s-%s", this.groupId, this.topicIdPartition));
            case 4 -> throw new LeaderNotAvailableException(String.format("Share partition is fenced %s-%s", this.groupId, this.topicIdPartition));
            case 0 -> false;
        };
    }

    private void maybeUpdatePersisterGapWindowStartOffset(long offset) {
        this.lock.writeLock().lock();
        try {
            if (this.persisterReadResultGapWindow != null) {
                if (this.persisterReadResultGapWindow.endOffset() == this.endOffset && offset <= this.persisterReadResultGapWindow.endOffset()) {
                    this.persisterReadResultGapWindow.gapStartOffset(offset);
                } else {
                    this.persisterReadResultGapWindow = null;
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LastOffsetAndMaxRecords lastOffsetAndMaxRecordsToAcquire(long fetchOffset, int maxFetchRecords, long lastOffset) {
        int maxRecordsToAcquire;
        long lastOffsetToAcquire = lastOffset;
        this.lock.readLock().lock();
        try {
            int inFlightRecordsCount = this.numInFlightRecords();
            maxRecordsToAcquire = Math.min(maxFetchRecords, this.maxInFlightMessages - inFlightRecordsCount);
            if (maxRecordsToAcquire <= 0) {
                if (fetchOffset <= this.endOffset()) {
                    maxRecordsToAcquire = Math.min(maxFetchRecords, (int)(this.endOffset() - fetchOffset + 1L));
                    lastOffsetToAcquire = this.endOffset();
                } else {
                    log.debug("Share partition {}-{} has reached max in-flight messages limit: {}. Cannot acquire more records, inflight records count: {}", this.groupId, this.topicIdPartition, this.maxInFlightMessages, inFlightRecordsCount);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return new LastOffsetAndMaxRecords(lastOffsetToAcquire, maxRecordsToAcquire);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShareAcquiredRecords acquireNewBatchRecords(String memberId, Iterable<? extends RecordBatch> batches, long firstOffset, long lastOffset, int batchSize, int maxFetchRecords) {
        this.lock.writeLock().lock();
        try {
            long lastAcquiredOffset;
            long firstAcquiredOffset = firstOffset;
            if (this.cachedState.isEmpty() && this.endOffset > firstAcquiredOffset) {
                firstAcquiredOffset = this.endOffset;
            }
            if ((long)maxFetchRecords < (lastAcquiredOffset = lastOffset) - firstAcquiredOffset + 1L) {
                lastAcquiredOffset = this.lastOffsetFromBatchWithRequestOffset(batches, firstAcquiredOffset + (long)maxFetchRecords - 1L);
                if (this.isPersisterReadGapWindowActive() && lastAcquiredOffset > lastOffset) {
                    lastAcquiredOffset = lastOffset;
                }
            }
            List<ShareFetchResponseData.AcquiredRecords> acquiredRecords = this.createBatches(memberId, batches, firstAcquiredOffset, lastAcquiredOffset, batchSize);
            if ((Long)this.cachedState.firstKey() == firstAcquiredOffset) {
                this.startOffset = firstAcquiredOffset;
            }
            if (lastAcquiredOffset > this.endOffset) {
                this.endOffset = lastAcquiredOffset;
            }
            this.maybeUpdatePersisterGapWindowStartOffset(lastAcquiredOffset + 1L);
            ShareAcquiredRecords shareAcquiredRecords = new ShareAcquiredRecords(acquiredRecords, (int)(lastAcquiredOffset - firstAcquiredOffset + 1L));
            return shareAcquiredRecords;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ShareFetchResponseData.AcquiredRecords> createBatches(String memberId, Iterable<? extends RecordBatch> batches, long firstAcquiredOffset, long lastAcquiredOffset, int batchSize) {
        this.lock.writeLock().lock();
        try {
            Object object;
            ArrayList<ShareFetchResponseData.AcquiredRecords> result = new ArrayList<ShareFetchResponseData.AcquiredRecords>();
            long currentFirstOffset = firstAcquiredOffset;
            if (lastAcquiredOffset - firstAcquiredOffset + 1L > (long)batchSize) {
                RecordBatch batch;
                long batchBaseOffset;
                object = batches.iterator();
                while (object.hasNext() && (batchBaseOffset = (batch = object.next()).baseOffset()) <= lastAcquiredOffset) {
                    if (batchBaseOffset - currentFirstOffset < (long)batchSize) continue;
                    result.add(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(currentFirstOffset).setLastOffset(batchBaseOffset - 1L).setDeliveryCount((short)1));
                    currentFirstOffset = batchBaseOffset;
                }
            }
            result.add(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(currentFirstOffset).setLastOffset(lastAcquiredOffset).setDeliveryCount((short)1));
            result.forEach(acquiredRecords -> {
                AcquisitionLockTimerTask timerTask = this.scheduleAcquisitionLockTimeout(memberId, acquiredRecords.firstOffset(), acquiredRecords.lastOffset());
                this.cachedState.put(acquiredRecords.firstOffset(), new InFlightBatch(this.timer, this.time, memberId, acquiredRecords.firstOffset(), acquiredRecords.lastOffset(), RecordState.ACQUIRED, 1, timerTask, this.timeoutHandler, this.sharePartitionMetrics));
                this.sharePartitionMetrics.recordInFlightBatchMessageCount(acquiredRecords.lastOffset() - acquiredRecords.firstOffset() + 1L);
            });
            object = result;
            return object;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int acquireSubsetBatchRecords(String memberId, long requestFirstOffset, long requestLastOffset, InFlightBatch inFlightBatch, List<ShareFetchResponseData.AcquiredRecords> result) {
        this.lock.writeLock().lock();
        int acquiredCount = 0;
        try {
            for (Map.Entry offsetState : inFlightBatch.offsetState().entrySet()) {
                if ((Long)offsetState.getKey() < requestFirstOffset) continue;
                if ((Long)offsetState.getKey() > requestLastOffset) {
                    break;
                }
                if (((InFlightState)offsetState.getValue()).state() != RecordState.AVAILABLE || ((InFlightState)offsetState.getValue()).hasOngoingStateTransition()) {
                    log.trace("The offset {} is not available in share partition: {}-{}, skipping: {}", offsetState.getKey(), this.groupId, this.topicIdPartition, inFlightBatch);
                    continue;
                }
                InFlightState updateResult = ((InFlightState)offsetState.getValue()).tryUpdateState(RecordState.ACQUIRED, DeliveryCountOps.INCREASE, this.maxDeliveryCount, memberId);
                if (updateResult == null || updateResult.state() != RecordState.ACQUIRED) {
                    log.trace("Unable to acquire records for the offset: {} in batch: {} for the share partition: {}-{}", offsetState.getKey(), inFlightBatch, this.groupId, this.topicIdPartition);
                    continue;
                }
                AcquisitionLockTimerTask acquisitionLockTimeoutTask = this.scheduleAcquisitionLockTimeout(memberId, (Long)offsetState.getKey(), (Long)offsetState.getKey());
                ((InFlightState)offsetState.getValue()).updateAcquisitionLockTimeoutTask(acquisitionLockTimeoutTask);
                result.add(new ShareFetchResponseData.AcquiredRecords().setFirstOffset((Long)offsetState.getKey()).setLastOffset((Long)offsetState.getKey()).setDeliveryCount((short)((InFlightState)offsetState.getValue()).deliveryCount()));
                ++acquiredCount;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return acquiredCount;
    }

    private boolean checkForFullMatch(InFlightBatch inFlightBatch, long firstOffsetToCompare, long lastOffsetToCompare) {
        return inFlightBatch.firstOffset() >= firstOffsetToCompare && inFlightBatch.lastOffset() <= lastOffsetToCompare;
    }

    private boolean checkForStartOffsetWithinBatch(long batchFirstOffset, long batchLastOffset) {
        long localStartOffset = this.startOffset();
        return batchFirstOffset < localStartOffset && batchLastOffset >= localStartOffset;
    }

    private Map<Long, RecordState> fetchRecordStateMapForAcknowledgementBatch(ShareAcknowledgementBatch batch) {
        HashMap<Long, RecordState> recordStateMap = new HashMap<Long, RecordState>();
        for (int index = 0; index < batch.acknowledgeTypes().size(); ++index) {
            recordStateMap.put(batch.firstOffset() + (long)index, SharePartition.fetchRecordState(batch.acknowledgeTypes().get(index)));
        }
        return recordStateMap;
    }

    private static RecordState fetchRecordState(byte acknowledgeType) {
        return switch (acknowledgeType) {
            case 1 -> RecordState.ACKNOWLEDGED;
            case 2 -> RecordState.AVAILABLE;
            case 0, 3 -> RecordState.ARCHIVED;
            default -> throw new IllegalArgumentException("Invalid acknowledge type: " + acknowledgeType);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NavigableMap<Long, InFlightBatch> fetchSubMapForAcknowledgementBatch(ShareAcknowledgementBatch batch) {
        this.lock.writeLock().lock();
        try {
            NavigableMap<Long, InFlightBatch> subMap;
            Map.Entry<Long, InFlightBatch> floorOffset = this.cachedState.floorEntry(batch.firstOffset());
            if (floorOffset == null) {
                boolean hasStartOffsetMoved = this.checkForStartOffsetWithinBatch(batch.firstOffset(), batch.lastOffset());
                if (hasStartOffsetMoved) {
                    floorOffset = this.cachedState.floorEntry(this.startOffset);
                } else {
                    log.debug("Batch record {} not found for share partition: {}-{}", batch, this.groupId, this.topicIdPartition);
                    throw new InvalidRecordStateException("Batch record not found. The request batch offsets are not found in the cache.");
                }
            }
            if ((subMap = this.cachedState.subMap(floorOffset.getKey(), true, batch.lastOffset(), true)).lastEntry().getValue().lastOffset() < batch.firstOffset()) {
                log.debug("Request batch: {} has offsets which are not found for share partition: {}-{}", batch, this.groupId, this.topicIdPartition);
                throw new InvalidRequestException("Batch record not found. The first offset in request is past acquired records.");
            }
            if (batch.lastOffset() > subMap.lastEntry().getValue().lastOffset()) {
                log.debug("Request batch: {} has offsets which are not found for share partition: {}-{}", batch, this.groupId, this.topicIdPartition);
                throw new InvalidRequestException("Batch record not found. The last offset in request is past acquired records.");
            }
            NavigableMap<Long, InFlightBatch> navigableMap = subMap;
            return navigableMap;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Throwable> acknowledgeBatchRecords(String memberId, ShareAcknowledgementBatch batch, Map<Long, RecordState> recordStateMap, NavigableMap<Long, InFlightBatch> subMap, List<InFlightState> updatedStates, List<PersisterStateBatch> stateBatches) {
        this.lock.writeLock().lock();
        try {
            for (Map.Entry entry : subMap.entrySet()) {
                Optional<Throwable> throwable;
                InFlightBatch inFlightBatch = (InFlightBatch)entry.getValue();
                if (inFlightBatch.lastOffset() < this.startOffset) {
                    log.trace("All offsets in the inflight batch {} are already archived: {}-{}", inFlightBatch, this.groupId, this.topicIdPartition);
                    continue;
                }
                if (inFlightBatch.offsetState() == null) {
                    throwable = this.validateAcknowledgementBatchMemberId(memberId, inFlightBatch);
                    if (throwable.isPresent()) {
                        Optional<Throwable> optional = throwable;
                        return optional;
                    }
                    if (inFlightBatch.batchHasOngoingStateTransition()) {
                        log.debug("The batch has on-going transition, batch: {} for the share partition: {}-{}", inFlightBatch, this.groupId, this.topicIdPartition);
                        Optional<Throwable> optional = Optional.of(new InvalidRecordStateException("The record state is invalid. The acknowledgement of delivery could not be completed."));
                        return optional;
                    }
                }
                boolean fullMatch = this.checkForFullMatch(inFlightBatch, batch.firstOffset(), batch.lastOffset());
                boolean isPerOffsetClientAck = batch.acknowledgeTypes().size() > 1;
                boolean hasStartOffsetMoved = this.checkForStartOffsetWithinBatch(inFlightBatch.firstOffset(), inFlightBatch.lastOffset());
                if (!fullMatch || inFlightBatch.offsetState() != null || isPerOffsetClientAck || hasStartOffsetMoved) {
                    log.debug("Subset or offset tracked batch record found for acknowledgement, batch: {}, request offsets - first: {}, last: {}, client per offsetstate {} for the share partition: {}-{}", inFlightBatch, batch.firstOffset(), batch.lastOffset(), isPerOffsetClientAck, this.groupId, this.topicIdPartition);
                    if (inFlightBatch.offsetState() == null) {
                        if (inFlightBatch.batchState() != RecordState.ACQUIRED) {
                            log.debug("The batch is not in the acquired state: {} for share partition: {}-{}", inFlightBatch, this.groupId, this.topicIdPartition);
                            Optional<Throwable> optional = Optional.of(new InvalidRecordStateException("The batch cannot be acknowledged. The subset batch is not in the acquired state."));
                            return optional;
                        }
                        inFlightBatch.maybeInitializeOffsetStateUpdate();
                    }
                    throwable = this.acknowledgePerOffsetBatchRecords(memberId, batch, inFlightBatch, recordStateMap, updatedStates, stateBatches);
                } else {
                    throwable = this.acknowledgeCompleteBatch(batch, inFlightBatch, recordStateMap.get(batch.firstOffset()), updatedStates, stateBatches);
                }
                if (!throwable.isPresent()) continue;
                Optional<Throwable> optional = throwable;
                return optional;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return Optional.empty();
    }

    private Optional<Throwable> validateAcknowledgementBatchMemberId(String memberId, InFlightBatch inFlightBatch) {
        if (inFlightBatch.batchMemberId().equals(EMPTY_MEMBER_ID)) {
            log.debug("The batch is not in the acquired state: {} for share partition: {}-{}. Empty member id for batch.", inFlightBatch, this.groupId, this.topicIdPartition);
            return Optional.of(new InvalidRecordStateException("The batch cannot be acknowledged. The batch is not in the acquired state."));
        }
        if (!inFlightBatch.batchMemberId().equals(memberId)) {
            log.debug("Member {} is not the owner of batch record {} for share partition: {}-{}", memberId, inFlightBatch, this.groupId, this.topicIdPartition);
            return Optional.of(new InvalidRecordStateException("Member is not the owner of batch record"));
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Throwable> acknowledgePerOffsetBatchRecords(String memberId, ShareAcknowledgementBatch batch, InFlightBatch inFlightBatch, Map<Long, RecordState> recordStateMap, List<InFlightState> updatedStates, List<PersisterStateBatch> stateBatches) {
        this.lock.writeLock().lock();
        try {
            RecordState recordStateDefault = recordStateMap.get(batch.firstOffset());
            for (Map.Entry offsetState : inFlightBatch.offsetState().entrySet()) {
                Optional<Throwable> optional;
                if ((Long)offsetState.getKey() < batch.firstOffset() || (Long)offsetState.getKey() < this.startOffset) continue;
                if ((Long)offsetState.getKey() > batch.lastOffset()) {
                    break;
                }
                if (((InFlightState)offsetState.getValue()).state() != RecordState.ACQUIRED) {
                    log.debug("The offset is not acquired, offset: {} batch: {} for the share partition: {}-{}", offsetState.getKey(), inFlightBatch, this.groupId, this.topicIdPartition);
                    optional = Optional.of(new InvalidRecordStateException("The offset cannot be acknowledged. The offset is not acquired."));
                    return optional;
                }
                if (((InFlightState)offsetState.getValue()).hasOngoingStateTransition()) {
                    log.debug("The offset has on-going transition, offset: {} batch: {} for the share partition: {}-{}", offsetState.getKey(), inFlightBatch, this.groupId, this.topicIdPartition);
                    optional = Optional.of(new InvalidRecordStateException("The record state is invalid. The acknowledgement of delivery could not be completed."));
                    return optional;
                }
                if (!((InFlightState)offsetState.getValue()).memberId().equals(memberId)) {
                    log.debug("Member {} is not the owner of offset: {} in batch: {} for the share partition: {}-{}", memberId, offsetState.getKey(), inFlightBatch, this.groupId, this.topicIdPartition);
                    optional = Optional.of(new InvalidRecordStateException("Member is not the owner of offset"));
                    return optional;
                }
                RecordState recordState = recordStateMap.size() > 1 ? recordStateMap.get(offsetState.getKey()) : recordStateDefault;
                InFlightState updateResult = ((InFlightState)offsetState.getValue()).startStateTransition(recordState, DeliveryCountOps.NO_OP, this.maxDeliveryCount, EMPTY_MEMBER_ID);
                if (updateResult == null) {
                    log.debug("Unable to acknowledge records for the offset: {} in batch: {} for the share partition: {}-{}", offsetState.getKey(), inFlightBatch, this.groupId, this.topicIdPartition);
                    Optional<Throwable> optional2 = Optional.of(new InvalidRecordStateException("Unable to acknowledge records for the batch"));
                    return optional2;
                }
                updatedStates.add(updateResult);
                stateBatches.add(new PersisterStateBatch((Long)offsetState.getKey(), (Long)offsetState.getKey(), updateResult.state().id(), (short)updateResult.deliveryCount()));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Throwable> acknowledgeCompleteBatch(ShareAcknowledgementBatch batch, InFlightBatch inFlightBatch, RecordState recordState, List<InFlightState> updatedStates, List<PersisterStateBatch> stateBatches) {
        this.lock.writeLock().lock();
        try {
            log.trace("Acknowledging complete batch record {} for the share partition: {}-{}", batch, this.groupId, this.topicIdPartition);
            if (inFlightBatch.batchState() != RecordState.ACQUIRED) {
                log.debug("The batch is not in the acquired state: {} for share partition: {}-{}", inFlightBatch, this.groupId, this.topicIdPartition);
                Optional<Throwable> optional = Optional.of(new InvalidRecordStateException("The batch cannot be acknowledged. The batch is not in the acquired state."));
                return optional;
            }
            InFlightState updateResult = inFlightBatch.startBatchStateTransition(recordState, DeliveryCountOps.NO_OP, this.maxDeliveryCount, EMPTY_MEMBER_ID);
            if (updateResult == null) {
                log.debug("Unable to acknowledge records for the batch: {} with state: {} for the share partition: {}-{}", new Object[]{inFlightBatch, recordState, this.groupId, this.topicIdPartition});
                Optional<Throwable> optional = Optional.of(new InvalidRecordStateException("Unable to acknowledge records for the batch"));
                return optional;
            }
            updatedStates.add(updateResult);
            stateBatches.add(new PersisterStateBatch(inFlightBatch.firstOffset(), inFlightBatch.lastOffset(), updateResult.state().id(), (short)updateResult.deliveryCount()));
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFetchOffsetMetadata(long nextFetchOffset, LogOffsetMetadata logOffsetMetadata) {
        this.lock.writeLock().lock();
        try {
            this.fetchOffsetMetadata.updateOffsetMetadata(nextFetchOffset, logOffsetMetadata);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<LogOffsetMetadata> fetchOffsetMetadata(long nextFetchOffset) {
        this.lock.readLock().lock();
        try {
            if (this.fetchOffsetMetadata.offsetMetadata() == null || this.fetchOffsetMetadata.offset() != nextFetchOffset) {
                Optional<LogOffsetMetadata> optional = Optional.empty();
                return optional;
            }
            Optional<LogOffsetMetadata> optional = Optional.of(this.fetchOffsetMetadata.offsetMetadata());
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    SharePartitionState partitionState() {
        this.lock.readLock().lock();
        try {
            SharePartitionState sharePartitionState = this.partitionState;
            return sharePartitionState;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackOrProcessStateUpdates(CompletableFuture<Void> future, Throwable throwable, List<InFlightState> updatedStates, List<PersisterStateBatch> stateBatches) {
        this.lock.writeLock().lock();
        try {
            if (throwable != null) {
                log.debug("Request failed for updating state, rollback any changed state for the share partition: {}-{}", (Object)this.groupId, (Object)this.topicIdPartition);
                updatedStates.forEach(state -> {
                    state.completeStateTransition(false);
                    if (state.state() == RecordState.AVAILABLE) {
                        this.updateFindNextFetchOffset(true);
                    }
                });
                future.completeExceptionally(throwable);
                return;
            }
            if (stateBatches.isEmpty() && updatedStates.isEmpty()) {
                future.complete(null);
                return;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.writeShareGroupState(stateBatches).whenComplete((result, exception) -> {
            boolean cacheStateUpdated = false;
            this.lock.writeLock().lock();
            try {
                if (exception != null) {
                    log.debug("Failed to write state to persister for the share partition: {}-{}", this.groupId, this.topicIdPartition, exception);
                    updatedStates.forEach(state -> {
                        state.completeStateTransition(false);
                        if (state.state() == RecordState.AVAILABLE) {
                            this.updateFindNextFetchOffset(true);
                        }
                    });
                    future.completeExceptionally((Throwable)exception);
                    return;
                }
                log.trace("State change request successful for share partition: {}-{}", (Object)this.groupId, (Object)this.topicIdPartition);
                updatedStates.forEach(state -> {
                    state.completeStateTransition(true);
                    if (state.state() == RecordState.AVAILABLE) {
                        this.updateFindNextFetchOffset(true);
                    }
                });
                cacheStateUpdated = this.maybeUpdateCachedStateAndOffsets();
                future.complete(null);
            }
            finally {
                this.lock.writeLock().unlock();
                this.maybeCompleteDelayedShareFetchRequest(cacheStateUpdated);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybeUpdateCachedStateAndOffsets() {
        this.lock.writeLock().lock();
        try {
            long lastKeyToRemove;
            if (!this.canMoveStartOffset()) {
                boolean bl = false;
                return bl;
            }
            long lastOffsetAcknowledged = this.findLastOffsetAcknowledged();
            if (lastOffsetAcknowledged == -1L) {
                boolean bl = false;
                return bl;
            }
            long lastCachedOffset = this.cachedState.lastEntry().getValue().lastOffset();
            if (lastOffsetAcknowledged == lastCachedOffset) {
                this.startOffset = lastCachedOffset + 1L;
                this.endOffset = lastCachedOffset + 1L;
                this.cachedState.clear();
                boolean bl = true;
                return bl;
            }
            long firstKeyToRemove = (Long)this.cachedState.firstKey();
            Map.Entry<Long, InFlightBatch> entry = this.cachedState.floorEntry(lastOffsetAcknowledged);
            if (lastOffsetAcknowledged == entry.getValue().lastOffset()) {
                this.startOffset = this.cachedState.higherKey(lastOffsetAcknowledged);
                if (this.isPersisterReadGapWindowActive()) {
                    this.startOffset = Math.min(this.persisterReadResultGapWindow.gapStartOffset(), this.startOffset);
                }
                lastKeyToRemove = entry.getKey();
            } else {
                this.startOffset = lastOffsetAcknowledged + 1L;
                lastKeyToRemove = entry.getKey().equals(this.cachedState.firstKey()) ? -1L : this.cachedState.lowerKey(entry.getKey());
            }
            if (lastKeyToRemove != -1L) {
                this.cachedState.subMap(firstKeyToRemove, true, lastKeyToRemove, true).clear();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    boolean canMoveStartOffset() {
        boolean isOngoingTransition;
        if (this.cachedState.isEmpty()) {
            return false;
        }
        Map.Entry<Long, InFlightBatch> entry = this.cachedState.floorEntry(this.startOffset);
        if (entry == null) {
            log.debug("The start offset: {} is not found in the cached state for share partition: {}-{} as there is an acquirable gap at the beginning. Cannot move the start offset.", this.startOffset, this.groupId, this.topicIdPartition);
            return false;
        }
        boolean isBatchState = entry.getValue().offsetState() == null;
        boolean bl = isOngoingTransition = isBatchState ? entry.getValue().batchHasOngoingStateTransition() : ((InFlightState)entry.getValue().offsetState().get(this.startOffset)).hasOngoingStateTransition();
        if (isOngoingTransition) {
            return false;
        }
        RecordState startOffsetState = isBatchState ? entry.getValue().batchState() : ((InFlightState)entry.getValue().offsetState().get(this.startOffset)).state();
        return this.isRecordStateAcknowledged(startOffsetState);
    }

    private boolean isPersisterReadGapWindowActive() {
        return this.persisterReadResultGapWindow != null && this.persisterReadResultGapWindow.endOffset() == this.endOffset;
    }

    private boolean isRecordStateAcknowledged(RecordState recordState) {
        return recordState == RecordState.ACKNOWLEDGED || recordState == RecordState.ARCHIVED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long findLastOffsetAcknowledged() {
        long lastOffsetAcknowledged = -1L;
        this.lock.readLock().lock();
        try {
            for (Map.Entry entry : this.cachedState.entrySet()) {
                InFlightBatch inFlightBatch = (InFlightBatch)entry.getValue();
                if (this.isPersisterReadGapWindowActive() && inFlightBatch.lastOffset() >= this.persisterReadResultGapWindow.gapStartOffset()) {
                    long l = lastOffsetAcknowledged;
                    return l;
                }
                if (inFlightBatch.offsetState() == null) {
                    if (inFlightBatch.batchHasOngoingStateTransition() || !this.isRecordStateAcknowledged(inFlightBatch.batchState())) {
                        long l = lastOffsetAcknowledged;
                        return l;
                    }
                    lastOffsetAcknowledged = inFlightBatch.lastOffset();
                    continue;
                }
                for (Map.Entry offsetState : inFlightBatch.offsetState().entrySet()) {
                    if (((InFlightState)offsetState.getValue()).hasOngoingStateTransition() || !this.isRecordStateAcknowledged(((InFlightState)offsetState.getValue()).state())) {
                        long l = lastOffsetAcknowledged;
                        return l;
                    }
                    lastOffsetAcknowledged = (Long)offsetState.getKey();
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return lastOffsetAcknowledged;
    }

    private long lastOffsetFromBatchWithRequestOffset(Iterable<? extends RecordBatch> batches, long offset) {
        RecordBatch previousBatch = null;
        for (RecordBatch recordBatch : batches) {
            if (offset < recordBatch.baseOffset()) break;
            previousBatch = recordBatch;
        }
        if (previousBatch != null && offset <= previousBatch.lastOffset()) {
            return previousBatch.lastOffset();
        }
        return offset;
    }

    CompletableFuture<Void> writeShareGroupState(List<PersisterStateBatch> stateBatches) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.persister.writeState(new WriteShareGroupStateParameters.Builder().setGroupTopicPartitionData(new GroupTopicPartitionData.Builder().setGroupId(this.groupId).setTopicsData(List.of(new TopicData<PartitionStateBatchData>(this.topicIdPartition.topicId(), List.of(PartitionFactory.newPartitionStateBatchData(this.topicIdPartition.partition(), this.stateEpoch, this.startOffset(), this.leaderEpoch, stateBatches))))).build()).build()).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to write the share group state for share partition: {}-{}", this.groupId, this.topicIdPartition, exception);
                future.completeExceptionally(new IllegalStateException(String.format("Failed to write the share group state for share partition %s-%s", this.groupId, this.topicIdPartition), (Throwable)exception));
                return;
            }
            if (result == null || result.topicsData() == null || result.topicsData().size() != 1) {
                log.error("Failed to write the share group state for share partition: {}-{}. Invalid state found: {}", this.groupId, this.topicIdPartition, result);
                future.completeExceptionally(new IllegalStateException(String.format("Failed to write the share group state for share partition %s-%s", this.groupId, this.topicIdPartition)));
                return;
            }
            TopicData<PartitionErrorData> state = result.topicsData().get(0);
            if (state.topicId() != this.topicIdPartition.topicId() || state.partitions().size() != 1 || state.partitions().get(0).partition() != this.topicIdPartition.partition()) {
                log.error("Failed to write the share group state for share partition: {}-{}. Invalid topic partition response: {}", this.groupId, this.topicIdPartition, result);
                future.completeExceptionally(new IllegalStateException(String.format("Failed to write the share group state for share partition %s-%s", this.groupId, this.topicIdPartition)));
                return;
            }
            PartitionErrorData partitionData = state.partitions().get(0);
            if (partitionData.errorCode() != Errors.NONE.code()) {
                KafkaException ex = this.fetchPersisterError(partitionData.errorCode(), partitionData.errorMessage());
                this.maybeLogError(String.format("Failed to write the share group state for share partition: %s-%s due to exception", this.groupId, this.topicIdPartition), Errors.forCode(partitionData.errorCode()), ex);
                future.completeExceptionally(ex);
                return;
            }
            future.complete(null);
        });
        return future;
    }

    private KafkaException fetchPersisterError(short errorCode, String errorMessage) {
        Errors error = Errors.forCode(errorCode);
        return switch (error) {
            case Errors.NOT_COORDINATOR, Errors.COORDINATOR_NOT_AVAILABLE, Errors.COORDINATOR_LOAD_IN_PROGRESS -> new CoordinatorNotAvailableException(errorMessage);
            case Errors.GROUP_ID_NOT_FOUND -> new GroupIdNotFoundException(errorMessage);
            case Errors.UNKNOWN_TOPIC_OR_PARTITION -> new UnknownTopicOrPartitionException(errorMessage);
            case Errors.FENCED_LEADER_EPOCH, Errors.FENCED_STATE_EPOCH -> new NotLeaderOrFollowerException(errorMessage);
            default -> new UnknownServerException(errorMessage);
        };
    }

    AcquisitionLockTimerTask scheduleAcquisitionLockTimeout(String memberId, long firstOffset, long lastOffset) {
        int recordLockDurationMs = ShareFetchUtils.recordLockDurationMsOrDefault(this.groupConfigManager, this.groupId, this.defaultRecordLockDurationMs);
        return this.scheduleAcquisitionLockTimeout(memberId, firstOffset, lastOffset, recordLockDurationMs);
    }

    private AcquisitionLockTimerTask scheduleAcquisitionLockTimeout(String memberId, long firstOffset, long lastOffset, long delayMs) {
        AcquisitionLockTimerTask acquisitionLockTimerTask = this.acquisitionLockTimerTask(memberId, firstOffset, lastOffset, delayMs);
        this.timer.add(acquisitionLockTimerTask);
        return acquisitionLockTimerTask;
    }

    private AcquisitionLockTimerTask acquisitionLockTimerTask(String memberId, long firstOffset, long lastOffset, long delayMs) {
        return new AcquisitionLockTimerTask(this.time, delayMs, memberId, firstOffset, lastOffset, this.releaseAcquisitionLockOnTimeout(), this.sharePartitionMetrics);
    }

    private AcquisitionLockTimeoutHandler releaseAcquisitionLockOnTimeout() {
        return (memberId, firstOffset, lastOffset, timerTask) -> {
            ArrayList<PersisterStateBatch> stateBatches;
            this.lock.writeLock().lock();
            try {
                if (timerTask.isCancelled()) {
                    log.debug("Timer task is already cancelled, not executing further.");
                    return;
                }
                Map.Entry<Long, InFlightBatch> floorOffset = this.cachedState.floorEntry(firstOffset);
                if (floorOffset == null) {
                    log.error("Base offset {} not found for share partition: {}-{}", firstOffset, this.groupId, this.topicIdPartition);
                    return;
                }
                stateBatches = new ArrayList<PersisterStateBatch>();
                NavigableMap<Long, InFlightBatch> subMap = this.cachedState.subMap(floorOffset.getKey(), true, lastOffset, true);
                for (Map.Entry entry : subMap.entrySet()) {
                    InFlightBatch inFlightBatch = (InFlightBatch)entry.getValue();
                    if (inFlightBatch.offsetState() == null && inFlightBatch.batchState() == RecordState.ACQUIRED && this.checkForStartOffsetWithinBatch(inFlightBatch.firstOffset(), inFlightBatch.lastOffset())) {
                        inFlightBatch.maybeInitializeOffsetStateUpdate();
                    }
                    if (inFlightBatch.offsetState() == null) {
                        this.releaseAcquisitionLockOnTimeoutForCompleteBatch(inFlightBatch, stateBatches, memberId);
                        continue;
                    }
                    this.releaseAcquisitionLockOnTimeoutForPerOffsetBatch(inFlightBatch, stateBatches, memberId, firstOffset, lastOffset);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
            if (!stateBatches.isEmpty()) {
                this.writeShareGroupState(stateBatches).whenComplete((result, exception) -> {
                    if (exception != null) {
                        log.debug("Failed to write the share group state on acquisition lock timeout for share partition: {}-{} memberId: {}", this.groupId, this.topicIdPartition, memberId, exception);
                    }
                    this.maybeUpdateCachedStateAndOffsets();
                });
            }
            this.maybeCompleteDelayedShareFetchRequest(!stateBatches.isEmpty());
        };
    }

    private void releaseAcquisitionLockOnTimeoutForCompleteBatch(InFlightBatch inFlightBatch, List<PersisterStateBatch> stateBatches, String memberId) {
        if (inFlightBatch.batchState() == RecordState.ACQUIRED) {
            InFlightState updateResult = inFlightBatch.tryUpdateBatchState(inFlightBatch.lastOffset() < this.startOffset ? RecordState.ARCHIVED : RecordState.AVAILABLE, DeliveryCountOps.NO_OP, this.maxDeliveryCount, EMPTY_MEMBER_ID);
            if (updateResult == null) {
                log.error("Unable to release acquisition lock on timeout for the batch: {} for the share partition: {}-{} memberId: {}", inFlightBatch, this.groupId, this.topicIdPartition, memberId);
                return;
            }
            stateBatches.add(new PersisterStateBatch(inFlightBatch.firstOffset(), inFlightBatch.lastOffset(), updateResult.state().id(), (short)updateResult.deliveryCount()));
            updateResult.cancelAndClearAcquisitionLockTimeoutTask();
            if (updateResult.state() != RecordState.ARCHIVED) {
                this.updateFindNextFetchOffset(true);
            }
            return;
        }
        log.debug("The batch is not in acquired state while release of acquisition lock on timeout, skipping, batch: {} for the share partition: {}-{} memberId: {}", inFlightBatch, this.groupId, this.topicIdPartition, memberId);
    }

    private void releaseAcquisitionLockOnTimeoutForPerOffsetBatch(InFlightBatch inFlightBatch, List<PersisterStateBatch> stateBatches, String memberId, long firstOffset, long lastOffset) {
        for (Map.Entry offsetState : inFlightBatch.offsetState().entrySet()) {
            if ((Long)offsetState.getKey() < firstOffset) continue;
            if ((Long)offsetState.getKey() > lastOffset) break;
            if (((InFlightState)offsetState.getValue()).state() != RecordState.ACQUIRED) {
                log.debug("The offset is not in acquired state while release of acquisition lock on timeout, skipping, offset: {} batch: {} for the share partition: {}-{} memberId: {}", offsetState.getKey(), inFlightBatch, this.groupId, this.topicIdPartition, memberId);
                continue;
            }
            InFlightState updateResult = ((InFlightState)offsetState.getValue()).tryUpdateState((Long)offsetState.getKey() < this.startOffset ? RecordState.ARCHIVED : RecordState.AVAILABLE, DeliveryCountOps.NO_OP, this.maxDeliveryCount, EMPTY_MEMBER_ID);
            if (updateResult == null) {
                log.error("Unable to release acquisition lock on timeout for the offset: {} in batch: {} for the share partition: {}-{} memberId: {}", offsetState.getKey(), inFlightBatch, this.groupId, this.topicIdPartition, memberId);
                continue;
            }
            stateBatches.add(new PersisterStateBatch((Long)offsetState.getKey(), (Long)offsetState.getKey(), updateResult.state().id(), (short)updateResult.deliveryCount()));
            updateResult.cancelAndClearAcquisitionLockTimeoutTask();
            if (updateResult.state() == RecordState.ARCHIVED) continue;
            this.updateFindNextFetchOffset(true);
        }
    }

    private void maybeCompleteDelayedShareFetchRequest(boolean shouldComplete) {
        if (shouldComplete) {
            this.replicaManager.completeDelayedShareFetchRequest(this.delayedShareFetchKey);
        }
    }

    private long startOffsetDuringInitialization(long partitionDataStartOffset) {
        if (partitionDataStartOffset != -1L) {
            return partitionDataStartOffset;
        }
        ShareGroupAutoOffsetResetStrategy offsetResetStrategy = this.groupConfigManager.groupConfig(this.groupId).isPresent() ? this.groupConfigManager.groupConfig(this.groupId).get().shareAutoOffsetReset() : GroupConfig.defaultShareAutoOffsetReset();
        if (offsetResetStrategy.type() == ShareGroupAutoOffsetResetStrategy.StrategyType.LATEST) {
            return ShareFetchUtils.offsetForLatestTimestamp(this.topicIdPartition, this.replicaManager, this.leaderEpoch);
        }
        if (offsetResetStrategy.type() == ShareGroupAutoOffsetResetStrategy.StrategyType.EARLIEST) {
            return ShareFetchUtils.offsetForEarliestTimestamp(this.topicIdPartition, this.replicaManager, this.leaderEpoch);
        }
        return ShareFetchUtils.offsetForTimestamp(this.topicIdPartition, this.replicaManager, offsetResetStrategy.timestamp(), this.leaderEpoch);
    }

    private ShareAcquiredRecords maybeFilterAbortedTransactionalAcquiredRecords(FetchPartitionData fetchPartitionData, FetchIsolation isolationLevel, ShareAcquiredRecords shareAcquiredRecords) {
        if (isolationLevel != FetchIsolation.TXN_COMMITTED || fetchPartitionData.abortedTransactions.isEmpty() || fetchPartitionData.abortedTransactions.get().isEmpty()) {
            return shareAcquiredRecords;
        }
        List<ShareFetchResponseData.AcquiredRecords> result = this.filterAbortedTransactionalAcquiredRecords(fetchPartitionData.records.batches(), shareAcquiredRecords.acquiredRecords(), fetchPartitionData.abortedTransactions.get());
        int acquiredCount = 0;
        for (ShareFetchResponseData.AcquiredRecords records : result) {
            acquiredCount += (int)(records.lastOffset() - records.firstOffset() + 1L);
        }
        return new ShareAcquiredRecords(result, acquiredCount);
    }

    private List<ShareFetchResponseData.AcquiredRecords> filterAbortedTransactionalAcquiredRecords(Iterable<? extends RecordBatch> batches, List<ShareFetchResponseData.AcquiredRecords> acquiredRecords, List<FetchResponseData.AbortedTransaction> abortedTransactions) {
        List<RecordBatch> recordsToArchive = this.fetchAbortedTransactionRecordBatches(batches, abortedTransactions);
        for (RecordBatch recordBatch : recordsToArchive) {
            NavigableMap<Long, InFlightBatch> subMap = this.fetchSubMap(recordBatch);
            this.archiveRecords(recordBatch.baseOffset(), recordBatch.lastOffset() + 1L, subMap, RecordState.ACQUIRED);
        }
        return this.filterRecordBatchesFromAcquiredRecords(acquiredRecords, recordsToArchive);
    }

    private void maybeLogError(String message, Errors receivedError, Throwable wrappedException) {
        if (receivedError == Errors.NETWORK_EXCEPTION) {
            log.debug(message, wrappedException);
        } else {
            log.error(message, wrappedException);
        }
    }

    List<ShareFetchResponseData.AcquiredRecords> filterRecordBatchesFromAcquiredRecords(List<ShareFetchResponseData.AcquiredRecords> acquiredRecordsList, List<RecordBatch> batchesToArchive) {
        Iterator<RecordBatch> batchesToArchiveIterator = batchesToArchive.iterator();
        if (!batchesToArchiveIterator.hasNext()) {
            return acquiredRecordsList;
        }
        ArrayList<ShareFetchResponseData.AcquiredRecords> result = new ArrayList<ShareFetchResponseData.AcquiredRecords>();
        Iterator<ShareFetchResponseData.AcquiredRecords> acquiredRecordsListIter = acquiredRecordsList.iterator();
        RecordBatch batchToArchive = batchesToArchiveIterator.next();
        ShareFetchResponseData.AcquiredRecords unresolvedAcquiredRecords = null;
        while (unresolvedAcquiredRecords != null || acquiredRecordsListIter.hasNext()) {
            if (unresolvedAcquiredRecords == null) {
                unresolvedAcquiredRecords = acquiredRecordsListIter.next();
            }
            long unresolvedFirstOffset = unresolvedAcquiredRecords.firstOffset();
            long unresolvedLastOffset = unresolvedAcquiredRecords.lastOffset();
            short unresolvedDeliveryCount = unresolvedAcquiredRecords.deliveryCount();
            if (batchToArchive == null) {
                result.add(unresolvedAcquiredRecords);
                unresolvedAcquiredRecords = null;
                continue;
            }
            if (unresolvedLastOffset < batchToArchive.baseOffset()) {
                result.add(unresolvedAcquiredRecords);
                unresolvedAcquiredRecords = null;
            }
            if (unresolvedFirstOffset <= batchToArchive.lastOffset() && unresolvedLastOffset >= batchToArchive.baseOffset()) {
                unresolvedAcquiredRecords = null;
                if (unresolvedFirstOffset < batchToArchive.baseOffset()) {
                    result.add(new ShareFetchResponseData.AcquiredRecords().setFirstOffset(unresolvedFirstOffset).setLastOffset(batchToArchive.baseOffset() - 1L).setDeliveryCount(unresolvedDeliveryCount));
                }
                if (unresolvedLastOffset > batchToArchive.lastOffset()) {
                    unresolvedAcquiredRecords = new ShareFetchResponseData.AcquiredRecords().setFirstOffset(batchToArchive.lastOffset() + 1L).setLastOffset(unresolvedLastOffset).setDeliveryCount(unresolvedDeliveryCount);
                }
            }
            if (unresolvedLastOffset <= batchToArchive.lastOffset()) continue;
            if (batchesToArchiveIterator.hasNext()) {
                batchToArchive = batchesToArchiveIterator.next();
                continue;
            }
            batchToArchive = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NavigableMap<Long, InFlightBatch> fetchSubMap(RecordBatch recordBatch) {
        this.lock.readLock().lock();
        try {
            Map.Entry<Long, InFlightBatch> floorEntry = this.cachedState.floorEntry(recordBatch.baseOffset());
            if (floorEntry == null) {
                log.debug("Fetched batch record {} not found for share partition: {}-{}", recordBatch, this.groupId, this.topicIdPartition);
                throw new IllegalStateException("Batch record not found. The request batch offsets are not found in the cache.");
            }
            NavigableMap<Long, InFlightBatch> navigableMap = this.cachedState.subMap(floorEntry.getKey(), true, recordBatch.lastOffset(), true);
            return navigableMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    List<RecordBatch> fetchAbortedTransactionRecordBatches(Iterable<? extends RecordBatch> batches, List<FetchResponseData.AbortedTransaction> abortedTransactions) {
        PriorityQueue<FetchResponseData.AbortedTransaction> orderedAbortedTransactions = this.orderedAbortedTransactions(abortedTransactions);
        HashSet<Long> abortedProducerIds = new HashSet<Long>();
        ArrayList<RecordBatch> recordsToArchive = new ArrayList<RecordBatch>();
        for (RecordBatch recordBatch : batches) {
            if (!recordBatch.hasProducerId()) continue;
            while (!orderedAbortedTransactions.isEmpty() && orderedAbortedTransactions.peek().firstOffset() <= recordBatch.lastOffset()) {
                FetchResponseData.AbortedTransaction abortedTransaction = orderedAbortedTransactions.poll();
                abortedProducerIds.add(abortedTransaction.producerId());
            }
            long producerId = recordBatch.producerId();
            if (this.containsAbortMarker(recordBatch)) {
                abortedProducerIds.remove(producerId);
                continue;
            }
            if (!this.isBatchAborted(recordBatch, abortedProducerIds)) continue;
            log.debug("Skipping aborted record batch for share partition: {}-{} with producerId {} and offsets {} to {}", this.groupId, this.topicIdPartition, producerId, recordBatch.baseOffset(), recordBatch.lastOffset());
            recordsToArchive.add(recordBatch);
        }
        return recordsToArchive;
    }

    private PriorityQueue<FetchResponseData.AbortedTransaction> orderedAbortedTransactions(List<FetchResponseData.AbortedTransaction> abortedTransactions) {
        PriorityQueue<FetchResponseData.AbortedTransaction> orderedAbortedTransactions = new PriorityQueue<FetchResponseData.AbortedTransaction>(abortedTransactions.size(), Comparator.comparingLong(FetchResponseData.AbortedTransaction::firstOffset));
        orderedAbortedTransactions.addAll(abortedTransactions);
        return orderedAbortedTransactions;
    }

    private boolean isBatchAborted(RecordBatch batch, Set<Long> abortedProducerIds) {
        return batch.isTransactional() && abortedProducerIds.contains(batch.producerId());
    }

    boolean containsAbortMarker(RecordBatch batch) {
        if (!batch.isControlBatch()) {
            return false;
        }
        Iterator batchIterator = batch.iterator();
        if (!batchIterator.hasNext()) {
            return false;
        }
        Record firstRecord = (Record)batchIterator.next();
        return ControlRecordType.ABORT == ControlRecordType.parse(firstRecord.key());
    }

    NavigableMap<Long, InFlightBatch> cachedState() {
        return new ConcurrentSkipListMap<Long, InFlightBatch>((SortedMap<Long, InFlightBatch>)this.cachedState);
    }

    boolean findNextFetchOffset() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.findNextFetchOffset;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    void updateFindNextFetchOffset(boolean value) {
        this.lock.writeLock().lock();
        try {
            this.findNextFetchOffset = value;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    long startOffset() {
        this.lock.readLock().lock();
        try {
            long l = this.startOffset;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    long endOffset() {
        this.lock.readLock().lock();
        try {
            long l = this.endOffset;
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    int stateEpoch() {
        return this.stateEpoch;
    }

    Timer timer() {
        return this.timer;
    }

    GapWindow persisterReadResultGapWindow() {
        return this.persisterReadResultGapWindow;
    }

    Uuid fetchLock() {
        return this.fetchLock.get();
    }

    static enum SharePartitionState {
        EMPTY,
        INITIALIZING,
        ACTIVE,
        FAILED,
        FENCED;

    }

    static final class OffsetMetadata {
        private long offset = -1L;
        private LogOffsetMetadata offsetMetadata;

        OffsetMetadata() {
        }

        long offset() {
            return this.offset;
        }

        LogOffsetMetadata offsetMetadata() {
            return this.offsetMetadata;
        }

        void updateOffsetMetadata(long offset, LogOffsetMetadata offsetMetadata) {
            this.offset = offset;
            this.offsetMetadata = offsetMetadata;
        }
    }

    static class GapWindow {
        private final long endOffset;
        private long gapStartOffset;

        GapWindow(long endOffset, long gapStartOffset) {
            this.endOffset = endOffset;
            this.gapStartOffset = gapStartOffset;
        }

        long endOffset() {
            return this.endOffset;
        }

        long gapStartOffset() {
            return this.gapStartOffset;
        }

        void gapStartOffset(long gapStartOffset) {
            this.gapStartOffset = gapStartOffset;
        }
    }

    private record LastOffsetAndMaxRecords(long lastOffset, int maxRecords) {
    }
}

