/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import io.confluent.kafka.storage.tier.fetcher.TierFetchDataInfo;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import kafka.tier.fetcher.TierFetchResult;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.server.AbstractLogReadResult;
import org.apache.kafka.server.LogReadResult;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;

public class TierLogReadResult
implements AbstractLogReadResult {
    private final TierFetchDataInfo info;
    private final Optional<FetchResponseData.EpochEndOffset> divergingEpoch;
    private final long highWatermark;
    private final long leaderLogStartOffset;
    private final long leaderLogEndOffset;
    private final long followerLogStartOffset;
    private final long fetchTimeMs;
    private final int readSize;
    private final OptionalLong lastStableOffset;
    private final OptionalInt preferredReadReplica;
    private final Optional<Throwable> exception;
    private final long readLatencyNanos;

    public TierLogReadResult(TierFetchDataInfo info, Optional<FetchResponseData.EpochEndOffset> divergingEpoch, long highWatermark, long leaderLogStartOffset, long leaderLogEndOffset, long followerLogStartOffset, long fetchTimeMs, int readSize, OptionalLong lastStableOffset, OptionalInt preferredReadReplica, Optional<Throwable> exception, long readLatencyNanos) {
        this.info = info;
        this.divergingEpoch = divergingEpoch;
        this.highWatermark = highWatermark;
        this.leaderLogStartOffset = leaderLogStartOffset;
        this.leaderLogEndOffset = leaderLogEndOffset;
        this.followerLogStartOffset = followerLogStartOffset;
        this.fetchTimeMs = fetchTimeMs;
        this.readSize = readSize;
        this.lastStableOffset = lastStableOffset;
        this.preferredReadReplica = preferredReadReplica;
        this.exception = exception;
        this.readLatencyNanos = readLatencyNanos;
    }

    public TierLogReadResult(TierFetchDataInfo info, Optional<FetchResponseData.EpochEndOffset> divergingEpoch, long highWatermark, long leaderLogStartOffset, long leaderLogEndOffset, long followerLogStartOffset, long fetchTimeMs, int readSize, OptionalLong lastStableOffset) {
        this(info, divergingEpoch, highWatermark, leaderLogStartOffset, leaderLogEndOffset, followerLogStartOffset, fetchTimeMs, readSize, lastStableOffset, OptionalInt.empty(), Optional.empty(), 0L);
    }

    @Override
    public TierFetchDataInfo info() {
        return this.info;
    }

    @Override
    public Optional<FetchResponseData.EpochEndOffset> divergingEpoch() {
        return this.divergingEpoch;
    }

    @Override
    public long highWatermark() {
        return this.highWatermark;
    }

    @Override
    public long leaderLogStartOffset() {
        return this.leaderLogStartOffset;
    }

    @Override
    public long leaderLogEndOffset() {
        return this.leaderLogEndOffset;
    }

    public long followerLogStartOffset() {
        return this.followerLogStartOffset;
    }

    @Override
    public long fetchTimeMs() {
        return this.fetchTimeMs;
    }

    public int readSize() {
        return this.readSize;
    }

    @Override
    public OptionalLong lastStableOffset() {
        return this.lastStableOffset;
    }

    @Override
    public OptionalInt preferredReadReplica() {
        return this.preferredReadReplica;
    }

    @Override
    public Optional<Throwable> exception() {
        return this.exception;
    }

    @Override
    public long readLatencyNanos() {
        return this.readLatencyNanos;
    }

    @Override
    public Records records() {
        return MemoryRecords.EMPTY;
    }

    public LogReadResult intoLogReadResult(TierFetchResult tierFetchResult, boolean isReadAllowed) {
        FetchDataInfo newInfo = new FetchDataInfo(LogOffsetMetadata.UNKNOWN_OFFSET_METADATA, tierFetchResult.records, false, this.info.abortedTransactions());
        if (!tierFetchResult.abortedTxns.isEmpty()) {
            List<FetchResponseData.AbortedTransaction> abortedTransactionList = tierFetchResult.abortedTxns.stream().map(AbortedTxn::asAbortedTransaction).toList();
            newInfo = new FetchDataInfo(newInfo.fetchOffsetMetadata, newInfo.records, newInfo.firstEntryIncomplete, Optional.of(abortedTransactionList));
        }
        Optional<Throwable> exceptionOpt = this.exception.isPresent() ? this.exception : Optional.ofNullable(tierFetchResult.exception);
        return new LogReadResult(newInfo, this.divergingEpoch, this.highWatermark, this.leaderLogStartOffset, this.leaderLogEndOffset, this.followerLogStartOffset, this.fetchTimeMs, this.lastStableOffset, isReadAllowed, false, this.preferredReadReplica, exceptionOpt, this.readLatencyNanos);
    }

    public String toString() {
        return "Tiered Fetch Data: [" + String.valueOf(this.info) + "], HW: [" + this.highWatermark + "], leaderLogStartOffset: [" + this.leaderLogStartOffset + "], leaderLogEndOffset: [" + this.leaderLogEndOffset + "], followerLogStartOffset: [" + this.followerLogStartOffset + "], fetchTimeMs: [" + this.fetchTimeMs + "], readLatencyNanos: [" + this.readLatencyNanos + "], readSize: [" + this.readSize + "], lastStableOffset: [" + String.valueOf(this.lastStableOffset) + "], error: [" + String.valueOf((Object)this.error()) + "]";
    }
}

