/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.domain.TierPartitionDeleteInitiate;
import io.confluent.kafka.storage.tier.domain.TierPartitionDeletePreInitiate;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.tier.GCCandidatePartition;
import kafka.tier.GCPartition;
import kafka.tier.GCTopic;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.common.OffsetAndEpoch;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015b\u0001B\b\u0011\u0001UA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!A!\u0007\u0001B\u0001B\u0003%1\u0007C\u0003@\u0001\u0011\u0005\u0001\tC\u0004G\u0001\t\u0007I\u0011B$\t\rm\u0003\u0001\u0015!\u0003I\u0011\u001da\u0006A1A\u0005\nuCaA\u001c\u0001!\u0002\u0013q\u0006\"B8\u0001\t\u0003\u0001\b\"\u0002@\u0001\t\u0003y\bbBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003'\u0001A\u0011AA\u000b\u0011\u001d\tI\u0002\u0001C\u0001\u00037Aq!!\b\u0001\t\u0003\tyB\u0001\u000eUS\u0016\u0014xJ\u00196fGR<\u0015M\u001d2bO\u0016\u001cu\u000e\u001c7fGR|'O\u0003\u0002\u0012%\u0005!A/[3s\u0015\u0005\u0019\u0012!B6bM.\f7\u0001A\n\u0004\u0001Ya\u0002CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001eA5\taD\u0003\u0002 %\u0005)Q\u000f^5mg&\u0011\u0011E\b\u0002\b\u0019><w-\u001b8h\u0003A!\u0018.\u001a:U_BL7-T1oC\u001e,'\u000f\u0005\u0002%O5\tQE\u0003\u0002'!\u0005)Ao\u001c9jG&\u0011\u0001&\n\u0002\u0011)&,'\u000fV8qS\u000el\u0015M\\1hKJ\fQ\"\\3uC\u0012\fG/Y\"bG\",\u0007CA\u00161\u001b\u0005a#BA\u0017/\u0003!iW\r^1eCR\f'BA\u0018\u0013\u0003\u0019\u0019XM\u001d<fe&\u0011\u0011\u0007\f\u0002\u0013\u0017J\u000bg\r^'fi\u0006$\u0017\r^1DC\u000eDW-\u0001\u0003uS6,\u0007C\u0001\u001b>\u001b\u0005)$BA\u00107\u0015\t9\u0004(\u0001\u0004d_6lwN\u001c\u0006\u0003'eR!AO\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0014aA8sO&\u0011a(\u000e\u0002\u0005)&lW-\u0001\u0004=S:LGO\u0010\u000b\u0005\u0003\u000e#U\t\u0005\u0002C\u00015\t\u0001\u0003C\u0003#\t\u0001\u00071\u0005C\u0003*\t\u0001\u0007!\u0006C\u00033\t\u0001\u00071'\u0001\u0005hGR{\u0007/[2t+\u0005A\u0005\u0003B%O!bk\u0011A\u0013\u0006\u0003\u00172\u000bq!\\;uC\ndWM\u0003\u0002N1\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005=S%aA'baB\u0011\u0011KV\u0007\u0002%*\u00111\u000bV\u0001\u0005kRLGNC\u0001V\u0003\u0011Q\u0017M^1\n\u0005]\u0013&\u0001B+V\u0013\u0012\u0003\"AQ-\n\u0005i\u0003\"aB$D)>\u0004\u0018nY\u0001\nO\u000e$v\u000e]5dg\u0002\nQcZ2DC:$\u0017\u000eZ1uKB\u000b'\u000f^5uS>t7/F\u0001_!\u0011IejX6\u0011\u0005\u0001LW\"A1\u000b\u0005E\u0011'BA2e\u0003\u001d\u0019Ho\u001c:bO\u0016T!aE3\u000b\u0005\u0019<\u0017!C2p]\u001adW/\u001a8u\u0015\u0005A\u0017AA5p\u0013\tQ\u0017M\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]B\u0011!\t\\\u0005\u0003[B\u0011AcR\"DC:$\u0017\u000eZ1uKB\u000b'\u000f^5uS>t\u0017AF4d\u0007\u0006tG-\u001b3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002#\u0005$G\rV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eF\u0002riZ\u0004\"a\u0006:\n\u0005MD\"\u0001B+oSRDQ!^\u0005A\u0002}\u000b\u0001\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8\t\u000b]L\u0001\u0019\u0001=\u0002?A\f'\u000f^5uS>t7I]3bi&|gn\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007\u000e\u0005\u0002zy6\t!P\u0003\u00028w*\u0011q\u0006O\u0005\u0003{j\u0014ab\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007.\u0001\u000fp]B\u000b'\u000f^5uS>tG)\u001a7fi\u0016\u0004&/Z%oSRL\u0017\r^3\u0015\u000bE\f\t!a\u0001\t\u000bUT\u0001\u0019A0\t\u000f\u0005\u0015!\u00021\u0001\u0002\b\u0005YB-\u001a7fi\u0016\u0004&/Z%oSRL\u0017\r^3SK\u000e|'\u000f\u001a+j[\u0016\u00042aFA\u0005\u0013\r\tY\u0001\u0007\u0002\u0005\u0019>tw-A\rp]B\u000b'\u000f^5uS>tG)\u001a7fi\u0016Le.\u001b;jCR,GcA9\u0002\u0012!)Qo\u0003a\u0001?\u0006IrN\u001c)beRLG/[8o\t\u0016dW\r^3D_6\u0004H.\u001a;f)\r\t\u0018q\u0003\u0005\u0006k2\u0001\raX\u0001\"[\u0006L(-\u001a)sK&s\u0017\u000e^5bi\u0016\u0004\u0016M\u001d;ji&|g\u000eR3mKRLwN\u001c\u000b\u0002c\u0006)R.Y=cK\u0012+G.\u001a;f!\u0006\u0014H/\u001b;j_:\u001cHcA9\u0002\"!9\u00111\u0005\bA\u0002\u0005\u001d\u0011a\u00043fY\u0016$XMQ1dW>4g-T:")
public class TierObjectGarbageCollector
implements Logging {
    private final TierTopicManager tierTopicManager;
    private final KRaftMetadataCache metadataCache;
    private final Time time;
    private final Map<UUID, GCTopic> gcTopics;
    private final Map<TopicIdPartition, GCCandidatePartition> gcCandidatePartitions;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TierObjectGarbageCollector tierObjectGarbageCollector = this;
        synchronized (tierObjectGarbageCollector) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Map<UUID, GCTopic> gcTopics() {
        return this.gcTopics;
    }

    private Map<TopicIdPartition, GCCandidatePartition> gcCandidatePartitions() {
        return this.gcCandidatePartitions;
    }

    public void addTopicPartition(TopicIdPartition topicIdPartition, OffsetAndEpoch partitionCreationOffsetAndEpoch) {
        ((GCTopic)this.gcTopics().getOrElseUpdate(topicIdPartition.topicId(), (Function0<GCTopic> & Serializable)() -> new GCTopic(topicIdPartition.topic(), partitionCreationOffsetAndEpoch))).partitions().getOrElseUpdate(BoxesRunTime.boxToInteger(topicIdPartition.partition()), (Function0<GCPartition> & Serializable)() -> new GCPartition(false));
    }

    public void onPartitionDeletePreInitiate(TopicIdPartition topicIdPartition, long deletePreInitiateRecordTime) {
        this.gcTopics().get(topicIdPartition.topicId()).foreach((Function1<GCTopic, Object> & Serializable)topic -> {
            TierObjectGarbageCollector.$anonfun$onPartitionDeletePreInitiate$1(topicIdPartition, topic);
            return BoxedUnit.UNIT;
        });
        this.gcCandidatePartitions().getOrElseUpdate(topicIdPartition, (Function0<GCCandidatePartition> & Serializable)() -> new GCCandidatePartition(deletePreInitiateRecordTime, false));
    }

    public void onPartitionDeleteInitiate(TopicIdPartition topicIdPartition) {
        this.gcCandidatePartitions().get(topicIdPartition).foreach((Function1<GCCandidatePartition, Object> & Serializable)x$9 -> {
            x$9.isDeleteInitiated_$eq(true);
            return BoxedUnit.UNIT;
        });
    }

    public void onPartitionDeleteComplete(TopicIdPartition topicIdPartition) {
        this.gcTopics().get(topicIdPartition.topicId()).foreach((Function1<GCTopic, Object> & Serializable)topic -> {
            topic.partitions().remove(BoxesRunTime.boxToInteger(topicIdPartition.partition()));
            if (topic.partitions().isEmpty()) {
                return this.gcTopics().remove(topicIdPartition.topicId());
            }
            return BoxedUnit.UNIT;
        });
        this.gcCandidatePartitions().remove(topicIdPartition);
    }

    public void maybePreInitiatePartitionDeletion() {
        MetadataImage currentMetadataImage = this.metadataCache.currentImage();
        Map deletedTopics = (Map)this.gcTopics().filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(TierObjectGarbageCollector.$anonfun$maybePreInitiatePartitionDeletion$1(currentMetadataImage, x0$1)));
        deletedTopics.foreach((Function1<Tuple2, Object> & Serializable)x0$2 -> {
            TierObjectGarbageCollector.$anonfun$maybePreInitiatePartitionDeletion$2(this, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public void maybeDeletePartitions(long deleteBackoffMs) {
        ((IterableOps.WithFilter)((MapOps.WithFilter)this.gcCandidatePartitions().withFilter((Function1<Tuple2<TopicIdPartition, GCCandidatePartition>, Object>)(Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(TierObjectGarbageCollector.$anonfun$maybeDeletePartitions$1(check$ifrefutable$1))).withFilter((Function1<Tuple2, Object> & Serializable)x$12 -> BoxesRunTime.boxToBoolean(TierObjectGarbageCollector.$anonfun$maybeDeletePartitions$2(x$12)))).withFilter((Function1<Tuple2, Object> & Serializable)x$13 -> BoxesRunTime.boxToBoolean(TierObjectGarbageCollector.$anonfun$maybeDeletePartitions$3(this, deleteBackoffMs, x$13)))).foreach((Function1<Tuple2, CompletableFuture> & Serializable)x$14 -> {
            Tuple2 tuple2 = x$14;
            if (tuple2 != null) {
                TopicIdPartition topicIdPartition = (TopicIdPartition)tuple2._1();
                GCCandidatePartition gcCandidatePartition = (GCCandidatePartition)tuple2._2();
                gcCandidatePartition.isDeleteInitiated_$eq(true);
                this.info((Function0<String> & Serializable)() -> "Send TierPartitionDeleteInitiate for " + topicIdPartition);
                return $this.tierTopicManager.addMetadata(new TierPartitionDeleteInitiate(topicIdPartition, -1, UUID.randomUUID())).whenComplete((x$11, e) -> {
                    if (e != null) {
                        this.error((Function0<String> & Serializable)() -> "Error while trying to send TierPartitionDeleteInitiate for " + topicIdPartition, (Function0<Throwable> & Serializable)() -> e);
                        gcCandidatePartition.isDeleteInitiated_$eq(false);
                        return;
                    }
                });
            }
            throw new MatchError(tuple2);
        });
    }

    public static final /* synthetic */ void $anonfun$onPartitionDeletePreInitiate$1(TopicIdPartition topicIdPartition$2, GCTopic topic) {
        topic.partitions().get(BoxesRunTime.boxToInteger(topicIdPartition$2.partition())).foreach((Function1<GCPartition, Object> & Serializable)partition -> {
            partition.isDeletePreInitiated_$eq(true);
            return BoxedUnit.UNIT;
        });
    }

    private static final boolean checkTopicDeleted$1(UUID topicId, GCTopic gcTopic, MetadataImage metadataImage) {
        return Ordering.Implicits$.MODULE$.infixOrderingOps(gcTopic.topicCreationOffsetAndEpoch(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).$less$eq(metadataImage.highestOffsetAndEpoch()) && metadataImage.topics().getTopic(new Uuid(topicId.getMostSignificantBits(), topicId.getLeastSignificantBits())) == null;
    }

    public static final /* synthetic */ boolean $anonfun$maybePreInitiatePartitionDeletion$1(MetadataImage currentMetadataImage$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            UUID topicId = (UUID)tuple2._1();
            GCTopic gcTopic = (GCTopic)tuple2._2();
            return TierObjectGarbageCollector.checkTopicDeleted$1(topicId, gcTopic, currentMetadataImage$1);
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ void $anonfun$maybePreInitiatePartitionDeletion$2(TierObjectGarbageCollector $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            UUID topicId = (UUID)tuple2._1();
            GCTopic gcTopic = (GCTopic)tuple2._2();
            gcTopic.partitions().foreach((Function1<Tuple2, Object> & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    int partitionId = tuple2._1$mcI$sp();
                    GCPartition partition = (GCPartition)tuple2._2();
                    if (!partition.isDeletePreInitiated()) {
                        partition.isDeletePreInitiated_$eq(true);
                        TopicIdPartition topicIdPartition = new TopicIdPartition(gcTopic.topicName(), topicId, partitionId);
                        $this.info((Function0<String> & Serializable)() -> "Send TierPartitionDeletePreInitiate for " + topicIdPartition);
                        return $this.tierTopicManager.addMetadata(new TierPartitionDeletePreInitiate(topicIdPartition, UUID.randomUUID())).whenComplete((x$10, e) -> {
                            if (e != null) {
                                $this.error((Function0<String> & Serializable)() -> "Error while trying to send TierPartitionDeletePreInitiate for " + topicIdPartition, (Function0<Throwable> & Serializable)() -> e);
                                partition.isDeletePreInitiated_$eq(false);
                                return;
                            }
                        });
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError(tuple2);
            });
            return;
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$maybeDeletePartitions$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$maybeDeletePartitions$2(Tuple2 x$12) {
        Tuple2 tuple2 = x$12;
        if (tuple2 != null) {
            GCCandidatePartition gcCandidatePartition = (GCCandidatePartition)tuple2._2();
            return !gcCandidatePartition.isDeleteInitiated();
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$maybeDeletePartitions$3(TierObjectGarbageCollector $this, long deleteBackoffMs$1, Tuple2 x$13) {
        Tuple2 tuple2 = x$13;
        if (tuple2 != null) {
            GCCandidatePartition gcCandidatePartition = (GCCandidatePartition)tuple2._2();
            return gcCandidatePartition.deletePreInitiateRecordTime() + deleteBackoffMs$1 <= $this.time.milliseconds();
        }
        throw new MatchError(tuple2);
    }

    public TierObjectGarbageCollector(TierTopicManager tierTopicManager, KRaftMetadataCache metadataCache, Time time) {
        this.tierTopicManager = tierTopicManager;
        this.metadataCache = metadataCache;
        this.time = time;
        Logging.$init$(this);
        this.gcTopics = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        this.gcCandidatePartitions = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
    }
}

