/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.backupObjectLifecycle;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.metrics.stats.Max;

public class LifecycleManagerMetrics {
    private final Metrics metrics;
    private static final String METRIC_GROUP_NAME = "LifecycleManager";
    private static final String FAILURE_METRIC_PREFIX = "LifecycleManagerFailure";
    private static final String IGNORED_FAILURE_METRIC_PREFIX = "LifecycleManagerIgnoredFailure";
    private static final String CONSUMER_LAG_METRIC_PREFIX = "ConsumerLag";
    private static final String NUM_OBJECTS_DELETED_PREFIX = "TotalObjectsDeleted";
    private static final String NUM_OBJECTS_DELETED_BEFORE_BUCKET_POLICY_PREFIX = "TotalObjectsDeletedBeforeBucketPolicy";
    private static final String NUM_DATA_SEGMENTS_DELETED_PREFIX = "TotalDataSegmentsDeleted";
    private static final String NUM_DATA_SEGMENTS_DELETED_BEFORE_BUCKET_POLICY_PREFIX = "TotalDataSegmentsDeletedBeforeBucketPolicy";
    private static final String NUM_DATA_SEGMENTS_DELETED_IN_DUE_TIME_PREFIX = "TotalDataSegmentsDeletedInDueTime";
    private static final String NET_DELAY_IN_DELETION_OF_ONE_DATA_BLOB_SEC_PREFIX = "NetDelayInDeletionOfOneDataBlobInSec";
    private static final String WEIGHTED_SAVINGS_CURRENT_RUN_PREFIX = "WeightedSavingsCurrentRun";
    private static final String WEIGHTED_BACKUP_COST_CURRENT_RUN_PREFIX = "WeightedBackupCostCurrentRun";
    private static final String AVERAGE_WEIGHTED_SAVINGS_PREFIX = "AverageWeightedSavings";
    private static final String CUMULATIVE_WEIGHTED_SAVINGS_PREFIX = "CumulativeWeightedSavings";
    private static final String WEIGHTED_SAVINGS_SAMPLED_STATS = "WeightedSavingsSampledStats";
    private static final String ACTIVE_STATE_INDICATOR_PREFIX = "BackupObjectLifecycleManagerActiveIndicator";
    private static final String LIVENESS_INDICATOR_PREFIX = "BackupObjectLifecycleManagerLivenessIndicator";
    private static final String DURATION_OF_LAST_RUN_PREFIX = "DurationOfLastRun";
    private static final String AVERAGE_DURATION_OF_RUN_PREFIX = "AverageDurationOfRun";
    private static final String MAX_DURATION_OF_RUN_PREFIX = "MaxDurationOfRun";
    private static final String DURATION_OF_RUN_SAMPLED_STATS = "DurationOfRunSampledStats";
    private final MetricName failureMetricName;
    private final MetricName ignoredFailureMetricName;
    private final MetricName consumerLagMetricName;
    private final MetricName numObjectsDeletedMetricName;
    private final MetricName numObjectsDeletedBeforeBucketPolicyMetricName;
    private final MetricName numDataSegmentsDeletedMetricName;
    private final MetricName numDataSegmentsDeletedInDueTimeMetricName;
    private final MetricName netDelayInDeletionOfOneDataBlobInSecMetricName;
    private final MetricName numDataSegmentsDeletedBeforeBucketPolicyMetricName;
    private final MetricName weightedSavingsCurrentRunMetricName;
    private final MetricName weightedBackupCostCurrentRunMetricName;
    public final Sensor weightedSavingsSensor;
    private final MetricName activeStateIndicatorMetricName;
    private final MetricName livenessIndicatorMetricName;
    private final MetricName durationOfLastRunMetricName;
    public final Sensor durationOfRunSensor;
    public IntGauge failureMetric = new IntGauge(0);
    public IntGauge ignoredFailureMetric = new IntGauge(0);
    public LongGauge consumerLagMetric = new LongGauge(0L);
    public LongGauge numObjectsDeletedMetric = new LongGauge(0L);
    public LongGauge numObjectsDeletedBeforeBucketPolicyMetric = new LongGauge(0L);
    public LongGauge numDataSegmentsDeletedMetric = new LongGauge(0L);
    public LongGauge numDataSegmentsDeletedInDueTimeMetric = new LongGauge(0L);
    public LongGauge netDelayInDeletionOfOneDataBlobInSecMetric = new LongGauge(0L);
    public LongGauge numDataSegmentsDeletedBeforeBucketPolicyMetric = new LongGauge(0L);
    public DoubleGauge weightedSavingsCurrentRunMetric = new DoubleGauge(0.0);
    public DoubleGauge weightedBackupCostCurrentRunMetric = new DoubleGauge(0.0);
    public IntGauge activeStateIndicatorMetric = new IntGauge(0);
    public IntGauge livenessIndicatorMetric = new IntGauge(1);
    public LongGauge durationOfLastRunMetric = new LongGauge(0L);

    public LifecycleManagerMetrics(Metrics metrics, int clmRunsPerDay) {
        this.metrics = metrics;
        this.failureMetricName = metrics.metricName(FAILURE_METRIC_PREFIX, METRIC_GROUP_NAME, "Integer to indicate an exception in the previous run of LifecycleManager", Collections.emptyMap());
        this.ignoredFailureMetricName = metrics.metricName(IGNORED_FAILURE_METRIC_PREFIX, METRIC_GROUP_NAME, "Integer to indicate count of consecutive exceptions that have been ignored", Collections.emptyMap());
        this.consumerLagMetricName = metrics.metricName(CONSUMER_LAG_METRIC_PREFIX, METRIC_GROUP_NAME, "Long value indicating total lag for LifecycleManager's consumer", Collections.emptyMap());
        this.numObjectsDeletedMetricName = metrics.metricName(NUM_OBJECTS_DELETED_PREFIX, METRIC_GROUP_NAME, "Total number of objects deleted in one run of CustomLifecycleManager", Collections.emptyMap());
        this.numObjectsDeletedBeforeBucketPolicyMetricName = metrics.metricName(NUM_OBJECTS_DELETED_BEFORE_BUCKET_POLICY_PREFIX, METRIC_GROUP_NAME, "Total number of objects deleted before they would have been expired by bucket policy", Collections.emptyMap());
        this.numDataSegmentsDeletedMetricName = metrics.metricName(NUM_DATA_SEGMENTS_DELETED_PREFIX, METRIC_GROUP_NAME, "Total number of data segments deleted in one run of CustomLifecycleManager", Collections.emptyMap());
        this.numDataSegmentsDeletedInDueTimeMetricName = metrics.metricName(NUM_DATA_SEGMENTS_DELETED_IN_DUE_TIME_PREFIX, METRIC_GROUP_NAME, "Total number of deleted data segments that were garbage collected by CLM in time", Collections.emptyMap());
        this.netDelayInDeletionOfOneDataBlobInSecMetricName = metrics.metricName(NET_DELAY_IN_DELETION_OF_ONE_DATA_BLOB_SEC_PREFIX, METRIC_GROUP_NAME, "Net delay in deletion of one data blob in seconds", Collections.emptyMap());
        this.numDataSegmentsDeletedBeforeBucketPolicyMetricName = metrics.metricName(NUM_DATA_SEGMENTS_DELETED_BEFORE_BUCKET_POLICY_PREFIX, METRIC_GROUP_NAME, "Total number of data segments deleted before they would have been expired by bucket policy", Collections.emptyMap());
        this.weightedSavingsCurrentRunMetricName = metrics.metricName(WEIGHTED_SAVINGS_CURRENT_RUN_PREFIX, METRIC_GROUP_NAME, "Number of backed-up data segments deleted times the number of days of storage cost saved", Collections.emptyMap());
        MetricName averageWeightedSavingsMetricName = metrics.metricName(AVERAGE_WEIGHTED_SAVINGS_PREFIX, METRIC_GROUP_NAME, "Average weighted savings over a sample window");
        MetricName cumulativeWeightedSavingsMetricName = metrics.metricName(CUMULATIVE_WEIGHTED_SAVINGS_PREFIX, METRIC_GROUP_NAME, "Cumulative weighted savings over a sample window");
        this.weightedSavingsSensor = metrics.sensor(WEIGHTED_SAVINGS_SAMPLED_STATS);
        this.weightedSavingsSensor.add(averageWeightedSavingsMetricName, new Avg(), new MetricConfig().samples(clmRunsPerDay * 30).timeWindow(30L, TimeUnit.DAYS));
        this.weightedSavingsSensor.add(cumulativeWeightedSavingsMetricName, new CumulativeSum(), new MetricConfig().samples(clmRunsPerDay * 30).timeWindow(30L, TimeUnit.DAYS));
        this.weightedBackupCostCurrentRunMetricName = metrics.metricName(WEIGHTED_BACKUP_COST_CURRENT_RUN_PREFIX, METRIC_GROUP_NAME, "Number of data segments backed-up since last run of backup object lifecycle manager", Collections.emptyMap());
        this.activeStateIndicatorMetricName = metrics.metricName(ACTIVE_STATE_INDICATOR_PREFIX, METRIC_GROUP_NAME, "Integer to indicate if backup object lifecycle manager is active", Collections.emptyMap());
        this.livenessIndicatorMetricName = metrics.metricName(LIVENESS_INDICATOR_PREFIX, METRIC_GROUP_NAME, "Integer to indicate if backup object lifecycle manager is alive", Collections.emptyMap());
        this.durationOfLastRunMetricName = metrics.metricName(DURATION_OF_LAST_RUN_PREFIX, METRIC_GROUP_NAME, "Duration of run in seconds", Collections.emptyMap());
        MetricName averageDurationOfRunMetricName = metrics.metricName(AVERAGE_DURATION_OF_RUN_PREFIX, METRIC_GROUP_NAME, "Average duration of run (in seconds) over a sampled window");
        MetricName maxDurationOfRunMetricName = metrics.metricName(MAX_DURATION_OF_RUN_PREFIX, METRIC_GROUP_NAME, "Maximum duration of run (in seconds) over a sampled window");
        this.durationOfRunSensor = metrics.sensor(DURATION_OF_RUN_SAMPLED_STATS);
        this.durationOfRunSensor.add(averageDurationOfRunMetricName, new Avg(), new MetricConfig().samples(clmRunsPerDay * 7).timeWindow(7L, TimeUnit.DAYS));
        this.durationOfRunSensor.add(maxDurationOfRunMetricName, new Max(), new MetricConfig().samples(clmRunsPerDay * 7).timeWindow(7L, TimeUnit.DAYS));
        this.addMetrics();
        this.addObjectDeletionMetrics();
    }

    private void addMetrics() {
        if (!this.metrics.metrics().containsKey(this.failureMetricName)) {
            this.metrics.addMetric(this.failureMetricName, this.failureMetric);
        }
        if (!this.metrics.metrics().containsKey(this.ignoredFailureMetricName)) {
            this.metrics.addMetric(this.ignoredFailureMetricName, this.ignoredFailureMetric);
        }
        if (!this.metrics.metrics().containsKey(this.consumerLagMetricName)) {
            this.metrics.addMetric(this.consumerLagMetricName, this.consumerLagMetric);
        }
        if (!this.metrics.metrics().containsKey(this.activeStateIndicatorMetricName)) {
            this.metrics.addMetric(this.activeStateIndicatorMetricName, this.activeStateIndicatorMetric);
        }
        if (!this.metrics.metrics().containsKey(this.livenessIndicatorMetricName)) {
            this.metrics.addMetric(this.livenessIndicatorMetricName, this.livenessIndicatorMetric);
        }
        if (!this.metrics.metrics().containsKey(this.durationOfLastRunMetricName)) {
            this.metrics.addMetric(this.durationOfLastRunMetricName, this.durationOfLastRunMetric);
        }
    }

    private void addObjectDeletionMetrics() {
        if (!this.metrics.metrics().containsKey(this.numObjectsDeletedMetricName)) {
            this.metrics.addMetric(this.numObjectsDeletedMetricName, this.numObjectsDeletedMetric);
        }
        if (!this.metrics.metrics().containsKey(this.numObjectsDeletedBeforeBucketPolicyMetricName)) {
            this.metrics.addMetric(this.numObjectsDeletedBeforeBucketPolicyMetricName, this.numObjectsDeletedBeforeBucketPolicyMetric);
        }
        if (!this.metrics.metrics().containsKey(this.numDataSegmentsDeletedMetricName)) {
            this.metrics.addMetric(this.numDataSegmentsDeletedMetricName, this.numDataSegmentsDeletedMetric);
        }
        if (!this.metrics.metrics().containsKey(this.numDataSegmentsDeletedInDueTimeMetricName)) {
            this.metrics.addMetric(this.numDataSegmentsDeletedInDueTimeMetricName, this.numDataSegmentsDeletedInDueTimeMetric);
        }
        if (!this.metrics.metrics().containsKey(this.netDelayInDeletionOfOneDataBlobInSecMetricName)) {
            this.metrics.addMetric(this.netDelayInDeletionOfOneDataBlobInSecMetricName, this.netDelayInDeletionOfOneDataBlobInSecMetric);
        }
        if (!this.metrics.metrics().containsKey(this.numDataSegmentsDeletedBeforeBucketPolicyMetricName)) {
            this.metrics.addMetric(this.numDataSegmentsDeletedBeforeBucketPolicyMetricName, this.numDataSegmentsDeletedBeforeBucketPolicyMetric);
        }
        if (!this.metrics.metrics().containsKey(this.weightedSavingsCurrentRunMetricName)) {
            this.metrics.addMetric(this.weightedSavingsCurrentRunMetricName, this.weightedSavingsCurrentRunMetric);
        }
        if (!this.metrics.metrics().containsKey(this.weightedBackupCostCurrentRunMetricName)) {
            this.metrics.addMetric(this.weightedBackupCostCurrentRunMetricName, this.weightedBackupCostCurrentRunMetric);
        }
    }

    public void removeMetrics() {
        this.metrics.removeMetric(this.failureMetricName);
        this.metrics.removeMetric(this.ignoredFailureMetricName);
        this.metrics.removeMetric(this.consumerLagMetricName);
        this.metrics.removeMetric(this.numObjectsDeletedMetricName);
        this.metrics.removeMetric(this.numObjectsDeletedBeforeBucketPolicyMetricName);
        this.metrics.removeMetric(this.numDataSegmentsDeletedMetricName);
        this.metrics.removeMetric(this.numDataSegmentsDeletedInDueTimeMetricName);
        this.metrics.removeMetric(this.netDelayInDeletionOfOneDataBlobInSecMetricName);
        this.metrics.removeMetric(this.numDataSegmentsDeletedBeforeBucketPolicyMetricName);
        this.metrics.removeMetric(this.weightedSavingsCurrentRunMetricName);
        this.metrics.removeMetric(this.weightedBackupCostCurrentRunMetricName);
        this.metrics.removeMetric(this.activeStateIndicatorMetricName);
        this.metrics.removeMetric(this.livenessIndicatorMetricName);
        this.metrics.removeMetric(this.durationOfLastRunMetricName);
        this.metrics.removeSensor(this.durationOfRunSensor.name());
        this.metrics.removeSensor(this.weightedSavingsSensor.name());
    }

    static class IntGauge
    implements Gauge<Integer> {
        private int value;

        IntGauge(Integer initialValue) {
            this.value = initialValue;
        }

        @Override
        public synchronized Integer value(MetricConfig config, long now) {
            return this.value;
        }

        public synchronized int update(int value) {
            this.value = value;
            return this.value;
        }

        public synchronized void increment() {
            ++this.value;
        }

        public synchronized void decrement() {
            --this.value;
        }
    }

    static class LongGauge
    implements Gauge<Long> {
        private Long value;

        LongGauge(Long initialValue) {
            this.value = initialValue;
        }

        @Override
        public synchronized Long value(MetricConfig config, long now) {
            return this.value;
        }

        public synchronized void update(Long value) {
            this.value = value;
        }

        public synchronized void incrementBy(Long i) {
            this.value = this.value + i;
        }
    }

    static class DoubleGauge
    implements Gauge<Double> {
        private Double value;

        DoubleGauge(Double initialValue) {
            this.value = initialValue;
        }

        @Override
        public synchronized Double value(MetricConfig config, long now) {
            return this.value;
        }

        public synchronized void update(Double value) {
            this.value = value;
        }
    }
}

