/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher.offsetcache;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.UUID;
import kafka.tier.fetcher.offsetcache.CachedFetchOffsetMetadata;
import kafka.tier.fetcher.offsetcache.FetchKey;
import kafka.tier.fetcher.offsetcache.FetchOffsetMetadata;
import org.apache.kafka.common.utils.Time;

public class FetchOffsetCache {
    private final LinkedHashMap<FetchKey, CachedFetchOffsetMetadata> cache;
    private final boolean enabled;
    private final Time time;
    private final long timeoutMs;
    private long hits = 0L;
    private long accesses = 0L;

    public FetchOffsetCache(Time time, final int size, int timeoutMs) {
        this.time = time;
        this.timeoutMs = timeoutMs;
        this.cache = new LinkedHashMap<FetchKey, CachedFetchOffsetMetadata>(this, 16, 0.75f, true){
            final /* synthetic */ FetchOffsetCache this$0;
            {
                this.this$0 = this$0;
                super(arg0, arg1, arg2);
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<FetchKey, CachedFetchOffsetMetadata> eldest) {
                return this.size() > size;
            }
        };
        this.enabled = size > 0;
    }

    public synchronized void put(UUID objectId, long offset, int byteOffset, OptionalInt batchSize) {
        this.put(objectId, offset, new FetchOffsetMetadata(byteOffset, batchSize));
    }

    public synchronized void put(UUID objectId, long offset, FetchOffsetMetadata fetchOffsetMetadata) {
        if (this.enabled) {
            this.cache.put(new FetchKey(objectId, offset), new CachedFetchOffsetMetadata(fetchOffsetMetadata, this.time.hiResClockMs()));
        }
    }

    public synchronized FetchOffsetMetadata get(UUID objectId, long offset) {
        FetchKey key = new FetchKey(objectId, offset);
        CachedFetchOffsetMetadata metadata = this.cache.get(key);
        if (metadata != null) {
            metadata.updateLastUsed(this.time.hiResClockMs());
            this.cache.put(key, metadata);
            ++this.hits;
        }
        ++this.accesses;
        return metadata != null ? metadata.underlying() : null;
    }

    public synchronized double hitRatio() {
        if (this.accesses == 0L) {
            return 1.0;
        }
        return (double)this.hits / (double)this.accesses;
    }

    public synchronized void expireEntries() {
        long currTime = this.time.hiResClockMs();
        this.cache.entrySet().removeIf(entry -> ((CachedFetchOffsetMetadata)entry.getValue()).lastUsed() + this.timeoutMs <= currTime);
    }

    public synchronized long size() {
        return this.cache.size();
    }

    public synchronized boolean enabled() {
        return this.enabled;
    }
}

