/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ResetException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.PropertiesFileCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ListVersionsRequest;
import com.amazonaws.services.s3.model.MultiObjectDeleteException;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.S3VersionSummary;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.services.s3.model.VersionListing;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import io.confluent.kafka.storage.SegmentMetadataLayoutPutMode;
import io.confluent.kafka.storage.checksum.E2EChecksumProtectedObjectType;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import io.confluent.kafka.storage.checksum.E2EChecksumUtils;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.store.CombinedObjectStream;
import io.confluent.kafka.storage.tier.store.ThrottledFileInputStream;
import io.confluent.kafka.storage.tier.store.objects.FragmentType;
import io.confluent.kafka.storage.tier.store.objects.ObjectType;
import io.confluent.kafka.storage.tier.store.objects.TierSegmentUpload;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectStoreMetadata;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.tier.S3TierObjectStoreUtils;
import kafka.tier.exceptions.E2EChecksumInvalidException;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.AutoAbortingGenericInputStream;
import kafka.tier.store.BucketHealthResult;
import kafka.tier.store.S3AutoAbortingInputStream;
import kafka.tier.store.S3TierObjectStoreConfig;
import kafka.tier.store.S3VersionInformation;
import kafka.tier.store.TierObjectAttribute;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreAction;
import kafka.tier.store.TierObjectStoreByokUtils;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.encryption.AwsTenantAwareEncryptionManager;
import kafka.tier.store.encryption.CleartextDataKey;
import kafka.tier.store.encryption.DataEncryptionKeyHolder;
import kafka.tier.store.encryption.EncryptionKeyCacheRefiller;
import kafka.tier.store.encryption.FtpsEncryptionKeyCacheRefiller;
import kafka.tier.store.encryption.KeySha;
import kafka.tier.store.encryption.TenantAwareEncryptionKeyManager;
import kafka.tier.store.objects.metadata.HealthMetadata;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.apache.kafka.storage.internals.utils.Throttler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncRequestBodyFromInputStreamConfiguration;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.exception.RetryableException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.internal.retry.SdkDefaultRetrySetting;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.GetObjectAttributesRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectVersionsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.ObjectAttributes;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public class S3TierObjectStore
extends TierObjectStore {
    private static final Logger log = LoggerFactory.getLogger(S3TierObjectStore.class);
    private final Optional<String> clusterIdOpt;
    private final Optional<Integer> brokerIdOpt;
    private final AmazonS3 client;
    private final Optional<S3AsyncClient> asyncClientOpt;
    private final S3TierObjectStoreConfig config;
    private final Optional<AWSCredentialsProvider> credentialsProvider;
    private final String bucket;
    private final String prefix;
    private final String sseAlgorithm;
    private final String sseCustomerEncryptionKey;
    private final int autoAbortThresholdBytes;
    private final boolean v2Enabled;
    private AtomicInteger credentialsRefreshRetries = new AtomicInteger();
    private Optional<ExecutorService> executorOpt = Optional.empty();
    private Optional<TenantAwareEncryptionKeyManager> encryptionKeyManagerOpt = Optional.empty();
    private Optional<EncryptionKeyCacheRefiller<Void>> encryptionKeyCacheRefillerOpt = Optional.empty();
    private final Optional<E2EChecksumStore> checksumStoreOpt;
    private final Time time;
    private final Metrics metrics;
    private static final int DEFAULT_S3_MAX_CREDENTIAL_REFRESH_RETRIES = 5;
    private static final int DEFAULT_S3_DELETE_BATCH_SIZE = 1000;
    private static final int DEFAULT_S3_MAX_LIST_KEYS = 1000;
    private static final String CRC32C = "CRC32C";
    private static final String CRC32C_HEADER = "x-amz-checksum-crc32c";
    private static final String ERROR_CODE_BAD_DIGEST = "BadDigest";
    static final String ERROR_CODE_EXPIRED_TOKEN = "ExpiredToken";
    public static final String ERROR_CODE_NO_SUCH_KEY = "NoSuchKey";
    private static final String KMS_INVALID_STATE_ERROR_CODE = "KMS.KMSInvalidStateException";

    public S3TierObjectStore(S3TierObjectStoreConfig config, Optional<E2EChecksumStore> checksumStoreOpt, Time time, Metrics metrics) {
        this(S3TierObjectStore.client(config), config, checksumStoreOpt, time, metrics);
    }

    S3TierObjectStore(AmazonS3ClientAndCredentialsProvider clientAndCredentialsProvider, S3TierObjectStoreConfig config, Optional<E2EChecksumStore> checksumStoreOpt, Time time, Metrics metrics) {
        this(clientAndCredentialsProvider.client(), clientAndCredentialsProvider.asyncClientOpt(), clientAndCredentialsProvider.credentialsProvider(), config, checksumStoreOpt, time, metrics);
    }

    S3TierObjectStore(AmazonS3 client, AWSCredentialsProvider credentialsProvider, S3TierObjectStoreConfig config, Optional<E2EChecksumStore> checksumStoreOpt, Time time, Metrics metrics) {
        this(client, Optional.empty(), credentialsProvider, config, checksumStoreOpt, time, metrics);
    }

    S3TierObjectStore(AmazonS3 client, Optional<S3AsyncClient> asyncClientOpt, AWSCredentialsProvider credentialsProvider, S3TierObjectStoreConfig config, Optional<E2EChecksumStore> checksumStoreOpt, Time time, Metrics metrics) {
        this.clusterIdOpt = config.clusterIdOpt;
        this.brokerIdOpt = config.brokerIdOpt;
        this.client = client;
        this.asyncClientOpt = asyncClientOpt;
        this.config = config;
        this.credentialsProvider = Optional.ofNullable(credentialsProvider);
        this.bucket = config.s3Bucket;
        this.prefix = config.s3Prefix;
        this.sseAlgorithm = config.s3SseAlgorithm;
        this.sseCustomerEncryptionKey = config.s3SseCustomerEncryptionKey;
        this.autoAbortThresholdBytes = config.s3AutoAbortThresholdBytes;
        this.expectBucket(this.bucket, config.s3Region, config.s3EndpointOverride);
        this.checksumStoreOpt = checksumStoreOpt;
        this.time = time;
        this.metrics = metrics;
        this.v2Enabled = config.s3V2Enabled;
    }

    @Override
    public String keyPrefix() {
        return this.prefix;
    }

    @Override
    public TierObjectStore.Backend getBackend() {
        return TierObjectStore.Backend.S3;
    }

    private Set<String> listObjectsWithoutVersions(String keyPrefix) {
        HashSet<String> objects = new HashSet<String>();
        try {
            this.checkExpiredCredentialsExceptionAndTryRefresh(() -> {
                ListObjectsV2Result result;
                com.amazonaws.services.s3.model.ListObjectsV2Request req = new com.amazonaws.services.s3.model.ListObjectsV2Request().withBucketName(this.bucket).withPrefix(keyPrefix).withMaxKeys(1000);
                do {
                    result = this.client.listObjectsV2(req);
                    for (S3ObjectSummary objectSummary : result.getObjectSummaries()) {
                        objects.add(objectSummary.getKey());
                    }
                    String token = result.getNextContinuationToken();
                    req.setContinuationToken(token);
                } while (result.isTruncated());
                log.debug("TierObjectStore listObjects versions: false keyPrefix:  " + keyPrefix + " # of objects returned: " + objects.size());
                return null;
            });
        }
        catch (com.amazonaws.SdkClientException e) {
            throw new TierObjectStoreRetriableException("Failed to list the objects (without versions) with prefix: " + keyPrefix, e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException("Unknown exception while listing objects (without versions) with prefix: " + keyPrefix, e);
        }
        return objects;
    }

    @Override
    public Map<String, List<VersionInformation>> listObject(String keyPrefix, boolean getVersionInfo) {
        if (this.v2Enabled) {
            try {
                return this.listObjectAsync(keyPrefix, getVersionInfo).get();
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception while listing objects with prefix: " + keyPrefix, e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                S3TierObjectStoreUtils.handleAwsSdkV2Exception("Unknown exception while listing objects with prefix: " + keyPrefix, e);
            }
        }
        HashMap<String, List<VersionInformation>> results = new HashMap<String, List<VersionInformation>>();
        if (!getVersionInfo) {
            for (String object : this.listObjectsWithoutVersions(keyPrefix)) {
                results.put(object, new ArrayList());
            }
            return results;
        }
        try {
            this.checkExpiredCredentialsExceptionAndTryRefresh(() -> {
                ListVersionsRequest request = new ListVersionsRequest().withBucketName(this.bucket).withPrefix(keyPrefix).withMaxResults(1000);
                VersionListing versionListings = this.client.listVersions(request);
                while (true) {
                    for (S3VersionSummary versionSummary : versionListings.getVersionSummaries()) {
                        results.putIfAbsent(versionSummary.getKey(), new ArrayList());
                        S3VersionInformation versionInfo = new S3VersionInformation(versionSummary.getVersionId(), versionSummary.isDeleteMarker(), versionSummary.isLatest());
                        ((List)results.get(versionSummary.getKey())).add(versionInfo);
                    }
                    if (!versionListings.isTruncated()) break;
                    versionListings = this.client.listNextBatchOfVersions(versionListings);
                }
                if (log.isDebugEnabled()) {
                    StringBuilder allBlobs = new StringBuilder();
                    results.forEach((key, versions) -> allBlobs.append("[").append((String)key).append("->").append(Arrays.toString(versions.toArray())).append("] "));
                    log.debug("TierObjectStore listObjects versions: true keyPrefix: " + keyPrefix + " " + String.valueOf(allBlobs));
                }
                return null;
            });
        }
        catch (com.amazonaws.SdkClientException e) {
            throw new TierObjectStoreRetriableException("Failed to list the objects with prefix: " + keyPrefix, e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException("Unknown exception while listing objects with prefix: " + keyPrefix, e);
        }
        return results;
    }

    private CompletableFuture<Map<String, List<VersionInformation>>> listObjectsWithoutVersionsAsync(String keyPrefix) {
        CompletableFuture<Map<String, List<VersionInformation>>> future = new CompletableFuture<Map<String, List<VersionInformation>>>();
        try {
            HashMap objects = new HashMap();
            ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().bucket(this.bucket).prefix(keyPrefix).maxKeys(1000).build();
            this.asyncClientOpt.get().listObjectsV2Paginator(request).subscribe(response -> response.contents().forEach(object -> objects.putIfAbsent(object.key(), new ArrayList()))).whenComplete((response, e) -> {
                if (e != null) {
                    future.completeExceptionally(this.convertOperationException(e.getCause(), TierObjectStoreAction.LIST_LIVE_OBJECTS.action(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(keyPrefix), Optional.empty()));
                } else {
                    future.complete(objects);
                }
            });
        }
        catch (Exception e2) {
            log.error("Failed to send async list request without version, keyPrefix: {}", (Object)keyPrefix, (Object)e2);
            future.completeExceptionally(e2);
        }
        return future;
    }

    @Override
    public CompletableFuture<Map<String, List<VersionInformation>>> listObjectAsync(String keyPrefix, boolean getVersionInfo) {
        this.checkAsyncClientPresent("listObject");
        if (!getVersionInfo) {
            return this.listObjectsWithoutVersionsAsync(keyPrefix);
        }
        CompletableFuture<Map<String, List<VersionInformation>>> future = new CompletableFuture<Map<String, List<VersionInformation>>>();
        try {
            HashMap results = new HashMap();
            ListObjectVersionsRequest request = (ListObjectVersionsRequest)ListObjectVersionsRequest.builder().bucket(this.bucket).prefix(keyPrefix).maxKeys(1000).build();
            this.asyncClientOpt.get().listObjectVersionsPaginator(request).subscribe(response -> {
                response.versions().forEach(version -> {
                    results.putIfAbsent(version.key(), new ArrayList());
                    ((List)results.get(version.key())).add(new S3VersionInformation(version.versionId(), false, version.isLatest()));
                });
                response.deleteMarkers().forEach(deleteMarker -> {
                    results.putIfAbsent(deleteMarker.key(), new ArrayList());
                    ((List)results.get(deleteMarker.key())).add(new S3VersionInformation(deleteMarker.versionId(), true, deleteMarker.isLatest()));
                });
            }).whenComplete((response, e) -> {
                if (e != null) {
                    future.completeExceptionally(this.convertOperationException(e.getCause(), TierObjectStoreAction.LIST_OBJECT.action(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(keyPrefix), Optional.empty()));
                } else {
                    if (log.isDebugEnabled()) {
                        StringBuilder allBlobs = new StringBuilder();
                        results.forEach((key, versions) -> allBlobs.append("[").append((String)key).append("->").append(Arrays.toString(versions.toArray())).append("] "));
                        log.debug("TierObjectStore listObjects versions: true keyPrefix: " + keyPrefix + " " + String.valueOf(allBlobs));
                    }
                    future.complete(results);
                }
            });
        }
        catch (Exception e2) {
            log.error("Failed to send async list request, keyPrefix: {}, getVersionInfo: {}", keyPrefix, getVersionInfo, e2);
            future.completeExceptionally(e2);
        }
        return future;
    }

    private SSECustomerKey maybeGetSseCustomerKeyForObject(String key, ObjectType objectType, ObjectStoreMetadata objectMetadata) {
        CleartextDataKey cleartextDataKey = TierObjectStoreByokUtils.maybeGetEncryptionKeyForObject(key, objectType, objectMetadata, Optional.empty(), this.encryptionKeyManagerOpt, this.encryptionKeyCacheRefillerOpt, log);
        if (cleartextDataKey == null) {
            return null;
        }
        byte[] rawEncryptionKey = cleartextDataKey.rawKeyMaterial();
        SecretKeySpec encryptionKey = new SecretKeySpec(rawEncryptionKey, 0, rawEncryptionKey.length, this.encryptionKeyManagerOpt.get().getKeyManagementClientEncryptionAlgorithm());
        return new SSECustomerKey(encryptionKey);
    }

    private Optional<SseCustomerKeyV2> maybeGetSseCustomerKeyV2ForObject(String key, ObjectType objectType, ObjectStoreMetadata objectMetadata) {
        CleartextDataKey cleartextDataKey = TierObjectStoreByokUtils.maybeGetEncryptionKeyForObject(key, objectType, objectMetadata, Optional.empty(), this.encryptionKeyManagerOpt, this.encryptionKeyCacheRefillerOpt, log);
        if (cleartextDataKey == null) {
            return Optional.empty();
        }
        return Optional.of(new SseCustomerKeyV2(cleartextDataKey));
    }

    private GetObjectRequest constructGetRequest(String key, ObjectType objectType, ObjectStoreMetadata objectMetadata, VersionInformation versionInformation) {
        SSECustomerKey sseCustomerKey;
        GetObjectRequest request = new GetObjectRequest(this.bucket, key);
        if (versionInformation != null) {
            request = new GetObjectRequest(this.bucket, key, versionInformation.getVersionId());
        }
        if ((sseCustomerKey = this.maybeGetSseCustomerKeyForObject(key, objectType, objectMetadata)) != null) {
            request = request.withSSECustomerKey(sseCustomerKey);
        }
        return request;
    }

    private GetObjectRequest.Builder constructAsyncGetRequestBuilder(String key, ObjectType objectType, ObjectStoreMetadata objectMetadata, VersionInformation versionInformation) {
        GetObjectRequest.Builder requestBuilder = software.amazon.awssdk.services.s3.model.GetObjectRequest.builder().bucket(this.bucket).key(key);
        if (versionInformation != null) {
            requestBuilder.versionId(versionInformation.getVersionId());
        }
        Optional<SseCustomerKeyV2> sseCustomerKeyOpt = this.maybeGetSseCustomerKeyV2ForObject(key, objectType, objectMetadata);
        sseCustomerKeyOpt.ifPresent(sseCustomerKey -> requestBuilder.sseCustomerKey(sseCustomerKey.base64EncodedKey).sseCustomerKeyMD5(sseCustomerKey.base64EncodedMd5).sseCustomerAlgorithm(sseCustomerKey.customerAlgorithm));
        return requestBuilder;
    }

    @Override
    protected TierObjectStoreResponse getObject(ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive, VersionInformation versionInformation) {
        S3Object object;
        if (this.v2Enabled) {
            try {
                return this.getObjectAsync(objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive, versionInformation).get();
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception while getting objects", e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                S3TierObjectStoreUtils.handleAwsSdkV2Exception("Unknown exception while getting objects", e);
            }
        }
        String key = this.keyPath(objectMetadata, objectType);
        String fullPath = this.fullKeyPath(key);
        GetObjectRequest request = this.constructGetRequest(key, objectType, objectMetadata, versionInformation);
        if (byteOffsetStart != null && byteOffsetEndExclusive != null) {
            request.setRange(byteOffsetStart, byteOffsetEndExclusive - 1L);
        } else if (byteOffsetStart != null && byteOffsetStart != 0L) {
            request.setRange(byteOffsetStart);
        } else if (byteOffsetEndExclusive != null) {
            throw new IllegalStateException(String.format("Cannot specify a byteOffsetEndExclusive=%d without specifying a byteOffsetStart", byteOffsetEndExclusive));
        }
        log.debug("Fetching object from S3 key: {}/{}, with range {} - {}", this.bucket, key, byteOffsetStart, byteOffsetEndExclusive);
        try {
            object = this.checkExpiredCredentialsExceptionAndTryRefresh(() -> this.client.getObject(request));
        }
        catch (Exception e) {
            throw this.convertFetchException(e, fullPath, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive);
        }
        S3ObjectInputStream inputStream = object.getObjectContent();
        return new S3TierObjectStoreResponse(inputStream, this.autoAbortThresholdBytes, object.getObjectMetadata().getContentLength());
    }

    @Override
    protected CompletableFuture<TierObjectStoreResponse> getObjectAsync(ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive, VersionInformation versionInformation) {
        CompletableFuture<TierObjectStoreResponse> future = new CompletableFuture<TierObjectStoreResponse>();
        try {
            if (this.asyncClientOpt.isPresent()) {
                String key = this.keyPath(objectMetadata, objectType);
                String fullPath = this.fullKeyPath(key);
                GetObjectRequest.Builder requestBuilder = this.constructAsyncGetRequestBuilder(key, objectType, objectMetadata, versionInformation);
                if (byteOffsetStart != null && byteOffsetEndExclusive != null) {
                    requestBuilder.range(String.format("bytes=%d-%d", byteOffsetStart, byteOffsetEndExclusive - 1L));
                } else if (byteOffsetStart != null && byteOffsetStart != 0L) {
                    requestBuilder.range(String.format("bytes=%d-", byteOffsetStart));
                } else if (byteOffsetEndExclusive != null) {
                    throw new IllegalStateException("Cannot specify a byteOffsetEndExclusive without specifying a byteOffsetStart");
                }
                log.debug("Fetching object from {}, with range {} - {}", fullPath, byteOffsetStart, byteOffsetEndExclusive);
                this.asyncClientOpt.get().getObject((software.amazon.awssdk.services.s3.model.GetObjectRequest)requestBuilder.build(), AsyncResponseTransformer.toBlockingInputStream()).handle((responseInputStream, e) -> {
                    if (e != null) {
                        future.completeExceptionally(this.convertFetchException(e.getCause() != null ? e.getCause() : e, fullPath, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive));
                    } else {
                        Long contentLength = ((GetObjectResponse)responseInputStream.response()).contentLength();
                        future.complete(new S3TierObjectStoreResponse((InputStream)responseInputStream, this.autoAbortThresholdBytes, contentLength != null ? contentLength : Long.MAX_VALUE));
                    }
                    return null;
                });
            } else {
                log.warn("Fallback to getObject because async S3 client isn't created, metadata: {}, type: {}", (Object)objectMetadata, (Object)objectType);
                future.complete(this.getObject(objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive, versionInformation));
            }
        }
        catch (Exception e2) {
            log.error("Failed to send async fetch request, metadata: {}, type: {}", new Object[]{objectMetadata, objectType, e2});
            future.completeExceptionally(e2);
        }
        return future;
    }

    private RuntimeException convertFetchException(Throwable e, String fullPath, ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive) {
        if (e instanceof AmazonClientException || e instanceof RetryableException || this.isRetryable(e) || this.isKmsXKSProxyTimeoutException(e)) {
            return new TierObjectStoreRetriableException(String.format("Failed to fetch object from %s, metadata: %s type: %s range %s-%s", new Object[]{fullPath, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive}), e);
        }
        return new TierObjectStoreFatalException(String.format("Unknown exception when fetching object from %s, metadata: %s type: %s range %s-%s", new Object[]{fullPath, objectMetadata, objectType, byteOffsetStart, byteOffsetEndExclusive}), e);
    }

    @Override
    public ByteBuffer getSnapshot(ObjectStoreMetadata metadata, FragmentType fragmentType, int estimatedBufferSize) {
        ByteBuffer buffer;
        if (this.v2Enabled) {
            try {
                return this.getSnapshotAsync(metadata, fragmentType, estimatedBufferSize).get();
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception while getting snapshots", e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                S3TierObjectStoreUtils.handleAwsSdkV2Exception("Unknown exception while getting snapshots", e);
            }
        }
        if (FragmentType.checkGetSnapshotSupported(fragmentType)) {
            throw new IllegalArgumentException("getSnapshot does not support the given fragmentType: " + String.valueOf((Object)fragmentType));
        }
        try (TierObjectStoreResponse response = this.getObjectStoreFragment(metadata, fragmentType);){
            buffer = ByteBuffer.wrap(Utils.readFullyToArray(response.getInputStream(), estimatedBufferSize));
        }
        catch (Exception e) {
            for (Throwable cause = e.getCause(); cause != null && cause != cause.getCause(); cause = cause.getCause()) {
                if (!(cause instanceof AmazonS3Exception) || !ERROR_CODE_NO_SUCH_KEY.equals(((AmazonS3Exception)cause).getErrorCode())) continue;
                throw new TierObjectStoreFatalException("Snapshot object not found in object store.", cause);
            }
            throw new TierObjectStoreRetriableException("Encountered an exception when fetching snapshot from object store.", e);
        }
        return buffer;
    }

    @Override
    public CompletableFuture<ByteBuffer> getSnapshotAsync(ObjectStoreMetadata metadata, FragmentType fragmentType, int estimatedBufferSize) {
        this.checkAsyncClientPresent("getSnapshot");
        if (FragmentType.checkGetSnapshotSupported(fragmentType)) {
            CompletableFuture<ByteBuffer> future = new CompletableFuture<ByteBuffer>();
            future.completeExceptionally(new IllegalArgumentException("getSnapshotAsync does not support the given fragmentType: " + String.valueOf((Object)fragmentType)));
            return future;
        }
        return ((CompletableFuture)this.getObjectStoreFragmentAsync(metadata, fragmentType).thenApply(response -> {
            try {
                return ByteBuffer.wrap(Utils.readFullyToArray(response.getInputStream(), estimatedBufferSize));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })).exceptionally(e -> {
            for (Throwable cause = e.getCause(); cause != null && cause != cause.getCause(); cause = cause.getCause()) {
                if (!(cause instanceof AwsServiceException) || !ERROR_CODE_NO_SUCH_KEY.equals(((AwsServiceException)cause).awsErrorDetails().errorCode())) continue;
                throw new TierObjectStoreFatalException("Snapshot object not found in object store.", cause);
            }
            throw new TierObjectStoreRetriableException("Encountered an exception when fetching snapshot from object store.", (Throwable)e);
        });
    }

    @Override
    public TierObjectStore.ByokKeyHolder prepPutSegment(TopicIdPartition topicIdPartition) throws TierObjectStoreRetriableException, IOException {
        return TierObjectStoreByokUtils.getByokKeyHolderForTopicIdPartition(topicIdPartition, this.encryptionKeyManagerOpt, log);
    }

    @Override
    public String putObject(ObjectStoreMetadata objectMetadata, File file, ObjectType objectType) {
        if (this.v2Enabled) {
            try {
                return this.putObjectAsync(objectMetadata, file, objectType).get();
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception while putting objects", e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                S3TierObjectStoreUtils.handleAwsSdkV2Exception("Unknown exception while putting objects", e);
            }
        }
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        String key = this.keyPath(objectMetadata, objectType);
        String fullPath = this.fullKeyPath(key);
        try {
            this.checkExpiredCredentialsExceptionAndTryRefresh(() -> {
                this.putFile(key, metadata, file, objectType.toE2EChecksumProtectedObjectType(), Optional.empty());
                return null;
            });
        }
        catch (AmazonClientException e) {
            AmazonS3Exception ex;
            if (e instanceof AmazonS3Exception && ERROR_CODE_BAD_DIGEST.equals((ex = (AmazonS3Exception)e).getErrorCode())) {
                throw new E2EChecksumInvalidException("Checksum mismatch during object store upload", (Throwable)ex);
            }
            throw new TierObjectStoreRetriableException(String.format("Failed to upload object to %s with metadata %s, file %s, type %s", new Object[]{fullPath, objectMetadata, file, objectType}), e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException(String.format("Failed to upload object to %s with metadata %s, file %s, type %s", new Object[]{fullPath, objectMetadata, file, objectType}), e);
        }
        return key;
    }

    @Override
    public CompletableFuture<String> putObjectAsync(ObjectStoreMetadata objectMetadata, File file, ObjectType objectType) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        try {
            this.checkAsyncClientPresent("putObject");
            Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
            String key = this.keyPath(objectMetadata, objectType);
            String fullPath = this.fullKeyPath(key);
            ((CompletableFuture)this.putFileAsync(key, metadata, file, objectType.toE2EChecksumProtectedObjectType(), Optional.empty()).thenApply(res -> future.complete(key))).exceptionally(e -> {
                future.completeExceptionally(this.convertOperationException((Throwable)e, TierObjectStoreAction.PUT_OBJECT.action(), Optional.of(objectMetadata), Optional.empty(), Optional.of(file), Optional.of(objectType), Optional.of(fullPath), Optional.empty()));
                return null;
            });
        }
        catch (Exception e2) {
            log.error("Failed to upload object to file {}, type {}, metadata {}", new Object[]{file, objectType, objectMetadata, e2});
            future.completeExceptionally(e2);
        }
        return future;
    }

    private RuntimeException convertOperationException(Throwable e, String action, Optional<ObjectStoreMetadata> metadata, Optional<TierSegmentUpload> tierSegmentUpload, Optional<File> file, Optional<ObjectType> objectType, Optional<String> fullPath, Optional<ByteBuffer> buffer) {
        RuntimeException exception;
        block9: {
            exception = null;
            if (e instanceof S3Exception) {
                S3Exception ex = (S3Exception)e;
                if (ex.awsErrorDetails() != null && ERROR_CODE_BAD_DIGEST.equals(ex.awsErrorDetails().errorCode())) {
                    if (action.equals(TierObjectStoreAction.PUT_SEGMENT.action())) {
                        try {
                            if (objectType.get().equals((Object)ObjectType.SEGMENT_WITH_METADATA) && tierSegmentUpload.isPresent()) {
                                this.handleS3ExceptionForCombinedObject(Optional.of(ex.awsErrorDetails().errorCode()), ex, tierSegmentUpload.get());
                                break block9;
                            }
                            this.handleS3ExceptionDuringSegmentUpload(ex, metadata.get(), objectType.get(), file.get());
                        }
                        catch (E2EChecksumInvalidException | TierObjectStoreRetriableException tierObjectStoreException) {
                            exception = tierObjectStoreException;
                        }
                    } else {
                        exception = new E2EChecksumInvalidException(String.format("Checksum mismatch when %s", action), (Throwable)ex);
                    }
                } else {
                    exception = SdkDefaultRetrySetting.RETRYABLE_STATUS_CODES.contains(ex.statusCode()) ? new TierObjectStoreRetriableException(String.format("Retryable: Failed %s with metadata: %s, file: %s, type: %s, filePath: %s, buffer: %s", action, metadata.orElse(null), file.orElse(null), objectType.orElse(null), fullPath.orElse(null), buffer.orElse(null)), e) : (this.isKmsXKSProxyTimeoutException(ex) ? new TierObjectStoreRetriableException(String.format("Retryable: Failed %s with metadata: %s, file: %s, type: %s, filePath: %s, buffer: %s", action, metadata.orElse(null), file.orElse(null), objectType.orElse(null), fullPath.orElse(null), buffer.orElse(null)), e) : new TierObjectStoreFatalException(String.format("Fatal: Unknown service exception when %s with metadata: %s, file: %s, type: %s, filePath: %s, buffer: %s", action, metadata.orElse(null), file.orElse(null), objectType.orElse(null), fullPath.orElse(null), buffer.orElse(null)), ex));
                }
            } else {
                exception = this.isRetryable(e) ? new TierObjectStoreRetriableException(String.format("Retryable: Failed %s with metadata: %s, file: %s, type: %s, filePath: %s, buffer: %s", action, metadata.orElse(null), file.orElse(null), objectType.orElse(null), fullPath.orElse(null), buffer.orElse(null)), e) : new TierObjectStoreFatalException(String.format("Fatal: Failed %s with metadata: %s, file: %s, type: %s, filePath: %s, buffer: %s", action, metadata.orElse(null), file.orElse(null), objectType.orElse(null), fullPath.orElse(null), buffer.orElse(null)), e);
            }
        }
        return exception;
    }

    private boolean isRetryable(Throwable e) {
        SdkException ex;
        for (Class<? extends Exception> retryableEx : SdkDefaultRetrySetting.RETRYABLE_EXCEPTIONS) {
            if (!retryableEx.isInstance(e)) continue;
            return true;
        }
        if (e instanceof AwsServiceException && SdkDefaultRetrySetting.RETRYABLE_STATUS_CODES.contains(((SdkServiceException)(ex = (AwsServiceException)e)).statusCode())) {
            return true;
        }
        if (e instanceof SdkClientException) {
            ex = (SdkClientException)e;
            return ex.retryable();
        }
        return false;
    }

    private boolean isKmsXKSProxyTimeoutException(Throwable e) {
        if (e instanceof S3Exception) {
            S3Exception ex = (S3Exception)e;
            AwsErrorDetails errorDetails = ex.awsErrorDetails();
            return ex.statusCode() == 400 && errorDetails != null && Objects.equals(errorDetails.errorCode(), KMS_INVALID_STATE_ERROR_CODE);
        }
        return false;
    }

    @Override
    public String putBuffer(ObjectStoreMetadata objectMetadata, ByteBuffer buffer, ObjectType objectType) {
        if (this.v2Enabled) {
            try {
                return this.putBufferAsync(objectMetadata, buffer, objectType).get();
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception while putting buffer", e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                S3TierObjectStoreUtils.handleAwsSdkV2Exception("Unknown exception while putting buffer", e);
            }
        }
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        String key = this.keyPath(objectMetadata, objectType);
        String fullPath = this.fullKeyPath(key);
        try {
            this.checkExpiredCredentialsExceptionAndTryRefresh(() -> {
                this.putBuf(key, metadata, buffer);
                return null;
            });
        }
        catch (AmazonClientException e) {
            throw new TierObjectStoreRetriableException(String.format("Failed to upload object to %s with metadata %s, buffer %s, type %s", new Object[]{fullPath, objectMetadata, buffer, objectType}), e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException(String.format("Failed to upload object to %s with metadata %s, buffer %s, type %s", new Object[]{fullPath, objectMetadata, buffer, objectType}), e);
        }
        return key;
    }

    @Override
    public CompletableFuture<String> putBufferAsync(ObjectStoreMetadata objectMetadata, ByteBuffer buffer, ObjectType objectType) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        try {
            this.checkAsyncClientPresent("putBuffer");
            String key = this.keyPath(objectMetadata, objectType);
            Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
            String fullPath = this.fullKeyPath(key);
            ((CompletableFuture)this.putBufAsync(key, metadata, buffer).thenApply(res -> future.complete(key))).exceptionally(e -> {
                future.completeExceptionally(this.convertOperationException((Throwable)e, TierObjectStoreAction.PUT_BUFFER.action(), Optional.of(objectMetadata), Optional.empty(), Optional.empty(), Optional.of(objectType), Optional.of(fullPath), Optional.of(buffer)));
                return null;
            });
        }
        catch (Exception e2) {
            log.error("Failed to upload object with metadata {}, buffer {}, type {}", new Object[]{objectMetadata, buffer, objectType});
            future.completeExceptionally(e2);
        }
        return future;
    }

    @Override
    public void restoreObjectByCopy(io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata objectMetadata, String key, VersionInformation lastLiveVersion) {
        if (this.v2Enabled) {
            try {
                this.restoreObjectByCopyAsync(objectMetadata, key, lastLiveVersion).get();
                return;
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception while restoring object by copying buffer", e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                S3TierObjectStoreUtils.handleAwsSdkV2Exception("Unknown exception while restoring object by copying buffer", e);
            }
        }
        String lastLiveVersionId = lastLiveVersion.getVersionId();
        String fullPath = this.fullKeyPath(key);
        try {
            this.checkExpiredCredentialsExceptionAndTryRefresh(() -> {
                CopyObjectRequest request = new CopyObjectRequest(this.bucket, key, lastLiveVersionId, this.bucket, key).withNewObjectMetadata(this.objectMetadataWithSseAlgorithm(null));
                if (this.isStorageClassDefined()) {
                    request.setStorageClass(this.config.s3StorageClass.get());
                }
                this.setKmsParams(request);
                log.debug("restore object for {}-{}", (Object)fullPath, (Object)lastLiveVersionId);
                this.client.copyObject(request);
                return null;
            });
        }
        catch (AmazonClientException e) {
            throw new TierObjectStoreRetriableException(String.format("Failed to restore object %s (version: %s)", fullPath, lastLiveVersionId), e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException(String.format("Unknown exception when restoring object %s (version: %s)", fullPath, lastLiveVersionId), e);
        }
    }

    @Override
    public CompletableFuture<Void> restoreObjectByCopyAsync(io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata objectMetadata, String key, VersionInformation lastLiveVersion) {
        this.checkAsyncClientPresent("restoreObjectByCopy");
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            String lastLiveVersionId = lastLiveVersion.getVersionId();
            String fullPath = this.fullKeyPath(key);
            CopyObjectRequest.Builder requestBuilder = software.amazon.awssdk.services.s3.model.CopyObjectRequest.builder().sourceBucket(this.bucket).sourceKey(key).sourceVersionId(lastLiveVersionId).destinationBucket(this.bucket).destinationKey(key).metadata(objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt));
            if (this.isStorageClassDefined()) {
                requestBuilder.storageClass(this.config.s3StorageClass.get());
            }
            if (this.usesKms()) {
                requestBuilder.serverSideEncryption(ServerSideEncryption.AWS_KMS).ssekmsKeyId(this.sseCustomerEncryptionKey);
            }
            log.debug("restore object for {}-{}", (Object)fullPath, (Object)lastLiveVersionId);
            this.asyncClientOpt.get().copyObject((software.amazon.awssdk.services.s3.model.CopyObjectRequest)requestBuilder.build()).handle((response, e) -> {
                if (e != null) {
                    future.completeExceptionally(this.convertOperationException(e.getCause(), String.format("%s %s", TierObjectStoreAction.RESTORE_OBJECT.action(), lastLiveVersionId), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(fullPath), Optional.empty()));
                } else {
                    future.complete(null);
                }
                return null;
            });
        }
        catch (Exception e2) {
            log.error("Failed to send async restore request, metadata: {}, key: {}", objectMetadata, key, e2);
            future.completeExceptionally(e2);
        }
        return future;
    }

    private void setKmsParams(CopyObjectRequest request) {
        if (this.usesKms()) {
            request.setSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(this.sseCustomerEncryptionKey));
        }
    }

    private void putSegmentFile(io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata objectMetadata, File segmentData, Optional<Throttler> throttler) throws IOException {
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        String key = this.keyPath(objectMetadata, ObjectType.SEGMENT);
        if (TierObjectStoreByokUtils.shouldUploadEncrypted(objectMetadata, key, this.encryptionKeyManagerOpt)) {
            this.putFileEncrypted(key, segmentData, objectMetadata, E2EChecksumProtectedObjectType.SEGMENT, throttler);
        } else {
            this.putFile(key, metadata, segmentData, E2EChecksumProtectedObjectType.SEGMENT, throttler);
        }
    }

    private void putSegmentAsMultiObject(TierSegmentUpload<?> tierSegmentUpload, AtomicReference<ObjectType> currObjectType) throws IOException {
        io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata objectMetadata = tierSegmentUpload.objectMetadata();
        Map<String, String> metadata = tierSegmentUpload.objectMetadata().objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        Optional<Throttler> throttler = tierSegmentUpload.throttlerOpt();
        currObjectType.set(ObjectType.SEGMENT);
        this.putSegmentFile(objectMetadata, tierSegmentUpload.segment(), throttler);
        currObjectType.set(ObjectType.OFFSET_INDEX);
        this.putFile(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.OFFSET_INDEX), metadata, tierSegmentUpload.offsetIdx(), E2EChecksumProtectedObjectType.OFFSET_INDEX, throttler);
        currObjectType.set(ObjectType.TIMESTAMP_INDEX);
        this.putFile(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.TIMESTAMP_INDEX), metadata, tierSegmentUpload.timestampIdx(), E2EChecksumProtectedObjectType.TIMESTAMP_INDEX, throttler);
        if (tierSegmentUpload.producerStateSnapshotOpt().isPresent()) {
            currObjectType.set(ObjectType.PRODUCER_STATE);
            Object producerState = tierSegmentUpload.producerStateSnapshotOpt().get();
            if (producerState instanceof File) {
                this.putFile(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.PRODUCER_STATE), metadata, (File)producerState, E2EChecksumProtectedObjectType.PRODUCER_STATE, throttler);
            } else if (producerState instanceof ByteBuffer) {
                this.putBuf(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.PRODUCER_STATE), metadata, (ByteBuffer)producerState);
            }
        }
        if (tierSegmentUpload.txnIdxOpt().isPresent()) {
            currObjectType.set(ObjectType.TRANSACTION_INDEX);
            this.putBuf(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.TRANSACTION_INDEX), metadata, tierSegmentUpload.txnIdxOpt().get());
        }
        if (tierSegmentUpload.epochStateOpt().isPresent()) {
            currObjectType.set(ObjectType.EPOCH_STATE);
            this.putBuf(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.EPOCH_STATE), metadata, tierSegmentUpload.epochStateOpt().get());
        }
    }

    private void putSegmentAsCombinedObject(TierSegmentUpload<?> tierSegmentUpload) throws IOException {
        try (CombinedObjectStream combinedObjectStream = tierSegmentUpload.makeCombinedObjectStream();){
            Optional<String> checksumOpt = this.checksumStoreOpt.flatMap(tierSegmentUpload::getChecksumForCombinedObject);
            String combinedObjectKeyPath = this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.SEGMENT_WITH_METADATA);
            this.putInputStream(combinedObjectKeyPath, tierSegmentUpload.objectMetadata(), combinedObjectStream, combinedObjectStream.length(), tierSegmentUpload.throttlerOpt().isPresent(), checksumOpt);
        }
    }

    private void putInputStream(String key, io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata objectMetadata, InputStream stream, long contentLength, boolean isThrottled, Optional<String> crc) throws IOException {
        if (!stream.markSupported()) {
            log.warn("[{}] InputStream does not support mark/reset, wrapping in BufferedInputStream", (Object)key);
            stream = new BufferedInputStream(stream);
        }
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        if (TierObjectStoreByokUtils.shouldUploadEncrypted(objectMetadata, key, this.encryptionKeyManagerOpt)) {
            ObjectMetadata s3ObjMetadata = new ObjectMetadata();
            if (metadata != null) {
                s3ObjMetadata.setUserMetadata(metadata);
            }
            s3ObjMetadata.setContentLength(contentLength);
            crc.ifPresent(checksum -> s3ObjMetadata.setHeader(CRC32C_HEADER, checksum));
            this.sendEncryptedPutRequest(key, objectMetadata, s3ObjMetadata, isThrottled, Optional.empty(), Optional.of(stream), crc, Optional.of((int)contentLength));
        } else {
            ObjectMetadata s3ObjMetadata = this.objectMetadataWithSseAlgorithm(metadata);
            s3ObjMetadata.setContentLength(contentLength);
            crc.ifPresent(checksum -> s3ObjMetadata.setHeader(CRC32C_HEADER, checksum));
            PutObjectRequest request = new PutObjectRequest(this.bucket, key, stream, s3ObjMetadata);
            request.getRequestClientOptions().setReadLimit((int)contentLength + 1);
            if (this.isStorageClassDefined()) {
                request.setStorageClass(this.config.s3StorageClass.get());
            }
            this.setKmsParams(request);
            this.client.putObject(request);
        }
    }

    private List<CompletableFuture<PutObjectResponse>> putSegmentAsMultiObjectAsync(TierSegmentUpload<?> tierSegmentUpload, AtomicReference<ObjectType> currObjectType) throws IOException {
        ArrayList<CompletableFuture<PutObjectResponse>> pendingFutures = new ArrayList<CompletableFuture<PutObjectResponse>>();
        io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata objectMetadata = tierSegmentUpload.objectMetadata();
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        currObjectType.set(ObjectType.SEGMENT);
        pendingFutures.add(this.putSegmentFileAsync(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.SEGMENT), objectMetadata, tierSegmentUpload.segment(), E2EChecksumProtectedObjectType.SEGMENT, tierSegmentUpload.throttlerOpt()));
        currObjectType.set(ObjectType.OFFSET_INDEX);
        pendingFutures.add(this.putAsync(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.OFFSET_INDEX), objectMetadata, tierSegmentUpload.offsetIdx(), E2EChecksumProtectedObjectType.OFFSET_INDEX, tierSegmentUpload.throttlerOpt()));
        currObjectType.set(ObjectType.TIMESTAMP_INDEX);
        pendingFutures.add(this.putAsync(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.TIMESTAMP_INDEX), objectMetadata, tierSegmentUpload.timestampIdx(), E2EChecksumProtectedObjectType.TIMESTAMP_INDEX, tierSegmentUpload.throttlerOpt()));
        if (tierSegmentUpload.producerStateSnapshotOpt().isPresent()) {
            currObjectType.set(ObjectType.PRODUCER_STATE);
            pendingFutures.add(this.putAsync(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.PRODUCER_STATE), objectMetadata, tierSegmentUpload.producerStateSnapshotOpt().get(), E2EChecksumProtectedObjectType.PRODUCER_STATE, tierSegmentUpload.throttlerOpt()));
        }
        if (tierSegmentUpload.txnIdxOpt().isPresent()) {
            currObjectType.set(ObjectType.TRANSACTION_INDEX);
            pendingFutures.add(this.putBufAsync(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.TRANSACTION_INDEX), metadata, tierSegmentUpload.txnIdxOpt().get()));
        }
        if (tierSegmentUpload.epochStateOpt().isPresent()) {
            currObjectType.set(ObjectType.EPOCH_STATE);
            pendingFutures.add(this.putBufAsync(this.keyPath(tierSegmentUpload.objectMetadata(), ObjectType.EPOCH_STATE), metadata, tierSegmentUpload.epochStateOpt().get()));
        }
        return pendingFutures;
    }

    private List<CompletableFuture<PutObjectResponse>> putSegmentAsCombinedObjectAsync(TierSegmentUpload<?> tierSegmentUpload) throws IOException {
        ArrayList<CompletableFuture<PutObjectResponse>> pendingFutures = new ArrayList<CompletableFuture<PutObjectResponse>>();
        io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata objectMetadata = tierSegmentUpload.objectMetadata();
        CombinedObjectStream combinedObjectStream = tierSegmentUpload.makeCombinedObjectStream();
        Optional<String> checksumOpt = this.checksumStoreOpt.flatMap(tierSegmentUpload::getChecksumForCombinedObject);
        String combinedObjectKeyPath = this.keyPath(objectMetadata, ObjectType.SEGMENT_WITH_METADATA);
        pendingFutures.add(this.putInputStreamAsync(combinedObjectKeyPath, E2EChecksumProtectedObjectType.SEGMENT_WITH_METADATA, objectMetadata, combinedObjectStream, combinedObjectStream.length(), tierSegmentUpload.throttlerOpt().isPresent(), checksumOpt));
        return pendingFutures;
    }

    protected CompletableFuture<PutObjectResponse> putInputStreamAsync(String key, E2EChecksumProtectedObjectType objectType, io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata objectMetadata, InputStream stream, long contentLength, boolean isThrottled, Optional<String> crc) {
        boolean isEncrypted;
        this.checkAsyncClientPresent("putInputStream");
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        crc.ifPresent(checksum -> metadata.put(CRC32C_HEADER, (String)checksum));
        PutObjectRequest.Builder putRequestBuilder = software.amazon.awssdk.services.s3.model.PutObjectRequest.builder().bucket(this.bucket).key(key).metadata(metadata);
        if (this.isStorageClassDefined()) {
            putRequestBuilder.storageClass(this.config.s3StorageClass.get());
        }
        if (!stream.markSupported()) {
            log.warn("[{}] InputStream does not support mark/reset, wrapping in BufferedInputStream", (Object)key);
            stream = new BufferedInputStream(stream);
        }
        if (isEncrypted = TierObjectStoreByokUtils.shouldUploadEncrypted(objectMetadata, key, this.encryptionKeyManagerOpt)) {
            KeySha keySha = KeySha.fromRawBytes(objectMetadata.opaqueData().intoByteArray());
            SseCustomerKeyV2 sseCustomerKey = new SseCustomerKeyV2(objectMetadata.topicIdPartition(), keySha);
            putRequestBuilder.sseCustomerKey(sseCustomerKey.base64EncodedKey).sseCustomerKeyMD5(sseCustomerKey.base64EncodedMd5).sseCustomerAlgorithm(sseCustomerKey.customerAlgorithm);
        } else {
            this.setSseAlgorithmAndKmsParamsV2(putRequestBuilder);
        }
        log.debug("Uploading InputStream to s3://{}/{}", (Object)this.bucket, (Object)key);
        return this.sendAsyncPutRequest(putRequestBuilder, key, metadata, objectType, isEncrypted, isThrottled, contentLength, Optional.empty(), Optional.of(stream));
    }

    @Override
    public void putSegment(TierSegmentUpload<?> tierSegmentUpload) {
        AtomicReference currentPutObjectType = new AtomicReference();
        if (this.v2Enabled) {
            try {
                this.putSegmentAsync(tierSegmentUpload).get();
                return;
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception while putting segment", e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                S3TierObjectStoreUtils.handleAwsSdkV2Exception("Unknown exception while putting segment", e);
            }
        }
        try {
            this.checkExpiredCredentialsExceptionAndTryRefresh(() -> {
                switch (tierSegmentUpload.putMode()) {
                    case LegacyMultiObject: {
                        this.putSegmentAsMultiObject(tierSegmentUpload, currentPutObjectType);
                        break;
                    }
                    case CombinedObject: {
                        currentPutObjectType.set(ObjectType.SEGMENT_WITH_METADATA);
                        this.putSegmentAsCombinedObject(tierSegmentUpload);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported segment PUT mode: " + String.valueOf((Object)tierSegmentUpload.putMode()));
                    }
                }
                return null;
            });
            this.checksumStoreOpt.ifPresent(tierSegmentUpload::postPutSegmentCleanup);
        }
        catch (AmazonClientException e) {
            ObjectType currentObjectType = (ObjectType)((Object)currentPutObjectType.get());
            if (ObjectType.SEGMENT_WITH_METADATA.equals((Object)currentObjectType)) {
                Optional<String> errorCode = e instanceof AmazonS3Exception ? Optional.of(((AmazonS3Exception)e).getErrorCode()) : Optional.empty();
                this.handleS3ExceptionForCombinedObject(errorCode, e, tierSegmentUpload);
            } else {
                Optional<File> file = TierObjectStoreUtils.getCurrentPutObjectFile(tierSegmentUpload, currentObjectType.toE2EChecksumProtectedObjectType());
                if (!file.isPresent()) {
                    throw new TierObjectStoreRetriableException("Failed to upload segment: " + String.valueOf(tierSegmentUpload.objectMetadata()), e);
                }
                this.handleAmazonClientException(e, tierSegmentUpload.objectMetadata(), (ObjectType)((Object)currentPutObjectType.get()), file.get());
                if (this.isKmsXKSProxyTimeoutException(e)) {
                    throw new TierObjectStoreRetriableException("KMS external key store timeout when uploading segment: " + String.valueOf(tierSegmentUpload.objectMetadata()), e);
                }
            }
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException("Unknown exception when uploading segment: " + String.valueOf(tierSegmentUpload.objectMetadata()), e);
        }
    }

    @Override
    public CompletableFuture<Void> putSegmentAsync(TierSegmentUpload<?> tierSegmentUpload) {
        this.checkAsyncClientPresent("putSegment");
        AtomicReference<ObjectType> currentPutObjectType = new AtomicReference<ObjectType>();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            ((CompletableFuture)CompletableFuture.allOf((switch (tierSegmentUpload.putMode()) {
                case SegmentMetadataLayoutPutMode.LegacyMultiObject -> this.putSegmentAsMultiObjectAsync(tierSegmentUpload, currentPutObjectType);
                case SegmentMetadataLayoutPutMode.CombinedObject -> {
                    currentPutObjectType.set(ObjectType.SEGMENT_WITH_METADATA);
                    yield this.putSegmentAsCombinedObjectAsync(tierSegmentUpload);
                }
                default -> throw new UnsupportedOperationException("Unsupported segment PUT mode " + String.valueOf((Object)tierSegmentUpload.putMode()));
            }).toArray(new CompletableFuture[0])).thenApply(res -> {
                this.checksumStoreOpt.ifPresent(tierSegmentUpload::postPutSegmentCleanup);
                future.complete(null);
                return null;
            })).exceptionally(e -> {
                ObjectType currentObjectType = (ObjectType)((Object)((Object)currentPutObjectType.get()));
                if (ObjectType.SEGMENT_WITH_METADATA.equals((Object)currentObjectType)) {
                    future.completeExceptionally(this.convertOperationException(e.getCause(), TierObjectStoreAction.PUT_SEGMENT.action(), Optional.of(tierSegmentUpload.objectMetadata()), Optional.of(tierSegmentUpload), Optional.empty(), Optional.of(currentObjectType), Optional.empty(), Optional.empty()));
                } else {
                    Optional<File> file = TierObjectStoreUtils.getCurrentPutObjectFile(tierSegmentUpload, currentObjectType.toE2EChecksumProtectedObjectType());
                    if (!file.isPresent()) {
                        future.completeExceptionally(new TierObjectStoreRetriableException("Failed to upload segment: " + String.valueOf(tierSegmentUpload.objectMetadata()), (Throwable)e));
                        return null;
                    }
                    future.completeExceptionally(this.convertOperationException(e.getCause(), TierObjectStoreAction.PUT_SEGMENT.action(), Optional.of(tierSegmentUpload.objectMetadata()), Optional.empty(), file, Optional.of(currentObjectType), Optional.empty(), Optional.empty()));
                }
                return null;
            });
        }
        catch (Exception e2) {
            future.completeExceptionally(new TierObjectStoreFatalException("Unknown exception when uploading segment: " + String.valueOf(tierSegmentUpload.objectMetadata()), e2));
        }
        return future;
    }

    private <T> CompletableFuture<PutObjectResponse> putSegmentFileAsync(String key, io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata objectMetadata, File file, E2EChecksumProtectedObjectType objectType, Optional<Throttler> throttler) throws IOException {
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        if (TierObjectStoreByokUtils.shouldUploadEncrypted(objectMetadata, key, this.encryptionKeyManagerOpt)) {
            return this.putFileEncryptedAsync(key, objectMetadata, file, objectType, throttler);
        }
        return this.putFileAsync(key, metadata, file, objectType, throttler);
    }

    private <T> CompletableFuture<PutObjectResponse> putAsync(String key, io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata objectMetadata, T data, E2EChecksumProtectedObjectType objectType, Optional<Throttler> throttler) throws IOException {
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        if (data instanceof File) {
            return this.putFileAsync(key, metadata, (File)data, objectType, throttler);
        }
        return this.putBufAsync(key, metadata, (ByteBuffer)data);
    }

    private <T> T checkExpiredCredentialsExceptionAndTryRefresh(Callable<T> func) throws Exception {
        try {
            T result = func.call();
            this.credentialsRefreshRetries.set(0);
            return result;
        }
        catch (AmazonS3Exception ex) {
            if (ERROR_CODE_EXPIRED_TOKEN.equals(ex.getErrorCode())) {
                this.tryRefreshCredentials(ex);
            } else {
                this.credentialsRefreshRetries.set(0);
            }
            throw ex;
        }
    }

    private void tryRefreshCredentials(AmazonS3Exception ex) {
        try {
            int numRetries = this.credentialsRefreshRetries.getAndIncrement();
            if (numRetries >= 5) {
                log.warn("Hit maximum number of consecutive credential refresh attempts without seeing a successful request, skipping refresh attempt.");
                return;
            }
            this.credentialsProvider.ifPresent(provider -> {
                log.info("S3 credentials expired; attempting a credentials provider refresh.", ex);
                provider.refresh();
            });
        }
        catch (Exception refreshException) {
            log.error("Received exception while attempting to refresh S3 credentials.", refreshException);
        }
    }

    @Override
    public void deleteSegment(io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata objectMetadata) {
        if (this.v2Enabled) {
            try {
                this.deleteSegmentAsync(objectMetadata).get();
                return;
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception while deleting segment", e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                S3TierObjectStoreUtils.handleAwsSdkV2Exception("Unknown exception while deleting segment", e);
            }
        }
        List<DeleteObjectsRequest.KeyVersion> keys = this.keysForSegment(objectMetadata);
        com.amazonaws.services.s3.model.DeleteObjectsRequest request = new com.amazonaws.services.s3.model.DeleteObjectsRequest(this.bucket).withKeys(keys);
        try {
            this.checkExpiredCredentialsExceptionAndTryRefresh(() -> this.client.deleteObjects(request));
        }
        catch (AmazonClientException e) {
            throw new TierObjectStoreRetriableException("Failed to delete segment: " + String.valueOf(objectMetadata), e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException("Unknown exception when deleting segment: " + String.valueOf(objectMetadata), e);
        }
    }

    @Override
    public CompletableFuture<Void> deleteSegmentAsync(io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata objectMetadata) {
        this.checkAsyncClientPresent("deleteSegment");
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            List<ObjectIdentifier> keys = this.keysForSegmentV2(objectMetadata);
            DeleteObjectsRequest request = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(this.bucket).delete((Delete)Delete.builder().objects(keys).build()).build();
            this.asyncClientOpt.get().deleteObjects(request).handle((response, exception) -> {
                if (exception == null) {
                    future.complete(null);
                } else {
                    Throwable e = exception.getCause();
                    future.completeExceptionally(this.convertOperationException(e, TierObjectStoreAction.DELETE_SEGMENT.action(), Optional.of(objectMetadata), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
                }
                return null;
            });
        }
        catch (Exception e) {
            future.completeExceptionally(new TierObjectStoreFatalException("Unknown exception when deleting segment: " + String.valueOf(objectMetadata), e));
        }
        return future;
    }

    @Override
    public TierObjectAttribute objectExists(ObjectStoreMetadata objectMetadata, ObjectType objectType) throws TierObjectStoreRetriableException {
        if (this.v2Enabled) {
            try {
                return this.objectExistsAsync(objectMetadata, objectType).get();
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception when checking objects", e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                S3TierObjectStoreUtils.handleAwsSdkV2Exception("Unknown exception when checking objects", e);
            }
        }
        TierObjectAttribute result = new TierObjectAttribute(false);
        try {
            this.checkExpiredCredentialsExceptionAndTryRefresh(() -> {
                String key = this.keyPath(objectMetadata, objectType);
                GetObjectMetadataRequest request = new GetObjectMetadataRequest(this.bucket, key);
                SSECustomerKey sseCustomerKey = this.maybeGetSseCustomerKeyForObject(key, objectType, objectMetadata);
                if (sseCustomerKey != null) {
                    request = request.withSSECustomerKey(sseCustomerKey);
                }
                ObjectMetadata metadata = this.client.getObjectMetadata(request);
                log.trace("objectExists at s3://{}/{} with metadata {}", this.bucket, key, metadata);
                result.exist = true;
                result.size = metadata.getContentLength();
                return null;
            });
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 404) {
                result.exist = false;
            }
            throw new TierObjectStoreRetriableException("Failed to check object existence: " + String.valueOf(objectMetadata) + " type: " + String.valueOf((Object)objectType), e);
        }
        catch (AmazonClientException e) {
            throw new TierObjectStoreRetriableException("Failed to check object existence: " + String.valueOf(objectMetadata) + " type: " + String.valueOf((Object)objectType), e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException("Unknown exception when checking object existence: " + String.valueOf(objectMetadata) + " type: " + String.valueOf((Object)objectType), e);
        }
        return result;
    }

    @Override
    public CompletableFuture<TierObjectAttribute> objectExistsAsync(ObjectStoreMetadata objectMetadata, ObjectType objectType) {
        CompletableFuture<TierObjectAttribute> future = new CompletableFuture<TierObjectAttribute>();
        try {
            if (this.asyncClientOpt.isPresent()) {
                String key = this.keyPath(objectMetadata, objectType);
                GetObjectAttributesRequest.Builder requestBuilder = GetObjectAttributesRequest.builder().bucket(this.bucket).key(key).objectAttributes(ObjectAttributes.OBJECT_SIZE);
                Optional<SseCustomerKeyV2> sseCustomerKeyOpt = this.maybeGetSseCustomerKeyV2ForObject(key, objectType, objectMetadata);
                sseCustomerKeyOpt.ifPresent(sseCustomerKey -> requestBuilder.sseCustomerKey(sseCustomerKey.base64EncodedKey).sseCustomerKeyMD5(sseCustomerKey.base64EncodedMd5).sseCustomerAlgorithm(sseCustomerKey.customerAlgorithm));
                this.asyncClientOpt.get().getObjectAttributes((GetObjectAttributesRequest)requestBuilder.build()).handle((attributes, exception) -> {
                    if (exception != null) {
                        Throwable e;
                        Throwable throwable = e = exception.getCause() != null ? exception.getCause() : exception;
                        if (e instanceof NoSuchKeyException) {
                            future.complete(new TierObjectAttribute(false));
                        } else if (e instanceof AwsServiceException) {
                            AwsServiceException ex = (AwsServiceException)e;
                            if (ex.statusCode() == 404) {
                                future.complete(new TierObjectAttribute(false));
                            } else if (SdkDefaultRetrySetting.RETRYABLE_STATUS_CODES.contains(ex.statusCode())) {
                                future.completeExceptionally(new TierObjectStoreRetriableException("Failed to check object existence: " + String.valueOf(objectMetadata) + " type: " + String.valueOf((Object)objectType), e));
                            } else if (this.isKmsXKSProxyTimeoutException(ex)) {
                                future.completeExceptionally(new TierObjectStoreRetriableException("Failed to check object existence: " + String.valueOf(objectMetadata) + " type: " + String.valueOf((Object)objectType), e));
                            } else {
                                future.completeExceptionally(new TierObjectStoreFatalException("Unknown exception when checking object existence: " + String.valueOf(objectMetadata) + " type: " + String.valueOf((Object)objectType), e));
                            }
                        } else if (this.isRetryable(e)) {
                            future.completeExceptionally(new TierObjectStoreRetriableException("Failed to check object existence: " + String.valueOf(objectMetadata) + " type: " + String.valueOf((Object)objectType), e));
                        } else {
                            future.completeExceptionally(new TierObjectStoreFatalException("Unknown exception when checking object existence: " + String.valueOf(objectMetadata) + " type: " + String.valueOf((Object)objectType), e));
                        }
                    } else {
                        log.trace("objectExists (async) at s3://{}/{} with metadata {}", this.bucket, key, attributes);
                        future.complete(new TierObjectAttribute(true, attributes.objectSize()));
                    }
                    return null;
                });
            } else {
                log.warn("Fallback to objectExists because async S3 client isn't created, metadata: {}, type: {}", (Object)objectMetadata, (Object)objectType);
                future.complete(this.objectExists(objectMetadata, objectType));
            }
        }
        catch (Exception e) {
            log.error("Failed to send objectExistsAsync request, metadata: {}, type: {}", new Object[]{objectMetadata, objectType, e});
            future.completeExceptionally(e);
        }
        return future;
    }

    @Override
    public void deleteVersions(List<TierObjectStore.KeyAndVersion> keys) {
        if (this.v2Enabled) {
            try {
                this.deleteVersionsAsync(keys).get();
                return;
            }
            catch (InterruptedException | CancellationException e) {
                throw new TierObjectStoreFatalException("Unknown exception when deleting versions", e.getCause() != null ? e.getCause() : e);
            }
            catch (ExecutionException e) {
                S3TierObjectStoreUtils.handleAwsSdkV2Exception("Unknown exception when deleting versions", e);
            }
        }
        ArrayList<DeleteObjectsRequest.KeyVersion> s3Keys = new ArrayList<DeleteObjectsRequest.KeyVersion>();
        for (TierObjectStore.KeyAndVersion key : keys) {
            DeleteObjectsRequest.KeyVersion keyVersion = key.versionId() == null ? new DeleteObjectsRequest.KeyVersion(key.key()) : new DeleteObjectsRequest.KeyVersion(key.key(), key.versionId());
            log.debug("Deleting object {} {}", (Object)keyVersion.getKey(), (Object)keyVersion.getVersion());
            s3Keys.add(keyVersion);
            if (s3Keys.size() < 1000) continue;
            this.makeDeleteObjectsCall(s3Keys);
            s3Keys.clear();
        }
        if (!s3Keys.isEmpty()) {
            this.makeDeleteObjectsCall(s3Keys);
        }
    }

    @Override
    public CompletableFuture<Void> deleteVersionsAsync(List<TierObjectStore.KeyAndVersion> keys) {
        this.checkAsyncClientPresent("deleteVersions");
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            ArrayList<ObjectIdentifier> s3Keys = new ArrayList<ObjectIdentifier>();
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            for (TierObjectStore.KeyAndVersion key : keys) {
                ObjectIdentifier keyVersion = key.versionId() == null ? (ObjectIdentifier)ObjectIdentifier.builder().key(key.key()).build() : (ObjectIdentifier)ObjectIdentifier.builder().key(key.key()).versionId(key.versionId()).build();
                log.debug("Deleting object {} {}", (Object)keyVersion.key(), (Object)keyVersion.versionId());
                s3Keys.add(keyVersion);
                if (s3Keys.size() < 1000) continue;
                futures.add(this.makeDeleteObjectsCallAsync(s3Keys));
                s3Keys.clear();
            }
            if (!s3Keys.isEmpty()) {
                futures.add(this.makeDeleteObjectsCallAsync(s3Keys));
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenComplete((response, e) -> {
                if (e != null) {
                    future.completeExceptionally((Throwable)e);
                } else {
                    future.complete(null);
                }
            });
        }
        catch (Exception e2) {
            log.error("Failed to send async delete request, keys: {}", (Object)keys, (Object)e2);
            future.completeExceptionally(e2);
        }
        return future;
    }

    private void makeDeleteObjectsCall(List<DeleteObjectsRequest.KeyVersion> s3Keys) {
        com.amazonaws.services.s3.model.DeleteObjectsRequest request = new com.amazonaws.services.s3.model.DeleteObjectsRequest(this.bucket).withKeys(s3Keys);
        try {
            this.checkExpiredCredentialsExceptionAndTryRefresh(() -> {
                log.debug("Sending a batch delete request");
                return this.client.deleteObjects(request);
            });
        }
        catch (MultiObjectDeleteException e) {
            log.error("S3 reported errors while deleting the following versioned objects:");
            e.getErrors().forEach(err -> log.error("Blob Key: " + err.getKey() + " Blob VersionId: " + err.getVersionId() + " Error Code: " + err.getCode() + " Error Message: " + err.getMessage()));
            throw new TierObjectStoreRetriableException("Failed to delete " + e.getErrors().size() + " versioned objects", e);
        }
        catch (com.amazonaws.SdkClientException e) {
            log.error(Arrays.toString(e.getStackTrace()));
            throw new TierObjectStoreRetriableException("Failed to delete versioned objects", e);
        }
        catch (Exception e) {
            throw new TierObjectStoreFatalException("Unknown exception when deleting versioned objects", e);
        }
    }

    private CompletableFuture<Void> makeDeleteObjectsCallAsync(List<ObjectIdentifier> s3Keys) {
        DeleteObjectsRequest request = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(this.bucket).delete((Delete)Delete.builder().objects(s3Keys).build()).build();
        log.debug("Sending a batch delete request");
        return this.asyncClientOpt.get().deleteObjects(request).handle((response, e) -> {
            if (e != null) {
                throw this.convertOperationException(e.getCause(), TierObjectStoreAction.DELETE_VERSIONED_OBJECTS.action(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
            }
            return null;
        });
    }

    @Override
    public void close() {
        super.close();
        this.client.shutdown();
        this.encryptionKeyManagerOpt.ifPresent(e -> e.close());
        this.asyncClientOpt.ifPresent(c -> c.close());
        this.executorOpt.ifPresent(e -> e.shutdown());
    }

    @Override
    public Optional<TenantAwareEncryptionKeyManager> initMultiTenantEncryptionSupport(MultiTenantMetadata multiTenantMetadata, ReplicaManager replicaManager) {
        if (this.config.tenantAwareEncryptionKeyManagerEnable) {
            if (this.asyncClientOpt.isPresent() && this.v2Enabled) {
                log.info("Initializing AwsTenantAwareEncryptionManager with V2 S3 client");
                this.encryptionKeyManagerOpt = Optional.of(new AwsTenantAwareEncryptionManager<S3AsyncClient>(this.asyncClientOpt.get(), this.config, multiTenantMetadata, this.time, this.metrics));
            } else {
                log.info("Initializing AwsTenantAwareEncryptionManager with v1 S3 client");
                this.encryptionKeyManagerOpt = Optional.of(new AwsTenantAwareEncryptionManager<AmazonS3>(this.client, this.config, multiTenantMetadata, this.time, this.metrics));
            }
            this.encryptionKeyCacheRefillerOpt = Optional.of(new FtpsEncryptionKeyCacheRefiller(replicaManager));
        } else {
            log.info("Skipping initialization of AwsTenantAwareEncryptionManager");
        }
        return this.encryptionKeyManagerOpt;
    }

    void setEncryptionKeyManagerOpt(AwsTenantAwareEncryptionManager<?> tenantAwareEncryptionManager) {
        this.encryptionKeyManagerOpt = Optional.of(tenantAwareEncryptionManager);
    }

    void setEncryptionKeyCacheRefillerOpt(EncryptionKeyCacheRefiller<Void> encryptionKeyCacheRefiller) {
        this.encryptionKeyCacheRefillerOpt = Optional.of(encryptionKeyCacheRefiller);
    }

    private String keyPath(ObjectStoreMetadata objectMetadata, ObjectType objectType) {
        return TierObjectStoreUtils.keyPath(this.prefix, objectMetadata, objectType);
    }

    private String fullKeyPath(String key) {
        return "s3://" + this.bucket + "/" + key;
    }

    private ObjectMetadata objectMetadataWithSseAlgorithm(Map<String, String> userMetadata) {
        ObjectMetadata metadata = new ObjectMetadata();
        if (this.sseAlgorithm != null) {
            metadata.setSSEAlgorithm(this.sseAlgorithm);
        }
        if (userMetadata != null) {
            metadata.setUserMetadata(userMetadata);
        }
        return metadata;
    }

    private void setSseAlgorithmAndKmsParamsV2(PutObjectRequest.Builder requestBuilder) {
        if (this.sseAlgorithm != null) {
            requestBuilder.serverSideEncryption(this.sseAlgorithm);
        }
        if (this.usesKms()) {
            requestBuilder.serverSideEncryption(ServerSideEncryption.AWS_KMS).ssekmsKeyId(this.sseCustomerEncryptionKey);
        }
    }

    private void checkAsyncClientPresent(String requestType) {
        if (!this.asyncClientOpt.isPresent()) {
            throw new TierObjectStoreFatalException(String.format("Failed to send async %s request because async S3 client isn't created", requestType));
        }
    }

    private void setKmsParams(PutObjectRequest request) {
        if (this.usesKms()) {
            request.setSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(this.sseCustomerEncryptionKey));
        }
    }

    private void putFile(String key, Map<String, String> metadata, File file, E2EChecksumProtectedObjectType objectType, Optional<Throttler> throttlerOpt) throws IOException {
        ObjectMetadata s3ObjMetadata = this.objectMetadataWithSseAlgorithm(metadata);
        Optional<String> crc = this.getCrcAndSetHeader(objectType, file, metadata, s3ObjMetadata);
        if (throttlerOpt.isPresent()) {
            try (ThrottledFileInputStream fileInputStream = new ThrottledFileInputStream(file, throttlerOpt.get());){
                s3ObjMetadata.setContentLength(file.length());
                PutObjectRequest request = new PutObjectRequest(this.bucket, key, fileInputStream, s3ObjMetadata);
                if (this.isStorageClassDefined()) {
                    request.setStorageClass(this.config.s3StorageClass.get());
                }
                this.setKmsParams(request);
                if (crc.isPresent()) {
                    log.debug("Uploading object to s3 with throttling://{}/{} with crc {}", this.bucket, key, crc.get());
                } else {
                    log.debug("Uploading object to s3 with throttling://{}/{}", (Object)this.bucket, (Object)key);
                }
                this.client.putObject(request);
            }
        } else {
            PutObjectRequest request = new PutObjectRequest(this.bucket, key, file).withMetadata(s3ObjMetadata);
            if (this.isStorageClassDefined()) {
                request.setStorageClass(this.config.s3StorageClass.get());
            }
            this.setKmsParams(request);
            if (crc.isPresent()) {
                log.debug("Uploading object to s3://{}/{} with crc {}", this.bucket, key, crc.get());
            } else {
                log.debug("Uploading object to s3://{}/{}", (Object)this.bucket, (Object)key);
            }
            this.client.putObject(request);
        }
    }

    private void logEncryptedUploadMessage(String key, KeySha keySha, boolean isThrottled, Optional<String> crc) {
        String logMessagePrefix;
        String string = logMessagePrefix = isThrottled ? "Uploading encrypted object with throttling for S3 key" : "Uploading encrypted object for S3 key";
        if (crc.isPresent()) {
            log.info("{}: {}/{} with crc {} with KeySha {}", logMessagePrefix, this.bucket, key, crc.get(), keySha);
        } else {
            log.info("{}: {}/{} with KeySha {}", logMessagePrefix, this.bucket, key, keySha);
        }
    }

    private SSECustomerKey generateSseCustomerKey(TopicIdPartition topicIdPartition, KeySha keySha) {
        DataEncryptionKeyHolder holder = TierObjectStoreByokUtils.generateEncryptionKeyForObject(topicIdPartition, keySha, this.encryptionKeyManagerOpt.get());
        byte[] rawEncryptionKey = holder.cleartextDataKey.rawKeyMaterial();
        return new SSECustomerKey(new SecretKeySpec(rawEncryptionKey, 0, rawEncryptionKey.length, this.encryptionKeyManagerOpt.get().getKeyManagementClientEncryptionAlgorithm()));
    }

    private void throwIfIllegalPutInvocation(Optional<File> fileOpt, Optional<InputStream> inputStreamOpt) {
        if (fileOpt.isPresent() && inputStreamOpt.isPresent()) {
            throw new IllegalArgumentException("Expected either a file or an input stream to be supplied for the put request, but received both.");
        }
        if (!fileOpt.isPresent() && !inputStreamOpt.isPresent()) {
            throw new IllegalArgumentException("Expected either a file or an input stream to be supplied for the put request, but received neither.");
        }
    }

    private void sendEncryptedPutRequest(String key, io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata objectMetadata, ObjectMetadata s3ObjMetadata, boolean isThrottled, Optional<File> fileOpt, Optional<InputStream> inputStreamOpt, Optional<String> crc, Optional<Integer> contentLengthOpt) {
        this.throwIfIllegalPutInvocation(fileOpt, inputStreamOpt);
        KeySha keySha = KeySha.fromRawBytes(objectMetadata.opaqueData().intoByteArray());
        SSECustomerKey sseCustomerKey = this.generateSseCustomerKey(objectMetadata.topicIdPartition(), keySha);
        if (fileOpt.isPresent()) {
            File file = fileOpt.get();
            PutObjectRequest request = new PutObjectRequest(this.bucket, key, file).withMetadata(s3ObjMetadata).withSSECustomerKey(sseCustomerKey);
            if (this.isStorageClassDefined()) {
                request.setStorageClass(this.config.s3StorageClass.get());
            }
            this.logEncryptedUploadMessage(key, keySha, isThrottled, crc);
            this.client.putObject(request);
        } else {
            InputStream stream = inputStreamOpt.get();
            PutObjectRequest request = new PutObjectRequest(this.bucket, key, stream, s3ObjMetadata).withSSECustomerKey(sseCustomerKey);
            if (this.isStorageClassDefined()) {
                request.setStorageClass(this.config.s3StorageClass.get());
            }
            contentLengthOpt.ifPresent(contentLength -> request.getRequestClientOptions().setReadLimit(contentLength + 1));
            this.logEncryptedUploadMessage(key, keySha, isThrottled, crc);
            this.client.putObject(request);
        }
    }

    private void putFileEncrypted(String key, File file, io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata objectMetadata, E2EChecksumProtectedObjectType objectType, Optional<Throttler> throttler) throws IOException {
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        ObjectMetadata s3ObjMetadata = new ObjectMetadata();
        s3ObjMetadata.setUserMetadata(metadata);
        Optional<String> crc = this.getCrcAndSetHeader(objectType, file, metadata, s3ObjMetadata);
        if (throttler.isPresent()) {
            try (ThrottledFileInputStream fileInputStream = new ThrottledFileInputStream(file, throttler.get());){
                s3ObjMetadata.setContentLength(file.length());
                this.sendEncryptedPutRequest(key, objectMetadata, s3ObjMetadata, true, Optional.empty(), Optional.of(fileInputStream), crc, Optional.empty());
            }
        } else {
            this.sendEncryptedPutRequest(key, objectMetadata, s3ObjMetadata, false, Optional.of(file), Optional.empty(), crc, Optional.empty());
        }
    }

    private CompletableFuture<PutObjectResponse> putFileEncryptedAsync(String key, io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata objectMetadata, File file, E2EChecksumProtectedObjectType objectType, Optional<Throttler> throttler) throws IOException {
        this.checkAsyncClientPresent("putFile");
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        Optional<String> crc = this.getCrcAndSetHeaderV2(objectType, file, metadata);
        PutObjectRequest.Builder putRequestBuilder = software.amazon.awssdk.services.s3.model.PutObjectRequest.builder().bucket(this.bucket).key(key).metadata(metadata);
        KeySha keySha = KeySha.fromRawBytes(objectMetadata.opaqueData().intoByteArray());
        SseCustomerKeyV2 sseCustomerKey = new SseCustomerKeyV2(objectMetadata.topicIdPartition(), keySha);
        putRequestBuilder.sseCustomerKey(sseCustomerKey.base64EncodedKey).sseCustomerKeyMD5(sseCustomerKey.base64EncodedMd5).sseCustomerAlgorithm(sseCustomerKey.customerAlgorithm);
        if (this.isStorageClassDefined()) {
            putRequestBuilder.storageClass(this.config.s3StorageClass.get());
        }
        if (throttler.isPresent()) {
            log.info("Asynchronously uploading encrypted object with throttling for S3 key: {}/{} with crc {} with OpaqueData {}", this.bucket, key, crc.orElse(null), keySha);
            ThrottledFileInputStream fileInputStream = new ThrottledFileInputStream(file, throttler.get());
            return this.sendAsyncPutRequest(putRequestBuilder, key, metadata, objectType, true, true, file.length(), Optional.empty(), Optional.of(fileInputStream));
        }
        log.info("Asynchronously uploading encrypted object for S3 key: {}/{} with crc {} with OpaqueData {}", this.bucket, key, crc.orElse(null), keySha);
        return this.sendAsyncPutRequest(putRequestBuilder, key, metadata, objectType, true, false, file.length(), Optional.of(file), Optional.empty());
    }

    private CompletableFuture<PutObjectResponse> sendAsyncPutRequest(PutObjectRequest.Builder builder, String key, Map<String, String> metadata, E2EChecksumProtectedObjectType objectType, boolean isEncrypted, boolean isThrottled, long contentLength, Optional<File> fileOpt, Optional<InputStream> inputStreamOpt) {
        this.throwIfIllegalPutInvocation(fileOpt, inputStreamOpt);
        CompletableFuture<PutObjectResponse> future = new CompletableFuture<PutObjectResponse>();
        if (fileOpt.isPresent()) {
            try {
                this.asyncClientOpt.get().putObject((software.amazon.awssdk.services.s3.model.PutObjectRequest)builder.build(), AsyncRequestBody.fromFile(fileOpt.get())).handle((response, e) -> {
                    if (e != null) {
                        future.completeExceptionally(e.getCause());
                    } else {
                        future.complete((PutObjectResponse)response);
                    }
                    return null;
                });
            }
            catch (Exception e2) {
                log.error("Failed to send putFileAsync request, isThrottled: {}, isEncrypted: {}, key: {}, metadata: {}, type: {}, file: {}", new Object[]{isThrottled, isEncrypted, key, metadata, objectType, fileOpt.get().getPath()});
                future.completeExceptionally(e2);
            }
        } else {
            InputStream is = inputStreamOpt.get();
            try {
                AsyncRequestBodyFromInputStreamConfiguration config = (AsyncRequestBodyFromInputStreamConfiguration)AsyncRequestBodyFromInputStreamConfiguration.builder().inputStream(is).contentLength(contentLength).maxReadLimit((int)contentLength + 1).executor(this.getExecutor().get()).build();
                this.asyncClientOpt.get().putObject((software.amazon.awssdk.services.s3.model.PutObjectRequest)builder.build(), AsyncRequestBody.fromInputStream(config)).handle((response, e) -> {
                    if (e != null) {
                        future.completeExceptionally(e.getCause());
                    } else {
                        future.complete((PutObjectResponse)response);
                    }
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        log.warn("failed closing InputStream after completion of asynchronous putObject", ex);
                    }
                    return null;
                });
            }
            catch (Exception e3) {
                log.error("Failed to send putInputStreamAsync request, isThrottled: {}, isEncrypted: {}, key: {}, metadata: {}, type: {}", new Object[]{isThrottled, isEncrypted, key, metadata, objectType});
                future.completeExceptionally(e3);
            }
        }
        return future;
    }

    private CompletableFuture<PutObjectResponse> putFileAsync(String key, Map<String, String> metadata, File file, E2EChecksumProtectedObjectType objectType, Optional<Throttler> throttlerOpt) throws IOException {
        this.checkAsyncClientPresent("putFile");
        Optional<String> crc = this.getCrcAndSetHeaderV2(objectType, file, metadata);
        PutObjectRequest.Builder putRequestBuilder = software.amazon.awssdk.services.s3.model.PutObjectRequest.builder().bucket(this.bucket).key(key).metadata(metadata);
        this.setSseAlgorithmAndKmsParamsV2(putRequestBuilder);
        if (this.isStorageClassDefined()) {
            putRequestBuilder.storageClass(this.config.s3StorageClass.get());
        }
        if (throttlerOpt.isPresent()) {
            ThrottledFileInputStream fileInputStream = new ThrottledFileInputStream(file, throttlerOpt.get());
            log.debug("Uploading object to s3 with throttling://{}/{} with crc {}", this.bucket, key, crc.orElse(null));
            return this.sendAsyncPutRequest(putRequestBuilder, key, metadata, objectType, false, true, file.length(), Optional.empty(), Optional.of(fileInputStream));
        }
        log.debug("Uploading object to s3://{}/{} with crc {}", this.bucket, key, crc.orElse(null));
        return this.sendAsyncPutRequest(putRequestBuilder, key, metadata, objectType, false, false, file.length(), Optional.of(file), Optional.empty());
    }

    private Optional<ExecutorService> getExecutor() {
        if (!this.executorOpt.isPresent()) {
            this.executorOpt = Optional.of(Executors.newSingleThreadExecutor());
        }
        return this.executorOpt;
    }

    private CompletableFuture<PutObjectResponse> putFileWithThrottlingAsync(String key, Map<String, String> metadata, File file, E2EChecksumProtectedObjectType objectType, Throttler throttler) {
        this.checkAsyncClientPresent("putFileWithThrottling");
        CompletableFuture<PutObjectResponse> future = new CompletableFuture<PutObjectResponse>();
        Optional<String> crc = this.getCrcAndSetHeaderV2(objectType, file, metadata);
        PutObjectRequest.Builder putRequestBuilder = software.amazon.awssdk.services.s3.model.PutObjectRequest.builder().bucket(this.bucket).key(key).metadata(metadata);
        this.setSseAlgorithmAndKmsParamsV2(putRequestBuilder);
        try {
            ThrottledFileInputStream fileInputStream = new ThrottledFileInputStream(file, throttler);
            log.debug("Uploading object to s3 with throttling://{}/{} with crc {}", this.bucket, key, crc.orElse(null));
            AsyncRequestBodyFromInputStreamConfiguration config = (AsyncRequestBodyFromInputStreamConfiguration)AsyncRequestBodyFromInputStreamConfiguration.builder().inputStream(fileInputStream).contentLength(file.length()).maxReadLimit((int)file.length() + 1).executor(this.getExecutor().get()).build();
            this.asyncClientOpt.get().putObject((software.amazon.awssdk.services.s3.model.PutObjectRequest)putRequestBuilder.build(), AsyncRequestBody.fromInputStream(config)).handle((response, e) -> {
                if (e != null) {
                    future.completeExceptionally(e.getCause());
                } else {
                    future.complete((PutObjectResponse)response);
                }
                return null;
            });
        }
        catch (Exception e2) {
            future.completeExceptionally(e2);
        }
        return future;
    }

    private Optional<String> getCrc(E2EChecksumProtectedObjectType objectType, File file, Map<String, String> metadata) {
        if (!this.checksumStoreOpt.isPresent()) {
            return Optional.empty();
        }
        E2EChecksumStore checksumStore = this.checksumStoreOpt.get();
        Optional<String> crc = Optional.empty();
        if (checksumStore.checksumProtectionEnabled(objectType)) {
            crc = objectType.shouldCalculateBeforeUpload() ? E2EChecksumUtils.compute32BitBase64Crc32c(file) : E2EChecksumUtils.getBase64CrcFromStore(checksumStore, file, metadata);
        }
        return crc;
    }

    private Optional<String> getCrcAndSetHeader(E2EChecksumProtectedObjectType objectType, File file, Map<String, String> metadata, ObjectMetadata s3ObjMetadata) {
        Optional<String> crc = this.getCrc(objectType, file, metadata);
        crc.ifPresent(s -> s3ObjMetadata.setHeader(CRC32C_HEADER, s));
        return crc;
    }

    private Optional<String> getCrcAndSetHeaderV2(E2EChecksumProtectedObjectType objectType, File file, Map<String, String> metadata) {
        Optional<String> crc = this.getCrc(objectType, file, metadata);
        if (crc.isPresent()) {
            metadata.put(CRC32C_HEADER, crc.get());
        } else {
            metadata.remove(CRC32C_HEADER);
        }
        return crc;
    }

    public void putBuf(String key, Map<String, String> userMetadata, ByteBuffer buf) {
        ObjectMetadata s3Metadata = this.objectMetadataWithSseAlgorithm(userMetadata);
        s3Metadata.setContentLength(buf.limit() - buf.position());
        s3Metadata.setHeader(CRC32C_HEADER, E2EChecksumUtils.compute32BitBase64Crc32c(buf));
        PutObjectRequest request = new PutObjectRequest(this.bucket, key, new ByteBufferInputStream(buf.duplicate()), s3Metadata);
        if (this.isStorageClassDefined()) {
            request.setStorageClass(this.config.s3StorageClass.get());
        }
        this.setKmsParams(request);
        log.debug("Uploading buffer to s3://{}/{}", (Object)this.bucket, (Object)key);
        this.client.putObject(request);
    }

    public CompletableFuture<PutObjectResponse> putBufAsync(String key, Map<String, String> userMetadata, ByteBuffer buf) {
        this.checkAsyncClientPresent("putBuf");
        CompletableFuture<PutObjectResponse> future = new CompletableFuture<PutObjectResponse>();
        HashMap<String, String> metadata = new HashMap<String, String>(userMetadata);
        metadata.put(CRC32C_HEADER, E2EChecksumUtils.compute32BitBase64Crc32c(buf));
        PutObjectRequest.Builder putRequestBuilder = software.amazon.awssdk.services.s3.model.PutObjectRequest.builder().bucket(this.bucket).key(key).metadata(metadata);
        if (this.isStorageClassDefined()) {
            putRequestBuilder.storageClass(this.config.s3StorageClass.get());
        }
        this.setSseAlgorithmAndKmsParamsV2(putRequestBuilder);
        log.debug("Uploading buffer to s3://{}/{}", (Object)this.bucket, (Object)key);
        this.asyncClientOpt.get().putObject((software.amazon.awssdk.services.s3.model.PutObjectRequest)putRequestBuilder.build(), AsyncRequestBody.fromByteBuffer(buf.duplicate())).handle((response, e) -> {
            if (e != null) {
                future.completeExceptionally(e.getCause());
            } else {
                future.complete((PutObjectResponse)response);
            }
            return null;
        });
        return future;
    }

    private boolean usesKms() {
        return this.config.usesKms();
    }

    private boolean isStorageClassDefined() {
        return this.config.s3StorageClass.isPresent() && !this.config.s3StorageClass.get().isBlank();
    }

    private List<DeleteObjectsRequest.KeyVersion> keysForSegment(io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata objectMetadata) {
        if (objectMetadata.isCombinedObject(this.prefix)) {
            return Collections.singletonList(new DeleteObjectsRequest.KeyVersion(this.keyPath(objectMetadata, ObjectType.SEGMENT_WITH_METADATA)));
        }
        ArrayList<DeleteObjectsRequest.KeyVersion> keys = new ArrayList<DeleteObjectsRequest.KeyVersion>();
        block5: for (ObjectType objectType : TierObjectStore.getObjectTypesPerSegment()) {
            switch (objectType) {
                case TRANSACTION_INDEX: {
                    if (!objectMetadata.hasAbortedTxns()) continue block5;
                    keys.add(new DeleteObjectsRequest.KeyVersion(this.keyPath(objectMetadata, objectType)));
                    continue block5;
                }
                case EPOCH_STATE: {
                    if (!objectMetadata.hasEpochState()) continue block5;
                    keys.add(new DeleteObjectsRequest.KeyVersion(this.keyPath(objectMetadata, objectType)));
                    continue block5;
                }
                case PRODUCER_STATE: {
                    if (!objectMetadata.hasProducerState()) continue block5;
                    keys.add(new DeleteObjectsRequest.KeyVersion(this.keyPath(objectMetadata, objectType)));
                    continue block5;
                }
            }
            keys.add(new DeleteObjectsRequest.KeyVersion(this.keyPath(objectMetadata, objectType)));
        }
        return keys;
    }

    private List<ObjectIdentifier> keysForSegmentV2(io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata objectMetadata) {
        if (objectMetadata.isCombinedObject(this.prefix)) {
            return Collections.singletonList((ObjectIdentifier)ObjectIdentifier.builder().key(this.keyPath(objectMetadata, ObjectType.SEGMENT_WITH_METADATA)).build());
        }
        ArrayList<ObjectIdentifier> keys = new ArrayList<ObjectIdentifier>();
        block5: for (ObjectType objectType : TierObjectStore.getObjectTypesPerSegment()) {
            switch (objectType) {
                case TRANSACTION_INDEX: {
                    if (!objectMetadata.hasAbortedTxns()) continue block5;
                    keys.add((ObjectIdentifier)ObjectIdentifier.builder().key(this.keyPath(objectMetadata, objectType)).build());
                    continue block5;
                }
                case EPOCH_STATE: {
                    if (!objectMetadata.hasEpochState()) continue block5;
                    keys.add((ObjectIdentifier)ObjectIdentifier.builder().key(this.keyPath(objectMetadata, objectType)).build());
                    continue block5;
                }
                case PRODUCER_STATE: {
                    if (!objectMetadata.hasProducerState()) continue block5;
                    keys.add((ObjectIdentifier)ObjectIdentifier.builder().key(this.keyPath(objectMetadata, objectType)).build());
                    continue block5;
                }
            }
            keys.add((ObjectIdentifier)ObjectIdentifier.builder().key(this.keyPath(objectMetadata, objectType)).build());
        }
        return keys;
    }

    @Override
    public BucketHealthResult checkBucketHealth() {
        if (this.v2Enabled) {
            return this.checkBucketHealthV2();
        }
        try {
            return this.checkExpiredCredentialsExceptionAndTryRefresh(() -> {
                ByteBuffer payload = TierObjectStoreUtils.timeHealthPayload();
                HealthMetadata metadata = new HealthMetadata(this.clusterIdOpt, this.brokerIdOpt);
                String key = metadata.toFragmentLocation(this.prefix, FragmentType.HEALTH_CHECK).get().objectPath();
                this.putBuf(key, metadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt), payload);
                try (InputStream inputStream = this.getObjectStoreFragment(metadata, FragmentType.HEALTH_CHECK).getInputStream();){
                    int read;
                    while ((read = inputStream.read()) > 0) {
                        log.trace("Bucket probe read {} bytes", (Object)read);
                    }
                }
                this.client.deleteObject(this.bucket, key);
                return BucketHealthResult.HEALTHY;
            });
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 400 && e.getErrorCode() != null && e.getErrorCode().startsWith("KMS.")) {
                log.error("Bucket health checker resulted in a BYOK related error with error code: {}, status code: {}", e.getErrorCode(), e.getStatusCode(), e);
                return BucketHealthResult.BYOK;
            }
            if (e.getStatusCode() == 403 && Objects.equals(e.getErrorCode(), "AccessDenied")) {
                log.error("Bucket health checker resulted in a permission error for customer key: {}", (Object)(this.usesKms() ? "not enabled" : this.sseCustomerEncryptionKey), (Object)e);
                if (this.usesKms()) {
                    return BucketHealthResult.BYOK;
                }
                return BucketHealthResult.PERMISSION;
            }
            log.error("Bucket health checker returned an unclassified error for status code: {} error code: {}", e.getStatusCode(), e.getErrorCode(), e);
            return BucketHealthResult.UNCLASSIFIED;
        }
        catch (Exception e) {
            log.error("Bucket health checker returned unclassified error", e);
            return BucketHealthResult.UNCLASSIFIED;
        }
    }

    public BucketHealthResult checkBucketHealthV2() {
        try {
            this.checkAsyncClientPresent("checkBucketHealth");
            ByteBuffer payload = TierObjectStoreUtils.timeHealthPayload();
            HealthMetadata metadata = new HealthMetadata(this.clusterIdOpt, this.brokerIdOpt);
            String key = metadata.toFragmentLocation(this.prefix, FragmentType.HEALTH_CHECK).get().objectPath();
            this.putBufAsync(key, metadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt), payload).get();
            try (InputStream inputStream = this.getObjectStoreFragmentAsync(metadata, FragmentType.HEALTH_CHECK).get().getInputStream();){
                int read;
                while ((read = inputStream.read()) > 0) {
                    log.trace("Bucket probe read {} bytes", (Object)read);
                }
            }
            ObjectIdentifier objectToDelete = (ObjectIdentifier)ObjectIdentifier.builder().key(key).build();
            DeleteObjectsRequest request = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(this.bucket).delete((Delete)Delete.builder().objects(objectToDelete).build()).build();
            this.asyncClientOpt.get().deleteObjects(request).get();
            return BucketHealthResult.HEALTHY;
        }
        catch (Exception exception) {
            Throwable e;
            Throwable throwable = e = exception instanceof CompletionException ? exception.getCause() : exception;
            if (e instanceof AwsServiceException) {
                AwsServiceException awsEx = (AwsServiceException)e;
                if (awsEx.statusCode() == 400 && awsEx.awsErrorDetails().errorCode() != null && awsEx.awsErrorDetails().errorCode().startsWith("KMS.")) {
                    log.error("Bucket health checker resulted in a BYOK related error with error code: {}, status code: {}", awsEx.awsErrorDetails().errorCode(), awsEx.statusCode(), awsEx);
                    return BucketHealthResult.BYOK;
                }
                if (awsEx.statusCode() == 403 && Objects.equals(awsEx.awsErrorDetails().errorCode(), "AccessDenied")) {
                    log.error("Bucket health checker resulted in a permission error for customer key: {}", (Object)(this.usesKms() ? "not enabled" : this.sseCustomerEncryptionKey), (Object)awsEx);
                    if (this.usesKms()) {
                        return BucketHealthResult.BYOK;
                    }
                    return BucketHealthResult.PERMISSION;
                }
                log.error("Bucket health checker returned an unclassified error for status code: {} error code: {}", awsEx.statusCode(), awsEx.awsErrorDetails().errorCode(), awsEx);
                return BucketHealthResult.UNCLASSIFIED;
            }
            log.error("Bucket health checker returned unclassified error", e);
            return BucketHealthResult.UNCLASSIFIED;
        }
    }

    public static String validateAndGetS3RegionName(String s3Region) {
        try {
            return Regions.fromName(s3Region).getName();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Configured " + KafkaConfig.TierS3RegionProp() + " '" + s3Region + "' is not known");
        }
    }

    private static boolean shouldEnableDualStack(S3TierObjectStoreConfig config) {
        if (config.s3Ipv6Enabled) {
            if (config.s3EndpointOverride.isPresent() && !config.s3EndpointOverride.get().isEmpty()) {
                log.warn("S3 dual-stack endpoint will not be enabled when using an endpoint override. Please set an IPv6 compatible S3 endpoint override to ensure IPv6 connectivity. ");
            } else {
                return true;
            }
        }
        return false;
    }

    public static AmazonS3ClientAndCredentialsProvider client(S3TierObjectStoreConfig config) throws TierObjectStoreFatalException {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setUserAgentPrefix(config.s3UserAgentPrefix);
        SSLConnectionSocketFactory sslConnectionSocketFactory = S3TierObjectStore.getSSLConnectionSocketFactory(config);
        if (sslConnectionSocketFactory != null) {
            clientConfiguration.getApacheHttpClientConfig().setSslSocketFactory(sslConnectionSocketFactory);
        }
        AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
        builder.setClientConfiguration(clientConfiguration);
        if (config.s3ForcePathStyleAccess.booleanValue()) {
            builder.setPathStyleAccessEnabled(true);
        }
        if (config.s3SignerOverride.isPresent() && !config.s3SignerOverride.get().isEmpty()) {
            clientConfiguration.setSignerOverride(config.s3SignerOverride.get());
        }
        if (config.s3EndpointOverride.isPresent() && !config.s3EndpointOverride.get().isEmpty()) {
            String s3RegionName = S3TierObjectStore.validateAndGetS3RegionName(config.s3Region);
            builder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(config.s3EndpointOverride.get(), s3RegionName));
        } else if (config.s3Region != null && !config.s3Region.isEmpty()) {
            builder.setRegion(config.s3Region);
        }
        log.debug("AWS_METADATA_SERVICE_TIMEOUT is {} seconds", (Object)System.getenv("AWS_METADATA_SERVICE_TIMEOUT"));
        AWSCredentialsProvider provider = config.s3CredFilePath.map(PropertiesFileCredentialsProvider::new).orElse(new DefaultAWSCredentialsProviderChain());
        if (config.assumeRoleArn.isPresent()) {
            AWSSecurityTokenServiceClientBuilder stsClientBuilder = AWSSecurityTokenServiceClient.builder();
            stsClientBuilder.setCredentials(provider);
            if (config.s3EndpointOverride.isPresent() && !config.s3EndpointOverride.get().isEmpty()) {
                String s3RegionName = S3TierObjectStore.validateAndGetS3RegionName(config.s3Region);
                stsClientBuilder.setRegion(s3RegionName);
            } else if (config.s3Region != null && !config.s3Region.isEmpty()) {
                stsClientBuilder.setRegion(config.s3Region);
            }
            AWSSecurityTokenService stsClient = (AWSSecurityTokenService)stsClientBuilder.build();
            provider = new STSAssumeRoleSessionCredentialsProvider.Builder(config.assumeRoleArn.get(), "tiered-storage").withStsClient(stsClient).build();
        }
        builder.setCredentials(provider);
        if (S3TierObjectStore.shouldEnableDualStack(config)) {
            builder.setDualstackEnabled(true);
        }
        return new AmazonS3ClientAndCredentialsProvider((AmazonS3)builder.build(), S3TierObjectStore.buildAsyncClient(config, sslConnectionSocketFactory), provider);
    }

    private static Optional<S3AsyncClient> buildAsyncClient(S3TierObjectStoreConfig config, SSLConnectionSocketFactory sslConnectionSocketFactory) {
        if (sslConnectionSocketFactory != null) {
            log.error("Skip building S3 async client: sslConnectionSocketFactory is specified");
            return Optional.empty();
        }
        if (config.s3SignerOverride.isPresent() && !config.s3SignerOverride.get().isEmpty()) {
            log.error("Skip building S3 async client: s3SignerOverride is specified");
            return Optional.empty();
        }
        if (config.s3CredFilePath.isPresent() && !config.s3CredFilePath.get().isEmpty()) {
            log.error("Skip building S3 async client: s3CredFilePath is specified");
            return Optional.empty();
        }
        ClientOverrideConfiguration.Builder clientOverrideConfiguration = ClientOverrideConfiguration.builder();
        clientOverrideConfiguration.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, config.s3UserAgentPrefix);
        S3AsyncClientBuilder builder = S3AsyncClient.builder();
        builder.overrideConfiguration((ClientOverrideConfiguration)clientOverrideConfiguration.build());
        builder.forcePathStyle(config.s3ForcePathStyleAccess);
        if (config.s3EndpointOverride.isPresent() && !config.s3EndpointOverride.get().isEmpty()) {
            String s3RegionName = S3TierObjectStore.validateAndGetS3RegionName(config.s3Region);
            builder.endpointOverride(URI.create(config.s3EndpointOverride.get()));
            builder.region(Region.of(s3RegionName));
        } else if (config.s3Region != null && !config.s3Region.isEmpty()) {
            builder.region(Region.of(config.s3Region));
        }
        log.debug("AWS_METADATA_SERVICE_TIMEOUT is {} seconds", (Object)System.getenv("AWS_METADATA_SERVICE_TIMEOUT"));
        SdkAutoCloseable provider = DefaultCredentialsProvider.builder().build();
        if (config.assumeRoleArn.isPresent() && !config.assumeRoleArn.get().isEmpty()) {
            StsClient stsClient = (StsClient)((StsClientBuilder)StsClient.builder().credentialsProvider((AwsCredentialsProvider)((Object)provider))).build();
            provider = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest((AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(config.assumeRoleArn.get()).roleSessionName("tiered-storage").build()).build();
        }
        builder.credentialsProvider((AwsCredentialsProvider)((Object)provider));
        if (S3TierObjectStore.shouldEnableDualStack(config)) {
            builder.dualstackEnabled(true);
        }
        return Optional.of((S3AsyncClient)builder.build());
    }

    private void expectBucket(String bucket, String expectedRegion, Optional<String> endpointOverride) throws TierObjectStoreFatalException {
        try {
            String actualRegion = this.client.getBucketLocation(bucket);
            if (actualRegion.equals("US") && expectedRegion.equals("us-east-1")) {
                return;
            }
            if (!expectedRegion.equals(actualRegion)) {
                log.warn("Bucket region {} does not match expected region {}", (Object)actualRegion, (Object)expectedRegion);
            }
        }
        catch (AmazonClientException ex) {
            if (endpointOverride.isPresent() && !endpointOverride.get().isEmpty()) {
                log.warn("On-prem store does not implement S3 API's GetBucketLocation. Skipping check which ensures that actual bucket region matches expected region.");
            }
            throw new TierObjectStoreFatalException("Failed to validate that bucket location for " + bucket + " matches location " + expectedRegion + "; unable to call GetBucketLocation", ex);
        }
    }

    private static SSLConnectionSocketFactory getSSLConnectionSocketFactory(S3TierObjectStoreConfig config) throws TierObjectStoreFatalException {
        boolean hasCustomKeyStore;
        if (config.s3SecurityProviders.isPresent() && !config.s3SecurityProviders.get().trim().isEmpty()) {
            HashMap<String, String> securityProviders = new HashMap<String, String>();
            securityProviders.put("security.providers", config.s3SecurityProviders.get());
            SecurityUtils.addConfiguredSecurityProviders(securityProviders);
        }
        SSLConnectionSocketFactory sslConnectionSocketFactory = null;
        boolean hasCustomTrustStore = config.s3SslTrustStoreLocation.isPresent() && !config.s3SslTrustStoreLocation.get().isEmpty();
        boolean bl = hasCustomKeyStore = config.s3SslKeyStoreLocation.isPresent() && !config.s3SslKeyStoreLocation.get().isEmpty();
        if (hasCustomTrustStore || hasCustomKeyStore) {
            try {
                SSLContextBuilder sslContextBuilder = SSLContexts.custom();
                if (hasCustomTrustStore) {
                    KeyStore trustStore = KeyStore.getInstance(config.s3SslTrustStoreType.get());
                    FileInputStream trustKeyStoreFile = new FileInputStream(config.s3SslTrustStoreLocation.get());
                    trustStore.load(trustKeyStoreFile, config.s3SslTrustStorePassword.get().value().toCharArray());
                    sslContextBuilder.loadTrustMaterial(trustStore, null);
                }
                if (hasCustomKeyStore) {
                    KeyStore keyStore = KeyStore.getInstance(config.s3SslKeyStoreType.get());
                    FileInputStream identityKeyStoreFile = new FileInputStream(config.s3SslKeyStoreLocation.get());
                    keyStore.load(identityKeyStoreFile, config.s3SslKeyStorePassword.get().value().toCharArray());
                    sslContextBuilder.loadKeyMaterial(keyStore, config.s3SslKeyPassword.get().value().toCharArray(), (aliases, socket) -> "confluent.kafka");
                }
                sslContextBuilder.setProtocol(config.s3SslProtocol);
                if (config.s3SslProvider.isPresent() && !config.s3SslProvider.get().trim().isEmpty()) {
                    config.s3SslProvider.ifPresent(sslContextBuilder::setProvider);
                }
                SSLContext sslContext = sslContextBuilder.build();
                sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, config.s3SslEnabledProtocols.toArray(new String[0]), null, (HostnameVerifier)new DefaultHostnameVerifier());
            }
            catch (Exception e) {
                throw new TierObjectStoreFatalException("Failed to load keystore or trust store for tiered object store", e);
            }
        }
        return sslConnectionSocketFactory;
    }

    private void handleS3ExceptionForCombinedObject(Optional<String> errorCode, Throwable e, TierSegmentUpload<?> tierSegmentUpload) {
        io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata objectMetadata = tierSegmentUpload.objectMetadata();
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        String remotePath = this.keyPath(objectMetadata, ObjectType.SEGMENT_WITH_METADATA);
        if (errorCode.isPresent() && ERROR_CODE_BAD_DIGEST.equals(errorCode.get()) && this.checksumStoreOpt.isPresent() && this.checksumStoreOpt.get().checksumProtectionEnabled(E2EChecksumProtectedObjectType.SEGMENT_WITH_METADATA)) {
            List<File> invalidFiles = tierSegmentUpload.validateFileChecksums(this.checksumStoreOpt.get(), metadata);
            if (invalidFiles.isEmpty()) {
                log.info("Network Error: On-network corruption of a file during upload: {} with metadata: {}", (Object)remotePath, (Object)metadata);
                throw new TierObjectStoreRetriableException(String.format("Failed to upload object, due to on-network corruption, to %s with metadata %s, type %s", new Object[]{remotePath, metadata, ObjectType.SEGMENT_WITH_METADATA}), e);
            }
            throw new E2EChecksumInvalidException("Failed to upload CombinedObject segment due to an on-disk corruption of files: " + String.valueOf(invalidFiles), e);
        }
        if (e instanceof ResetException) {
            throw new TierObjectStoreFatalException("Failed to upload segment when S3 SDK attempted reset of InputStream: " + String.valueOf(objectMetadata), e);
        }
        throw new TierObjectStoreRetriableException("Failed to upload segment due to unexpected error: " + String.valueOf(objectMetadata), e);
    }

    private void handleAmazonClientException(AmazonClientException e, ObjectStoreMetadata objectMetadata, ObjectType objectType, File file) {
        if (objectType != ObjectType.SEGMENT_WITH_METADATA && e instanceof AmazonS3Exception && ERROR_CODE_BAD_DIGEST.equals(((AmazonS3Exception)e).getErrorCode())) {
            this.validateChecksumOnPutSegmentFailure(objectMetadata, objectType, file, e);
        }
        throw new TierObjectStoreRetriableException("Failed to upload segment: " + String.valueOf(objectMetadata) + " due to file: " + String.valueOf(file), e);
    }

    private void handleS3ExceptionDuringSegmentUpload(S3Exception e, ObjectStoreMetadata objectMetadata, ObjectType objectType, File file) {
        if (objectType != ObjectType.SEGMENT_WITH_METADATA) {
            this.validateChecksumOnPutSegmentFailure(objectMetadata, objectType, file, e);
        }
        throw new TierObjectStoreRetriableException("Failed to upload segment: " + String.valueOf(objectMetadata) + " due to file: " + String.valueOf(file), e);
    }

    private void validateChecksumOnPutSegmentFailure(ObjectStoreMetadata objectMetadata, ObjectType objectType, File file, Throwable e) {
        Map<String, String> metadata = objectMetadata.objectMetadata(this.clusterIdOpt, this.brokerIdOpt);
        String filePath = file.getAbsolutePath();
        Optional<Object> crc = Optional.empty();
        String remotePath = this.keyPath(objectMetadata, objectType);
        if (this.checksumStoreOpt.isPresent() && this.checksumStoreOpt.get().checksumProtectionEnabled(objectType.toE2EChecksumProtectedObjectType())) {
            crc = E2EChecksumUtils.getBase64CrcFromStore(this.checksumStoreOpt.get(), file, metadata);
        }
        if (crc.isPresent()) {
            Optional<String> recalculatedCrc = E2EChecksumUtils.compute32BitBase64Crc32c(file);
            if (crc.equals(recalculatedCrc)) {
                log.info("Network Error: On-network corruption of a file during upload: {} with expected CRC value: {} and recalculated CRC value: {}", filePath, crc.get(), recalculatedCrc.get());
                throw new TierObjectStoreRetriableException(String.format("Failed to upload object, due to on-network corruption, to %s with metadata %s, file %s, type %s", new Object[]{remotePath, metadata, file, objectType}), e);
            }
            throw new E2EChecksumInvalidException("Failed to upload object due to an on-disk corruption of file: " + filePath, e);
        }
    }

    public static class AmazonS3ClientAndCredentialsProvider {
        private final AmazonS3 client;
        private final Optional<S3AsyncClient> asyncClientOpt;
        private final AWSCredentialsProvider credentialsProvider;

        public AmazonS3ClientAndCredentialsProvider(AmazonS3 client, Optional<S3AsyncClient> asyncClientOpt, AWSCredentialsProvider credentialsProvider) {
            this.client = client;
            this.asyncClientOpt = asyncClientOpt;
            this.credentialsProvider = credentialsProvider;
        }

        public AmazonS3 client() {
            return this.client;
        }

        public Optional<S3AsyncClient> asyncClientOpt() {
            return this.asyncClientOpt;
        }

        public AWSCredentialsProvider credentialsProvider() {
            return this.credentialsProvider;
        }
    }

    private class SseCustomerKeyV2 {
        final String base64EncodedKey;
        final String customerAlgorithm;
        final String base64EncodedMd5;

        SseCustomerKeyV2(TopicIdPartition topicIdPartition, KeySha keySha) {
            this(TierObjectStoreByokUtils.generateEncryptionKeyForObject((TopicIdPartition)topicIdPartition, (KeySha)keySha, (TenantAwareEncryptionKeyManager)s3TierObjectStore.encryptionKeyManagerOpt.get()).cleartextDataKey);
        }

        SseCustomerKeyV2(CleartextDataKey cleartextDataKey) {
            byte[] rawEncryptionKey = cleartextDataKey.rawKeyMaterial();
            this.base64EncodedKey = SseCustomerKeyV2.base64EncodedKey(rawEncryptionKey);
            this.base64EncodedMd5 = SseCustomerKeyV2.base64EncodedKeyMd5(rawEncryptionKey);
            this.customerAlgorithm = S3TierObjectStore.this.encryptionKeyManagerOpt.get().getKeyManagementClientEncryptionAlgorithm();
        }

        private static final String base64EncodedKey(byte[] rawEncryptionKey) {
            return Base64.getEncoder().encodeToString(rawEncryptionKey);
        }

        private static final String base64EncodedKeyMd5(byte[] rawEncryptionKey) {
            MessageDigest digest = null;
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            return Base64.getEncoder().encodeToString(digest.digest(rawEncryptionKey));
        }
    }

    private static class S3TierObjectStoreResponse
    implements TierObjectStoreResponse {
        private final AutoAbortingGenericInputStream inputStream;

        S3TierObjectStoreResponse(InputStream inputStream, long autoAbortSize, long streamSize) {
            this.inputStream = new S3AutoAbortingInputStream(inputStream, autoAbortSize, streamSize);
        }

        @Override
        public void close() {
            this.inputStream.close();
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }
    }
}

