/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;

public class TierObjectStoreMetrics {
    private final Metrics metrics;
    private static final String METRIC_GROUP_NAME = "TierObjectStore";
    private static final String SEGMENT_OBJECTS_UPLOADED_PREFIX = "SegmentObjectsUploaded";
    private static final String SEGMENT_FETCHED_PREFIX = "SegmentFetched";
    private static final String OFFSET_INDEX_FETCHED_PREFIX = "OffsetIndexFetched";
    private static final String TIMESTAMP_INDEX_FETCHED_PREFIX = "TimestampIndexFetched";
    private static final String TRANSACTION_INDEX_FETCHED_PREFIX = "TransactionIndexFetched";
    private static final String PRODUCER_STATE_FETCHED_PREFIX = "ProducerStateFetched";
    private static final String EPOCH_STATE_FETCHED_PREFIX = "EpochStateFetched";
    private static final String TIER_STATE_FETCHED_PREFIX = "TierStateFetched";
    private static final String OBJECT_VERSIONS_DELETED_PREFIX = "ObjectVersionsDeleted";
    private static final String PUT_LATENCY_PREFIX = "PutLatency";
    private static final String GET_LATENCY_PREFIX = "GetLatency";
    private static final String DELETE_LATENCY_PREFIX = "DeleteLatency";
    private static final String LIST_LATENCY_PREFIX = "ListLatency";
    private static final String OBJECT_EXISTS_LATENCY_PREFIX = "ObjectExistsLatency";
    private static final String CHECK_BUCKET_HEALTH_LATENCY_PREFIX = "CheckBucketHealthLatency";
    private final Sensor segmentObjectsUploaded;
    private final Sensor segmentFetched;
    private final Sensor offsetIndexFetched;
    private final Sensor timestampIndexFetched;
    private final Sensor transactionIndexFetched;
    private final Sensor producerStateFetched;
    private final Sensor epochStateFetched;
    private final Sensor tierStateFetched;
    private final Sensor objectVersionsDeleted;
    private final Sensor putLatency;
    private final Sensor getLatency;
    private final Sensor deleteLatency;
    private final Sensor listLatency;
    private final Sensor objectExistsLatency;
    private final Sensor checkBucketHealthLatency;
    private final List<Sensor> sensors = new ArrayList<Sensor>();
    final MetricName segmentObjectsUploadRateMetricName;
    final MetricName segmentObjectsUploadTotalSegmentMetricName;
    final MetricName fetchRateSegmentMetricName;
    final MetricName fetchCountTotalSegmentMetricName;
    final MetricName fetchRateOffsetIndexMetricName;
    final MetricName fetchCountTotalOffsetIndexMetricName;
    final MetricName fetchRateTimestampIndexMetricName;
    final MetricName fetchCountTimestampIndexMetricName;
    final MetricName fetchRateTransactionIndexMetricName;
    final MetricName fetchCountTransactionIndexMetricName;
    final MetricName fetchRateProducerStateMetricName;
    final MetricName fetchCountTotalProducerStateMetricName;
    final MetricName fetchRateEpochStateMetricName;
    final MetricName fetchCountTotalEpochStateMetricName;
    final MetricName fetchRateTierStateMetricName;
    final MetricName fetchCountTotalTierStateMetricName;
    final MetricName objectVersionsDeletedRateMetricName;
    final MetricName objectVersionsDeletedTotalMetricName;
    final MetricName put50PercentileLatencyMetricName;
    final MetricName put90PercentileLatencyMetricName;
    final MetricName put99PercentileLatencyMetricName;
    final MetricName get50PercentileLatencyMetricName;
    final MetricName get90PercentileLatencyMetricName;
    final MetricName get99PercentileLatencyMetricName;
    final MetricName delete50PercentileLatencyMetricName;
    final MetricName delete90PercentileLatencyMetricName;
    final MetricName delete99PercentileLatencyMetricName;
    final MetricName list50PercentileLatencyMetricName;
    final MetricName list90PercentileLatencyMetricName;
    final MetricName list99PercentileLatencyMetricName;
    final MetricName objectExists50PercentileLatencyMetricName;
    final MetricName objectExists90PercentileLatencyMetricName;
    final MetricName objectExists99PercentileLatencyMetricName;
    final MetricName checkBucketHealth50PercentileLatencyMetricName;
    final MetricName checkBucketHealth90PercentileLatencyMetricName;
    final MetricName checkBucketHealth99PercentileLatencyMetricName;

    TierObjectStoreMetrics(Metrics metrics) {
        this.metrics = metrics;
        this.segmentObjectsUploaded = this.sensor(SEGMENT_OBJECTS_UPLOADED_PREFIX, new Sensor[0]);
        this.segmentObjectsUploadRateMetricName = metrics.metricName("SegmentObjectsUploadedRate", METRIC_GROUP_NAME, "The number of segment or metadata objects uploaded per second to tiered storage", Collections.emptyMap());
        this.segmentObjectsUploadTotalSegmentMetricName = metrics.metricName("SegmentObjectsUploadedTotal", METRIC_GROUP_NAME, "The total number of segment or metadata objects uploaded to tiered storage", Collections.emptyMap());
        Meter segmentObjectsUploadedMeter = new Meter(this.segmentObjectsUploadRateMetricName, this.segmentObjectsUploadTotalSegmentMetricName);
        this.segmentFetched = this.sensor(SEGMENT_FETCHED_PREFIX, new Sensor[0]);
        this.fetchRateSegmentMetricName = metrics.metricName("SegmentFetchedRate", METRIC_GROUP_NAME, "The number of segment fetched per second from tiered storage", Collections.emptyMap());
        this.fetchCountTotalSegmentMetricName = metrics.metricName("SegmentFetchedTotal", METRIC_GROUP_NAME, "The total number of segment fetched from tiered storage", Collections.emptyMap());
        Meter segmentFetchedMeter = new Meter(this.fetchRateSegmentMetricName, this.fetchCountTotalSegmentMetricName);
        this.offsetIndexFetched = this.sensor(OFFSET_INDEX_FETCHED_PREFIX, new Sensor[0]);
        this.fetchRateOffsetIndexMetricName = metrics.metricName("OffsetIndexFetchedRate", METRIC_GROUP_NAME, "The number of offset indices fetched per second from tiered storage", Collections.emptyMap());
        this.fetchCountTotalOffsetIndexMetricName = metrics.metricName("OffsetIndexFetchedTotal", METRIC_GROUP_NAME, "The total number of offset indices fetched from tiered storage", Collections.emptyMap());
        Meter offsetIndexFetchedMeter = new Meter(this.fetchRateOffsetIndexMetricName, this.fetchCountTotalOffsetIndexMetricName);
        this.timestampIndexFetched = this.sensor(TIMESTAMP_INDEX_FETCHED_PREFIX, new Sensor[0]);
        this.fetchRateTimestampIndexMetricName = metrics.metricName("TimestampIndexFetchedRate", METRIC_GROUP_NAME, "The number of timestamp indices fetched per second from tiered storage", Collections.emptyMap());
        this.fetchCountTimestampIndexMetricName = metrics.metricName("TimestampIndexFetchedTotal", METRIC_GROUP_NAME, "The total number of timestamp indices fetched from tiered storage", Collections.emptyMap());
        Meter timestampIndexFetchedMeter = new Meter(this.fetchRateTimestampIndexMetricName, this.fetchCountTimestampIndexMetricName);
        this.transactionIndexFetched = this.sensor(TRANSACTION_INDEX_FETCHED_PREFIX, new Sensor[0]);
        this.fetchRateTransactionIndexMetricName = metrics.metricName("TransactionIndexFetchedRate", METRIC_GROUP_NAME, "The number of transaction indices fetched per second from tiered storage", Collections.emptyMap());
        this.fetchCountTransactionIndexMetricName = metrics.metricName("TransactionIndexFetchedTotal", METRIC_GROUP_NAME, "The total number of transaction indices fetched from tiered storage", Collections.emptyMap());
        Meter transactionIndexFetchedMeter = new Meter(this.fetchRateTransactionIndexMetricName, this.fetchCountTransactionIndexMetricName);
        this.producerStateFetched = this.sensor(PRODUCER_STATE_FETCHED_PREFIX, new Sensor[0]);
        this.fetchRateProducerStateMetricName = metrics.metricName("ProducerStateFetchedRate", METRIC_GROUP_NAME, "The number of producer state snapshots fetched per second from tiered storage", Collections.emptyMap());
        this.fetchCountTotalProducerStateMetricName = metrics.metricName("ProducerStateFetchedTotal", METRIC_GROUP_NAME, "The total number of producer state snapshots fetched from tiered storage", Collections.emptyMap());
        Meter producerStateFetchedMeter = new Meter(this.fetchRateProducerStateMetricName, this.fetchCountTotalProducerStateMetricName);
        this.epochStateFetched = this.sensor(EPOCH_STATE_FETCHED_PREFIX, new Sensor[0]);
        this.fetchRateEpochStateMetricName = metrics.metricName("EpochStateFetchedRate", METRIC_GROUP_NAME, "The number of leader epoch state files fetched per second from tiered storage", Collections.emptyMap());
        this.fetchCountTotalEpochStateMetricName = metrics.metricName("EpochStateFetchedTotal", METRIC_GROUP_NAME, "The total number of leader epoch state files fetched from tiered storage", Collections.emptyMap());
        Meter epochStateFetchedMeter = new Meter(this.fetchRateEpochStateMetricName, this.fetchCountTotalEpochStateMetricName);
        this.tierStateFetched = this.sensor(TIER_STATE_FETCHED_PREFIX, new Sensor[0]);
        this.fetchRateTierStateMetricName = metrics.metricName("TierStateFetchedRate", METRIC_GROUP_NAME, "The number of tier state snapshots fetched per second from tiered storage", Collections.emptyMap());
        this.fetchCountTotalTierStateMetricName = metrics.metricName("TierStateFetchedTotal", METRIC_GROUP_NAME, "The total number of tier state snapshots fetched from tiered storage", Collections.emptyMap());
        Meter tierStateFetchedMeter = new Meter(this.fetchRateTierStateMetricName, this.fetchCountTotalTierStateMetricName);
        this.objectVersionsDeleted = this.sensor(OBJECT_VERSIONS_DELETED_PREFIX, new Sensor[0]);
        this.objectVersionsDeletedRateMetricName = metrics.metricName("ObjectVersionsDeletedRate", METRIC_GROUP_NAME, "The number of object versions deleted per second from tiered storage", Collections.emptyMap());
        this.objectVersionsDeletedTotalMetricName = metrics.metricName("ObjectVersionsDeletedTotal", METRIC_GROUP_NAME, "The total number of object versions deleted from tiered storage", Collections.emptyMap());
        Meter objectVersionsDeletedMeter = new Meter(this.objectVersionsDeletedRateMetricName, this.objectVersionsDeletedTotalMetricName);
        double maxLatencyMs = 30000.0;
        int totalBucketSizeInBytes = (int)maxLatencyMs * 4;
        this.putLatency = this.sensor(PUT_LATENCY_PREFIX, new Sensor[0]);
        this.put50PercentileLatencyMetricName = metrics.metricName("PutLatency50Percentile", METRIC_GROUP_NAME, "The 50-percentile latency for PUT calls made to the object store by tiered storage in ms", Collections.emptyMap());
        this.put90PercentileLatencyMetricName = metrics.metricName("PutLatency90Percentile", METRIC_GROUP_NAME, "The 90-percentile latency for PUT calls made to the object store by tiered storage in ms", Collections.emptyMap());
        this.put99PercentileLatencyMetricName = metrics.metricName("PutLatency99Percentile", METRIC_GROUP_NAME, "The 99-percentile latency for PUT calls made to the object store by tiered storage in ms", Collections.emptyMap());
        Percentile putLatency50Percentile = new Percentile(this.put50PercentileLatencyMetricName, 50.0);
        Percentile putLatency90Percentile = new Percentile(this.put90PercentileLatencyMetricName, 90.0);
        Percentile putLatency99Percentile = new Percentile(this.put99PercentileLatencyMetricName, 99.0);
        Percentiles putLatencyPercentiles = new Percentiles(totalBucketSizeInBytes, maxLatencyMs, Percentiles.BucketSizing.CONSTANT, putLatency50Percentile, putLatency90Percentile, putLatency99Percentile);
        this.getLatency = this.sensor(GET_LATENCY_PREFIX, new Sensor[0]);
        this.get50PercentileLatencyMetricName = metrics.metricName("GetLatency50Percentile", METRIC_GROUP_NAME, "The 50-percentile latency for GET calls made to the object store by tiered storage in ms", Collections.emptyMap());
        this.get90PercentileLatencyMetricName = metrics.metricName("GetLatency90Percentile", METRIC_GROUP_NAME, "The 90-percentile latency for GET calls made to the object store by tiered storage in ms", Collections.emptyMap());
        this.get99PercentileLatencyMetricName = metrics.metricName("GetLatency99Percentile", METRIC_GROUP_NAME, "The 99-percentile latency for GET calls made to the object store by tiered storage in ms", Collections.emptyMap());
        Percentile getLatency50Percentile = new Percentile(this.get50PercentileLatencyMetricName, 50.0);
        Percentile getLatency90Percentile = new Percentile(this.get90PercentileLatencyMetricName, 90.0);
        Percentile getLatency99Percentile = new Percentile(this.get99PercentileLatencyMetricName, 99.0);
        Percentiles getLatencyPercentiles = new Percentiles(totalBucketSizeInBytes, maxLatencyMs, Percentiles.BucketSizing.CONSTANT, getLatency50Percentile, getLatency90Percentile, getLatency99Percentile);
        this.deleteLatency = this.sensor(DELETE_LATENCY_PREFIX, new Sensor[0]);
        this.delete50PercentileLatencyMetricName = metrics.metricName("DeleteLatency50Percentile", METRIC_GROUP_NAME, "The 50-percentile latency for DELETE calls made to the object store by tiered storage in ms", Collections.emptyMap());
        this.delete90PercentileLatencyMetricName = metrics.metricName("DeleteLatency90Percentile", METRIC_GROUP_NAME, "The 90-percentile latency for DELETE calls made to the object store by tiered storage in ms", Collections.emptyMap());
        this.delete99PercentileLatencyMetricName = metrics.metricName("DeleteLatency99Percentile", METRIC_GROUP_NAME, "The 99-percentile latency for DELETE calls made to the object store by tiered storage in ms", Collections.emptyMap());
        Percentile deleteLatency50Percentile = new Percentile(this.delete50PercentileLatencyMetricName, 50.0);
        Percentile deleteLatency90Percentile = new Percentile(this.delete90PercentileLatencyMetricName, 90.0);
        Percentile deleteLatency99Percentile = new Percentile(this.delete99PercentileLatencyMetricName, 99.0);
        Percentiles deleteLatencyPercentiles = new Percentiles(totalBucketSizeInBytes, maxLatencyMs, Percentiles.BucketSizing.CONSTANT, deleteLatency50Percentile, deleteLatency90Percentile, deleteLatency99Percentile);
        this.listLatency = this.sensor(LIST_LATENCY_PREFIX, new Sensor[0]);
        this.list50PercentileLatencyMetricName = metrics.metricName("ListLatency50Percentile", METRIC_GROUP_NAME, "The 50-percentile latency for LIST calls made to the object store by tiered storage in ms", Collections.emptyMap());
        this.list90PercentileLatencyMetricName = metrics.metricName("ListLatency90Percentile", METRIC_GROUP_NAME, "The 90-percentile latency for LIST calls made to the object store by tiered storage in ms", Collections.emptyMap());
        this.list99PercentileLatencyMetricName = metrics.metricName("ListLatency99Percentile", METRIC_GROUP_NAME, "The 99-percentile latency for LIST calls made to the object store by tiered storage in ms", Collections.emptyMap());
        Percentile listLatency50Percentile = new Percentile(this.list50PercentileLatencyMetricName, 50.0);
        Percentile listLatency90Percentile = new Percentile(this.list90PercentileLatencyMetricName, 90.0);
        Percentile listLatency99Percentile = new Percentile(this.list99PercentileLatencyMetricName, 99.0);
        Percentiles listLatencyPercentiles = new Percentiles(totalBucketSizeInBytes, maxLatencyMs, Percentiles.BucketSizing.CONSTANT, listLatency50Percentile, listLatency90Percentile, listLatency99Percentile);
        this.objectExistsLatency = this.sensor(OBJECT_EXISTS_LATENCY_PREFIX, new Sensor[0]);
        this.objectExists50PercentileLatencyMetricName = metrics.metricName("ObjectExistsLatency50Percentile", METRIC_GROUP_NAME, "The 50-percentile latency for OBJECT_EXISTS calls made to the object store by tiered storage in ms", Collections.emptyMap());
        this.objectExists90PercentileLatencyMetricName = metrics.metricName("ObjectExistsLatency90Percentile", METRIC_GROUP_NAME, "The 90-percentile latency for OBJECT_EXISTS calls made to the object store by tiered storage in ms", Collections.emptyMap());
        this.objectExists99PercentileLatencyMetricName = metrics.metricName("ObjectExistsLatency99Percentile", METRIC_GROUP_NAME, "The 99-percentile latency for OBJECT_EXISTS calls made to the object store by tiered storage in ms", Collections.emptyMap());
        Percentile objectExistsLatency50Percentile = new Percentile(this.objectExists50PercentileLatencyMetricName, 50.0);
        Percentile objectExistsLatency90Percentile = new Percentile(this.objectExists90PercentileLatencyMetricName, 90.0);
        Percentile objectExistsLatency99Percentile = new Percentile(this.objectExists99PercentileLatencyMetricName, 99.0);
        Percentiles objectExistsLatencyPercentiles = new Percentiles(totalBucketSizeInBytes, maxLatencyMs, Percentiles.BucketSizing.CONSTANT, objectExistsLatency50Percentile, objectExistsLatency90Percentile, objectExistsLatency99Percentile);
        this.checkBucketHealthLatency = this.sensor(CHECK_BUCKET_HEALTH_LATENCY_PREFIX, new Sensor[0]);
        this.checkBucketHealth50PercentileLatencyMetricName = metrics.metricName("CheckBucketHealthLatency50Percentile", METRIC_GROUP_NAME, "The 50-percentile latency for check bucket health calls made to the object store by tiered storage in ms", Collections.emptyMap());
        this.checkBucketHealth90PercentileLatencyMetricName = metrics.metricName("CheckBucketHealthLatency90Percentile", METRIC_GROUP_NAME, "The 90-percentile latency for check bucket health calls made to the object store by tiered storage in ms", Collections.emptyMap());
        this.checkBucketHealth99PercentileLatencyMetricName = metrics.metricName("CheckBucketHealthLatency99Percentile", METRIC_GROUP_NAME, "The 99-percentile latency for check bucket health calls made to the object store by tiered storage in ms", Collections.emptyMap());
        Percentile checkBucketHealthLatency50Percentile = new Percentile(this.checkBucketHealth50PercentileLatencyMetricName, 50.0);
        Percentile checkBucketHealthLatency90Percentile = new Percentile(this.checkBucketHealth90PercentileLatencyMetricName, 90.0);
        Percentile checkBucketHealthLatency99Percentile = new Percentile(this.checkBucketHealth99PercentileLatencyMetricName, 99.0);
        Percentiles checkBucketHealthLatencyPercentiles = new Percentiles(totalBucketSizeInBytes, maxLatencyMs, Percentiles.BucketSizing.CONSTANT, checkBucketHealthLatency50Percentile, checkBucketHealthLatency90Percentile, checkBucketHealthLatency99Percentile);
        this.segmentObjectsUploaded.add(segmentObjectsUploadedMeter);
        this.segmentFetched.add(segmentFetchedMeter);
        this.offsetIndexFetched.add(offsetIndexFetchedMeter);
        this.timestampIndexFetched.add(timestampIndexFetchedMeter);
        this.transactionIndexFetched.add(transactionIndexFetchedMeter);
        this.producerStateFetched.add(producerStateFetchedMeter);
        this.epochStateFetched.add(epochStateFetchedMeter);
        this.tierStateFetched.add(tierStateFetchedMeter);
        this.objectVersionsDeleted.add(objectVersionsDeletedMeter);
        this.putLatency.add(putLatencyPercentiles);
        this.getLatency.add(getLatencyPercentiles);
        this.deleteLatency.add(deleteLatencyPercentiles);
        this.listLatency.add(listLatencyPercentiles);
        this.objectExistsLatency.add(objectExistsLatencyPercentiles);
        this.checkBucketHealthLatency.add(checkBucketHealthLatencyPercentiles);
    }

    private Sensor sensor(String name, Sensor ... parents) {
        Sensor sensor = this.metrics.sensor(name, parents);
        this.sensors.add(sensor);
        return sensor;
    }

    public void close() {
        for (Sensor sensor : this.sensors) {
            this.metrics.removeSensor(sensor.name());
        }
    }

    public Sensor segmentObjectsUploaded() {
        return this.segmentObjectsUploaded;
    }

    public Sensor segmentFetched() {
        return this.segmentFetched;
    }

    public Sensor offsetIndexFetched() {
        return this.offsetIndexFetched;
    }

    public Sensor timestampIndexFetched() {
        return this.timestampIndexFetched;
    }

    public Sensor transactionIndexFetched() {
        return this.transactionIndexFetched;
    }

    public Sensor producerStateFetched() {
        return this.producerStateFetched;
    }

    public Sensor epochStateFetched() {
        return this.epochStateFetched;
    }

    public Sensor tierStateFetched() {
        return this.tierStateFetched;
    }

    public Sensor objectVersionsDeleted() {
        return this.objectVersionsDeleted;
    }

    public Sensor putLatency() {
        return this.putLatency;
    }

    public Sensor getLatency() {
        return this.getLatency;
    }

    public Sensor deleteLatency() {
        return this.deleteLatency;
    }

    public Sensor listLatency() {
        return this.listLatency;
    }

    public Sensor objectExistsLatency() {
        return this.objectExistsLatency;
    }

    public Sensor checkBucketHealthLatency() {
        return this.checkBucketHealthLatency;
    }
}

