/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.encryption;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.store.encryption.EncryptedDataKey;
import kafka.tier.store.encryption.EncryptionKeyCacheRefiller;
import kafka.tier.store.encryption.TenantAwareEncryptionKeyManager;

public class GcsObjectMetadataKeyCacheRefiller
implements EncryptionKeyCacheRefiller<BlobId> {
    private final Storage storage;

    public GcsObjectMetadataKeyCacheRefiller(Storage storage) {
        this.storage = storage;
    }

    @Override
    public ByteBuffer get(String logicalClusterId, TopicIdPartition topicIdPartition, UUID objectId, Optional<BlobId> objectSpecificMetadataOpt) {
        if (objectSpecificMetadataOpt.isEmpty()) {
            throw new IllegalStateException("BlobId must be set before calling get for GcsObjectMetadataKeyCacheRefiller.");
        }
        BlobId blobId = objectSpecificMetadataOpt.get();
        Blob blobMetadata = this.storage.get(blobId, Storage.BlobGetOption.fields(Storage.BlobField.METADATA));
        if (blobMetadata == null) {
            return null;
        }
        Map<String, String> extractedMetadata = blobMetadata.getMetadata();
        String extractedEncryptedKeyBase64Encoded = TenantAwareEncryptionKeyManager.getKeyWithFallbackToLegacy(extractedMetadata, "ioconfluentbase64encrypteddatakey", List.of("ioConfluentBase64EncryptedDataKey", "io.confluent/base64-encrypted-data-key"));
        if (extractedEncryptedKeyBase64Encoded == null || extractedEncryptedKeyBase64Encoded.isEmpty()) {
            return null;
        }
        EncryptedDataKey encryptedDataKey = EncryptedDataKey.fromBase64Encoded(extractedEncryptedKeyBase64Encoded);
        return ByteBuffer.wrap(encryptedDataKey.keyMaterial());
    }
}

