/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kafka.server.ReplicaManager;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\tub!\u0002\u000e\u001c\u0003\u0003\u0011\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u000b\u0001\u0003A\u0011A!\t\u00115\u0003\u0001\u0019!C\u0001;9C\u0001B\u0015\u0001A\u0002\u0013\u0005Qd\u0015\u0005\u00073\u0002\u0001\u000b\u0015B(\t\u000fy\u0003\u0001\u0019!C\u0005?\"9\u0011\u000e\u0001a\u0001\n\u0013Q\u0007B\u00027\u0001A\u0003&\u0001\rC\u0004o\u0001\t\u0007I\u0011B8\t\u000f\u0005\u0015\u0001\u0001)A\u0005a\"9\u0011q\u0001\u0001\u0007\u0002\u0005%\u0001bBA\u0012\u0001\u0019\u0005\u0011Q\u0005\u0005\b\u0003g\u0001a\u0011AA\u001b\u0011\u0019\ti\f\u0001C\u0001?\"9\u0011q\u0018\u0001\u0005\u0002\u0005\u0005\u0007bBAe\u0001\u0011\u00051d\u001c\u0005\b\u0003\u0017\u0004A\u0011AAg\u0011!\t9\u000e\u0001C\t7\u0005e\u0007\u0002CAl\u0001\u0011E1$!=\t\u000f\u0005e\b\u0001\"\u0005\u0002|\"A!1\u0001\u0001\u0005\u0012m\u0011)\u0001\u0003\u0005\u0003\n\u0001!\tb\u0007B\u0006\u0011!\u0011Y\u0003\u0001C\t7\t5\u0002b\u0002B\u0019\u0001\u0011E!1\u0007\u0005\b\u0005k\u0001A\u0011\u0003B\u001c\u0005!!\u0016.\u001a:UCN\\'B\u0001\u000f\u001e\u0003\u0015!\u0018m]6t\u0015\tqr$\u0001\u0003uS\u0016\u0014(\"\u0001\u0011\u0002\u000b-\fgm[1\u0004\u0001U\u00111ER\n\u0004\u0001\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g\r\u0005\u0002,]5\tAF\u0003\u0002.?\u0005)Q\u000f^5mg&\u0011q\u0006\f\u0002\b\u0019><w-\u001b8h\u00031\u0011X\r\u001e:z%\u0006$Xm\u00149u!\r)#\u0007N\u0005\u0003g\u0019\u0012aa\u00149uS>t\u0007CA\u001b?\u001b\u00051$BA\u001c9\u0003\u0011\u0019wN]3\u000b\u0005eR\u0014aB7fiJL7m\u001d\u0006\u0003wq\na!_1n[\u0016\u0014(\"A\u001f\u0002\u0007\r|W.\u0003\u0002@m\t)Q*\u001a;fe\u00061A(\u001b8jiz\"\"A\u0011'\u0011\u0007\r\u0003A)D\u0001\u001c!\t)e\t\u0004\u0001\u0005\u000b\u001d\u0003!\u0019\u0001%\u0003\u0003Q\u000b\"!\u0013\"\u0011\u0005\u0015R\u0015BA&'\u0005\u001dqu\u000e\u001e5j]\u001eDQ\u0001\r\u0002A\u0002E\n!B]3uef\u001cu.\u001e8u+\u0005y\u0005CA\u0013Q\u0013\t\tfEA\u0002J]R\faB]3uef\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0002U/B\u0011Q%V\u0005\u0003-\u001a\u0012A!\u00168ji\"9\u0001\fBA\u0001\u0002\u0004y\u0015a\u0001=%c\u0005Y!/\u001a;ss\u000e{WO\u001c;!Q\t)1\f\u0005\u0002&9&\u0011QL\n\u0002\tm>d\u0017\r^5mK\u0006aq\f]1vg\u0016$WK\u001c;jYV\t\u0001\rE\u0002&e\u0005\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\tQLW.\u001a\u0006\u0002M\u0006!!.\u0019<b\u0013\tA7MA\u0004J]N$\u0018M\u001c;\u0002!}\u0003\u0018-^:fIVsG/\u001b7`I\u0015\fHC\u0001+l\u0011\u001dAv!!AA\u0002\u0001\fQb\u00189bkN,G-\u00168uS2\u0004\u0003F\u0001\u0005\\\u0003\u001dyVM\u001d:peN,\u0012\u0001\u001d\t\u0004cR4X\"\u0001:\u000b\u0005M,\u0017\u0001B;uS2L!!\u001e:\u0003\u0007M+G\u000f\u0005\u0002x\u007f:\u0011\u00010 \b\u0003srl\u0011A\u001f\u0006\u0003w\u0006\na\u0001\u0010:p_Rt\u0014\"A\u0014\n\u0005y4\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0003\t\u0019AA\u0005UQJ|w/\u00192mK*\u0011aPJ\u0001\t?\u0016\u0014(o\u001c:tA\u0005\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\\\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002 5\u0011\u0011q\u0002\u0006\u0004=\u0005E!\u0002BA\n\u0003+\tqa\u001d;pe\u0006<WMC\u0002!\u0003/QA!!\u0007\u0002\u001c\u0005I1m\u001c8gYV,g\u000e\u001e\u0006\u0003\u0003;\t!![8\n\t\u0005\u0005\u0012q\u0002\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\f1a\u0019;y+\t\t9\u0003\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\ti#H\u0001\bM\u0016$8\r[3s\u0013\u0011\t\t$a\u000b\u0003'\r\u000bgnY3mY\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0015Q\u0014\u0018M\\:ji&|g\u000e\u0006\b\u00028\u0005=\u0013\u0011NA=\u0003\u0013\u000bI*a*\u0015\t\u0005e\u0012Q\t\t\u0006\u0003w\t\t\u0005R\u0007\u0003\u0003{Q1!a\u0010'\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003\u0007\niD\u0001\u0004GkR,(/\u001a\u0005\b\u0003\u000fj\u00019AA%\u0003\t)7\r\u0005\u0003\u0002<\u0005-\u0013\u0002BA'\u0003{\u0011\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\r\u0011l\u0001\u0019AA)!\u0011\t\u0019&!\u001a\u000e\u0005\u0005U#bA\u0017\u0002X)!\u0011\u0011LA.\u0003\u0019\u0019w.\\7p]*\u0019\u0001%!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\r\u0014aA8sO&!\u0011qMA+\u0005\u0011!\u0016.\\3\t\u000f\u0005-T\u00021\u0001\u0002n\u0005\tB/[3s)>\u0004\u0018nY!qa\u0016tG-\u001a:\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cR1!a\u001d\u001e\u0003\u0015!x\u000e]5d\u0013\u0011\t9(!\u001d\u0003#QKWM\u001d+pa&\u001c\u0017\t\u001d9f]\u0012,'\u000fC\u0004\u0002|5\u0001\r!! \u0002\u001fQLWM](cU\u0016\u001cGo\u0015;pe\u0016\u0004B!a \u0002\u00066\u0011\u0011\u0011\u0011\u0006\u0004\u0003\u0007k\u0012!B:u_J,\u0017\u0002BAD\u0003\u0003\u0013q\u0002V5fe>\u0013'.Z2u'R|'/\u001a\u0005\b\u0003\u0017k\u0001\u0019AAG\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004B!a$\u0002\u00166\u0011\u0011\u0011\u0013\u0006\u0004\u0003'{\u0012AB:feZ,'/\u0003\u0003\u0002\u0018\u0006E%A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\b\u00037k\u0001\u0019AAO\u0003\u0019\u0019wN\u001c4jOB!\u0011qTAR\u001b\t\t\tKC\u0002\u0002\u001cnIA!!*\u0002\"\nyA+[3s)\u0006\u001c8n]\"p]\u001aLw\rC\u0004\u0002*6\u0001\r!a+\u0002\u0013QD'o\u001c;uY\u0016\u0014\b\u0003B\u00133\u0003[\u0003B!a,\u0002:6\u0011\u0011\u0011\u0017\u0006\u0004[\u0005M&\u0002BA[\u0003o\u000b\u0011\"\u001b8uKJt\u0017\r\\:\u000b\t\u0005M\u00111L\u0005\u0005\u0003w\u000b\tLA\u0005UQJ|G\u000f\u001e7fe\u0006Y\u0001/Y;tK\u0012,f\u000e^5m\u00031I7/\u0012:s_J\u001cF/\u0019;f+\t\t\u0019\rE\u0002&\u0003\u000bL1!a2'\u0005\u001d\u0011un\u001c7fC:\f1\"\u001a:s_J\u001cF/\u0019;fg\u0006qAo\u001c9jGB\u000b'\u000f^5uS>tWCAAh!\u0011\t\t.a5\u000e\u0005\u0005]\u0013\u0002BAk\u0003/\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\bsKR\u0014\u0018\u0010V1tW2\u000bG/\u001a:\u0015\u0013Q\u000bY.a8\u0002d\u00065\bBBAo%\u0001\u0007q*A\tnCb\u0014V\r\u001e:z\u0005\u0006\u001c7n\u001c4g\u001bNDa!!9\u0013\u0001\u0004y\u0015!E7j]J+GO]=CC\u000e\\wN\u001a4Ng\"9\u0011Q\u001d\nA\u0002\u0005\u001d\u0018!\u00028po6\u001b\bcA\u0013\u0002j&\u0019\u00111\u001e\u0014\u0003\t1{gn\u001a\u0005\u0007\u0003_\u0014\u0002\u0019\u0001<\u0002\u0003Q$r\u0001VAz\u0003k\f9\u0010\u0003\u0004\u0002^N\u0001\ra\u0014\u0005\b\u0003K\u001c\u0002\u0019AAt\u0011\u0019\tyo\u0005a\u0001m\u0006IA-\u001a7bsR\u000b7o\u001b\u000b\u0006)\u0006u(\u0011\u0001\u0005\u0007\u0003\u007f$\u0002\u0019A(\u0002\u000f\u0011,G.Y=Ng\"9\u0011Q\u001d\u000bA\u0002\u0005\u001d\u0018!D:fi\u0016\u0013(o\u001c:Ti\u0006$X\rF\u0002U\u0005\u000fAa!a<\u0016\u0001\u00041\u0018aD2mK\u0006\u0014XI\u001d:peN#\u0018\r^3\u0015\u0007Q\u0013i\u0001C\u0004\u0003\u0010Y\u0001\rA!\u0005\u0002\u001dQD'o\\<bE2,7\t\\1tgB\"!1\u0003B\u0013!\u0019\u0011)B!\b\u0003$9!!q\u0003B\r!\tIh%C\u0002\u0003\u001c\u0019\na\u0001\u0015:fI\u00164\u0017\u0002\u0002B\u0010\u0005C\u0011Qa\u00117bgNT1Aa\u0007'!\r)%Q\u0005\u0003\r\u0005O\u0011i!!A\u0001\u0002\u000b\u0005!\u0011\u0006\u0002\u0004?\u0012\n\u0014CA%w\u0003Y\u0019\u0017M\\2fY\u0006sGmU3u\u000bJ\u0014xN]*uCR,Gc\u0001+\u00030!1\u0011q^\fA\u0002Y\fac\u001c8Tk\u000e\u001cWm]:gk2$&/\u00198tSRLwN\u001c\u000b\u0002)\u0006yrN\\*vG\u000e,7o\u001d4vYR\u0013\u0018M\\:ji&|gnV5uQ\u0012+G.Y=\u0015\u000bQ\u0013IDa\u000f\t\u000f\u0005}\u0018\u00041\u0001\u0002h\"9\u0011Q]\rA\u0002\u0005\u001d\b")
public abstract class TierTask<T extends TierTask<T>>
implements Logging {
    private final Option<Meter> retryRateOpt;
    private volatile int retryCount;
    private volatile Option<Instant> _pausedUntil;
    private final Set<Throwable> _errors;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TierTask tierTask = this;
        synchronized (tierTask) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int retryCount() {
        return this.retryCount;
    }

    public void retryCount_$eq(int x$1) {
        this.retryCount = x$1;
    }

    private Option<Instant> _pausedUntil() {
        return this._pausedUntil;
    }

    private void _pausedUntil_$eq(Option<Instant> x$1) {
        this._pausedUntil = x$1;
    }

    private Set<Throwable> _errors() {
        return this._errors;
    }

    public abstract TopicIdPartition topicIdPartition();

    public abstract CancellationContext ctx();

    public abstract Future<T> transition(Time var1, TierTopicAppender var2, TierObjectStore var3, ReplicaManager var4, TierTasksConfig var5, Option<Throttler> var6, ExecutionContext var7);

    public Option<Instant> pausedUntil() {
        return this._pausedUntil();
    }

    public boolean isErrorState() {
        return !this._errors().isEmpty();
    }

    public Set<Throwable> errorStates() {
        return this._errors();
    }

    public TopicPartition topicPartition() {
        return this.topicIdPartition().topicPartition();
    }

    public void retryTaskLater(int maxRetryBackoffMs, int minRetryBackoffMs, long nowMs, Throwable t) {
        this.retryCount_$eq(this.retryCount() + 1);
        this.retryRateOpt.foreach((Function1<Meter, Object> & Serializable)x$1 -> {
            x$1.mark();
            return BoxedUnit.UNIT;
        });
        Instant now = Instant.ofEpochMilli(nowMs);
        int pauseMs = Math.max(Math.min(maxRetryBackoffMs, (Random$.MODULE$.nextInt(this.retryCount()) + 1) * 1000), minRetryBackoffMs);
        this.info((Function0<String> & Serializable)() -> "retrying " + this + " after " + pauseMs + "ms", (Function0<Throwable> & Serializable)() -> t);
        this._pausedUntil_$eq(new Some<Instant>(now.plusMillis(pauseMs)));
    }

    public void retryTaskLater(int maxRetryBackoffMs, long nowMs, Throwable t) {
        this.retryTaskLater(maxRetryBackoffMs, 0, nowMs, t);
    }

    public void delayTask(int delayMs, long nowMs) {
        Instant now = Instant.ofEpochMilli(nowMs);
        this.info((Function0<String> & Serializable)() -> "retrying " + this + " after " + delayMs + "ms");
        this._pausedUntil_$eq(new Some<Instant>(now.plusMillis(delayMs)));
    }

    public void setErrorState(Throwable t) {
        this._errors().add(t);
    }

    public void clearErrorState(Class<? extends Throwable> throwableClass) {
        this._errors().removeIf(error -> {
            Class<?> clazz = error.getClass();
            Class clazz2 = throwableClass;
            return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
        });
    }

    public void cancelAndSetErrorState(Throwable t) {
        this.setErrorState(t);
        this.ctx().cancel();
    }

    public void onSuccessfulTransition() {
        this.retryCount_$eq(0);
        this._pausedUntil_$eq(None$.MODULE$);
    }

    public void onSuccessfulTransitionWithDelay(long delayMs, long nowMs) {
        Instant now = Instant.ofEpochMilli(nowMs);
        this.onSuccessfulTransition();
        this._pausedUntil_$eq(new Some<Instant>(now.plusMillis(delayMs)));
    }

    public TierTask(Option<Meter> retryRateOpt) {
        this.retryRateOpt = retryRateOpt;
        Logging.$init$(this);
        this.retryCount = 0;
        this._pausedUntil = None$.MODULE$;
        this._errors = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

