/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.PriorityQueue;
import kafka.server.ReplicaManager;
import kafka.tier.tasks.compaction.CompactionSummarizer$;
import kafka.tier.tasks.compaction.CompactionSummaryEntry;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.tasks.compaction.TierLogToClean;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0005\u0005-b\u0001B\u0006\r\u0001UA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007C\u0003=\u0001\u0011\u0005Q\bC\u0003D\u0001\u0011\u0005A\tC\u0003_\u0001\u0011%qlB\u0005\u0002\f1\t\t\u0011#\u0001\u0002\u000e\u0019A1\u0002DA\u0001\u0012\u0003\ty\u0001\u0003\u0004=\u0011\u0011\u0005\u0011\u0011\u0003\u0005\n\u0003'A\u0011\u0013!C\u0001\u0003+\u0011AcQ8na\u0006\u001cG/[8o'VlW.\u0019:ju\u0016\u0014(BA\u0007\u000f\u0003)\u0019w.\u001c9bGRLwN\u001c\u0006\u0003\u001fA\tQ\u0001^1tWNT!!\u0005\n\u0002\tQLWM\u001d\u0006\u0002'\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u00179A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\u0004\"!\b\u0011\u000e\u0003yQ!a\b\n\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0005r\"a\u0002'pO\u001eLgnZ\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\t!s%D\u0001&\u0015\t1##\u0001\u0004tKJ4XM]\u0005\u0003Q\u0015\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'/\u0001\u0004d_:4\u0017n\u001a\t\u0003W5j\u0011\u0001\f\u0006\u0003S9I!A\f\u0017\u0003\u001fQKWM\u001d+bg.\u001c8i\u001c8gS\u001e\fA\u0001^5nKB\u0011\u0011GO\u0007\u0002e)\u0011qd\r\u0006\u0003iU\naaY8n[>t'BA\n7\u0015\t9\u0004(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002s\u0005\u0019qN]4\n\u0005m\u0012$\u0001\u0002+j[\u0016\fa\u0001P5oSRtD\u0003\u0002 A\u0003\n\u0003\"a\u0010\u0001\u000e\u00031AQA\t\u0003A\u0002\rBQ!\u000b\u0003A\u0002)Bqa\f\u0003\u0011\u0002\u0003\u0007\u0001'\u0001\u000bm_\u001e\u001cu.\u001c9bGRLwN\\*v[6\f'/\u001f\u000b\u0003\u000bB\u0003\"AR'\u000f\u0005\u001d[\u0005C\u0001%\u0019\u001b\u0005I%B\u0001&\u0015\u0003\u0019a$o\\8u}%\u0011A\nG\u0001\u0007!J,G-\u001a4\n\u00059{%AB*ue&twM\u0003\u0002M1!)\u0011+\u0002a\u0001%\u0006y1m\\7qC\u000e$\u0018n\u001c8UCN\\7\u000fE\u0002T1ns!\u0001\u0016,\u000f\u0005!+\u0016\"A\r\n\u0005]C\u0012a\u00029bG.\fw-Z\u0005\u00033j\u0013A\u0001T5ti*\u0011q\u000b\u0007\t\u0003\u007fqK!!\u0018\u0007\u0003\u001d\r{W\u000e]1di&|g\u000eV1tW\u0006q\u0002O]5oiR{\u0007\u000fV3o\u0007>l\u0007/Y2uS>twk\u001c:lY>\fGm]\u000b\u0003Ar$\"!R1\t\u000b\t4\u0001\u0019A2\u0002\u0005A\f\bc\u00013jW6\tQM\u0003\u0002gO\u0006!Q\u000f^5m\u0015\u0005A\u0017\u0001\u00026bm\u0006L!A[3\u0003\u001bA\u0013\u0018n\u001c:jif\fV/Z;f!\u0011yDN\u001c>\n\u00055d!AF\"p[B\f7\r^5p]N+X.\\1ss\u0016sGO]=\u0011\u0005=DX\"\u00019\u000b\u0005E\t(B\u0001:t\u0003\u001d\u0019Ho\u001c:bO\u0016T!a\u0005;\u000b\u0005U4\u0018!C2p]\u001adW/\u001a8u\u0015\u00059\u0018AA5p\u0013\tI\bO\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]B\u00111\u0010 \u0007\u0001\t\u0015ihA1\u0001\u007f\u0005\u00051\u0016cA@\u0002\u0006A\u0019q#!\u0001\n\u0007\u0005\r\u0001DA\u0004O_RD\u0017N\\4\u0011\u0007]\t9!C\u0002\u0002\na\u00111!\u00118z\u0003Q\u0019u.\u001c9bGRLwN\\*v[6\f'/\u001b>feB\u0011q\bC\n\u0003\u0011Y!\"!!\u0004\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t9BK\u00021\u00033Y#!a\u0007\u0011\t\u0005u\u0011qE\u0007\u0003\u0003?QA!!\t\u0002$\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003KA\u0012AC1o]>$\u0018\r^5p]&!\u0011\u0011FA\u0010\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class CompactionSummarizer
implements Logging {
    private final ReplicaManager replicaManager;
    private final TierTasksConfig config;
    private final Time time;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$3() {
        return CompactionSummarizer$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        CompactionSummarizer compactionSummarizer = this;
        synchronized (compactionSummarizer) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String logCompactionSummary(List<CompactionTask> compactionTasks) {
        PriorityQueue maxCompactionDelaySortedSummary = new PriorityQueue((o1, o2) -> Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong(o2.value())).compareTo(Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong(o1.value()))));
        PriorityQueue expectedCompactionEfficiencySortedSummary = new PriorityQueue((o1, o2) -> Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble(o1.value())).compareTo(Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble(o2.value()))));
        long now = this.time.milliseconds();
        compactionTasks.foreach((Function1<CompactionTask, Option> & Serializable)task -> task.maybeUpdateLogToClean($this.replicaManager, now, $this.config.logCleanupIntervalMs()).map((Function1<TierLogToClean, Object> & Serializable)tierLogToClean -> BoxesRunTime.boxToBoolean(CompactionSummarizer.$anonfun$logCompactionSummary$4(maxCompactionDelaySortedSummary, expectedCompactionEfficiencySortedSummary, tierLogToClean))));
        if (!maxCompactionDelaySortedSummary.isEmpty() && !expectedCompactionEfficiencySortedSummary.isEmpty()) {
            String compactionSummary = "Compaction Workload Summary for Broker " + this.config.brokerId() + ":\n\tTopic Partitions With Highest Max Compaction Delay (ms):\n" + this.printTopTenCompactionWorkloads(maxCompactionDelaySortedSummary) + "\tTopic Partitions With Lowest Expected Compaction Efficiency:\n" + this.printTopTenCompactionWorkloads(expectedCompactionEfficiencySortedSummary);
            this.info((Function0<String> & Serializable)() -> compactionSummary);
            return compactionSummary;
        }
        return "";
    }

    private <V> String printTopTenCompactionWorkloads(PriorityQueue<CompactionSummaryEntry<TopicIdPartition, V>> pq) {
        ArrayList<CompactionSummaryEntry> entries = new ArrayList<CompactionSummaryEntry>();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp(x$1 -> Option$.MODULE$.apply(pq.poll()).foreach((Function1<CompactionSummaryEntry, Object> & Serializable)entry -> BoxesRunTime.boxToBoolean(entries.add(entry))));
        StringBuilder output = new StringBuilder();
        entries.forEach(entry -> output.append("\t\t" + entry.key() + "   " + entry.value() + "\n"));
        return output.toString();
    }

    public static final /* synthetic */ boolean $anonfun$logCompactionSummary$4(PriorityQueue maxCompactionDelaySortedSummary$1, PriorityQueue expectedCompactionEfficiencySortedSummary$1, TierLogToClean tierLogToClean) {
        TopicIdPartition topicIdPartition = tierLogToClean.topicIdPartition().get();
        CompactionSummaryEntry<TopicIdPartition, Object> maxCompactionDelayEntry = new CompactionSummaryEntry<TopicIdPartition, Object>(topicIdPartition, tierLogToClean.thresholdMaxCompactionDelayMs().getOrElse(() -> 0L));
        CompactionSummaryEntry<TopicIdPartition, Double> expectedCompactionEfficiencyEntry = new CompactionSummaryEntry<TopicIdPartition, Double>(topicIdPartition, BoxesRunTime.boxToDouble(tierLogToClean.expectedCompactionEfficiency()));
        maxCompactionDelaySortedSummary$1.add(maxCompactionDelayEntry);
        return expectedCompactionEfficiencySortedSummary$1.add(expectedCompactionEfficiencyEntry);
    }

    public CompactionSummarizer(ReplicaManager replicaManager, TierTasksConfig config, Time time) {
        this.replicaManager = replicaManager;
        this.config = config;
        this.time = time;
        Logging.$init$(this);
    }
}

