/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import java.io.Serializable;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.ChangeMetadata;
import kafka.tier.tasks.LeadershipChange;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.TierTaskQueue;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierLogToClean;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.OffsetMapSupplier;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.AbstractSeq;
import scala.collection.immutable.List;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]a\u0001B\u0006\r\u0001UA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u000bY\u0003A\u0011A,\t\r}\u0003A\u0011\u000b\ba\u0011\u0019q\u0007\u0001\"\u0015\u000f_\"A\u0011Q\u0001\u0001\u0005R9\t9AA\nD_6\u0004\u0018m\u0019;j_:$\u0016m]6Rk\u0016,XM\u0003\u0002\u000e\u001d\u0005Q1m\\7qC\u000e$\u0018n\u001c8\u000b\u0005=\u0001\u0012!\u0002;bg.\u001c(BA\t\u0013\u0003\u0011!\u0018.\u001a:\u000b\u0003M\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001-A\u0019q\u0003\u0007\u000e\u000e\u00039I!!\u0007\b\u0003\u001bQKWM\u001d+bg.\fV/Z;f!\tYB$D\u0001\r\u0013\tiBB\u0001\bD_6\u0004\u0018m\u0019;j_:$\u0016m]6\u0002\u0007\r$\b\u0010\u0005\u0002!G5\t\u0011E\u0003\u0002#!\u00059a-\u001a;dQ\u0016\u0014\u0018B\u0001\u0013\"\u0005M\u0019\u0015M\\2fY2\fG/[8o\u0007>tG/\u001a=u\u0003!i\u0017\r\u001f+bg.\u001c\bCA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#aA%oi\u0006!A/[7f!\tq\u0003(D\u00010\u0015\t\u0001\u0014'A\u0003vi&d7O\u0003\u00023g\u000511m\\7n_:T!a\u0005\u001b\u000b\u0005U2\u0014AB1qC\u000eDWMC\u00018\u0003\ry'oZ\u0005\u0003s=\u0012A\u0001V5nK\u0006QAn\\4U_\u000ecW-\u00198\u0011\u000b\u001db$DP!\n\u0005uB#!\u0003$v]\u000e$\u0018n\u001c83!\t9s(\u0003\u0002AQ\t!Aj\u001c8h!\r9#\tR\u0005\u0003\u0007\"\u0012aa\u00149uS>t\u0007CA\u000eF\u0013\t1EB\u0001\bUS\u0016\u0014Hj\\4U_\u000ecW-\u00198\u0002#=4gm]3u\u001b\u0006\u00048+\u001e9qY&,'\u000f\u0005\u0002J!6\t!J\u0003\u0002L\u0019\u0006\u0019An\\4\u000b\u00055s\u0015!C5oi\u0016\u0014h.\u00197t\u0015\ty5'A\u0004ti>\u0014\u0018mZ3\n\u0005ES%!E(gMN,G/T1q'V\u0004\b\u000f\\5fe\u0006)B/[3s\u0007>l\u0007/Y2uS>tW*\u001a;sS\u000e\u001c\bCA\u000eU\u0013\t)FBA\u000bUS\u0016\u00148i\\7qC\u000e$\u0018n\u001c8NKR\u0014\u0018nY:\u0002\rqJg.\u001b;?)\u001dA\u0016LW.];z\u0003\"a\u0007\u0001\t\u000by9\u0001\u0019A\u0010\t\u000b\u0015:\u0001\u0019\u0001\u0014\t\u000b1:\u0001\u0019A\u0017\t\u000bi:\u0001\u0019A\u001e\t\u000b\u001d;\u0001\u0019\u0001%\t\u000bI;\u0001\u0019A*\u0002\u0013M|'\u000f\u001e+bg.\u001cHCA1n!\r\u0011'N\u0007\b\u0003G\"t!\u0001Z4\u000e\u0003\u0015T!A\u001a\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0013BA5)\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001b7\u0003\t1K7\u000f\u001e\u0006\u0003S\"BQa\u0004\u0005A\u0002\u0005\fqA\\3x)\u0006\u001c8\u000eF\u0002\u001bavDQ!]\u0005A\u0002I\f\u0001\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8\u0011\u0005M\\X\"\u0001;\u000b\u0005E)(BA(w\u0015\t\u0019rO\u0003\u0002ys\u0006I1m\u001c8gYV,g\u000e\u001e\u0006\u0002u\u0006\u0011\u0011n\\\u0005\u0003yR\u0014\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\t\u000byL\u0001\u0019A@\u0002\u00115,G/\u00193bi\u0006\u00042aFA\u0001\u0013\r\t\u0019A\u0004\u0002\u0014'R\f'\u000f^\"iC:<W-T3uC\u0012\fG/Y\u0001\u000b[\u0006L\bK]8dKN\u001cH\u0003BA\u0005\u0003\u001f\u00012aJA\u0006\u0013\r\ti\u0001\u000b\u0002\b\u0005>|G.Z1o\u0011\u0019q(\u00021\u0001\u0002\u0012A\u0019q#a\u0005\n\u0007\u0005UaB\u0001\bDQ\u0006tw-Z'fi\u0006$\u0017\r^1")
public class CompactionTaskQueue
extends TierTaskQueue<CompactionTask> {
    private final CancellationContext ctx;
    private final Time time;
    private final Function2<CompactionTask, Object, Option<TierLogToClean>> logToClean;
    private final OffsetMapSupplier offsetMapSupplier;
    private final TierCompactionMetrics tierCompactionMetrics;

    @Override
    public List<CompactionTask> sortTasks(List<CompactionTask> tasks) {
        long now = this.time.milliseconds();
        Object updated = tasks.map((Function1<CompactionTask, Tuple2> & Serializable)task -> new Tuple2<CompactionTask, Option<TierLogToClean>>((CompactionTask)task, $this.logToClean.apply((CompactionTask)task, BoxesRunTime.boxToLong(now))));
        this.debug(() -> CompactionTaskQueue.$anonfun$sortTasks$2((List)updated));
        return ((List)((AbstractSeq)((List)((List)updated).filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(CompactionTaskQueue.$anonfun$sortTasks$3(x0$1)))).map((Function1<Tuple2, Tuple2> & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                CompactionTask task = (CompactionTask)tuple2._1();
                Option toCleanOpt = (Option)tuple2._2();
                return new Tuple2(task, toCleanOpt.get());
            }
            throw new MatchError(tuple2);
        })).sortBy((Function1<Tuple2, TierLogToClean> & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                TierLogToClean toClean = (TierLogToClean)tuple2._2();
                return toClean;
            }
            throw new MatchError(tuple2);
        }, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).map((Function1<Tuple2, CompactionTask> & Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                CompactionTask task = (CompactionTask)tuple2._1();
                return task;
            }
            throw new MatchError(tuple2);
        });
    }

    @Override
    public CompactionTask newTask(TopicIdPartition topicIdPartition, StartChangeMetadata metadata) {
        StartChangeMetadata startChangeMetadata = metadata;
        if (startChangeMetadata instanceof StartLeadership) {
            StartLeadership startLeadership = (StartLeadership)startChangeMetadata;
            return new CompactionTask(this.ctx.subContext(), topicIdPartition, this.offsetMapSupplier, new CompactionTask.CleanLog(startLeadership.leaderEpoch(), None$.MODULE$), this.tierCompactionMetrics, this.time);
        }
        throw new IllegalStateException("Unexpected change " + startChangeMetadata);
    }

    @Override
    public boolean mayProcess(ChangeMetadata metadata) {
        ChangeMetadata changeMetadata = metadata;
        return changeMetadata instanceof LeadershipChange;
    }

    public static final /* synthetic */ String $anonfun$sortTasks$2(List updated$1) {
        return "Ordering between task tier log to cleans: " + updated$1;
    }

    public static final /* synthetic */ boolean $anonfun$sortTasks$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            CompactionTask task = (CompactionTask)tuple2._1();
            Option toCleanOpt = (Option)tuple2._2();
            return toCleanOpt.exists((Function1<TierLogToClean, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.cleanable(task.taskCreationTime())));
        }
        throw new MatchError(tuple2);
    }

    public CompactionTaskQueue(CancellationContext ctx, int maxTasks, Time time, Function2<CompactionTask, Object, Option<TierLogToClean>> logToClean, OffsetMapSupplier offsetMapSupplier, TierCompactionMetrics tierCompactionMetrics) {
        this.ctx = ctx;
        this.time = time;
        this.logToClean = logToClean;
        this.offsetMapSupplier = offsetMapSupplier;
        this.tierCompactionMetrics = tierCompactionMetrics;
        super(ctx, maxTasks, time);
    }
}

