/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.storage.log.TierLogSegment;
import io.confluent.kafka.storage.tier.TopicIdPartition;
import io.confluent.kafka.storage.tier.domain.AbstractTierMetadata;
import io.confluent.kafka.storage.tier.domain.TierCompactionCommitAndSwap;
import io.confluent.kafka.storage.tier.domain.TierSegmentUploadInitiate;
import io.confluent.kafka.storage.tier.state.TierPartitionState;
import io.confluent.kafka.storage.tier.store.objects.FragmentType;
import io.confluent.kafka.storage.tier.store.objects.metadata.ObjectMetadata;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CancellationException;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierLogCompactionFatalException;
import kafka.tier.exceptions.TierLogCompactionFatalException$;
import kafka.tier.exceptions.TierLogCompactionFencedException;
import kafka.tier.exceptions.TierLogCompactionFencedException$;
import kafka.tier.exceptions.TierMetadataRetriableException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.OffsetIndexFetchRequest;
import kafka.tier.fetcher.TierAbortedTxnReader;
import kafka.tier.fetcher.TierSegmentReader;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.TierObjectStoreRetryPolicy;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogSegment;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class TierLogCompactionUtils$
implements Logging {
    public static final TierLogCompactionUtils$ MODULE$ = new TierLogCompactionUtils$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TierLogCompactionUtils$ tierLogCompactionUtils$ = this;
        synchronized (tierLogCompactionUtils$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return CompactionTask.class.getName();
    }

    public boolean isCompactAndDelete(LogConfig logConfig) {
        return logConfig.compact() && logConfig.delete();
    }

    public int startingPosition(CancellationContext ctx, TierLogSegment segment, TierObjectStore tierObjectStore) {
        return BoxesRunTime.unboxToInt(this.maybeHandleIOException((Function0<String> & Serializable)() -> "Error while computing starting position for segment " + segment, () -> {
            int n;
            int indexPos = OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffset((CancellationContext)ctx$2, (TierObjectStore)tierObjectStore$2, (ObjectMetadata)segment$1.metadata(), (long)segment$1.baseOffset()).startOffsetPosition.position;
            TierObjectStoreResponse response = tierObjectStore.getObjectStoreFragment(segment.metadata(), FragmentType.SEGMENT, Predef$.MODULE$.long2Long(indexPos));
            TierSegmentReader reader = new TierSegmentReader("CleanerFetch(segment=" + segment + ", targetOffset=" + segment.baseOffset() + ")");
            try {
                n = indexPos + reader.positionForOffset(ctx, response.getInputStream(), segment.baseOffset(), Integer.MAX_VALUE);
            }
            finally {
                response.close();
            }
            return n;
        }));
    }

    public int startingPosition(TierLogSegment segment, TierObjectStore tierObjectStore, CancellationContext ctx, TierObjectStoreRetryPolicy retryPolicy) {
        return BoxesRunTime.unboxToInt(this.maybeRetry((Function0<TierObjectStoreRetryPolicy> & Serializable)() -> retryPolicy, ctx, () -> MODULE$.startingPosition(ctx, segment, tierObjectStore)));
    }

    public void readSegment(TierLogSegment segment, TierObjectStore tierObjectStore, int startBytePosition, ByteBuffer readBuffer) {
        try (TierObjectStoreResponse response = tierObjectStore.getObjectStoreFragment(segment.metadata(), FragmentType.SEGMENT, Predef$.MODULE$.long2Long(startBytePosition), Predef$.MODULE$.long2Long((long)startBytePosition + (long)readBuffer.capacity()));){
            this.maybeHandleIOException((Function0<String> & Serializable)() -> "Error while reading segment " + segment, () -> Utils.readFully(response.getInputStream(), readBuffer, false));
            readBuffer.flip();
        }
    }

    public void readSegment(TierLogSegment segment, TierObjectStore tierObjectStore, int startBytePosition, ByteBuffer readBuffer, CancellationContext ctx, TierObjectStoreRetryPolicy retryPolicy) {
        this.maybeRetry((Function0<TierObjectStoreRetryPolicy> & Serializable)() -> retryPolicy, ctx, () -> MODULE$.readSegment(segment, tierObjectStore, startBytePosition, readBuffer));
    }

    public Option<ByteBuffer> fetchEpochState(TierObjectStore tierObjectStore, TierLogSegment finalSegment) {
        Option option;
        if (finalSegment.metadata().hasEpochState()) {
            try (TierObjectStoreResponse response = tierObjectStore.getObjectStoreFragment(finalSegment.metadata(), FragmentType.EPOCH_STATE);){
                option = new Some<ByteBuffer>(ByteBuffer.wrap((byte[])this.maybeHandleIOException((Function0<String> & Serializable)() -> "Error while reading epoch state for segment " + finalSegment, (Function0<byte[]> & Serializable)() -> Utils.readFullyToArray(response.getInputStream(), Predef$.MODULE$.Integer2int(TierStateFetcher.ESTIMATED_BUFFER_SIZE)))));
            }
        } else {
            option = None$.MODULE$;
        }
        None$ epochStateOpt = option;
        return epochStateOpt;
    }

    public Option<ByteBuffer> fetchEpochState(TierObjectStore tierObjectStore, TierLogSegment finalSegment, CancellationContext ctx, TierObjectStoreRetryPolicy retryPolicy) {
        return (Option)this.maybeRetry((Function0<TierObjectStoreRetryPolicy> & Serializable)() -> retryPolicy, ctx, (Function0<Option> & Serializable)() -> MODULE$.fetchEpochState(tierObjectStore, finalSegment));
    }

    public Option<ByteBuffer> fetchProducerState(TierObjectStore tierObjectStore, TierLogSegment finalSegment) {
        Option option;
        if (finalSegment.metadata().hasProducerState()) {
            try (TierObjectStoreResponse response = tierObjectStore.getObjectStoreFragment(finalSegment.metadata(), FragmentType.PRODUCER_STATE);){
                option = new Some<ByteBuffer>(ByteBuffer.wrap((byte[])this.maybeHandleIOException((Function0<String> & Serializable)() -> "Error while reading producer state for segment " + finalSegment, (Function0<byte[]> & Serializable)() -> Utils.readFullyToArray(response.getInputStream(), Predef$.MODULE$.Integer2int(TierStateFetcher.ESTIMATED_BUFFER_SIZE)))));
            }
        } else {
            option = None$.MODULE$;
        }
        None$ producerStateOpt = option;
        return producerStateOpt;
    }

    public Option<ByteBuffer> fetchProducerState(TierObjectStore tierObjectStore, TierLogSegment finalSegment, CancellationContext ctx, TierObjectStoreRetryPolicy retryPolicy) {
        return (Option)this.maybeRetry((Function0<TierObjectStoreRetryPolicy> & Serializable)() -> retryPolicy, ctx, (Function0<Option> & Serializable)() -> MODULE$.fetchProducerState(tierObjectStore, finalSegment));
    }

    public List<AbortedTxn> fetchAbortedTransactions(TierObjectStore tierObjectStore, TierLogSegment segment, CancellationContext ctx) {
        if (segment.metadata().hasAbortedTxns()) {
            List list;
            try (TierObjectStoreResponse response = tierObjectStore.getObjectStoreFragment(segment.metadata(), FragmentType.TRANSACTION_INDEX);){
                list = (List)this.maybeHandleIOException((Function0<String> & Serializable)() -> "Error while fetching aborted transactions for segment " + segment, (Function0<List> & Serializable)() -> CollectionConverters$.MODULE$.ListHasAsScala(TierAbortedTxnReader.readInto(ctx, response.getInputStream(), segment.baseOffset(), segment.endOffset())).asScala().toList());
            }
            return list;
        }
        return package$.MODULE$.List().empty();
    }

    public List<AbortedTxn> fetchAbortedTransactions(TierObjectStore tierObjectStore, TierLogSegment segment, CancellationContext ctx, TierObjectStoreRetryPolicy retryPolicy) {
        return (List)this.maybeRetry((Function0<TierObjectStoreRetryPolicy> & Serializable)() -> retryPolicy, ctx, (Function0<List> & Serializable)() -> MODULE$.fetchAbortedTransactions(tierObjectStore, segment, ctx));
    }

    public void writeMarker(TierTopicAppender tierTopicAppender, AbstractTierMetadata marker) {
        TierPartitionState.AppendResult result;
        this.info((Function0<String> & Serializable)() -> "Emitting " + marker + " for " + marker.topicIdPartition());
        TierPartitionState.AppendResult appendResult = result = tierTopicAppender.addMetadata(marker).get();
        if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals((Object)appendResult)) {
            this.info((Function0<String> & Serializable)() -> "Finalized " + marker + " for " + marker.topicIdPartition());
            return;
        }
        if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals((Object)appendResult)) {
            this.error((Function0<String> & Serializable)() -> "Stopping state machine for " + marker.topicIdPartition() + " as attempt to transition was fenced");
            throw new TierLogCompactionFencedException(marker.topicIdPartition(), TierLogCompactionFencedException$.MODULE$.$lessinit$greater$default$2());
        }
        if (((Object)((Object)TierPartitionState.AppendResult.FAILED)).equals((Object)appendResult)) {
            this.warn((Function0<String> & Serializable)() -> "Backing off compaction process for " + marker.topicIdPartition() + " as attempt to transition was failed.");
            throw new TierMetadataRetriableException(marker.topicIdPartition().toString());
        }
        if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals((Object)appendResult)) {
            throw new NotTierablePartitionException(marker.topicIdPartition());
        }
        this.error((Function0<String> & Serializable)() -> "Unexpected append result for " + marker.topicIdPartition() + ": " + result);
        throw new TierLogCompactionFatalException("Unexpected append result for " + marker.topicIdPartition() + ": " + result, TierLogCompactionFatalException$.MODULE$.$lessinit$greater$default$2());
    }

    public void writeUploadInitiateMarker(TierSegmentUploadInitiate uploadInitiate, TopicIdPartition topicIdPartition, Time time, TierTopicAppender tierTopicAppender) {
        long startTimeMs = time.milliseconds();
        this.writeMarker(tierTopicAppender, uploadInitiate);
        this.info((Function0<String> & Serializable)() -> uploadInitiate + " for " + topicIdPartition + " was successfully written in in " + (time.milliseconds() - startTimeMs) + " ms");
    }

    public void writeCommitAndSwapMarker(TierCompactionCommitAndSwap commitAndSwap, TopicIdPartition topicIdPartition, Time time, TierTopicAppender tierTopicAppender) {
        long startTimeMs = time.milliseconds();
        this.writeMarker(tierTopicAppender, commitAndSwap);
        this.info((Function0<String> & Serializable)() -> commitAndSwap + " for " + topicIdPartition + " was successfully written in in " + (time.milliseconds() - startTimeMs) + " ms");
    }

    public boolean shouldCompactNextSourceSegmentIntoDestSegment(TopicIdPartition topicIdPartition, LogSegment destSegment, TierLogSegment nextSegment, int targetSegmentSize, int minSegmentSize, int maxSegmentSize) {
        if (!destSegment.canConvertToRelativeOffset(nextSegment.endOffset())) {
            this.info((Function0<String> & Serializable)() -> topicIdPartition + ": next source segment may have offsets that are too large for the current dest segment's base offset, completing segment.");
            return false;
        }
        if (destSegment.size() == 0) {
            return true;
        }
        if (destSegment.size() > maxSegmentSize - nextSegment.size()) {
            this.warn((Function0<String> & Serializable)() -> topicIdPartition + ": combined size of dest segment(" + destSegment.size() + ") and next source segment(" + nextSegment + ") exceeds max compacted segment size limit(" + maxSegmentSize + "), completing segment.");
            return false;
        }
        if (destSegment.size() >= minSegmentSize && destSegment.size() > targetSegmentSize - nextSegment.size()) {
            this.info((Function0<String> & Serializable)() -> topicIdPartition + ": combined size of dest segment(" + destSegment.size() + ") and next source segment(" + nextSegment + ") exceeds target segment size limit(" + targetSegmentSize + "), completing segment.");
            return false;
        }
        return true;
    }

    public <T> T maybeRetry(Function0<TierObjectStoreRetryPolicy> retryPolicy, CancellationContext ctx, Function0<T> fun) {
        IntRef retryCount = IntRef.create(0);
        while (true) {
            if (ctx.isCancelled()) {
                throw new CancellationException("Cancellation context has been marked canceled, cancelling the operation.");
            }
            try {
                ++retryCount.elem;
                return fun.apply();
            }
            catch (Exception e) {
                TierObjectStoreRetryPolicy.RetryInfo retryInfo = retryPolicy.apply().shouldRetry(e, retryCount.elem);
                if (!retryInfo.shouldRetry()) {
                    this.error((Function0<String> & Serializable)() -> "Fail operation after " + retryCount$1.elem + " retries.", (Function0<Throwable>)(Function0<Exception> & Serializable)() -> e);
                    throw e;
                }
                Thread.sleep(retryInfo.getRetryInterval());
                continue;
            }
            break;
        }
    }

    private <T> T maybeHandleIOException(Function0<String> errorMsg, Function0<T> fun) {
        T t;
        try {
            t = fun.apply();
        }
        catch (IOException e) {
            throw new TierObjectStoreRetriableException(errorMsg.apply(), e);
        }
        catch (UncheckedIOException e) {
            throw new TierObjectStoreRetriableException(errorMsg.apply(), e);
        }
        return t;
    }

    private TierLogCompactionUtils$() {
    }
}

