/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.snapshot;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Meter;
import io.confluent.kafka.storage.log.AbstractLog;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.server.ReplicaManager;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTaskWorkingSet;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.tasks.snapshot.MetadataSnapshotMetrics;
import kafka.tier.tasks.snapshot.MetadataSnapshotTask;
import kafka.tier.tasks.snapshot.MetadataSnapshotTaskQueue;
import kafka.tier.tasks.snapshot.TierMetadataSnapshotManager$;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Some;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005%h\u0001\u0002\u0014(\u0005AB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"A1\n\u0001B\u0001B\u0003%A\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003T\u0011!I\u0006A!A!\u0002\u0013Q\u0006\u0002C/\u0001\u0005\u000b\u0007I\u0011\u00010\t\u0011\u0011\u0004!\u0011!Q\u0001\n}C\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\te\u0002\u0011\t\u0011)A\u0006g\")\u0011\u0010\u0001C\u0001u\"I\u0011Q\u0002\u0001C\u0002\u0013%\u0011q\u0002\u0005\t\u0003?\u0001\u0001\u0015!\u0003\u0002\u0012!I\u0011\u0011\u0005\u0001C\u0002\u0013%\u00111\u0005\u0005\t\u0003w\u0001\u0001\u0015!\u0003\u0002&!I\u0011Q\b\u0001C\u0002\u0013%\u00111\u0005\u0005\t\u0003\u007f\u0001\u0001\u0015!\u0003\u0002&!I\u0011\u0011\t\u0001C\u0002\u0013%\u00111\u0005\u0005\t\u0003\u0007\u0002\u0001\u0015!\u0003\u0002&!I\u0011Q\t\u0001C\u0002\u0013%\u0011q\t\u0005\t\u00033\u0002\u0001\u0015!\u0003\u0002J!I\u00111\f\u0001C\u0002\u0013%\u0011Q\f\u0005\t\u0003K\u0002\u0001\u0015!\u0003\u0002`!I\u0011q\r\u0001C\u0002\u0013%\u0011q\t\u0005\t\u0003S\u0002\u0001\u0015!\u0003\u0002J!I\u00111\u000e\u0001C\u0002\u0013%\u0011Q\f\u0005\t\u0003[\u0002\u0001\u0015!\u0003\u0002`!Q\u0011q\u000e\u0001C\u0002\u0013\u0005\u0011&!\u001d\t\u0011\u0005e\u0004\u0001)A\u0005\u0003gB\u0011\"a\u001f\u0001\u0005\u0004%I!! \t\u0011\u00055\u0005\u0001)A\u0005\u0003\u007fBq!a$\u0001\t\u0003\t\t\nC\u0004\u00022\u0002!\t!a-\t\u000f\u0005m\u0006\u0001\"\u0003\u0002>\u001eI\u0011\u0011Z\u0014\u0002\u0002#\u0005\u00111\u001a\u0004\tM\u001d\n\t\u0011#\u0001\u0002N\"1\u0011p\tC\u0001\u0003\u001fD\u0011\"!5$#\u0003%\t!a5\u00037QKWM]'fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8u\u001b\u0006t\u0017mZ3s\u0015\tA\u0013&\u0001\u0005t]\u0006\u00048\u000f[8u\u0015\tQ3&A\u0003uCN\\7O\u0003\u0002-[\u0005!A/[3s\u0015\u0005q\u0013!B6bM.\f7\u0001A\n\u0004\u0001E:\u0004C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$AB!osJ+g\r\u0005\u00029w5\t\u0011H\u0003\u0002;[\u0005)Q\u000f^5mg&\u0011A(\u000f\u0002\b\u0019><w-\u001b8h\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"a\u0010\"\u000e\u0003\u0001S!!Q\u0017\u0002\rM,'O^3s\u0013\t\u0019\u0005I\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002#QLWM\u001d+pa&\u001c\u0017\t\u001d9f]\u0012,'\u000f\u0005\u0002G\u00136\tqI\u0003\u0002IW\u0005)Ao\u001c9jG&\u0011!j\u0012\u0002\u0012)&,'\u000fV8qS\u000e\f\u0005\u000f]3oI\u0016\u0014\u0018a\u0004;jKJ|%M[3diN#xN]3\u0011\u00055\u0003V\"\u0001(\u000b\u0005=[\u0013!B:u_J,\u0017BA)O\u0005=!\u0016.\u001a:PE*,7\r^*u_J,\u0017aA2uqB\u0011AkV\u0007\u0002+*\u0011akK\u0001\bM\u0016$8\r[3s\u0013\tAVKA\nDC:\u001cW\r\u001c7bi&|gnQ8oi\u0016DH/\u0001\u0005nCb$\u0016m]6t!\t\u00114,\u0003\u0002]g\t\u0019\u0011J\u001c;\u0002\r\r|gNZ5h+\u0005y\u0006C\u00011c\u001b\u0005\t'BA/*\u0013\t\u0019\u0017MA\bUS\u0016\u0014H+Y:lg\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\nA\u0001^5nKB\u0011q\r]\u0007\u0002Q*\u0011!(\u001b\u0006\u0003U.\faaY8n[>t'B\u0001\u0018m\u0015\tig.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0006\u0019qN]4\n\u0005ED'\u0001\u0002+j[\u0016\f!!Z2\u0011\u0005Q<X\"A;\u000b\u0005Y\u001c\u0014AC2p]\u000e,(O]3oi&\u0011\u00010\u001e\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtDCD>\u0000\u0003\u0003\t\u0019!!\u0002\u0002\b\u0005%\u00111\u0002\u000b\u0003yz\u0004\"! \u0001\u000e\u0003\u001dBQA\u001d\u0006A\u0004MDQ!\u0010\u0006A\u0002yBQ\u0001\u0012\u0006A\u0002\u0015CQa\u0013\u0006A\u00021CQA\u0015\u0006A\u0002MCQ!\u0017\u0006A\u0002iCQ!\u0018\u0006A\u0002}Cq!\u001a\u0006\u0011\u0002\u0003\u0007a-\u0001\u0007nKR\u0014\u0018nY:He>,\b/\u0006\u0002\u0002\u0012A!\u00111CA\u000e\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011aB7fiJL7m\u001d\u0006\u0003\u0003.LA!!\b\u0002\u0016\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0002\u001b5,GO]5dg\u001e\u0013x.\u001e9!\u0003!\u0011\u0017\u0010^3SCR,WCAA\u0013!\u0011\t9#a\u000e\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\tAaY8sK*!\u0011qCA\u0018\u0015\u0011\t\t$a\r\u0002\re\fW.\\3s\u0015\t\t)$A\u0002d_6LA!!\u000f\u0002*\t)Q*\u001a;fe\u0006I!-\u001f;f%\u0006$X\rI\u0001\ne\u0016$(/\u001f*bi\u0016\f!B]3uef\u0014\u0016\r^3!\u00039)\u0007pY3qi&|gn\u001d*bi\u0016\fq\"\u001a=dKB$\u0018n\u001c8t%\u0006$X\rI\u0001%\u000bJ*ul\u0011%F\u0007.\u001bV+T0G)B\u001bvl\u0014(`\t&\u001b6jX\"P%J+\u0006\u000bV%P\u001dV\u0011\u0011\u0011\n\t\u0005\u0003\u0017\n)&\u0004\u0002\u0002N)!\u0011qJA)\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0013\u0001\u00026bm\u0006LA!a\u0016\u0002N\t11\u000b\u001e:j]\u001e\fQ%\u0012\u001aF?\u000eCUiQ&T+6{f\t\u0016)T?>su\fR%T\u0017~\u001buJ\u0015*V!RKuJ\u0014\u0011\u0002!=tG)[:l\u0007>\u0014(/\u001e9uS>tWCAA0!\u0011\t9#!\u0019\n\t\u0005\r\u0014\u0011\u0006\u0002\b\u0007>,h\u000e^3s\u0003Eyg\u000eR5tW\u000e{'O];qi&|g\u000eI\u0001(\u000bJ*ul\u0011%F\u0007.\u001bV+T0G)B\u001bvl\u0014(`\u001d\u0016#vk\u0014*L?\u000e{%KU+Q)&{e*\u0001\u0015Fe\u0015{6\tS#D\u0017N+Vj\u0018$U!N{vJT0O\u000bR;vJU&`\u0007>\u0013&+\u0016)U\u0013>s\u0005%A\np]:+Go^8sW\u000e{'O];qi&|g.\u0001\u000bp]:+Go^8sW\u000e{'O];qi&|g\u000eI\u0001\ni\u0006\u001c8.U;fk\u0016,\"!a\u001d\u0011\u0007u\f)(C\u0002\u0002x\u001d\u0012\u0011$T3uC\u0012\fG/Y*oCB\u001c\bn\u001c;UCN\\\u0017+^3vK\u0006QA/Y:l#V,W/\u001a\u0011\u0002\u0015]|'o[5oON+G/\u0006\u0002\u0002\u0000A1\u0011\u0011QAB\u0003\u000fk\u0011!K\u0005\u0004\u0003\u000bK#A\u0005+jKJ$\u0016m]6X_J\\\u0017N\\4TKR\u00042!`AE\u0013\r\tYi\n\u0002\u0015\u001b\u0016$\u0018\rZ1uCNs\u0017\r]:i_R$\u0016m]6\u0002\u0017]|'o[5oON+G\u000fI\u0001\u0007I><vN]6\u0015\u0005\u0005M\u0005CBAK\u0003K\u000bYK\u0004\u0003\u0002\u0018\u0006\u0005f\u0002BAM\u0003?k!!a'\u000b\u0007\u0005uu&\u0001\u0004=e>|GOP\u0005\u0002i%\u0019\u00111U\u001a\u0002\u000fA\f7m[1hK&!\u0011qUAU\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\r6\u0007E\u0003u\u0003[\u000b9)C\u0002\u00020V\u0014aAR;ukJ,\u0017\u0001C:ikR$wn\u001e8\u0015\u0005\u0005U\u0006c\u0001\u001a\u00028&\u0019\u0011\u0011X\u001a\u0003\tUs\u0017\u000e^\u0001\u000eg\u000eDW\rZ;mS:<G*Y4\u0015\t\u0005}\u0016Q\u0019\t\u0004e\u0005\u0005\u0017bAAbg\t!Aj\u001c8h\u0011\u001d\t9-\ta\u0001\u0003\u000f\u000bA\u0001^1tW\u0006YB+[3s\u001b\u0016$\u0018\rZ1uCNs\u0017\r]:i_Rl\u0015M\\1hKJ\u0004\"!`\u0012\u0014\u0005\r\nDCAAf\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011\u0011Q\u001b\u0016\u0004M\u0006]7FAAm!\u0011\tY.!:\u000e\u0005\u0005u'\u0002BAp\u0003C\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r8'\u0001\u0006b]:|G/\u0019;j_:LA!a:\u0002^\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public final class TierMetadataSnapshotManager
implements Logging {
    private final ReplicaManager replicaManager;
    private final CancellationContext ctx;
    private final TierTasksConfig config;
    private final KafkaMetricsGroup metricsGroup;
    private final Meter byteRate;
    private final Meter retryRate;
    private final Meter exceptionsRate;
    private final String E2E_CHECKSUM_FTPS_ON_DISK_CORRUPTION;
    private final Counter onDiskCorruption;
    private final String E2E_CHECKSUM_FTPS_ON_NETWORK_CORRUPTION;
    private final Counter onNetworkCorruption;
    private final MetadataSnapshotTaskQueue taskQueue;
    private final TierTaskWorkingSet<MetadataSnapshotTask> workingSet;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$7() {
        return TierMetadataSnapshotManager$.MODULE$.$lessinit$greater$default$7();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TierMetadataSnapshotManager tierMetadataSnapshotManager = this;
        synchronized (tierMetadataSnapshotManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TierTasksConfig config() {
        return this.config;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private Meter byteRate() {
        return this.byteRate;
    }

    private Meter retryRate() {
        return this.retryRate;
    }

    private Meter exceptionsRate() {
        return this.exceptionsRate;
    }

    private String E2E_CHECKSUM_FTPS_ON_DISK_CORRUPTION() {
        return this.E2E_CHECKSUM_FTPS_ON_DISK_CORRUPTION;
    }

    private Counter onDiskCorruption() {
        return this.onDiskCorruption;
    }

    private String E2E_CHECKSUM_FTPS_ON_NETWORK_CORRUPTION() {
        return this.E2E_CHECKSUM_FTPS_ON_NETWORK_CORRUPTION;
    }

    private Counter onNetworkCorruption() {
        return this.onNetworkCorruption;
    }

    public MetadataSnapshotTaskQueue taskQueue() {
        return this.taskQueue;
    }

    private TierTaskWorkingSet<MetadataSnapshotTask> workingSet() {
        return this.workingSet;
    }

    public List<Future<MetadataSnapshotTask>> doWork() {
        return this.workingSet().doWork(this.config(), None$.MODULE$);
    }

    public void shutdown() {
        this.ctx.cancel();
        this.taskQueue().close();
    }

    private long schedulingLag(MetadataSnapshotTask task) {
        MetadataSnapshotTask.MetadataSnapshotTaskState metadataSnapshotTaskState = task.state();
        if (metadataSnapshotTaskState instanceof MetadataSnapshotTask.BeforeLeaderSnapshotState) {
            return -1L;
        }
        if (metadataSnapshotTaskState instanceof MetadataSnapshotTask.BeforeMetadataSnapshotState) {
            return BoxesRunTime.unboxToLong(this.replicaManager.getLog(task.topicPartition()).map((Function1<AbstractLog, Object> & Serializable)log -> BoxesRunTime.boxToLong(TierMetadataSnapshotManager.$anonfun$schedulingLag$1(log))).getOrElse(() -> 0L));
        }
        if (metadataSnapshotTaskState instanceof MetadataSnapshotTask.MetadataSnapshotState) {
            return -2L;
        }
        if (metadataSnapshotTaskState instanceof MetadataSnapshotTask.AfterMetadataSnapshotState) {
            return -3L;
        }
        if (metadataSnapshotTaskState instanceof MetadataSnapshotTask.MetadataSnapshotGarbageCollectionState) {
            return -4L;
        }
        if (metadataSnapshotTaskState instanceof MetadataSnapshotTask.FailedMetadataSnapshotState) {
            return -5L;
        }
        throw new MatchError(metadataSnapshotTaskState);
    }

    public static final /* synthetic */ long $anonfun$schedulingLag$1(AbstractLog log) {
        return log.tierPartitionState().lastSnapshotTimestampMs();
    }

    public TierMetadataSnapshotManager(ReplicaManager replicaManager, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, CancellationContext ctx, int maxTasks, TierTasksConfig config, Time time, ExecutionContext ec) {
        this.replicaManager = replicaManager;
        this.ctx = ctx;
        this.config = config;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.metricsGroup().removeMetric("BytesPerSec");
        this.byteRate = this.metricsGroup().newMeter("BytesPerSec", "bytes per second", TimeUnit.SECONDS);
        this.metricsGroup().removeMetric("RetriesPerSec");
        this.retryRate = this.metricsGroup().newMeter("RetriesPerSec", "number of retries per second", TimeUnit.SECONDS);
        this.metricsGroup().removeMetric("ObjectStoreRetriableExceptionsPerSec");
        this.exceptionsRate = this.metricsGroup().newMeter("ObjectStoreRetriableExceptionsPerSec", "number of times TierObjectStoreRetriableException was invoked per second", TimeUnit.SECONDS);
        this.E2E_CHECKSUM_FTPS_ON_DISK_CORRUPTION = "E2EChecksumFtpsOnDiskCorruption";
        this.metricsGroup().removeMetric(this.E2E_CHECKSUM_FTPS_ON_DISK_CORRUPTION());
        this.onDiskCorruption = this.metricsGroup().newCounter(this.E2E_CHECKSUM_FTPS_ON_DISK_CORRUPTION());
        this.E2E_CHECKSUM_FTPS_ON_NETWORK_CORRUPTION = "E2EChecksumFtpsOnNetworkCorruption";
        this.metricsGroup().removeMetric(this.E2E_CHECKSUM_FTPS_ON_NETWORK_CORRUPTION());
        this.onNetworkCorruption = this.metricsGroup().newCounter(this.E2E_CHECKSUM_FTPS_ON_NETWORK_CORRUPTION());
        this.taskQueue = new MetadataSnapshotTaskQueue(ctx.subContext(), maxTasks, time, (Function1<MetadataSnapshotTask, Object> & Serializable)task -> BoxesRunTime.boxToLong(this.schedulingLag(task)), new MetadataSnapshotMetrics(new Some<Meter>(this.byteRate()), new Some<Meter>(this.retryRate()), new Some<Meter>(this.exceptionsRate()), new Some<Counter>(this.onDiskCorruption()), new Some<Counter>(this.onNetworkCorruption())), config.brokerId());
        this.workingSet = new TierTaskWorkingSet<MetadataSnapshotTask>(this.taskQueue(), replicaManager, tierTopicAppender, tierObjectStore, time, ec);
    }
}

