/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.GetTierRecoveryDataUploadJobResultRequest;
import io.confluent.rest.GetTierRecoveryDataUploadJobResultResponse;
import io.confluent.rest.InitiateTierRecoveryDataUploadRequest;
import io.confluent.rest.InitiateTierRecoveryDataUploadResponse;
import io.confluent.rest.ResponseContainer;
import io.confluent.rest.RewindTierTopicConsumerRequest;
import io.confluent.rest.RewindTierTopicConsumerResponse;
import io.confluent.rest.TierMetadataRecoveryHandler;
import io.confluent.rest.TierRecoveryDataUploadResult;
import io.confluent.rest.TierTopicHeadDataLossDetectionRequest;
import io.confluent.rest.TierTopicHeadDataLossDetectionResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import kafka.tier.common.RestServerUtil;
import kafka.tier.tools.TierOrchestratorUtils;
import kafka.tier.tools.commands.GetTierRecoveryDataUploadJobResultCommandRequest;
import kafka.tier.tools.commands.GetTierRecoveryDataUploadJobResultCommandResponse;
import kafka.tier.tools.commands.InitiateTierRecoveryDataUploadCommandRequest;
import kafka.tier.tools.commands.InitiateTierRecoveryDataUploadCommandResponse;
import kafka.tier.tools.commands.RewindTierTopicConsumerCommandRequest;
import kafka.tier.tools.commands.RewindTierTopicConsumerCommandResponse;
import kafka.tier.tools.commands.TierTopicHeadDataLossDetectionCommandRequest;
import kafka.tier.tools.commands.TierTopicHeadDataLossDetectionCommandResponse;
import kafka.tier.topic.TierTopicConsumerRewindPolicy;
import kafka.tier.topic.recovery.TierTopicHeadDataLossReport;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TierMetadataRecoveryOrchestrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TierMetadataRecoveryOrchestrator.class);
    private final AdminClient adminClient;
    private final CloseableHttpClient httpClient;
    private final Integer restServerPort;
    private static final String HTTP_PREFIX = "http://";
    private static final Map<TierTopicHeadDataLossDetectionResponse.CompletionStatus, TierTopicHeadDataLossReport.CompletionStatus> COMPLETION_STATUS_CONVERSION_MAP = Map.of(TierTopicHeadDataLossDetectionResponse.CompletionStatus.SUCCESS, TierTopicHeadDataLossReport.CompletionStatus.SUCCESS, TierTopicHeadDataLossDetectionResponse.CompletionStatus.PARTIAL_SUCCESS, TierTopicHeadDataLossReport.CompletionStatus.PARTIAL_SUCCESS, TierTopicHeadDataLossDetectionResponse.CompletionStatus.FAILURE, TierTopicHeadDataLossReport.CompletionStatus.FAILURE);
    static final ObjectMapper OBJECT_MAPPER = TierMetadataRecoveryHandler.OBJECT_MAPPER;

    public TierMetadataRecoveryOrchestrator(AdminClient adminClient, Integer restServerPort) {
        this(adminClient, RestServerUtil.buildHttpClient(), restServerPort);
    }

    public TierMetadataRecoveryOrchestrator(AdminClient adminClient, CloseableHttpClient httpClient, Integer restServerPort) {
        this.adminClient = adminClient;
        this.httpClient = httpClient;
        this.restServerPort = restServerPort;
    }

    public Map<Integer, String> getBrokerUrlsIfBrokerExists(Set<Integer> brokerId) throws ExecutionException, InterruptedException {
        Map<Integer, String> brokerToUrlMap = TierOrchestratorUtils.getBrokerToUrlMap(this.adminClient, this.restServerPort, LOGGER);
        HashMap<Integer, String> brokerToUrlMapFiltered = new HashMap<Integer, String>();
        for (Integer id : brokerId) {
            if (!brokerToUrlMap.containsKey(id)) {
                throw new IllegalArgumentException("Broker " + id + " not found in the cluster");
            }
            brokerToUrlMapFiltered.put(id, brokerToUrlMap.get(id));
        }
        return brokerToUrlMapFiltered;
    }

    public RewindTierTopicConsumerCommandResponse rewindTierTopicConsumerForCluster(Optional<Map<Integer, Map<Long, Optional<Integer>>>> partitionToPositionOpt, boolean forceStop, TierTopicConsumerRewindPolicy policy) throws ExecutionException, InterruptedException, JsonProcessingException {
        LOGGER.info("Rewinding tier topic consumer for all brokers in the cluster.");
        Map<Integer, String> brokerToUrlMap = TierOrchestratorUtils.getBrokerToUrlMap(this.adminClient, this.restServerPort, LOGGER);
        RewindTierTopicConsumerCommandResponse rewindTierTopicConsumerCommandResponse = new RewindTierTopicConsumerCommandResponse();
        for (Map.Entry<Integer, String> brokerAndUrl : brokerToUrlMap.entrySet()) {
            RewindTierTopicConsumerRequest request = new RewindTierTopicConsumerRequest(partitionToPositionOpt.orElse(null), forceStop, policy.id());
            String response = this.rewindTierTopicConsumer(new RewindTierTopicConsumerCommandRequest(brokerAndUrl.getValue(), request));
            this.parseRewindTierTopicConsumerResponse(rewindTierTopicConsumerCommandResponse, response, brokerAndUrl.getKey(), policy);
        }
        LOGGER.debug(TierOrchestratorUtils.prettyPrint(OBJECT_MAPPER, rewindTierTopicConsumerCommandResponse));
        return rewindTierTopicConsumerCommandResponse;
    }

    public RewindTierTopicConsumerCommandResponse rewindTierTopicConsumerForBroker(Optional<Map<Integer, Map<Long, Optional<Integer>>>> partitionToPositionOpt, boolean forceStop, TierTopicConsumerRewindPolicy policy, int brokerId) throws JsonProcessingException, ExecutionException, InterruptedException {
        String brokerUrl = TierOrchestratorUtils.getBrokerUrlIfBrokerExists(this.adminClient, this.restServerPort, brokerId, LOGGER);
        RewindTierTopicConsumerCommandResponse rewindTierTopicConsumerCommandResponse = new RewindTierTopicConsumerCommandResponse();
        RewindTierTopicConsumerRequest request = new RewindTierTopicConsumerRequest(partitionToPositionOpt.orElse(null), forceStop, policy.id());
        String response = this.rewindTierTopicConsumer(new RewindTierTopicConsumerCommandRequest(brokerUrl, request));
        this.parseRewindTierTopicConsumerResponse(rewindTierTopicConsumerCommandResponse, response, brokerId, policy);
        LOGGER.debug(TierOrchestratorUtils.prettyPrint(OBJECT_MAPPER, rewindTierTopicConsumerCommandResponse));
        return rewindTierTopicConsumerCommandResponse;
    }

    private String rewindTierTopicConsumer(RewindTierTopicConsumerCommandRequest request) throws JsonProcessingException {
        LOGGER.info("Rewinding tier topic consumer for broker {} with request: {}", (Object)request.brokerUrl(), (Object)TierOrchestratorUtils.prettyPrint(OBJECT_MAPPER, request.request()));
        return RestServerUtil.sendRequestTryHttps(request, this.httpClient);
    }

    private void parseRewindTierTopicConsumerResponse(RewindTierTopicConsumerCommandResponse rewindTierTopicConsumerCommandResponse, String response, Integer broker, TierTopicConsumerRewindPolicy policy) throws JsonProcessingException {
        if (response == null) {
            String message = "Unable to rewind tier topic consumer for broker " + broker;
            rewindTierTopicConsumerCommandResponse.getFailed().add(new RewindTierTopicConsumerCommandResponse.FailedBrokerDetail(broker, message, null));
        } else {
            boolean partialFail;
            RewindTierTopicConsumerResponse result = (RewindTierTopicConsumerResponse)TierMetadataRecoveryOrchestrator.OBJECT_MAPPER.readValue((String)response, new TypeReference<ResponseContainer<RewindTierTopicConsumerResponse>>(){}).data.attributes;
            boolean bl = partialFail = !result.skippedPartitions().isEmpty();
            if (partialFail && policy == TierTopicConsumerRewindPolicy.SKIP_MISSING_PARTITIONS) {
                String message = "Failed to fully rewind tier topic consumer for broker " + broker;
                rewindTierTopicConsumerCommandResponse.getFailed().add(new RewindTierTopicConsumerCommandResponse.FailedBrokerDetail(broker, message, result.skippedPartitions()));
            } else {
                rewindTierTopicConsumerCommandResponse.getSuccess().add(broker);
            }
        }
    }

    public InitiateTierRecoveryDataUploadCommandResponse initiateTierRecoveryDataUploadForCluster(Set<TopicIdPartition> topicIdPartitions, String identifier, int numThreads) throws ExecutionException, InterruptedException, JsonProcessingException {
        LOGGER.info("Initiating tier recovery data upload for all brokers in the cluster.");
        Map<Integer, String> brokerToUrlMap = TierOrchestratorUtils.getBrokerToUrlMap(this.adminClient, this.restServerPort, LOGGER);
        InitiateTierRecoveryDataUploadCommandResponse initiateTierRecoveryDataUploadCommandResponse = new InitiateTierRecoveryDataUploadCommandResponse();
        for (Map.Entry<Integer, String> brokerAndUrl : brokerToUrlMap.entrySet()) {
            InitiateTierRecoveryDataUploadRequest request = new InitiateTierRecoveryDataUploadRequest(topicIdPartitions, identifier, numThreads);
            String response = this.initiateTierRecoveryDataUpload(new InitiateTierRecoveryDataUploadCommandRequest(brokerAndUrl.getValue(), request));
            this.parseInitiateTierRecoveryDataUploadResponse(initiateTierRecoveryDataUploadCommandResponse, response, brokerAndUrl.getKey());
        }
        LOGGER.debug(TierOrchestratorUtils.prettyPrint(OBJECT_MAPPER, initiateTierRecoveryDataUploadCommandResponse));
        return initiateTierRecoveryDataUploadCommandResponse;
    }

    public InitiateTierRecoveryDataUploadCommandResponse initiateTierRecoveryDataUploadForBroker(Set<TopicIdPartition> topicIdPartitions, String identifier, int numThreads, int brokerId) throws JsonProcessingException, ExecutionException, InterruptedException {
        String brokerUrl = TierOrchestratorUtils.getBrokerUrlIfBrokerExists(this.adminClient, this.restServerPort, brokerId, LOGGER);
        InitiateTierRecoveryDataUploadCommandResponse initiateTierRecoveryDataUploadCommandResponse = new InitiateTierRecoveryDataUploadCommandResponse();
        InitiateTierRecoveryDataUploadRequest request = new InitiateTierRecoveryDataUploadRequest(topicIdPartitions, identifier, numThreads);
        String response = this.initiateTierRecoveryDataUpload(new InitiateTierRecoveryDataUploadCommandRequest(brokerUrl, request));
        this.parseInitiateTierRecoveryDataUploadResponse(initiateTierRecoveryDataUploadCommandResponse, response, brokerId);
        LOGGER.debug(TierOrchestratorUtils.prettyPrint(OBJECT_MAPPER, initiateTierRecoveryDataUploadCommandResponse));
        return initiateTierRecoveryDataUploadCommandResponse;
    }

    private String initiateTierRecoveryDataUpload(InitiateTierRecoveryDataUploadCommandRequest request) throws JsonProcessingException {
        LOGGER.info("Initiating upload of tier recovery data for broker {} with request: {}", (Object)request.brokerUrl(), (Object)TierOrchestratorUtils.prettyPrint(OBJECT_MAPPER, request.request()));
        return RestServerUtil.sendRequestTryHttps(request, this.httpClient);
    }

    private void parseInitiateTierRecoveryDataUploadResponse(InitiateTierRecoveryDataUploadCommandResponse initiateTierRecoveryDataUploadCommandResponse, String response, Integer broker) throws JsonProcessingException {
        if (response == null) {
            String message = "Unable to initiate tier recovery data upload for broker " + broker;
            initiateTierRecoveryDataUploadCommandResponse.getFailed().add(new InitiateTierRecoveryDataUploadCommandResponse.FailedBrokerDetail(broker, message));
        } else {
            InitiateTierRecoveryDataUploadResponse result = (InitiateTierRecoveryDataUploadResponse)TierMetadataRecoveryOrchestrator.OBJECT_MAPPER.readValue((String)response, new TypeReference<ResponseContainer<InitiateTierRecoveryDataUploadResponse>>(){}).data.attributes;
            initiateTierRecoveryDataUploadCommandResponse.getSuccess().add(new InitiateTierRecoveryDataUploadCommandResponse.SuccessBrokerDetail(broker, result.jobId()));
        }
    }

    public GetTierRecoveryDataUploadJobResultCommandResponse getTierRecoveryDataUploadJobResultForBrokers(Map<Integer, UUID> brokerToJobId, Map<Integer, String> brokerToUrlMap) throws JsonProcessingException {
        LOGGER.info("Get tier recovery data upload result for provided brokers.");
        GetTierRecoveryDataUploadJobResultCommandResponse getTierRecoveryDataUploadJobResultCommandResponse = new GetTierRecoveryDataUploadJobResultCommandResponse();
        for (Map.Entry<Integer, UUID> brokerAndJobId : brokerToJobId.entrySet()) {
            GetTierRecoveryDataUploadJobResultRequest request = new GetTierRecoveryDataUploadJobResultRequest(brokerAndJobId.getValue());
            String response = this.getTierRecoveryDataUploadJobResult(new GetTierRecoveryDataUploadJobResultCommandRequest(brokerToUrlMap.get(brokerAndJobId.getKey()), request));
            this.parseGetTierRecoveryDataUploadJobResponse(getTierRecoveryDataUploadJobResultCommandResponse, response, brokerAndJobId.getKey(), brokerAndJobId.getValue());
        }
        LOGGER.debug(TierOrchestratorUtils.prettyPrint(OBJECT_MAPPER, getTierRecoveryDataUploadJobResultCommandResponse));
        return getTierRecoveryDataUploadJobResultCommandResponse;
    }

    public GetTierRecoveryDataUploadJobResultCommandResponse getTierRecoveryDataUploadJobResultForBroker(int brokerId, UUID jobId) throws JsonProcessingException, ExecutionException, InterruptedException {
        LOGGER.info("Get tier recovery data upload result for broker {}.", (Object)brokerId);
        String brokerUrl = TierOrchestratorUtils.getBrokerUrlIfBrokerExists(this.adminClient, this.restServerPort, brokerId, LOGGER);
        GetTierRecoveryDataUploadJobResultCommandResponse getTierRecoveryDataUploadJobResultCommandResponse = new GetTierRecoveryDataUploadJobResultCommandResponse();
        GetTierRecoveryDataUploadJobResultRequest request = new GetTierRecoveryDataUploadJobResultRequest(jobId);
        String response = this.getTierRecoveryDataUploadJobResult(new GetTierRecoveryDataUploadJobResultCommandRequest(brokerUrl, request));
        this.parseGetTierRecoveryDataUploadJobResponse(getTierRecoveryDataUploadJobResultCommandResponse, response, brokerId, jobId);
        LOGGER.debug(TierOrchestratorUtils.prettyPrint(OBJECT_MAPPER, getTierRecoveryDataUploadJobResultCommandResponse));
        return getTierRecoveryDataUploadJobResultCommandResponse;
    }

    private String getTierRecoveryDataUploadJobResult(GetTierRecoveryDataUploadJobResultCommandRequest request) throws JsonProcessingException {
        LOGGER.info("Get upload tier recovery data result for broker {} with request: {}", (Object)request.brokerUrl(), (Object)TierOrchestratorUtils.prettyPrint(OBJECT_MAPPER, request.request()));
        return RestServerUtil.sendRequestTryHttps(request, this.httpClient);
    }

    private void parseGetTierRecoveryDataUploadJobResponse(GetTierRecoveryDataUploadJobResultCommandResponse getTierRecoveryDataUploadJobResultCommandResponse, String response, Integer broker, UUID jobId) throws JsonProcessingException {
        if (response == null) {
            String message = "Unable to get tier recovery data upload job result for broker " + broker;
            getTierRecoveryDataUploadJobResultCommandResponse.getFailed().add(new GetTierRecoveryDataUploadJobResultCommandResponse.BrokerDetail(broker, jobId, null, Optional.of(message)));
        } else {
            GetTierRecoveryDataUploadJobResultResponse result = (GetTierRecoveryDataUploadJobResultResponse)TierMetadataRecoveryOrchestrator.OBJECT_MAPPER.readValue((String)response, new TypeReference<ResponseContainer<GetTierRecoveryDataUploadJobResultResponse>>(){}).data.attributes;
            if (this.isCompletedUpload(result.result())) {
                getTierRecoveryDataUploadJobResultCommandResponse.getCompleted().add(new GetTierRecoveryDataUploadJobResultCommandResponse.BrokerDetail(broker, jobId, result.result(), Optional.empty()));
            } else if (this.isInProgressUpload(result.result())) {
                getTierRecoveryDataUploadJobResultCommandResponse.getInProgress().add(new GetTierRecoveryDataUploadJobResultCommandResponse.BrokerDetail(broker, jobId, result.result(), Optional.empty()));
            } else {
                String message = String.format("Failed to parse the tier recovery data upload job result for broker %d due to unexpected job status: %s. Job Result: %s", new Object[]{broker, result.result().status(), result});
                getTierRecoveryDataUploadJobResultCommandResponse.getFailed().add(new GetTierRecoveryDataUploadJobResultCommandResponse.BrokerDetail(broker, jobId, result.result(), Optional.of(message)));
            }
        }
    }

    private boolean isCompletedUpload(TierRecoveryDataUploadResult result) {
        return result != null && result.status() == TierRecoveryDataUploadResult.TierRecoveryDataUploadJobStatus.COMPLETED;
    }

    private boolean isInProgressUpload(TierRecoveryDataUploadResult result) {
        return result != null && new HashSet<TierRecoveryDataUploadResult.TierRecoveryDataUploadJobStatus>(Arrays.asList(TierRecoveryDataUploadResult.TierRecoveryDataUploadJobStatus.RUNNING, TierRecoveryDataUploadResult.TierRecoveryDataUploadJobStatus.DATA_UPLOAD_COMPLETED)).contains((Object)result.status());
    }

    public TierTopicHeadDataLossDetectionCommandResponse detectDataLossInTierTopicForCluster(String identifier, Set<TopicPartition> tierTopicPartitionAllowList) throws ExecutionException, InterruptedException, JsonProcessingException {
        LOGGER.info("Starting on-demand data loss validation for all brokers in the cluster on tier topic partitions: {}.", (Object)tierTopicPartitionAllowList);
        Map<Integer, String> brokerToUrlMap = TierOrchestratorUtils.getBrokerToUrlMap(this.adminClient, this.restServerPort, LOGGER);
        TierTopicHeadDataLossDetectionCommandResponse dataLossValidationResponse = new TierTopicHeadDataLossDetectionCommandResponse();
        for (Map.Entry<Integer, String> brokerAndUrl : brokerToUrlMap.entrySet()) {
            TierTopicHeadDataLossDetectionRequest request = new TierTopicHeadDataLossDetectionRequest(identifier, tierTopicPartitionAllowList);
            String response = this.detectDataLossInTierTopic(new TierTopicHeadDataLossDetectionCommandRequest(brokerAndUrl.getValue(), request));
            this.parseDataLossValidationResponse(dataLossValidationResponse, response, brokerAndUrl.getKey());
        }
        System.out.println(TierOrchestratorUtils.prettyPrint(OBJECT_MAPPER, dataLossValidationResponse));
        return dataLossValidationResponse;
    }

    public TierTopicHeadDataLossDetectionCommandResponse detectDataLossInTierTopicForBroker(int brokerId, String identifier, Set<TopicPartition> tierTopicPartitionAllowList) throws JsonProcessingException, ExecutionException, InterruptedException {
        String brokerUrl = TierOrchestratorUtils.getBrokerUrlIfBrokerExists(this.adminClient, this.restServerPort, brokerId, LOGGER);
        TierTopicHeadDataLossDetectionCommandResponse dataLossValidationResponse = new TierTopicHeadDataLossDetectionCommandResponse();
        TierTopicHeadDataLossDetectionRequest request = new TierTopicHeadDataLossDetectionRequest(identifier, tierTopicPartitionAllowList);
        String response = this.detectDataLossInTierTopic(new TierTopicHeadDataLossDetectionCommandRequest(brokerUrl, request));
        this.parseDataLossValidationResponse(dataLossValidationResponse, response, brokerId);
        LOGGER.debug(TierOrchestratorUtils.prettyPrint(OBJECT_MAPPER, dataLossValidationResponse));
        return dataLossValidationResponse;
    }

    private String detectDataLossInTierTopic(TierTopicHeadDataLossDetectionCommandRequest request) throws JsonProcessingException {
        LOGGER.info("Detecting data loss for broker {} with request: {}", (Object)request.brokerUrl(), (Object)TierOrchestratorUtils.prettyPrint(OBJECT_MAPPER, request.request()));
        return RestServerUtil.sendRequestTryHttps(request, this.httpClient);
    }

    private void parseDataLossValidationResponse(TierTopicHeadDataLossDetectionCommandResponse dataLossDetectionCommandResponse, String response, Integer broker) throws JsonProcessingException {
        if (response == null) {
            String message = "Unable to start on-demand data loss detection for broker " + broker;
            dataLossDetectionCommandResponse.getFailed().add(new TierTopicHeadDataLossDetectionCommandResponse.FailedBrokerDetail(broker, TierTopicHeadDataLossReport.CompletionStatus.FAILURE, Collections.singletonList(message), null));
        } else {
            TierTopicHeadDataLossDetectionResponse result = (TierTopicHeadDataLossDetectionResponse)TierMetadataRecoveryOrchestrator.OBJECT_MAPPER.readValue((String)response, new TypeReference<ResponseContainer<TierTopicHeadDataLossDetectionResponse>>(){}).data.attributes;
            if (result.completionStatus() == TierTopicHeadDataLossDetectionResponse.CompletionStatus.SUCCESS) {
                dataLossDetectionCommandResponse.getSuccess().add(new TierTopicHeadDataLossDetectionCommandResponse.SuccessBrokerDetail(broker, result.dataLossReportPath()));
            } else {
                ArrayList<String> errorMessages = new ArrayList<String>();
                if (result.completionStatus() == TierTopicHeadDataLossDetectionResponse.CompletionStatus.PARTIAL_SUCCESS) {
                    errorMessages.add("Data loss detection did not complete for all tier topic partitions");
                }
                errorMessages.addAll(result.errorMessages());
                dataLossDetectionCommandResponse.getFailed().add(new TierTopicHeadDataLossDetectionCommandResponse.FailedBrokerDetail(broker, COMPLETION_STATUS_CONVERSION_MAP.get((Object)result.completionStatus()), errorMessages, result.dataLossReportPath()));
            }
        }
    }
}

