/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerConfig;

public class TierRecoveryConfig {
    public static final String VALIDATE = "confluent.tier.recovery.validate";
    public static final String MATERIALIZE = "confluent.tier.recovery.materialize";
    public static final String WORKING_DIR = "confluent.tier.recovery.working.dir";
    public static final String DUMP_EVENTS = "confluent.tier.recovery.dump.events";
    public static final String BROKER_WORKDIR_LIST = "confluent.tier.recovery.broker.workdir.list";

    static Properties toConsumerProps(Properties props) {
        Properties newProperties = new Properties();
        for (String configName : ConsumerConfig.configNames()) {
            Object value = props.get(configName);
            if (value == null) continue;
            newProperties.put(configName, value);
        }
        return newProperties;
    }

    static Properties toMaterializerProperties(Properties props) {
        Properties newProperties = new Properties();
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("bootstrap.servers", "bootstrap-server");
        mapping.put(VALIDATE, "validate-tier-storage");
        mapping.put(MATERIALIZE, "materialize");
        mapping.put(WORKING_DIR, "working-dir");
        mapping.put(DUMP_EVENTS, "dump-events");
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            Object newKey = mapping.get(prop.getKey());
            if (newKey != null) {
                newProperties.put(newKey, prop.getValue());
                continue;
            }
            newProperties.put(prop.getKey(), prop.getValue());
        }
        return newProperties;
    }
}

