/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.stream.Collectors;
import kafka.tier.tools.PartitionUploadInfo;

public class TierRecoveryUploadMetadataJson {
    @JsonProperty(value="version")
    final Integer version;
    @JsonProperty(value="partitions")
    final Map<String, PartitionUploadInfo> partitions;

    @JsonCreator
    public TierRecoveryUploadMetadataJson(@JsonProperty(value="version") Integer version, @JsonProperty(value="partitions") Map<String, PartitionUploadInfo> partitions) {
        this.version = version;
        this.partitions = partitions;
    }

    public String toString() {
        return "TierRecoveryUploadMetadataJson{version=" + this.version + ", partitions=" + this.partitionsToString() + "}";
    }

    private String partitionsToString() {
        return this.partitions.entrySet().stream().map(entry -> {
            String partition = (String)entry.getKey();
            String partitionUploadInfo = ((PartitionUploadInfo)entry.getValue()).toString();
            return String.format("partition=%s, partitionUploadInfo=%s", partition, partitionUploadInfo);
        }).collect(Collectors.joining(",\n"));
    }
}

