/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import kafka.tier.tools.UnfreezeLogStartOffsetRawInput;
import kafka.tier.tools.common.RestoreRawOutputInfoLocal;
import kafka.tier.tools.common.UnfreezeTriggerOutputLocal;

public class UnfreezeLogStartOffsetRawInputLocal
extends UnfreezeLogStartOffsetRawInput<RestoreRawOutputInfoLocal, UnfreezeTriggerOutputLocal> {
    @Override
    public List<RestoreRawOutputInfoLocal> getUnfreezeLogStartOffsetTriggerInput(Path inputJsonFile) {
        if (Files.notExists(inputJsonFile, new LinkOption[0]) || !Files.isRegularFile(inputJsonFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Trigger tool's input file does not exist: " + String.valueOf(inputJsonFile));
        }
        try {
            return RestoreRawOutputInfoLocal.readJsonFromFile(inputJsonFile);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Couldn't parse provided input JSON", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Incorrect JSON file provided: " + String.valueOf(inputJsonFile), e);
        }
    }

    @Override
    public File getFtpsForTopicPartition(RestoreRawOutputInfoLocal input) {
        return input.input().path().toFile();
    }

    @Override
    public UnfreezeTriggerOutputLocal getUnfreezeTriggerOutput(RestoreRawOutputInfoLocal input, String event) {
        return new UnfreezeTriggerOutputLocal(input, event);
    }

    @Override
    public void writeOutputFile(List<UnfreezeTriggerOutputLocal> outputs, File outputFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(outputFile);
        UnfreezeTriggerOutputLocal.writeJsonToFile(outputs, fos);
        fos.close();
    }
}

