/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import io.confluent.kafka.storage.tier.TopicIdPartition;
import java.util.Collection;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.server.InternalAdmin;
import kafka.tier.topic.InitializedTierTopic;
import kafka.tier.topic.TierTopicPartitioner;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TierTopic
implements InitializedTierTopic {
    private static final Logger LOGGER = LoggerFactory.getLogger(TierTopic.class);
    private final String topicName;
    private TierTopicPartitioner partitioner;
    private OptionalInt numPartitions = OptionalInt.empty();

    public TierTopic(String tierNamespace) {
        this.topicName = TierTopic.topicName(tierNamespace);
    }

    public void initialize(InternalAdmin internalAdmin, int configuredNumPartitions, short configuredReplicationFactor) {
        Properties topicConfig = TierTopic.topicConfig();
        this.initialize(internalAdmin.ensureTopic(this.topicName, configuredNumPartitions, configuredReplicationFactor, topicConfig));
        this.tryUpdatingTopicConfig(internalAdmin, topicConfig);
    }

    public void tryUpdatingTopicConfig(InternalAdmin internalAdmin, Properties topicConfig) {
        try {
            internalAdmin.updateTopicConfig(this.topicName, topicConfig);
        }
        catch (Exception e) {
            LOGGER.error("Failed to update topic config for {}", (Object)this.topicName, (Object)e);
        }
    }

    public void initialize(int numPartitions) {
        this.numPartitions = OptionalInt.of(numPartitions);
        this.partitioner = new TierTopicPartitioner(numPartitions);
    }

    @Override
    public Set<TopicPartition> toTierTopicPartitions(Collection<TopicIdPartition> tieredPartitions) {
        if (this.partitioner == null) {
            throw new IllegalStateException("initialize must be called for TierTopic before use.");
        }
        return TierTopic.toTierTopicPartitions(tieredPartitions, this.topicName, this.partitioner);
    }

    @Override
    public TopicPartition toTierTopicPartition(TopicIdPartition tieredPartition) {
        if (this.partitioner == null) {
            throw new IllegalStateException("initialize must be called for TierTopic before use.");
        }
        return TierTopic.toTierTopicPartition(tieredPartition, this.topicName, this.partitioner);
    }

    @Override
    public String topicName() {
        return this.topicName;
    }

    @Override
    public OptionalInt numPartitions() {
        return this.numPartitions;
    }

    public static String topicName(String tierNamespace) {
        if (tierNamespace != null && !tierNamespace.isEmpty()) {
            return "_confluent-tier-state-" + tierNamespace;
        }
        return "_confluent-tier-state";
    }

    public static Set<TopicPartition> toTierTopicPartitions(Collection<TopicIdPartition> tieredPartitions, String topicName, TierTopicPartitioner partitioner) {
        return tieredPartitions.stream().map(tieredPartition -> TierTopic.toTierTopicPartition(tieredPartition, topicName, partitioner)).collect(Collectors.toSet());
    }

    public static TopicPartition toTierTopicPartition(TopicIdPartition tieredPartition, String topicName, TierTopicPartitioner partitioner) {
        return new TopicPartition(topicName, partitioner.partitionId(tieredPartition));
    }

    public static Properties topicConfig() {
        Properties properties = new Properties();
        properties.put("cleanup.policy", "delete");
        properties.put("retention.ms", "-1");
        properties.put("retention.bytes", "-1");
        properties.put("unclean.leader.election.enable", "false");
        return properties;
    }

    public static boolean isConfigValid(Logger logger, String topicName, LogConfig config) {
        boolean isValid;
        boolean bl = isValid = config.delete() && !config.compact() && config.retentionMs == -1L && config.retentionSize == -1L;
        if (config.uncleanLeaderElectionEnable && isValid) {
            logger.warn("Unclean leader election is enabled on tier metadata topic ({}). This could cause unintended data loss or inconsistencies. It is recommended that unclean leader election be disabled on this topic.", (Object)topicName);
        }
        return isValid;
    }
}

