/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.auth;

import io.confluent.kafka.security.oauthbearer.OAuthBearerJwsToken;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;

public class JwtPrincipal
implements Principal {
    private final OAuthBearerToken idToken;
    private final String subClaimName;
    private final String groupsClaimName;

    public JwtPrincipal(OAuthBearerToken idToken, String subClaimName, String groupsClaimName) {
        this.idToken = idToken;
        this.subClaimName = subClaimName;
        this.groupsClaimName = groupsClaimName;
    }

    public JwtPrincipal(OAuthBearerToken idToken) {
        this(idToken, null, null);
    }

    @Override
    public String getName() {
        if (this.subClaimName != null && !this.subClaimName.isEmpty()) {
            return (String)this.jwtClaims().get(this.subClaimName);
        }
        return this.idToken.principalName();
    }

    public String getSubClaimName() {
        return this.subClaimName;
    }

    public String getGroupsClaimName() {
        return this.groupsClaimName;
    }

    public Set<String> getScope() {
        return Collections.unmodifiableSet(this.idToken.scope());
    }

    public String getJwt() {
        return this.idToken.value();
    }

    public Map<String, Object> jwtClaims() {
        if (this.idToken instanceof OAuthBearerJwsToken) {
            return ((OAuthBearerJwsToken)this.idToken).jwtClaims();
        }
        return Collections.emptyMap();
    }
}

